
xyeplot <- function(x,data,...,err=NULL,jitter.x=TRUE,
                    panel=panel.xyeplot,prepanel=prepanel.xyeplot,
                    subgroups,subscripts=TRUE,
                    accumulator=if(missing(subgroups)) panel.superpose else panel.superpose2) {
  xyplot(x,data,...,
         err=eval(substitute(err),data,environment(x)),
         subgroups=if(missing(subgroups)) NULL else eval(substitute(subgroups),data,environment(x)),
         accumulator=accumulator,
         panel=panel,prepanel=prepanel,jitter.x=jitter.x)
}

panel.xyeplot <- function(x,y,...,err,groups=NULL,subgroups,jitter.x,
                          panel.groups=panel.xyeplot,accumulator=panel.superpose,
                          type='b',
                          col.line = if(is.null(groups)) plot.line$col else superpose.line$col,
                          lty = if(is.null(groups)) plot.line$lty else superpose.line$lty,
                          lwd = if(is.null(groups)) plot.line$lwd else superpose.line$lwd,
                          col = if(is.null(groups)) plot.symbol$col else superpose.symbol$col,
                          col.symbol = col,
                          pch = if(is.null(groups)) plot.symbol$pch else superpose.symbol$pch,
                          cex = if(is.null(groups)) plot.symbol$cex else superpose.symbol$cex,
                          fill = if(is.null(groups)) plot.symbol$fill else superpose.symbol$fill) {
  plot.line <- trellis.par.get("plot.line")
  plot.symbol <- trellis.par.get('plot.symbol')
  superpose.line <- trellis.par.get("superpose.line")
  superpose.symbol <- trellis.par.get('superpose.symbol')
  subs <- match.call()$subscripts
  subs <- eval(subs,parent.frame())
  if (is.null(subs)) subs <- seq(along=err)
  if (!is.null(groups)) {
    if ((is.logical(jitter.x) && jitter.x) | is.numeric(jitter.x))
      x <- jitterDJW(x,groups,subs,jitter.x)
    accumulator(x,y,...,type=type,err=err,groups=groups,subgroups=subgroups,panel.groups=panel.groups,
                    col.line=col.line, lty=lty, lwd=lwd, col.symbol=col.symbol, pch=pch, cex=cex)
  }
  else {
    if (is.numeric(err))
      err2 <- list(y-err[subs],y+err[subs])
    else if (is.list(err) && length(err)==2 && is.numeric(err[[1]]) & is.numeric(err[[2]]))
      err2 <- list(err[[1]][subs],err[[2]][subs])
    else stop('Badly specified error bars')
    larrows(as.numeric(x),err2[[1]],as.numeric(x),err2[[2]], length=.05,angle=90,code=3,
            col=col.line,lty=lty,lwd=lwd)
    if ('o' %in% type || 'b' %in% type) type <- c(type,'p','l')
    if ('l' %in% type)
      panel.lines(x,y, lty=lty,col=col.line,lwd=lwd,...)
    if ('p' %in% type) 
      panel.points(x,y, cex=cex,fill=fill,col=col.symbol,pch=pch,...) 
  }
}

prepanel.xyeplot <- function(x,y,...,err,subscripts=seq(along=x)) {
  if (is.numeric(err))
    err2 <- list(y-err[subscripts],y+err[subscripts])
  else if (is.list(err) && length(err)==2 && is.numeric(err[[1]]) & is.numeric(err[[2]]))
    err2 <- list(err[[1]][subscripts],err[[2]][subscripts])
  else stop('Badly specified error bars')
  list(xlim=if(is.numeric(x)) range(x,finite=TRUE) else levels(x),
       ylim=range(c(y,err2[[1]],err2[[2]]),finite=TRUE))
     }



panel.superpose2 <- function (x, y = NULL, subscripts, groups, panel.groups = "panel.xyplot", 
    col, col.line = superpose.line$col, col.symbol = superpose.symbol$col, fill = superpose.symbol$fill,
    pch = superpose.symbol$pch, cex = superpose.symbol$cex, font = superpose.symbol$font, 
    fontface = superpose.symbol$fontface, fontfamily = superpose.symbol$fontfamily, 
    lty = superpose.line$lty, lwd = superpose.line$lwd, alpha = superpose.symbol$alpha, 
    type = "p", subgroups,...) 
{
    if (!missing(type)) {
        have.type <- TRUE
        type <- unique(type)
        wg <- match("g", type, nomatch = NA)
        if (!is.na(wg)) {
            panel.grid(h = -1, v = -1)
            type <- type[-wg]
        }
    }
    else have.type <- FALSE
    x <- as.numeric(x)
    if (!is.null(y)) 
        y <- as.numeric(y)
    if (length(x) > 0) {
        if (!missing(col)) {
            if (missing(col.line)) 
                col.line <- col
            if (missing(col.symbol)) 
                col.symbol <- col
        }
        superpose.symbol <- trellis.par.get("superpose.symbol")
        superpose.line <- trellis.par.get("superpose.line")
        vals <- if (is.factor(groups)) 
            levels(groups)
        else sort(unique(groups))
        vals2 <- if (is.factor(subgroups))
          levels(subgroups)
        else sort(unique(subgroups))
        nvals <- length(vals)
        col.line <- rep(col.line, length = nvals)
        col.symbol <- rep(col.symbol, length = nvals)
        fill <- rep(fill, length=nvals)
        pch <- rep(pch, length = nvals)
        lty <- rep(lty, length = nvals)
        lwd <- rep(lwd, length = nvals)
        alpha <- rep(alpha, length = nvals)
        cex <- rep(cex, length = nvals)
        font <- rep(font, length = nvals)
        fontface <- rep(fontface, length = nvals)
        fontfamily <- rep(fontfamily, length = nvals)
        panel.groups <- if (is.function(panel.groups)) 
            panel.groups
        else if (is.character(panel.groups)) 
            get(panel.groups)
        else eval(panel.groups)
        for (i in seq(along = vals)) for (j in seq(along = vals2))
          {
            id <- ((groups[subscripts] == vals[i]) & (subgroups[subscripts]==vals2[j]))
            if (any(id)) {
                args <- list(x = x[id], subscripts = subscripts[id], 
                  pch = pch[i], cex = cex[i], font = font[i], 
                  fontface = fontface[i], fontfamily = fontfamily[i], 
                  col.line = col.line[i], col.symbol = col.symbol[i], fill = fill[i],
                  lty = lty[i], lwd = lwd[i], alpha = alpha[i], 
                  ...)
                if (have.type) 
                  args$type <- type
                if (!is.null(y)) 
                  args$y <- y[id]
                do.call("panel.groups", args)
            }
        }
    }
  }
