# A cleverer way to do division, when the data is censored


setMethodS3('%/%','Surv',
function(e1,e2) {
  x <- e1
  y <- e2
  # status=1: true value
  # status=0: larger than this
  # status=2: smaller than this
  z <- x[,'time']/y[,'time']
  xs <- x[,'status']
  ys <- y[,'status']
  s <- rep(NA,length(z)) # status is unknown, except in these cases:
  s[ys==1] <- xs[ys==1] # If the denominator is exact, inherit direction from numerator
  s[xs==1 & ys==2] <- 0 # if numerator exact, reverse direction of denominator
  s[xs==1 & ys==0] <- 2 # if numerator exact, reverse direction of denominator
  s[xs==0 & ys==2] <- 0 # if they both point to a larger value
  s[xs==2 & ys==0] <- 2 # if they both point to a smaller value
  z[is.na(s)] <- NA
  s[is.na(s)] <- 1 # tidy up the NA cases
  s[is.na(z)] <- 1
  Surv(z,z,s,type='interval')
},
            appendVarArgs=FALSE)


