'%begins%' <- function(str,prefixes) 1:length(str) %in% fold(lapply(paste('^',prefixes,sep=''), function(yy) grep(yy,str)), union)
'%contains%' <- function(str,substrings) 1:length(str) %in% fold(lapply(substrings, function(yy) grep(yy,str)), union)
'%whichbegin%' <- function(str,prefixes) str[str %begins% prefixes]
'%whichcontain%' <- function(str,substrings) str[str %contains% substrings]

cleanstrata <- function(fit) sapply(strsplit(names(fit$strata),'='), function(x) x[length(x)])


strstrip <- function(x,space='[:space:]',inside=FALSE) {
  space <- as.character(space)
  if (nchar(space)==0 | (substr(space,1,1)=='^' & nchar(space)==1)) stop('Badly specified whitespace')
  W <- paste('[',space,']',sep='')
  if (substr(space,1,1)!='^') 
    w <- paste('[^',space,']',sep='')
  else
    w <- paste('[',substr(space,2,nchar(space)),']',sep='')
  res <- gsub(paste('^',W,'*(',w,'.*',w,'|',w,'?)',W,'*$',sep=''),'\\1',x)
  if (!inside) return(res)
  sapply(strsplit(res,paste(W,'+',sep='')),paste,collapse=' ')
}


splitAlphaNum <- function(str, first=c('character','numeric')) {
  cols <- list()
  first <- first[1]
  if (!(first %in% c('character','numeric'))) stop('Can only match either character or numeric')
  re <- c('character'='^[^[:digit:]]+', 'numeric'='^[[:digit:]]+')
  other <- c('character'='numeric', 'numeric'='character')
  while(max(nchar(str))>0) {
    m <- regexpr(re[first], str)
    matched <- ifelse(m==-1,NA,substr(str,1,attr(m,'match.length')))
    str <- substr(str,ifelse(m==-1,1,attr(m,'match.length')+1),nchar(str))
    if (first=='numeric') cols <- c(cols,list(numeric=as.numeric(matched))) else cols <- c(cols,list(character=matched))
    first <- other[first]
  }
  cols
}

orderAlphaNum <- function(str,...)
  do.call('order',splitAlphaNum(as.character(str),...))

sortAlphaNum <- function(str,...) str[orderAlphaNum(str,...)]

