prettytable <- function(df,wrap=integer(0)) {
  y <- as.data.frame(df)
  class(y) <- c('prettytable',setdiff(class(y),'prettytable'))
  attr(y,'wrap') <- wrap
  y }

print.prettytable <- function(x, ..., digits=NULL, na.encode=FALSE, rowsep=NA, colsep=' ', justify='left', rowsperpage=Inf) {
  mm <- as.matrix(format.data.frame(x,digits=digits,na.encode=na.encode))
  if (is.null(attr(x,'wrap'))) attr(x,'wrap') <- integer(0)
  if (!is.numeric(attr(x,'wrap'))) stop('Must supply an integer vector of minimum column widths')
  # Count the desired width of each column
  colwidth.max <- sapply(1:ncol(mm), function(j) max(2,nchar(mm[,j])))
  names(colwidth.max) <- names(x)
  colwidth.min <- colwidth.max
  headwidth <- nchar(names(x))
  colwidth.max <- pmax(headwidth,colwidth.max)
  flexicol <- names(attr(x,'wrap'))
  flexicol <- flexicol[flexicol %in% names(x)]
  colwidth.min[flexicol] <- attr(x,'wrap')[flexicol]
  colwidth.max <- pmax(colwidth.min,colwidth.max)
  pagewidth <- options('width')$width
  nameswidth <- max(nchar(row.names(mm)))
  #
  # Decide which columns to print on which page
  pages <- list(names(colwidth.min)[1])
  for (i in 2:length(colwidth.min)) {
    lastpage <- pages[[length(pages)]]
    newcol <- names(colwidth.min)[i]
    widthsofar <- sum(colwidth.min[lastpage])+(length(lastpage)-1)*nchar(colsep)+nameswidth+nchar(colsep)
    newwidth <- widthsofar + colwidth.min[i]+nchar(colsep)
    if (newwidth<=pagewidth) pages[[length(pages)]] <- c(lastpage,newcol) else pages <- c(pages,list(newcol))
  }
  # 
  # For each page in turn, decide what width to use for each column
  resizecols <- function(page) {
    colwidth <- colwidth.min[page]
    residwidth <- pagewidth - (nameswidth+1) - (sum(colwidth)+nchar(colsep)*(length(colwidth)-1))
    flexi <- names(colwidth.max[page])[colwidth.max[page]>colwidth.min[page]]
    if (length(flexi)>0) {
      flexi <- colwidth.max[flexi] - colwidth.min[flexi] # how many more chars each flexi column wants
      scalewidth <- min(residwidth,sum(flexi))
      while(TRUE) {
        flexiplus <- round(flexi*scalewidth/sum(flexi))
        if (sum(flexiplus)<=residwidth) break
        scalewidth <- scalewidth-1 }
      colwidth[names(flexiplus)] <- colwidth[names(flexiplus)] + flexiplus
    }
    colwidth
  }
  colwidth <- lapply(pages, resizecols)
  # Print each page in turn.
  # Wrap each column, so that it fits!
  # This means: add fictitious rows, OR just go ahead and do the printing myself
  wraptext <- function(val,w) {
    if (is.na(val)) val <- 'NA'
    if (nchar(val)>w) {
      r <- nchar(val) %/% (w-1) + ifelse(nchar(val) %% (w-1)>0,1,0)
      val <- paste(sapply(1:r, function(i) substr(val,(i-1)*(w-1)+1,i*(w-1))),ifelse(1:r<r,'~',''),sep='') }
    format(val, width=w, justify=justify)
  }
  printrow <- function(texts,cw) {
    cols <- lapply(seq(along=cw), function(j) wraptext(texts[j],cw[j]))
    maxr <- max(sapply(cols,length))
    blanks <- sapply(seq(along=cols), function(j) format('',width=nchar(cols[[j]][1])))
    for (j in seq(along=cols))
      cols[[j]] <- c(cols[[j]], rep(blanks[j], maxr-length(cols[[j]])))
    colst <- do.call('paste',c(cols,list(sep=colsep)))
    colst
  }
  #
  pagesplit <- if(rowsperpage==Inf)
    list(1:nrow(mm))
  else
    lapply(1:((nrow(mm)+rowsperpage-1) %/% rowsperpage), function(p)
           seq(1+(p-1)*rowsperpage, min(nrow(mm),p*rowsperpage)))
  for (ii in pagesplit) {
    for (p in seq(along=pages)) {
      cw <- colwidth[[p]]
      rowtext <- printrow(c('',names(cw)),c(nameswidth,cw))
      for (tt in rowtext) cat(tt,'\n')
      if (!is.na(rowsep))
        cat(substr(paste(rep(rowsep,nchar(rowtext[1])),collapse=''),1,nchar(rowtext[1])),'\n')
      for (i in ii) {
        rowtext <- printrow(c(row.names(mm)[i],mm[i,names(cw)]), c(nameswidth,cw))
        for (tt in rowtext) cat(tt,'\n') }
      if (p<length(pages)) cat('\n')
    }
    cat('\n\n')
  }
}



