levelsUsed <- function(x) {
  if (!is.factor(x)) return(unique(x))
  levels(x)[levels(x) %in% unique(x)] }


simpleKey2 <- function (text, outof=seq(along=text),
                        points=TRUE, rectangles=FALSE, lines = FALSE,
                        columns, rows, byrow,
                        col=add.text$col, cex=add.text$cex, font=add.text$font,
                        fontface=add.text$fontface, fontfamily=add.text$fontfamily,
                        ...) {
    if (missing(columns)) columns <- NULL
    if (missing(rows)) rows <- NULL
    if (missing(byrow)) byrow <- NULL
    numargs <- length(text)
    if (numargs == 0) stop("Missing labels for key")
    if (is.null(rows) & is.null(columns)) columns <- 1
    if (!is.null(columns) & !is.null(rows)) stop("Specify either number of rows or number of columns, not both")
    if (is.null(byrow)) byrow <- is.null(columns)
    if (is.null(columns)) columns <- (numargs + rows - 1)%/%rows
    if (is.character(outof)) {
        foo <- seq(along=outof)
        names(foo) <- outof
        foo <- as.numeric(foo[text])
        lab <- outof[foo[!is.na(foo)]]
    }
    else {
        if (length(text)!=length(outof)) stop("Labels and index-in-trellis-settings must have same length")
        foo <- outof
        lab <- text
    }
    if (byrow && length(foo)>0) {
        numargs <- length(foo)
        rows <- numargs%/%columns + ifelse(numargs%%columns>0,1,0)
        args <- c(1:numargs, rep(NA, columns*rows-numargs))
        args <- matrix(args, ncol=columns, nrow=rows, byrow=TRUE)
        args <- as.vector(args) # this is the permutation we need to apply
        foo <- foo[args[!is.na(args)]]
        lab <- lab[args[!is.na(args)]]
    }
    foo <- foo[!is.na(foo)]
    lab <- lab[!is.na(foo)]
    #
    add.text <- trellis.par.get("add.text")
    ans <- list(text=list(lab=lab), col=col, cex=cex, 
                font=font, fontface=fontface, fontfamily=fontfamily, 
                columns=columns, ...)
    if (points) ans$points <- Rows(trellis.par.get("superpose.symbol"),foo)
    if (rectangles) ans$rectangles <- Rows(trellis.par.get("superpose.polygon"),foo)
    if (lines) ans$lines <- Rows(trellis.par.get("superpose.line"),foo)
    ans
}

