locf <- function(x,data) {
  # Extract data from x = obs~time|id
  if (length(x)!=3) stop('Formula must have the form obs~time|id')
  lhs <- x[[2]]
  rhs <- x[[3]]
  if (x[[1]]!=as.name('~')) stop('Formula must have the form .~.')
  if (length(rhs)!=3) stop('RHS must have the form time|id')
  if (rhs[[1]]!=as.name('|')) stop('RHS must have the form .|.')
  obs <- eval(lhs,data,environment(x))
  time <- eval(rhs[[2]],data,environment(x))
  id <- eval(rhs[[3]],data,environment(x))
  if (any(is.na(time))) stop('The variable `time` may not have missing values')
  if (any(is.na(id))) stop('The variable `id` may not have missing values')
  if (missing(data)) data <- NULL
  #
  df <- data.frame(id=id,obs=obs,time=time)
  df <- reshape(df,direction='wide',idvar='id',timevar='time',v.names='obs')
  times <- sort(unique(time))
  df[[paste('imputed',times[1],sep='.')]] <- FALSE
  df[[paste('imputedfrom',times[1],sep='.')]] <- as.character(times[1])
  for (t in seq(along=times[-1])) {
    prev <- df[[paste('obs',times[t],sep='.')]]
    impfrom <- df[[paste('imputedfrom',times[t],sep='.')]]
    this <- df[[paste('obs',times[t+1],sep='.')]]
    df[[paste('imputed',times[t+1],sep='.')]] <- is.na(this)
    df[[paste('imputedfrom',times[t+1],sep='.')]] <- ifelse(is.na(this),impfrom,as.character(times[t+1]))
    this[is.na(this)] <- prev[is.na(this)]
    df[[paste('obs',times[t+1],sep='.')]] <- this }
  df <- reshape(df, direction='long',
                idvar='id', timevar='time', times=times,
                v.names=c('obs','imputed','imputedfrom'),
                varying=list(paste('obs',times,sep='.'),paste('imputed',times,sep='.'),paste('imputedfrom',times,sep='.')))
  df <- df[order(factor(df$id,levels=unique(id)),df$time),]
  if (is.factor(times)) df$imputedfrom <- factor(as.character(df$imputedfrom),levels=levels(times))
  if (is.numeric(times)) df$imputedfrom <- as.numeric(as.character(df$imputedfrom),levels=levels(times))
  names(df)[names(df)=='obs'] <- deparse(substitute(lhs))
  rhs2 <- rhs[[2]]
  rhs3 <- rhs[[3]]
  names(df)[names(df)=='time'] <- deparse(substitute(rhs2))
  names(df)[names(df)=='id'] <- deparse(substitute(rhs3))
  df
}
