edf <- function(...,panel=panel.edf,prepanel=prepanel.edf,type='S',ylab='')
  xyplot(...,panel=panel,prepanel=prepanel,type=type,ylab=ylab)

prepanel.edf <- function(x,y...) list(xlim=range(x,na.rm=TRUE),
                                      ylim=c(0,1))

panel.edf <- function(x,y,...,groups=NULL,subscripts) {
  ss <- function(n) n:1/n
  if (is.null(groups)) {
    x <- x[!is.na(x)]
    panel.xyplot(sort(x),ss(length(x)),...,groups=NULL)
  }
  else {
    vals <- if (is.factor(groups)) levels(groups) else sort(unique(groups))
    subg <- groups[subscripts]
    ok <- !is.na(subg)
    for (i in seq(along=vals)) {
      id <- ok & (subg==vals[i]) & !is.na(x)
      if (howmany(id)<=1) next
      x[id] <- sort(x[id])
      y[id] <- ss(howmany(id))
    panel.xyplot(x,y,...,groups=groups,subscripts=subscripts)
  } }
}
