#tablemargin <- function(tab, margin=NULL, drop.zero=TRUE) {
#  getentry <- function(ind) {
#    dd <- dim(tab)
#    if (all(ind<=dd)) {
#      ddp <- c(1,cumprod(dim(tab)))[1:length(dim(tab))]
#      wi <- 1 + sum((ind-1)*ddp)
#      return(tab[[wi]]) }
#    w <- which(ind>dd)[1]
#    sum(sapply(1:dim(tab)[w], function(j) { ind[w]=j; getentry(ind) }))
#    }
#  if (is.null(margin)) margin <- seq(along=dim(tab))
#  newdimind <- lapply(seq(along=dim(tab)), function(j)
#    if (!drop.zero) which(apply(tab,j,sum)>-Inf) else which(apply(tab,j,sum)>0) )
#  newdimind[margin] <- lapply(seq(along=margin), function(j) c(newdimind[[margin[j]]],'TOTAL'=dim(tab)[margin[j]]+1))
#  names(newdimind) <- names(dimnames(tab))
#  newdimnames <- lapply(newdimind, names)
#  names(newdimnames) <- names(newdimind)
#  newdim <- sapply(newdimind, length)
#  newdimp <- c(1,cumprod(newdim))[1:length(newdim)]
#  newdimr <- rev(cumprod(c(1,rev(newdim))))[-1]
#  inds <- do.call('cbind',
#    lapply(seq(along=newdim), function(j) rep(newdimind[[j]], each=newdimp[j], times=newdimr[j])))
#  res <- sapply(1:prod(newdim), function(i) getentry(inds[i,]))
#  res <- array(res, dim=newdim, dimnames=newdimnames)
#  mostattributes(res) <- attributes(tab)
#  dim(res) <- newdim
#  dimnames(res) <- newdimnames
#  res
#  }

propmargins.table <- function(x, margin=seq(along=dim(x)), margin.prop=margin) {
  allmargins <- seq(along=dim(x))
  z1 <- addmargins.table(x, margin)
  z2 <- addmargins.table(x, setdiff(margin,margin.prop))
  z3 <- prop.table(z2, setdiff(allmargins,margin.prop))
  z4 <- addmargins.table(z3, margin.prop)
  z4 <- round(z4*100)
  z <- paste(format(z1,justify='right'),' (',z4,'%)',sep='')
  dim(z) <- dim(z1)
  dimnames(z) <- dimnames(z1)
  z }

addmargins.table <- function (x, margin=seq(along=dim(x)), FUN=sum) {
  allmargins <- seq(along = dim(x))
  y <- x
  for (i in margin) {
    ind <- setdiff(allmargins,i)
    TOTAL <- if(length(ind)==0) FUN(y) else apply(y,ind,FUN)
    y <- abind(y,TOTAL=TOTAL,along=i)
  }
  names(dimnames(y)) <- names(dimnames(x))
  y }

repsafe <- function(x,length.out) {
  if (length(x)==1) return(rep(x,length.out))
  if (length(x)==length.out) return(x)
  warning('Going to dangerous lengths, duplicating a vector of length ',length(x),' to have length ',length.out)
  rep(x,length.out=length.out)
  }

aggregateList <- function(x, by, FUN, data=NULL) {
  byname <- deparse(substitute(by))
  if (!is.null(data)) {
    x <- eval(substitute(x),data)
    if (is.data.frame(x)) stop('Do not specify a data frame both as the first argument and the data argument')
    by <- eval(substitute(by),data)
  }
  else
    by <- eval(substitute(by),x)
  if (!is.list(by)) {
    by <- list(by)
    names(by) <- byname
  }
  defaultnames <- paste('by',seq(along=by),sep='.')
  if (is.null(names(by))) names(by) <- defaultnames
  ind <- which(nchar(names(by))==0)
  names(by)[ind] <- defaultnames[ind]
  #
  if (!is.list(FUN)) {
    funname <- deparse(substitute(FUN))
    FUN <- list(FUN)
    names(FUN) <- funname
    }
  defaultnames <- paste('FUN',seq(along=FUN),sep='.')
  if (is.null(names(FUN))) names(FUN) <- defaultnames
  ind <- which(nchar(names(FUN))==0)
  names(FUN)[ind] <- defaultnames[ind]
  #
  if (is.atomic(x)) xx <- x else xx <- 1:nrow(x)
  idcol <- tapply(xx, INDEX=by, FUN=function(x) x[1], simplify=FALSE)
  d <- dim(idcol)
  w <- NULL
  for (i in seq(along=d)) {
    j <- rep.int(rep.int(seq(1:d[i]), prod(d[seq(length=i-1)]) * rep.int(1,d[i])),
                 prod(d[seq(from=i+1,length=length(d)-i)]))
    w <- cbind(w, dimnames(idcol)[[i]][j]) }
  w <- w[which(!unlist(lapply(idcol,is.null))),,drop=FALSE]
  idcol <- data.frame(w)
  idcol[] <- lapply(1:length(idcol), function(i) {
    if (is.factor(by[[i]])) return(factor(idcol[[i]],levels=levels(by[[i]])))
    if (is.character(by[[i]])) return(as.character(idcol[[i]]))
    idcol[[i]] })
  names(idcol) <- names(by)
  #
  evalfun <- function(FUN,funname) {
    if (is.atomic(x))
      res <- tapply(x, INDEX=by, FUN=FUN, simplify=FALSE)
    else
      res <- tapply(1:nrow(x), INDEX=by, FUN=function(inds) FUN(x[inds,]), simplify=FALSE)
    dim(res) <- prod(dim(res))
    res <- res[!sapply(res, is.null)] # drop entries for dud combinations
    if (any(!sapply(res,is.atomic)))
      stop('Function ',funname,' must always return a scalar; got nonatomic')
    if (length(unique(sapply(res,length)))>1)
      stop('Function ',funname,' must always return a scalar; got longer')
    unlist(res)
  }
  res <- lapply(seq(along=FUN), function(i) data.frame(evalfun(FUN[[i]],names(FUN)[i])))
  res <- do.call('cbind',res)
  names(res) <- names(FUN)
  cbind(idcol,res)
}



# Given two vectors, superimpose them, giving preference to the first, and overwriting NAs.
squelch2 <- function(x,y,...,warn=TRUE) {
  if (!identical(class(x),class(y)))
    stop('Cannot squelch two vectors ',
         if(is.character(warn)) paste('for',warn) else '',
            'of different class, ',class(x),' and ',class(y))
  ow <- !is.na(x) & !is.na(y) & x!=y
  if (is.character(warn) && any(ow)) warning('Overwriting ',howmany(ow),' values for ',warn, call.=FALSE)
  if (is.logical(warn) && warn && any(ow)) warning('Overwriting ',howmany(ow),' values')
  res <- ifelse(!is.na(x),x,y)
  mostattributes(res) <- attributes(x)
  res
}
squelch <- function(data, idvar, drop=character(0), FUN=squelch2, warn=TRUE) {
  data <- data[,!(names(data) %in% drop)]
  if (any(sapply(idvar, function(id) any(is.na(data[[id]]))))) stop('No missing values permitted in idvar')
  if (any(idvar %in% drop)) stop('Cannot drop idvar variables')
  varying <- rep(NA,nrow(data))
  ids <- do.call('paste',c(data[idvar],list(sep='DJWSQUELCH')))
  for (id in unique(ids)) { m <- which(ids==id); varying[m] <- 1:length(m) }
  if (max(varying)==1) return(data)
  subdata <- lapply(1:max(varying), function(v) data[varying==v,,drop=FALSE])
  res <- subdata[[1]]
  mergecols <- names(data)[!(names(data) %in% idvar)]
  if (length(mergecols)==0) stop('No columns to squelch')
  for (i in 2:length(subdata)) {
    df <- merge(res, subdata[[i]], by=idvar, all=TRUE)
    res <- df[,idvar,drop=FALSE]
    newcols <- lapply(mergecols, function(cc) squelch2( df[[paste(cc,'.x',sep='')]], df[[paste(cc,'.y',sep='')]], warn=if(warn) cc else FALSE ))
    names(newcols) <- mergecols
    res <- cbind(res,newcols)
  }
  res
}

