print.Coefmat <- function (x,
                           pcol = which(tolower(colnames(x)) %begins% c('pr','sig','pval','p-val')),
                           digits = max(3, getOption("digits") - 2),
                           dig.tst = max(1, min(5, digits - 1)),
                           signif.stars = getOption("show.signif.stars"), signif.legend = signif.stars,
                           eps.Pvalue = .Machine$double.eps, na.print='NA',...) {
  if (is.null(dim(x))) x <- t(as.matrix(x))
  x <- as.data.frame(x)
  printc <- x
  printc[] <- lapply(x, as.character)
  # Special-case processing for numeric columns
  asNum <- function(n) {
    digmin <- 1 + floor(log10(range(abs(n)[n!=0],na.rm=TRUE)))
    format(round(n,max(1,digits-digmin)),digits=digits)
  }
  ncol <- which(sapply(x,is.numeric))
  printc[,ncol] <- lapply(x[,ncol,drop=FALSE], asNum)
  # Special-case processing for the p column
  asPval <- function(p) {
    p <- as.numeric(as.character(p))
    pr <- format.pval(p, digits=dig.tst, eps=eps.Pvalue)
    sist <- symnum(p,corr=FALSE,na=FALSE,cutpoints=c(0,.001,.01,.05,.1,1),symbols=c('***','** ','*  ','.  ','   '))
    res <- paste(pr,sist)
    res[is.na(p)] <- na.print
    res
    }
  printc[,pcol] <- lapply(x[,pcol,drop=FALSE], asPval)
  names(printc)[pcol] <- paste(names(printc)[pcol],'    ',sep='')
  #
  print(printc)
}

'[.Coefmat' <- function(m,i,j,drop=FALSE) {
   if (!missing(i) && is.character(i)) {
     i <- lapply(paste('^',i,'$',sep=''), function(p) {
       match <- grep(p,row.names(m))
       if (length(match)==0) warning('No rows match "',substr(p,2,nchar(p)-1),'"',call.=FALSE)
       match })
     i <- do.call('c',i)
     i <- i[!duplicated(i)]
   }
   class(m) <- setdiff(class(m),'Coefmat')
   if (length(class(m))==0) class(m) <- ifelse(mode(m)=='numeric','matrix','data.frame')
   if ((missing(i) || length(i)==0) && missing(j)) stop('Specify either rows or columns')
   if (missing(i) || length(i)==0) res <- m[,j,drop=drop]
   if (missing(j)) res <- m[i,,drop=drop]
   if (!missing(i) && !missing(j)) res <- m[i,j,drop=drop]
   class(res) <- c('Coefmat',class(res))
   res
}

#'[.Coefmat' <- function(m,...) {
#  y <- NextMethod('[',m)
#  class(y) <- c('Coefmat',setdiff(class(y),'Coefmat'))
#  y
#}


coefTable <- function(fit,type=c('e','s','c','p'),...) UseMethod('coefTable')

coefTable.lme <- function(fit,type=c('e','d','c','p'),...) {
  wantvarcode <- list('e'=c(estimate='Value'), 'd'=c('DF'='DF'), 's'=c('se'='Std.Error'),
                      'c'=c('2.5%'='lower','97.5%'='upper'), 'p'=c('p-value'='p-value'))
  wantvar <- do.call('c', lapply(type, function(x) wantvarcode[[x]]))
  res <- cbind(summary(fit)$tTable,intervals(summary(fit),which='fixed')$fixed)
  res <- res[,wantvar]
  colnames(res) <- names(wantvar)
  class(res) <- c('Coefmat',class(res))
  res }

coefTable.lm <- function(fit,type=c('e','c','p'),...) {
  wantvarcode <- list('e'=c(estimate='Estimate'), 's'=c('se'='Std. Error'), 'p'=c('p-value'='Pr(>|t|)'),
                      'c'=c('2.5%'='2.5 %','97.5%'='97.5 %'))
  wantvar <- do.call('c', lapply(type, function(x) wantvarcode[[x]]))
  res <- cbind(coef(summary(fit)), confint(fit))
  res <- res[,wantvar]
  colnames(res) <- names(wantvar)
  class(res) <- c('Coefmat',class(res))
  res }

coefTable.glm <- function(fit,type=c('e','c','p'),...) {
  wantvarcode <- list('e'=c(estimate='Estimate'), 's'=c('se'='Std. Error'), 'p'=c('p-value'='Pr(>|z|)'),
                      'c'=c('2.5%'='2.5 %','97.5%'='97.5 %'))
  wantvar <- do.call('c', lapply(type, function(x) wantvarcode[[x]]))
  res <- cbind(coef(summary(fit)), confint(profile(fit)))
  res <- res[,wantvar]
  colnames(res) <- names(wantvar)
  class(res) <- c('Coefmat',class(res))
  res }
