sigstyle <- function(p) {
  pstr2 <- symnum(p,corr=FALSE, na=FALSE,
                    cutpoints = c(0, 0.001, 0.01, 0.05, 0.1, 1), 
                    symbols = c("3", "2", "1", "0", "."))
  lineswd <- c('3'=2,'2'=2,'1'=1,'0'=1,'.'=0)[as.character(pstr2)]
  linesty <- c('3'=1,'2'=1,'1'=1,'0'=3,'.'=3)[as.character(pstr2)]
  list(lwd=lineswd,lty=linesty)
  }

sigchar <- function(p)
  paste(symnum(p,corr=FALSE, na=FALSE,
               cutpoints = c(0, 0.001, 0.01, 0.05, 0.1, 1), 
               symbols = c("*** ", "** ", "* ", ". ", "")),
        format.pval(p,digits=2),sep='')


showchanges <- function(...,panel=panel.showchanges,panel.groups=panel.groups.showchanges)
  xyplot(...,panel=panel,panel.groups=panel.groups)
#
panel.groups.showchanges <- function(x,y,...,connect.line,arrowswidth) {
           arrowswidth <- arrowswidth/2*1.2
           for (i in seq(along=x))
             panel.xyplot(c(x[i]-arrowswidth,x[i]+arrowswidth),c(y[i],y[i]),...)
           connect.line <- rep(connect.line, length.out=length(x)-1)
           for (i in seq(along=connect.line)) if (connect.line[i])
             panel.xyplot(c(x[i]+arrowswidth,x[i+1]-arrowswidth),
                          c(y[i],y[i+1]),...)
         }
#
panel.showchanges <- function(x,y,groups,subscripts,...,sig,arrowswidth=.2,connect.line=TRUE,cex=.7,len=.1) {
  panel.superpose(x,y,groups=groups,subscripts=subscripts,arrowswidth=arrowswidth,connect.line=connect.line,...)
  sel <- 1:length(groups) %in% subscripts
  for (xxi in seq(along=unique(x))) {
    xx <- unique(x)[xxi]
    selx <- 1:length(groups) %in% (subscripts[x==xx])
    selg <- sapply(unique(groups), function(g) which(selx & groups==g)[1])
    names(selg) <- unique(groups)
    ally <- rep(NA,length(groups))
    ally[subscripts] <- y
    yg <- ally[selg]
    names(yg) <- names(selg)
    numsigarrows <- sum(sapply(sig[selx],length))
    drawsigarrow <- 1
    for (i in seq(along=subscripts)) if (x[i]==xx) {
      sigxy <- sig[[subscripts[i]]]
      y0 <- y[i]
      y1 <- yg[names(sigxy)]
      for (a in seq(along=y1)) {
        xa <- as.numeric(xx) + if(numsigarrows==1) 0 else -arrowswidth/2+arrowswidth*(drawsigarrow-1)/(numsigarrows-1)
        sigxyp <- sigxy[a]
        if (is.na(sigxyp)) next
        larrows(x0=xa,y0=y0,x1=xa,y1=y1[a], lwd=sigstyle(sigxyp)$lwd,lty=sigstyle(sigxyp)$lty,len=len)
        ltext(x=xa+.1/numsigarrows,y=(y0+y1[a])/2,labels=sigchar(sigxyp),cex=cex,srt=-90,adj=c(.5,0))
        drawsigarrow <- drawsigarrow+1
      } }
  }
}
