bwplot2 <- function(x,data,...,err='bw',jitter.x=TRUE,
                    panel=panel.bwplot2,prepanel=prepanel.bwplot2,
                    subgroups,
                    accumulator=if(missing(subgroups)) panel.superpose else panel.superpose2) {
  xyplot(x,data,...,err=err[[1]],jitter.x=jitter.x,
         subgroups=if(missing(subgroups)) NULL else eval(substitute(subgroups),data,environment(x)),
         accumulator=accumulator,
         panel=panel,prepanel=prepanel)
}

panel.bwplot2 <- function(x,y,...,subscripts,err,jitter.x,groups=NULL,subgroups,
                          panel.groups=panel.bwplot2,accumulator=panel.superpose,
                          col.line = if(is.null(groups)) plot.line$col else superpose.line$col,
                          lty = if(is.null(groups)) plot.line$lty else superpose.line$lty,
                          lwd = if(is.null(groups)) plot.line$lwd else superpose.line$lwd) {
  plot.line <- trellis.par.get("plot.line")
  superpose.line <- trellis.par.get("superpose.line")
  if (!is.null(groups)) {
    if ((is.logical(jitter.x) && jitter.x) | is.numeric(jitter.x))
      x <- jitterDJW(x,groups,subscripts,jitter.x)
    accumulator(x,y,...,subscripts=subscripts,err=err,
                groups=groups,subgroups=subgroups,panel.groups=panel.groups,
                col.line=col.line, lty=lty, lwd=lwd)
  }
  else {
    if (missing(subscripts)) subscripts <- 1:length(x)
    x <- as.numeric(x)
    xx <- sort(unique(x))
    yy <- sapply(xx, function(xval) {
      yvals <- y[x==xval]
      if (err=='bw') {
        bs <- boxplot.stats(yvals)$stats
        llines(c(xval,xval),bs[c(1,5)], col=col.line,lty=lty,lwd=1)
        llines(c(xval,xval),bs[c(2,4)], col=col.line,lty=1,lwd=3)
        outliers <- boxplot.stats(yvals)$out
        lpoints(rep(xval,length(outliers)),outliers, pch=16, col=col.line)
        return(bs[3]) }
      else if (err=='seq') {
        yvals <- yvals[!is.na(yvals)]
        upp <-  median(yvals)+1.253*diff(quantile(yvals,c(pnorm(0),pnorm(1))))/sqrt(length(yvals))
        low <-  median(yvals)-1.253*diff(quantile(yvals,c(pnorm(0),pnorm(1))))/sqrt(length(yvals))
        mid <- median(yvals)
        larrows(xval,low,xval,upp, length=0.04,angle=90,code=3, col=col.line,lty=lty,lwd=lwd)
        return(mid)
        }
      else if (err=='se' || is.numeric(err)) {
        yvals <- yvals[!is.na(yvals)]
        yval <- mean(yvals)
        sdmult <- if (err=='se') 1 else qnorm(1-(1-err)/2)
        if (length(yvals)>0) {
          se <- sdmult*sd(yvals)/sqrt(length(yvals))
          larrows(xval,yval-se,xval,yval+se, length=0.04,angle=90,code=3, col=col.line,lty=lty,lwd=lwd) }
        return(yval)
      }
      else if (err=='median') return(median(yvals[!is.na(yvals)]))
      else if (err=='mean' || err=='none') return(mean(yvals[!is.na(yvals)]))
      else stop('Unknown value for err: ',as.character(err))
      })
    xx <- xx[!is.nan(yy) & !is.na(yy)]
    yy <- yy[!is.nan(yy) & !is.na(yy)]
    panel.xyplot(xx,yy,...,subscripts=subscripts,col.line=col.line,lty=lty,lwd=lwd)
  }
}

prepanel.bwplot2 <- function(x,y,...,groups,subscripts,err) {
  if (err=='bw') return(list(
        xlim=if(is.numeric(x)) range(x, finite=TRUE) else levels(x),
        ylim=range(y, finite=TRUE)))
  if (missing(subscripts)) subscripts <- 1:length(x)
  if (missing(groups)) groups <- rep(1,length(x)) else groups <- groups[subscripts]
  ylim <- numeric(0)
  for (gr in unique(groups)) for (xx in unique(x)) {
    ss <- as.numeric(x)==as.numeric(xx) & as.character(groups)==as.character(gr)
    if (length(which(ss))==0) next
    yvals <- y[ss]
    yvals <- yvals[!is.na(yvals)]
    if (length(yvals)==0) next
    if (length(yvals)==1) { ylim <- c(ylim,yvals); next }
    ylim <- c(ylim, mean(yvals)+c(-1,1)*sd(yvals)/sqrt(length(yvals)))
  }
  if (length(ylim)==0) ylim <- c(0,1)
  list(xlim=if(is.numeric(x)) range(x,finite=TRUE) else levels(x),ylim=range(ylim,finite=TRUE))
}

