

		
; /* pu17hdr.s - reset entry point to monitor rom
;  *  
;  *
;  * Software Excellence from Tenison Technology.
;  *
;  *  
;  * (C) 1995 Tenison Technology.
;  * (C) 1992 DJ Greaves.
;  *
;  */

	
	; /* some of these values also in mymachdep.h */ 
StackTop	equ 0xF7FE
BSS_ORG		equ 0xDF00
IOBASE		equ 0xF800
	
uart_data	.equ IOBASE+0x82	// Low byte at not at plus one - little end now.
uart_status	.equ IOBASE+0x80
	
uart_status_txidle	.equ 1		// bit 0
uart_status_rxav	.equ 2		// bit 1

	.text
	
	.org	0	

divzero:	
coldreset:

	lod	r7,#StackTop
	mov	r2,r7
	jmp	__crt0
	
	
_open:
		ret

	;; Polled I/O to onboard UART.
	
__sa_wrch:
ps0:	lod	r1,uart_status
	and	r1,#uart_status_txidle
	beq	ps0		; Wait for last char to leave
	strb	r0,uart_data
	ret


__sa_rdch:	
ps1:	lod	r0,uart_status
	and	r0,#uart_status_rxav
	beq	ps1		; Wait for char to arrive
	lodb	r0,uart_data
	ret


	;;  Return non-zero if user attention (e.g. control C)
_checkend:	
	lod	r0,uart_status
	and	r0,#uart_status_rxav	;  here, check any char
	ret


	;;  Just give the sp for now
_read_cpu_control_reg
		mov	r0,r7
		ret

	;; 
_clear_breakpoint:

	;; 
_install_breakpoint:
		ret

	
	.bss
	.org	BSS_ORG

	;; Console flags should be set from the uart rx interrupt routine
	;; for a control C or so on.  Not implemented.
_console_flags:
		.defw 0
	
_bptaddr:	
		.defw 0

	.text
	;;  EOF

	