/*
 * mymon.c  Mar 99
 *
 * Software Excellence from Tenison Technology.
 *
 * CBG Generic Monitor
 * (C) 1998 - with serial download checksum etc..
 * (C) 1995 Tenison Technology.
 * (C) 1995 DJ Greaves.
 *
 */




#include "mymachdep.h"
#include "prstdio.h"
#define DB(X) 
#ifdef OST_VERSION
#define PIE_CONTROL ((volatile uchar *) 0x4C000001) /* D8-15 */
#define PIE_STATUS  ((volatile uchar *) 0x48000001) /* D8-15 */
#define PIE_FIFO    ((volatile uchar *) 0x58000000)
#endif


extern void init_mylinein
();
extern int rhex(char *);
extern char *readcookedline_pe(int, int);
extern char **shell_parse();
extern int myvict_main(int, char **);
extern int init_myvict();
static int errorf;
static uchar *ihex_offset;
extern int deb;
static int last_addr;
static int bytes_loaded;
int monmode;

extern int read_cpu_control_reg();
extern void flush_dtoi1();

void mymon_main()
{
  int prompt = 1;
  bytes_loaded = 0;
  errorf = 0;
  ihex_offset = 0;
  printf("CBG mymon low-level monitor. Aug-98\n");
  /*printf("CPU CR=%08X\n", read_cpu_control_reg());*/  

  init_mylinein();
#ifdef VICTORIA
  init_myvict();
#endif

#ifdef AUTORUN
  if (1)
    {
      char *argv[1];
      printf("Automatically executing \"vic\"\n");
      argv[0]="vic";
      mymon_dispatch(argv);
  }
#endif

  while(1)
  {
    char *cmd, **argv;
    monmode = 0;
    cmd = readcookedline_pe(prompt, prompt);
 
    if (cmd[0] == ':')
    {
      prompt = 0;
      intel_hex(cmd);
      continue;
    }

    prompt = 1;
    if (errorf) printf("\n\nDownload error\n\n");
    if (strcmp(cmd, "quit")==0) break;
    DB(printf(">%s<\n", cmd));
    argv = shell_parse(cmd);
    mymon_dispatch(argv);
  }
}



mymon_help(char **argv)
{
  int i; int j;
  for (i=3; i< 26; i++) 
    {
      for (j=3;j<6;j++)
	{
	  if (j == 0) j = 1;
	  printf("%i %i %i       ", i, j, i /j);
	}
      printf("\n");
    }

#ifdef VICTORIA
  printf("vic                            enter Victoria ATM program\n");
#endif
  printf("MYMON commands are:\n");
  printf("md addr [ lines ]              memory display in hex/ascii\n");
  printf("mdw addr [ lines ]             as md but displays in 32 bit words\n");
  printf("mm [-fix] b/w addr             interactive memory update\n");

#ifdef HASIO
  printf("iodb port [lines]              i/o space byte display\n");
  printf("iodl port [lines]              i/o space u32 isplay\n");
  printf("iowl port value                write word to io space\n");
#endif

  printf("mmr  b/w addr [ times ]        memory read loop\n");
  printf("mmw  b/w addr [ times ]        memory write loop\n");
  printf("go addr                        jump\n");
  printf("dis b n                        disassemble N lines from base\n");
#ifdef XILINX
  printf("xb [base end]                  boot xilinx \n");
#endif
  printf("bp [ n ] [ clear ]             breakpoint install or clear \n");
  printf("fill start end [val]           fill memory with zero or value\n");
  printf("findb start end val            find memory with this byte\n");
  printf("findl start end val            find memory with this word\n");
#ifndef IS16BIT
  printf("crc start end                  give crc of memory \n");
  printf("spec n                         execute benchmark n \n");
#endif

#ifdef PCI
  printf("pci                            \n");
#endif

#ifdef OST_VERSION
  printf("p [v]                          send a cell on VCI v, random payload\n");
  printf("g                              read a cell from the RX fifo and print\n");
  printf("cw n                           write hex value to Xilinx Card control\n");
  printf("s                              read Xilinx Card status register\n");

#endif
  printf("\n:<valid mcs line to store>\n");
  printf("offset [ v ]                   set or display download offset\n");
  printf("clear                          clear download error flag\n");
}

/*
 * Interactive memory modify
 */
mymon_mm(char **argv)
{
  int b = 0;
  int byte;
  int fixf = 0;
  char m;
  if (!strcmp(argv[1], "-fix"))
    {
      fixf = 1;
      argv ++;
    }
  m = tolower(argv[1][0]);
  if (m != 'b' && m != 'w') 
  {
    printf("Syntax  mm [-fix] b addr    for byte access\n");
    printf("Syntax  mm [-fix] w addr    for word access\n");
    return;
  }
  if (argv[2]) b = rhex(argv[2]);
  while (1)
  {
    volatile uchar *ba = (uchar *) b;
    volatile int *wa = (int *) b;
    printf("%08X ", b);
    if (m == 'b') printf("%02X >", *ba);
    if (m == 'w') printf("%08X >", *wa);
    argv = shell_parse(readcookedline_pe(0, 1));
    if (argv[0][0] == '.' || argv[0][0] == 'q') return;
    if (argv[0][0] == '-' || argv[0][0] == '^') 
    {
      if (m == 'b') b -= 1; else b -= 4;
      continue;
    }
    if (strlen(argv[0])) 
    {
      int e = 0;
      int v = rhex(argv[0]);
      if (m == 'b') *ba = v; else *wa = v;
      if (m == 'b' && *ba != v) e = 1;
      if (m == 'w' && *wa != v) e = 1;
      if (e) {  printf("ERROR "); continue; }
    }
    if (fixf == 0) { if (m == 'b') b += 1; else b += 4; }
  }
}


/*
 * Breakpoint set and clear 
 */
extern void clear_breakpoint();
extern void install_breakpoint(int);
extern int bptaddr;
mymon_bp(char **argv)
{
  if (argv[1] && strcmp(argv[1], "clear")==0)
    {
      clear_breakpoint();
    }
  else if (argv[1]) 
    {
      int a = rhex(argv[1]);
      install_breakpoint(a);
    }
  else printf("bp at %08X\n", bptaddr);

}

#ifndef IS16BIT
/*
 * CRC - 16 bit processors only
 */
int mymon_crc(char **argv)
{
  char *s, *start = 0, *end = 0;
  unsigned int r = 0;
  if (argv[1]) start = (char *) rhex(argv[1]);
  if (argv[2]) end = (char *) rhex(argv[2]);
  s = start;
  while (s <= end)
    {
      int d = *s++;
      if (r & 0x80000000) r = (r<<1) ^ 0x1C1; else r = r << 1;
      r = r ^ d;
    }
  printf("CRC %08X to %08X is %08X\n", start, end, r);
  return 0;
}
#endif

int mymon_findb(char **argv)
{
  unsigned int r = 0;
  if (argv[1] && argv[2] && argv[3])
    {
      char *start = (char *) rhex(argv[1]);
      char *end = (char *) rhex(argv[2]);
      char *s = (char *) start;
      int  val = rhex(argv[3]);
      while (s <= end)
	{
	  if (*s == val) printf("Found at %x ", s);
	  s++;
	}
      printf("... done\n");
    }
  return 0;
}

int mymon_findl(char **argv)
{
  unsigned int r = 0;
  if (argv[1] && argv[2] && argv[3])
    {
      int *start = (int *) rhex(argv[1]);
      int *end = (int *) rhex(argv[2]);
      int *s = (int *) start;
      int  val = rhex(argv[3]);
      while (s <= end && s!= start)
	{
	  if (*s == val) printf("Found at %x ", s);
	  s++;
	}
      printf("... done\n");
    }
  return 0;
}


int mymon_fill(char **argv)
{
  unsigned int r = 0;
  if (argv[1] && argv[2])
    {
      int *start = (int *) rhex(argv[1]);
      int *end = (int *) rhex(argv[2]);
      int *s = (int *) start;
      int val = 0;
      if (argv[3]) val = rhex(argv[3]);
      while (s <= end)
	{
	  *s++ = val;
	}
      printf("done\n");
    }
  return 0;
}



#ifndef IS16BIT
/*
 * benchmark
 */
int mymon_spec(char **argv)
{
  unsigned int r = 0;
  int i;
  if (argv[1]) r = rhex(argv[1]);
  printf("Benchmark %i\n", r);
  for(i=0;i<1000000;i++)
    {
      if (r) *((int *) 32) = i;
    }
  printf("Done\n");
  return 0;
}
#endif


/*
 * Tight read/write loop
 */
mymon_ma(int write, char **argv)
{
  int b = 0;
  int l = 0;  /* 0 is infinite times */
  int byte;
  char m = tolower(argv[1][0]);
  if (m != 'b' && m != 'w') 
  {
    printf("Syntax   %s b addr [times]    for byte access\n", argv[0]);
    printf("Syntax   %s w addr [times]    for word access\n", argv[0]);
    return;
  }
  if (argv[2]) b = rhex(argv[2]);
  if (argv[3]) l = rhex(argv[3]);
  if (l) printf("Loop poll of address %08X, %i times \n", b, l);
  else printf("Loop poll of address %08X forever more\n", b);
  console_flags = 0;
  while (l != 1)
  {
    volatile int dummy;
    int *wa = (int *) b;
    uchar *ba = (uchar *) b;
    if (console_flags) break;
    if (l > 1) l -= 1;
    if (m == b)
    {
      if (write==0) dummy = *ba; else *ba = dummy++;
    }
    else
    {
      if (write==0) dummy = *wa; else *wa = dummy++;
    }
  }
  printf("Done\n");
}


static int go_addr;

mymon_go(char **argv)
{
  int (*f)();
  int rc;
  if (argv[1])
  {
    go_addr = rhex(argv[1]);
  }
  printf("Execute at $%08X\n", go_addr);
  f = (int *)  go_addr;
#ifdef CACHE
  flush_dtoi();
#endif
  rc =  f(argv);
  printf("Returned %i\n", rc);
}

extern void myadis(int, int);    

int mymon_dis(char **argv)
{
  int b = 0;
  int l = 20;
  if (argv[1] && argv[1][0] != '.') b = rhex(argv[1]); else b = last_addr;
  if (argv[2]) l = rhex(argv[2]);  
  while (l-- > 0)
  {
    int *x = (int *) b;
    /*    myadis(*x, b);
     */
    b += 4;
  }
  last_addr = b;
  return 0;
}


/*
 * Xilinx boot
 *  clock is gio2,
 * prog is gio1,
 * data is gio0
 */
void MDEL()
{
  volatile int i;
  for (i=0;i<100;i++) continue;
}

#ifdef XILINX

void xbyte(uchar c)
{
  int i;
  volatile int *port = (int *) 0xC4000040; /* Access to Quark GPIO pins */
  for (i=0; i<8; i++)
    {
      int d = (c & 1) << 8;
      
      *port = (0x10001400 | d);  /* Write with clock high */
      MDEL(0);
      *port = (0x10000400 | d);     /* Write with clock low */
      MDEL(0);
      *port = (0x10001400 | d);  /* Write with clock high again */
      MDEL(0);
      c = c >> 1;
    }
}

extern char xfile[];
extern char xfile_end[];
int mymon_xboot(char **argv)
{
  char *start = xfile;
  char *end = xfile_end;
  char *s;
  volatile int *port = (int *) 0xC4000040; /* Access to Quark GPIO pins */
  *port = 0x10000110;  /* put clock and data high, prog low */
  MDEL(0);
  if (argv[1]) start = (char *) rhex(argv[1]);
  if (argv[2]) end = (char *) rhex(argv[2]);
  printf ("Xilinx boot from %08X to %08X\n", start, end);
  *port = 0x10000150;  /* put clock and data high, prog high */
  s = start;
  while (s != end)
    {
      xbyte(*s++);
    }
  xbyte(0xFF);
  xbyte(0xFF);
}
#endif


int mymon_md(char **argv)
{
  int b = 0;
  int l = 1;
  if (argv[1] && argv[1][0] != '.') b = rhex(argv[1]); else b = last_addr;
  
  if (argv[2]) l = rhex(argv[2]);  
  console_flags = 0;
  while (l-- > 0)
  {
    int i;
    uchar *x = (uchar *) b;
    printf("%X  ", b);
    for (i=0; i<16; i++)
    {
      printf("%02X ", x[i]);
      if ((i & 3) == 3) printf(" ");
    }
    printf("  ");
    for (i=0; i<16; i++)
    {
      uchar t = x[i];

      if (t <32 || t >= 127) t = '.';
      printf("%c", t);
    }
    printf("\n");
    b += 16;
    if (checkend()) break;
  }
  last_addr = b;
  return 0;
}
    
int mymon_md_w(char **argv)
{
  int b = 0;
  int l = 1;

  if (argv[1] && argv[1][0] != '.') b = rhex(argv[1]); else b = last_addr;
  if (argv[2]) l = rhex(argv[2]);  
  while (l-- > 0)
  {
    int i;
    int *xw = (int *) b;
    uchar *x = (uchar *) b;

    printf("%X  ", b);

    for (i=0; i<4; i++)
    {
      printf("%08X   ", xw[i]);
    }
    for (i=0; i<16; i++)
    {
      uchar t = x[i];
      if (t <32 || t >= 127) t = '.';
      printf("%c", t);
    }
    printf("\n");
    b += 16;
  }
  last_addr = b;
  return 0;
}


#ifdef HASIO
/*
 * long io read display
 */
int mymon_iodl(char **argv)
{
  int b = 0;
  int l = 1;

  if (argv[1] && argv[1][0] != '.') b = rhex(argv[1]); else b = last_addr;
  if (argv[2]) l = rhex(argv[2]);  
  while (l-- > 0)
  {
    int i;

    printf("%X : ", b);

    for (i=0; i<16; i+=4)
    {
      printf("%08X   ", inl(b+i));
    }
    printf("\n");
    b += 16;
  }
  last_addr = b;
  return 0;
}


int mymon_iodb(char **argv)
{
  int b = 0;
  int l = 1;

  if (argv[1] && argv[1][0] != '.') b = rhex(argv[1]); else b = last_addr;
  if (argv[2]) l = rhex(argv[2]);  
  while (l-- > 0)
  {
    int i;

    printf("%X : ", b);

    for (i=0; i<16; i++)
    {
      printf("%02X ", inb(i+b));
    }
    printf("\n");
    b += 16;
  }
  last_addr = b;
  return 0;
}


int mymon_iowl(char **argv)
{
  if (argv[1] && argv[2])
    {
      int port = rhex(argv[1]);
      int val = rhex(argv[2]);
      outl_p(val, port);
    }
  else printf("error: syntax is : ioww port value\n");
  return 0;
}
#endif


int mymon_clear()
{ 
  /* Corrput count on an error */
  printf("\n::%i bytes loaded\n", bytes_loaded - errorf);
  errorf = 0;

  bytes_loaded = 0;
  return 0; 
}

extern void zog1(void);
extern void zog2(void);
extern void zog3(void);
extern void zog4(void);
extern void zog5(void);

int mymon_offset(char **argv)
{
  if (argv[1]) ihex_offset = (uchar *) rhex(argv[1]);
  printf("Offset for hex download 0x%08X\n", ihex_offset);
  return 0;
}

int mymon_dispatch(char **argv)
{
  /* printf("command echo %s %s\n", *argv, argv[1]);
   */
  if (*argv == NULL || strlen(*argv)==0) return;
  if (strcmp(*argv, "?")==0  || strcmp(*argv, "help")==0) return mymon_help(argv);
  if (strcmp(*argv, "md")==0) return mymon_md(argv);
  if (strcmp(*argv, "mdw")==0) return mymon_md_w(argv);
  if (strcmp(*argv, "mmw")==0) return mymon_ma(1, argv);

#ifdef HASIO
  if (strcmp(*argv, "iodl")==0) return mymon_iodl(argv);
  if (strcmp(*argv, "iodb")==0) return mymon_iodb(argv);
  if (strcmp(*argv, "iowl")==0) return mymon_iowl(argv);
#endif

/*
  if (strcmp(*argv, "debug")==0) return cmd_set_debug(argv);
*/

#ifdef PCI
  if (strcmp(*argv, "pci")==0) { cmd_pci(argv); return 0; }
#endif


#if 0
  if (strcmp(*argv, "z1")==0) { zog1(); return 0; }
  if (strcmp(*argv, "z2")==0) { zog2(); return 0; }
  if (strcmp(*argv, "z3")==0) { zog3(); return 0; }
  if (strcmp(*argv, "z4")==0) { zog4(); return 0; }
  if (strcmp(*argv, "z5")==0) { zog5(); return 0; }
#endif

#ifdef CACHE
  if (strcmp(*argv, "dtoi")==0) { flush_dtoi(); return 0; }
#endif

#ifdef VICTORIA
  if (strcmp(*argv, "vic")==0) return myvict_main(0, argv);
#endif

  if (strcmp(*argv, "bp")==0) return mymon_bp(argv);
  if (strcmp(*argv, "mmr")==0) return mymon_ma(0, argv);
  if (strcmp(*argv, "mm")==0) return mymon_mm(argv);
  if (strcmp(*argv, "go")==0) return mymon_go(argv);
  if (strcmp(*argv, "dis")==0) return mymon_dis(argv);
  if (strcmp(*argv, "clear")==0) return mymon_clear();
#ifndef IS16BIT
  if (strcmp(*argv, "crc")==0) return mymon_crc(argv);
  if (strcmp(*argv, "spec")==0) return mymon_spec(argv);
#endif
  if (strcmp(*argv, "fill")==0) return mymon_fill(argv);
  if (strcmp(*argv, "findb")==0) return mymon_findb(argv);

#ifdef XILINX
  if (strcmp(*argv, "xb")==0) return mymon_xboot(argv);
#endif


  if (strcmp(*argv, "findl")==0) return mymon_findl(argv);

  if (strcmp(*argv, "offset")==0) return mymon_offset(argv);
#ifdef OST_VERSION
  if (strcmp(*argv, "p")==0) return mymon_atmsend(argv);
  if (strcmp(*argv, "g")==0) return mymon_atmget(argv);
  if (strcmp(*argv, "s")==0) return mymon_status(argv);
  if (strcmp(*argv, "cw")==0) return mymon_control(argv);
#endif
  sayprompt(); printf("Possibly an error >%s< >%s<\n", argv[0], argv[1]);
}

char *inpoi;
int iread(len)
{
  int r = 0;
  int i;
  for (i=0; i < len; i++)
  {
    char c = toupper(*inpoi++);
    while (c == ' ') c = toupper(*inpoi++);
    c = (c <= '9') ? c-'0': c-('0'+7);
    r = (r<<4) + c;
  }
  return r;
}


int handle_ihex(int write, char *src)
{
  int llen, laddr, ltype;
  uchar lsum;
  int wq;
  inpoi = src+1; /* Skip colon */
  llen = iread(2);
  laddr = iread(4);
  ltype = iread(2);
  if (ltype == 2 && llen == 2) /* segment indication */
    {
      ihex_offset = (uchar *) (iread(4) << 4); 
      lsum = iread(2);  /* ignore check sum of segment ! */
      return errorf;
    }
  else if (ltype != 0)
    {
      printf("Unknown type 0x%x encountered in line %s\n", ltype, src);
      errorf = 1;
      return errorf;
    }
  lsum = llen + laddr + ltype + (laddr >> 8);
  for (wq=0; wq<llen; wq++)
    {
      uchar data = iread(2);
      lsum = lsum + data;
      if (write) ihex_offset[laddr] = data;
      laddr += 1;
      bytes_loaded += 1;
    }
  lsum += iread(2);
  if (lsum != 0) 
    { 
      printf("Checksum error in line %s, residue 0x%X (%X)\n", src, lsum, llen);
      errorf = 1;
      return errorf;
    }
  return errorf;
}


intel_hex(char *t)
{
  if (*t != ':') return;
  if (handle_ihex(0, t)) errorf = 1;
  if (errorf == 0) handle_ihex(1, t);
} 


sayprompt()
{
  if (monmode==0)  printf("mymon:");
  else if (monmode==1) printf("V: ");
  else printf("WC: ");
}

/*
 * OST PIE Specific Code Follows
 */

#ifdef OST_VERSION
mymon_control(char **argv)
{
  if (argv[1]) *PIE_CONTROL = rhex(argv[1]);
}

mymon_status()
{
  printf("Status = %02X\n", *PIE_STATUS);
}
#endif


/* End of cbg mymon.c */


