
/* CBG solos c preprocessor */


/* cbgc closure c compiler 4th January 1992 
 *
 * ANSI -Wall version.
 *
 * (C) 1990-95 Tenison Technology
 * DJ Greaves
 * Tenison Technology
 * 10 Tenison Road
 * Cambridge CB1 2DW
 */

/* another comment */


#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "ccchdr.h"

extern void banner();

/* A struct for a macro argument */
typedef struct marg 
{ char *pram; struct marg *next;  
} MARG;

typedef struct macro 
{
  char *mname, *mbody;
  struct macro *next;
  struct marg * args;
} MACRO;

int prepeval(char *pp);
void finalchar(char c);
void unfinalchar();
int toklen(char *pp);
int macmatch(char *fixed, char *var);
void undef(char *name);
void hashdefine(char *name);
void swap(char **p, char **q);
int cppverbose = 0;
int readsrcfile(char *name, char *pp);
void scanchange(char *pp, char old, char new);
void expand(char *pp, struct macro *env, int depth);
void mactable_init();
int preplev9();
int preplev6();
int preplev5();
int preplev45();
int preplev4();
int preplev3();
int preplev2();
void hashdefstr(char *x, char *q);



FILE *sysin;

int eflag = 1;  /* -E option flag to echo expanded input */
char *outpoi;
int errors;
int copying;


const maxfilelen = (500100);

char *buffer1, *buffer2, *buffer3, *outbuffer;
char *macrocmd();
char *eoline();
struct macro *maclookup();
struct macro *menvlookup();
int listing = 0;


void cpperror(char *p, char *q, char *r)
{
  banner();
  printf(p, q, r);
  printf("\n");
  errors += 1;
}

void cppfatal(char *p, char *q, char *r)
{
  banner();
  printf(p, q, r);
  printf("\n");
  exit(1);
}


#ifdef CPPMAIN
int cppmain(argc, argv) char **argv;
{
  cppinit();
  if (argc < 2)
  {
    printf("usenix: cpp [ -v -dumpmacros ] fn \n");
    return 1;
  }
  while(1)
  {
    if (strcmp(argv[1], "-v")==0)
    {
      cppverbose = 1;
      argv++;
      argc--;
      continue;
    }

    if (strcmp(argv[1], "-dumpmacros")==0)
    {
      dumpmacs = 1;
      argv++;
      argc--;
    }
    break;
  }
  cpprun(argv[1]);
}
#endif


void cppinit()
{
  mactable_init();
  buffer1 = malloc(maxfilelen);  /* primary source */
  buffer2 = malloc(maxfilelen);  /* Include file to be inserted */
  buffer3 = malloc(maxfilelen);
  outbuffer = malloc(maxfilelen);
  /* hashdefstr("__DATE__", datestring()); */
}

void buftofile(char *pp, char *fn)  /* Print buffer to a file */
{
  FILE *fd = fopen(fn, "w");
  int len = strlen(pp);
  if (fd)
  {
    fwrite(pp, 1, len, fd);
    fclose(fd);
  }
}


void topexpand(pp) char *pp;
{ 
  outpoi = outbuffer;
  expand(pp, NULL, 0);
}

char *getlitem(e) char *e;
{
   char *s = e;
   char * r;
   int instring = 0;
   int len;
   int parens = 0;
   while (1)
   {
     char c = *e++;
     if (c == '"') instring = 1 - instring;
     if (instring) continue;
     if (c == '(') parens ++;
     if (c == ')') 
     {
       if (parens == 0) break;
       parens --;
       continue;
     }
     if (parens == 0 && c == ',') break;
     if (c == 0) break;
   }
   len = e - s - 1;
   r = malloc(len + 1);
   strncpy(r, s, len);
   r[len] = 0;
   return r;
}
   

struct macro *newenv(pp, env, ap) char *pp; struct macro *env; struct marg *ap; 
{ 
  struct macro *nm;
  while (ap)
  {
    char *litem = getlitem(pp);
    pp += strlen(litem)+1;

    if (cppverbose) printf("Add >%s< to env with >%s<\n", ap->pram, litem);
    nm = (struct macro *) malloc(sizeof(struct macro));
    nm -> next = env;
    env = nm;
    nm -> mbody = litem;
    nm -> mname = ap->pram;
    nm -> args = NULL;
    ap = ap->next;
  }
  return env;
}


void expand(char *pp, struct macro *env, int depth)
{
  int instring = 0;
  char stringtype;
  struct macro *nenv;
  if (cppverbose) printf("Expanding >%.20s...<\n", pp);
  if (depth > 100) 
  { 
    cpperror("recursive macro production %s", pp, "");
    return;
  }
  while(1)
  {
    char c;  
    int n;
    struct macro *mm;
    c = *pp;
    if (c == 0)
    {
      finalchar(0);
      return;
    }

    if (c == '\\')
    {
       finalchar(c);
       pp++;
       finalchar(*pp++);
       continue;
    }
    if (c == '"')
    {
      if (instring && stringtype == '"') instring = 0;
      else if (instring == 0)
      {
        stringtype = '"';
        instring = 1;
      }
    }
    if (c == '\'')
    {
      if (instring && stringtype == '\'') instring = 0;
      else if (instring == 0)
      {
        stringtype = '\'';
        instring = 1;
      }
    }

    if (instring || (!isalnum(c) && c != '_'))
    {
      finalchar(c);
      pp++;
      continue;
    }

    n = toklen(pp);
    mm = menvlookup(pp, env, n);
    if (mm == NULL) mm = maclookup(pp, 0, n, "");
    if (mm) 
    {
      struct marg *ap = mm->args;
      pp += n;
      while(*pp == ' ') pp++;


      if (cppverbose) printf("Expanding %s with ap %s \n", mm->mname, mm->mbody);
      nenv = NULL;
      if (ap != NULL)
      {
        if (*pp != '(')
        {
	  printf(">%s<\n", pp);
	  cpperror("arg %1.20s for %1.20s missing", ap->pram, mm->mname);
        }
        else
        {
          int pars = 1;
          pp++;
          nenv = newenv(pp, nenv, ap);     
          while (*pp && pars > 0)
          { 
            if (*pp == ')') pars--;
            if (*pp == '(') pars++;
            pp++;
          }
        } 
      }
      expand(mm->mbody, nenv, depth+1);
      unfinalchar();
      finalchar(' ');
      continue;      
    }
    else
    {
      int i;
      for(i=0;i<n;i++) finalchar(*pp++);
    }    
  }
}  

int toklen(char *pp)
{
  int r = 0;
  while(1)
  {
    char c = *pp++;
    if (isalnum(c)==0 && c != '_') return r;
    r++;
  }
}


void stripcomments(char *buffer)
{
  int instring = 0;
  char stringtype;
  char *pp = buffer;
  char *dp = buffer;  /* Output to input buffer since output always shorter ! */
  while(1)
  {
    char c = *pp++;
    if (c == 0) 
    {
      *dp = 0;
      return;
    }

    if (instring == 0 && c == '/' && *pp == '*')  /* Strip comments */
    {
      pp++;
      while(1)
      {
        char c1 = *pp++;
        if (c1 == 0) cppfatal("end of file in comment", "", "");
        if (c1 == '*' && *pp == '/')
        {
          pp++;
          break;
        }
      }
      continue;
    }        

    if (c == '"')
    {
      if (instring && stringtype == '"') instring = 0;
      else if (instring == 0)
      {
        stringtype = '"';
        instring = 1;
      }
    }
    if (c == '\'')
    {
      if (instring && stringtype == '\'') instring = 0;
      else if (instring == 0)
      {
        stringtype = '\'';
        instring = 1;
      }
    }
    *dp++ = c;
  }
}

void passOne(char *pp)
{ 
  int atsol = 1;
  int inastring = 0;
  copying = 1;

  outpoi = outbuffer;
  while(1)
  {
    char c = *pp++;
    if (c == 0) 
    {
      finalchar(0);
      return;
    }
 
    if (c == '#' && atsol)
    {
      pp = macrocmd(pp);
      continue;
    }

#ifdef OLDSTRIP
    if (inastring == 0 && c == '/' && *pp == '*')  /* Strip comments */
    {
      pp++;
      while(1)
      {
        char c1 = *pp++;
        if (c1 == 0) cppfatal("end of file in comment", "", "");
        if (c1 == '*' && *pp == '/')
        {
          pp++;
          break;
        }
      }
      continue;
    }        
#endif

    /* Update at start of line flag */
    if (c == '\n')  atsol = 1; else if (c > ' ') atsol = 0;
    if (copying & 1) 
    {
      finalchar(c);
      if (c == '"') inastring = 1-inastring;
    }
  }
}

char * macrocmd(pp) char *pp;
{
  while(*pp == ' ') pp++;

  if (strncmp(pp, "define", 6)==0)
  {
      char *toat = eoline(pp);
      pp += 6;
      scanchange(pp, '\n', 0);
      if (copying & 1) hashdefine(pp);
      return toat;
  }

  if (strncmp(pp, "undef", 5)==0)
  {
      char *toat = eoline(pp);
      pp += 6;
      scanchange(pp, '\n', 0);
      if (copying & 1) undef(pp);
      return toat;
  }

  if (strncmp(pp, "define", 6)==0)
  {
      char *toat = eoline(pp);
      pp += 6;
      scanchange(pp, '\n', 0);
      if (copying & 1) hashdefine(pp);
      return toat;
  }

  if (strncmp(pp, "include", 7)==0)
  {
      char *toat = eoline(pp);
      char *fn1 = pp + 7;
      scanchange(fn1, '\n', 0);
      if (copying & 1)
      {
        char *d = buffer3;
        char *s;
        if (readsrcfile(fn1, buffer2))
        {
          printf("cpp: could not include %s\n", fn1);
          return toat;
        }

        s = buffer1;  /* Copy first half of buffer 1 to buffer 3 */
        while(s != pp) *d++ = *s++;

        s = buffer2; /* Cat buffer 2 onto buffer 3 */
        pp = d;  /* This is the point to resume processing */
        while(*s) *d++ = *s++;



        s = toat;    /* Cat remainder of 1 onto 3 */
        while(*s) *d++ = *s++;
        *d = 0; 
        swap(&buffer3, &buffer1);

        if(cppverbose) printf("Size %i chars\n", strlen(buffer1));
        if (strlen(buffer1) >= maxfilelen) cppfatal("cpp output too long", "", "");
        return pp;
      }
      return toat;
  }

  if (strncmp(pp, "ifdef", 5)==0)
  {
      char *toat = eoline(pp);
      pp += 5;
      scanchange(pp, '\n', 0);
      while (*pp == ' ') pp++;
      copying = (copying << 2) + 2;
      if (copying & 4)
         if (maclookup(pp, 0, toklen(pp), "")!=NULL) copying = copying | 1;
      return toat;
  }


  if (strncmp(pp, "ifndef", 6)==0)
  {
      char *toat = eoline(pp);
      pp += 6;
      scanchange(pp, '\n', 0);
      while (*pp == ' ') pp++;
      copying = (copying << 2) + 2;
      if (copying & 4)
          if (maclookup(pp, 0, toklen(pp), "") == NULL) copying = copying | 1;
      return toat;
  }

  if (strncmp(pp, "if", 2)==0)  /* #if comes after #ifdef and #undef */
  {
      char *toat = eoline(pp);
      pp += 2;
      scanchange(pp, '\n', 0);
      while (*pp == ' ') pp++;
      copying = copying << 2;
      if (copying & 4)
           if (prepeval(pp)) copying = copying | 1;
      return toat;
  }

  if (strncmp(pp, "elif", 4)==0)  /*  */
  {
      char *toat = eoline(pp);
      pp += 2;
      if (copying < 2) cppfatal("spurious elif surprise", "", ""); 
      scanchange(pp, '\n', 0);
      while (*pp == ' ') pp++;
      if (copying & 1) copying -= 1;
      else 
	{ if (copying & 4)
	  if (prepeval(pp)) copying = copying | 1;
	}
      return toat;
  }

  if (strncmp(pp, "warn", 4)==0)
  {
    char *rex = eoline(pp);
    scanchange(pp, '\n', 0);
    if (copying & 1) printf("cpp: %i warning: %s\n", copying, pp+4);
    return rex;
  }

  if (strncmp(pp, "error", 5)==0)
  {
    char *rex = eoline(pp);
    scanchange(pp, '\n', 0);
    if (copying & 1) printf("cpp: %i error: %s\n", copying, pp);
    exit(1);
    return rex;
  }

  if (strncmp(pp, "else", 4)==0)
  {
    if (copying < 2) cppfatal("spurious else surprise", "", ""); 
    if (copying & 1)  copying = copying - 1;
    else
    {
      if (copying & 4) copying += 1;  /* Else clause only runs if enclosing */
    }                                 /* block is enabled. */
   return eoline(pp);
  }

  if (strncmp(pp, "endif", 5)==0)
  {
    if (copying < 4) cppfatal("spurious endif surprise", "", ""); 
    copying = copying >> 2;
    return eoline(pp);
  }

  if (strncmp(pp, "pragma", 5)==0)
  {
    printf("cpp: ignoring %.35s...\n", pp);
    return eoline(pp);
  }

  cpperror("unknown cpp directive '%.15s...'", pp, "");
  return eoline(pp);
}


void unfinalchar()
{
  outpoi --;
}

void finalchar(char c)
{
  if (listing) putchar(c); 
  *outpoi ++ = c;
}




/* mode 1 for define on not found.  mode 0 for dont */
/* Open hash table of macros */
const HASHSIZE = 4096;
struct macro **mactable;

void mactable_init()
{
  int i;
  mactable = (struct macro **) malloc(HASHSIZE*4);
  for (i=0; i<HASHSIZE; i++) mactable[i] = NULL; 
}

void dumpmacros()
{
  int h;
  for (h=0; h<HASHSIZE; h++) 
  {
    struct macro *r = mactable[h];
    while(r)
    {
      printf(">%s<  >%s<\n", r->mname, r->mbody);
      r = r->next;
    }
  }
}

struct macro *maclookup(name, mode, len, prim) char *name, *prim;
{
  struct macro *r;
  int h = 0;
  char *hp = name;
  int i;
  for(i=0;i<len;i++) h = (h<<1) + *hp++;
  h = h & (HASHSIZE-1);
  r = mactable[h];
  while(r)
  {
    if (macmatch(r->mname, name)==0) 
    {
      if (mode == 1) cpperror("macro %s defined again", name, "");
      if (mode == 1) cpperror("old value >%s<", r->mbody, "");
      return r;
    }
    r = r->next;
  }
  if (mode == 0) return NULL;
  r = (struct macro *) malloc(sizeof(struct macro));
  r->next = mactable[h];
  mactable[h] = r;

  r->mname = malloc(len+1);
  strncpy(r->mname, name, len);
  r->mname[len] = 0;
  r->args = NULL;
  return r;
}


int cpprun(char *srcname, int dumpmacs)
{
  int rc = readsrcfile(srcname, buffer1);
  if (rc) return 1;
  hashdefstr("__FILE__", srcname);
  passOne(buffer1);  /* Pass 1 performs conditional evaluation and includes */
  swap(&buffer1, &outbuffer);
  if (dumpmacs) dumpmacros();
  topexpand(buffer1);
  swap(&buffer1, &outbuffer);
  /* buftofile(buffer1, "tempcpp.c"); */
  return errors;
}
  
struct marg * reverseargs(x, c) struct marg * x, *c;
{
  struct marg * ap;
  if (x == NULL) return c;
  ap = x->next;
  x->next = c;
  return reverseargs(ap, x);
}
  
/* See if string fixed is a lstring of var */
int macmatch(char *fixed, char *var)
{
  while(*fixed) if (*fixed++ != *var++) return -1;
  if (isalnum(*var) || *var == '_') return -1;
  return 0;
}

struct macro *menvlookup(name, r, len) char *name; struct macro *r;
{
  while(r)
  {
    if (macmatch(r->mname, name)==0)
    {
      return r;
    }
    r = r->next;
  }
  return NULL;
}

void undef(char *name)  /* Code to perform #undef */
{
  struct macro *nm;
  int len;
  while(*name == ' ') name++;
  len = toklen(name);
  nm = maclookup(name, 0, len, "[UNDEF]");
  if (nm != NULL)
  {
    nm->mname = "**";   /* Change macro name to something illegal */
  }
}

char htbuf[132];

void hashdefstr(char *x, char *q)
{
  strcpy(&htbuf[0], x);
  strcat(&htbuf[0], "\"");
  strcat(&htbuf[0], q);
  strcat(&htbuf[0], "\"");
  hashdefine(&htbuf[0]);
}

void hashdefine(char *name)
{
  struct macro *nm;
  int len;
  int bodlen;
  while(*name == ' ') name++;
  len = toklen(name);

  nm = maclookup(name, 1, len, "[X]");
/*
  if (dumpmacs) printf("%.100s defined\n", name);
*/
  name += len;
  nm->args = NULL;
/* now chech for dummy args */
/* There must be no space before the dummy arg lparen */
  if (*name == '(')
  {
    name++;
    while(1)
    { 
      struct marg * ap;
      int n;
      while (*name == ' ') name++;
      if (*name == 0) break;
      if (*name == ')')
      { 
         name++;
         break;
      }
      n = toklen(name);  
/*      printf("arg of size %i at %s", n, name);
*/
      ap = (struct marg *) malloc(sizeof(struct marg));
      ap -> next = nm->args;
      nm ->args = ap;
      ap -> pram = malloc(n+1);
      strncpy (ap->pram, name, n);
      ap->pram[n] = 0;     
      name += n;
      if (*name == ',') name ++;
    }
  }

/* Now body of definition */
  nm->args = reverseargs(nm->args, NULL);

  while(*name == ' ') name++;    
  bodlen = strlen(name);
/*
  printf("hashdefine of %x >%s< for %i\n", *name, name, bodlen);
*/
  nm ->mbody = malloc(bodlen+1);
  strncpy(nm->mbody, name, bodlen);
  nm->mbody[bodlen] = 0;
}

  
 


char *eoline(pp) char *pp;
{
  while(*pp && *pp != '\n') pp++;
  if (*pp == '\n') pp++;
/*  printf("eoline returns >%s<\n", pp);
*/
  return pp;
}


void swap(char **p, char **q)
{
  char *t;
  t = *p;
  *p = *q;
  *q = t;
}


void scanchange(char *pp, char old, char new) 
{
  while(*pp)
  {
    if (*pp == old) 
    {
      *pp = new;
      return;
    }
    pp++;
  }
}

void dumpfile(char *pp)
{
  while(*pp) putchar(*pp++);
}
 

char aname[132];
int readsrcfile(char *name, char *pp)  /* Return 1 for error */
{
  int len;
  char *buffer = pp;
  char *epoint;
  char *sp;
  int mf = 0;

  int i;
  while (*name <= ' ') name++;
  sysin = NULL;

  if (*name == '<') for (i=0;i<sys_dirs;i++)
    {
      if (*name == '<')
	{
	  strcpy(aname, default_sys_dirs[i]);
	  strcat(aname, "/");
	  strcat(aname, name+1);
	  scanchange(aname, '>', 0);
	}
      if (mf) printf("Search %s\n", aname);
      sysin = fopen(aname, "r");
      if (sysin) break;
    }
  else if  (*name == '"') for (i=0;i<usr_dirs;i++)
    {
      if (*name == '"')
	{
	  strcpy(aname, default_usr_dirs[i]);
	  strcat(aname, "/");
	  strcat(aname, name+1);
	  scanchange(aname, '"', 0);
	}
      if (mf) printf("Search %s\n", aname);
      sysin = fopen(aname, "r");
      if (sysin) break;
    }
  else /* not quotes, then cmd line -> scan current dir */
    {
      strcpy(aname, name);
      if (mf) printf("Search %s\n", aname);
      sysin = fopen(aname, "r");
    }

  if (sysin == NULL)
    {
      printf("cpp: cant open %s for input\n", name);
      return 1;
    }
  len = fread(buffer, 1, maxfilelen, sysin);
  fclose(sysin);
  if (len == maxfilelen) cppfatal("file %s too long", name, "");

  epoint = buffer + len;
  sp = buffer;

  while(sp < epoint)  /* Rework to same buffer since bound to be shorter */
  {
    char c = *sp++;
    if (c == 0) continue;
    if (c == 13) c = '\n';
    if (c == 9) c = ' ';
    if (c == '\\') /* Strip backslash-newline sequences */
    {
      c = *sp++;
      if (c == '\n' || c == 13) continue;
      *pp++ = '\\';
    }
    *pp++ = c;
  }
  *pp = 0;  /* One null only on the end */
  if (cppverbose) printf("%s %i chars\n", aname, len);
  stripcomments(buffer);
  return 0;
}
  

char *gpp;

void evskipsp()
{
  while(*gpp == ' ') gpp++;
}


int pevop(ss) char *ss;
{
  evskipsp();
  if (strncmp(ss, gpp, strlen(ss))==0)
  {
    gpp += strlen(ss);
    return 1;
  }
  return 0;
}

/* Level 1 of pre-processor manifest constant evaluator */
int preplev1() /* Handle logical OR */
{
  int r = preplev2();
  while (pevop("||"))
  {
    int s = preplev2();
    if (s) r = s;
  }
  return r;
}

int preplev2() /* Handle logical AND */
{
  int r = preplev3();
  while (pevop("&&"))
  {
    int s = preplev3();
    if (s==0) r = 0;
  }
  return r;
}

int preplev3() /* Handle comparison ops arithmetic != and == */
{
  int r = preplev4();
  while (1)
  { 
    if (pevop("=="))
    {
      int s = preplev4();
      return (r==s) ? 1:0;
    }
    else if (pevop("!="))
    {
      int s = preplev4();
      return (r!=s) ? 1:0;
    }
    else if (pevop(">="))
    {
      int s = preplev4();
      return (r>=s) ? 1:0;
    }
    else if (pevop("<="))
    {
      int s = preplev4();
      return (r<=s) ? 1:0;
    }
    else if (pevop(">"))
    {
      int s = preplev4();
      return (r>s) ? 1:0;
    }
    else if (pevop("<"))
    {
      int s = preplev4();
      return (r<s) ? 1:0;
    }
    else break;
    }
  return r;
}


int preplev4() /* Handle arithmetic >> and << */
{
  int r = preplev45();
  while (1)
  {
    if (pevop("<<"))
    {
      int s = preplev45();
      r = r << s;
    }
    else if (pevop(">>"))
    {
      int s = preplev45();
      r = r >> s;
    }
    else break;
    }
  return r;
}

int preplev45() /* Handle arithmetic + and - */
{
  int r = preplev5();
  while (1)
  {
    if (pevop("+"))
    {
      int s = preplev4();
      r = r + s;
    }
    else if (pevop("-"))
    {
      int s = preplev4();
      r = r - s;
    }
    else break;
    }
  return r;
}

int preplev5() /* Handle arithmetic * / and % */
{
  int r = preplev6();
  while (1)
  {
    if (pevop("*"))
    {
      int s = preplev5();
      r = r * s;
    }
    else if (pevop("/"))
    {
      int s = preplev6();
      r = r / s;
    }
    else if (pevop("%"))
    {
      int s = preplev6();
      r = r % s;
    }
    else break;
    }
  return r;
}

int preplev6()
{
  return preplev9();
}

/* Level 9 of pre-processor manifest constant evaluator */
int preplev9()
{
  char c;
  evskipsp();
  c = *gpp;
  if (c==0) return 0;

  if (c == '!')  /* monadic not operator */
  {
    gpp++;
    if (preplev9()) return 0;
    return 1;
  }

  if (c == '-')  /* monadic negate operator */
  {
    gpp++;
    return 0-preplev9();
  }

  if (isdigit(c))  /* numbers */
  {
    int r = atoi(gpp);
    while (isalnum(*gpp)) gpp++;
    c = toupper(*gpp);
    if (c== 'U' || c == 'L') gpp++;
    return r;
  }

  if (c == '\'')  /* Ascii constants */
    {
      char *gst = gpp;
      int r;
      gpp++;
      r = *gpp++;
      if (r == '\\')
	{
	  char v = *gpp++;
	  if (isdigit(v))
	    {
	      r = 0;      
	      while (isdigit(v))
		{
		  r = (r<<3) + (v-'0');
		  v = *gpp++;
		}
	    }
	  else 
	    {
	      if (v=='n') r = '\n'; else r = v;
	    }
	}
      if (*gpp++ != '\'') cpperror("Closing single quote missing %s", gst, "");
      return r;
    }
  
     
  if (c == '(')
  {

    int r;
    gpp++;
    r  = preplev1();
    if (*gpp++ != ')') cppfatal("parenthesis mislaid %s", gpp-1, "");
    return r;
  }

  if (strncmp(gpp, "defined", 7)==0)
  {
    int parenf = 0;
    int r = 0;
    int len;
    gpp += 7;
    evskipsp();
    if (*gpp == '(')
    {
      gpp++;
      parenf = 1;
    }
    len = toklen(gpp);
    if (maclookup(gpp, 0, len, "Y")!=NULL) r=1; 
    gpp += len;
    if (parenf) gpp++; /* Skip close paren */
    return r;
  }
  if (toklen(gpp))
  {
    int len;
    int r = 0;
    len = toklen(gpp);
    if (maclookup(gpp, 0, len, "Z")!=NULL) r=1; 
    gpp += len;
    return r;
  }
  cppfatal("Bad preprocessor expression %s", gpp, "");
  return 0;
}

  
int prepeval(char *pp) 
{
  int r;
  gpp = pp;
  r = preplev1();
  return r;
}

#if 0

char datebuf[100];

char *monthdata =
     "jan-feb-march-april-may-june-july-aug-sept-oct-nov-dec-";


void char *month(m)   /* 1 for Jan */
{
  char *p = monthdata;
  char *q;
  while (m > 1)
   {
     while (*p != (char) 0 && *p != '-') p++;
     p++;
     m --;
   }
  q = p;
  while (*q != (char) 0 && *q != '-') q++;
  *q = (char) 0;
  return p;
}


char *datestring()
{
  char *p = datebuf;
  int dd = msdostime();
  int d = dd & 0xFFFF;
  sprintf(p, "%02i:%02i:%02i", d >> 11,      /* Time field */
                               (d & 0x7E0) >> 5,
                               (d & 0x1F) << 1);
  d = dd >> 16;
  p = datebuf + strlen(datebuf);
  sprintf(p, "  %i-%s-%i", d & 31,
                       month((d & 0x1E0) >> 5),
                       1980 + ((d & 0xFE00) >> 9));
  return datebuf;
}
#endif



/* end of cbg cpp.c */

