

/* cbgc closure c compiler 4th January 1992 
 *
 * ARX version 
 *
 * (C) 1990-95, 1998 Tenison Technology
 * DJ Greaves
 * Tenison Technology
 * 10 Tenison Road
 * Cambridge CB1 2DW
 */



#include <stdio.h>
#include <malloc.h>
#include "ccchdr.h"

extern char * malloc();
EXPRESSION *loadtoh(EXPRESSION *ex);
struct expression *mul124(), *longmult();
extern int mode_arx_000;

/* prototypes */
int pointedsize(EXPRESSION *e);
EXPRESSION *remove_index(EXPRESSION *e);

extern int tracing;


/*
 * If an indirect register > 3 is needed for ALU ops, then
 * this cannot be supported, so must do a loadto.
 */
EXPRESSION *kill_hi_index_regs(EXPRESSION *e)
{
  if (e->einds > 0 && e->epathhi == e_register && e->epathlo > 3)
    {
      e = gloadto(e);
    }
  return e;
}




EXPRESSION *pexp(EXPRESSION *ex)
{
  extern FILE *sysout;
  
  return fpexp(sysout, ex);
}


/*
 * See if data is a possible ARM immediate value. 
 * rotate left till packed into bottom byte 
 */
int packable_arm_imed(unsigned int vin)
{
  unsigned int v = vin;
  int r;
  for (r=0; r<16; r++)
    {
      if (v < 256) 
	{
	  return 1;
	}

      v = (v << 2) | ((v >> 30) & 3);
    }
    return 0;
}


int must_adrf_it(EXPRESSION * rhs)
{
  int adrf;
  /*	  if (rhs->epathlo == el_symbolic) adrf = 1;
	  else
	  */
  if (rhs->epathlo == el_label) adrf = 1;
  else adrf = 0;
  return adrf;
}


/*
 * mover requires both args to be valid target modes
 * and should just generate code chosing the best instruction
 * for the job in non-orthogonal processors (e.g. ARM).  Note, ARM
 * requries at least one arg to be a register, so dont call this
 * routine unless that is the case. 
 */
void code_mover_lhsreg(EXPRESSION *lhs, EXPRESSION *rhs, int nodreff)
{
  int size = pathsize(rhs);
  if (lhs->einds != 0) error("internal : CML lhsreg einds not zero");

  if (rhs->epathhi == e_value)
    {
      if (nodreff==0) /* absolute loads  */
	{
	  if (rhs->epathlo != el_label) /* all others go via pool */
	    {
	      EXPRESSION *n = blank_reg();
	      code_mover_lhsreg(n, rhs, 1);
	      assembly("\t ldr!S !B,[!r]\n", size, lhs, n->epathlo);
	      flagsvalid = 0;  /* not valid */
	      killval(n);
	    }
	  else if (size == 1)
	    {
	      assembly("\t ldrb !B,!B\n", lhs, rhs);
	      flagsvalid = 0;  /* not valid */
	    }
	  else 
	    {
	      assembly("\t ldr !B,!B ; Dq\n", lhs, rhs); 
	      flagsvalid = 0; 
	    }
	}
      else /* immediate loads */
	{  
	  /* immediate loads of a value */
	  if (must_adrf_it(rhs))
	    {
	      assembly("\t adr !r,!V\n", lhs->epathlo, rhs->epathlo, rhs->evalue);
	      flagsvalid = 0;  /* not valid */
	    }
	  else
	    {
	      int val = rhs->evalue.i;
	      if (rhs->epathlo == el_numeric && packable_arm_imed(val))
		{
		  assembly("\t movs !B,#!i\n", lhs, val); 
		  flagsvalid = 0;  /* not valid FOR NOW - see size */
		}
	      else
		{
		  /* Lit pool immediate constant thing in its entireity */
		  int lab = litpooladd_l(rhs, NULL);
		  assembly("\t ldr !B,!L ; lit !B\n", lhs, lab, rhs);
		}
	    }
	}
    }
  
  else if (rhs->epathhi == e_register) 
    /* lhs and rhs are regs -  use mov instructions */
    {
      if (nodreff)
	{

	  if (rhs ->epathhi == e_register && lhs->epathlo == rhs->epathlo) 
	    {
	      /* assembly("; AS already there !B !B\n", lhs, rhs); */
	      flagsvalid = 0;  /* not valid */
	      /* Dont move a register to itself - e.g. passing arg in regsiter */
	    }
	  else
	    {
	      assembly("\t mov  !r,!r ; AS-xl\n", lhs->epathlo, rhs->epathlo);
	      if (rhs->evalue.i)
		{
		  if (packable_arm_imed(rhs->evalue.i))
		    {
		      assembly("\t adds !r,!r,#!i ; XRI\n", lhs->epathlo, lhs->epathlo, rhs->evalue.i);
		      flagsvalid = 1;
		    }
		  else	printf("Internal error: %i ignored\n", rhs->evalue.i);
		 }
	      else flagsvalid = 0;
	    }
	}
      else
	{
	  if (rhs->evalue.i == 0)
	    assembly("\t ldr!S  !r,[!r] ; AS-f\n", size, lhs->epathlo, rhs->epathlo);
	  else assembly("\t ldr!S  !r,[!r,#!i] ; AS-f\n", size, lhs->epathlo, rhs->epathlo, rhs->evalue);
	  flagsvalid = 0;
	}
    }

  else 
    {
      error("internal: bad mover LHSREG %i", rhs->epathhi);
      pexp(rhs);
    }
}

/* for this varient, we know lhs is not a register */
void code_mover_rhsreg(EXPRESSION *lhs, EXPRESSION *rhs)
{
  assembly("\t str!S !B,!B ; mv \n", pathsize(lhs), rhs, lhs);
}


/* 
 * Returns lhs, modified as necessary.
 */
void code_moveri(EXPRESSION *lhs, EXPRESSION *rhs, char *t, int nodreff)
{
  if (0)
    {
      if (nodreff) assembly("; !B <- !B  !i (%s)\n", lhs, rhs, nodreff, t);
      else assembly("; !B <- M[!B]  !i (%s)\n", lhs, rhs, nodreff, t);
    }
  if (lhs->epathhi == e_register && lhs->einds==0) code_mover_lhsreg(lhs, rhs, nodreff);
  else code_mover_rhsreg(lhs, rhs);

 
}





/* 
 *
 * Reduce einds to at most one and also avoid large abs.
 */
EXPRESSION *make_regimed_mode(EXPRESSION *e)
{
  e = make_ldst_mode(e);
  if (pimrhs(e)) return e;
  else return gloadto(e);
}

/* 
 *
 * Reduce einds to at most one and also avoid large abs.
 */
EXPRESSION *make_ldst_mode(EXPRESSION *e)
{
  if (e->einds <= 1)
    {
      if (e->einds > 0 && e->epathhi == e_value && 
	  (e->epathlo == el_numeric ||
	   e->epathlo == el_symbolic))
	{
	  /* On the ARM, for long range absolute stores, need to put */
	  /* address of the arg in a reg on the ARM */
	  EXPRESSION *ne = blank_reg();
	  copy_etype_info(ne, e);   
	  code_moveri(ne, e, "mkldst", 1);
	  killval(e);
	  ne->einds = e->einds;
	  return make_ldst_mode(ne);
	}
      return e;
    }
  else if (e->epathhi == e_register)   /* Register indirect ? */
    {
      int nreg;
      nreg = newdreg();
      if (e->evalue.i != 0)                  /* if indexed ? */
	assembly("\t ldr !r,[!r,#%i]\n", nreg, e->epathlo, e->evalue.i);
      else
	assembly("\t ldr !r,[!r]\n", nreg, e->epathlo);
      freereg(e->epathlo);
      e->einds --;
      e->unmodifiablef = 0;
      e->epathhi = e_register;
      e->epathlo = nreg;
      e->evalue.i = 0;
      return make_ldst_mode(e);
    }

   else if (e->epathhi == e_value)  /* an absolute address with large inds */ 
     {
       return make_ldst_mode(reduce_indsof(e));
     }
   else
     {
       error("internal error in mode_arx_aux");
       pexp(e);
       exit(1);
       return e;
     }
}


/*
 * move from any formal paramenter or parameter reg or special reg
 * into dalt mode 
 */
EXPRESSION *makedalt(EXPRESSION * ex)
{
  if (tracing) assembly("; MX-DALT !B umf=!i\n", ex, ex->unmodifiablef);
  if ((ex->einds == 0 && (ex->unmodifiablef || (ex->epathhi == e_register && ex->epathlo >= 13))))
    {
      EXPRESSION *nex = blank_reg();
      ex = make_ldst_mode(ex);
      copy_etype_info(nex, ex);      
      code_moveri(nex, ex, "makedalt a", 1);
      killval(ex);
      return nex;
    }
  return ex;
}


/*
 * >gloadto 
 * loadto loads an expression into a register, but not
 * necessarily a `writeable' register.
 */
EXPRESSION * gloadto(EXPRESSION *e)
{
  /* Dont call valid mode on flags since it just calls us back again ! */
  if (e->epathhi == e_flags || e->epathhi == e_flags_unsigned) 
    {
      printf("Not supported condition to int conversion\n");
      exit(1);
      return e;
    }
  else
    {
      e = make_ldst_mode(e);
      if (e->einds) 
	{
	  EXPRESSION *ne = blank_reg();
	  code_moveri(ne, e, "gloadto", 0); 
	  copy_etype_info(ne, e);
	  ne->einds = e->einds - 1;
	  ne->it = e->it;
	  killval(e);
	  return gloadto(ne);
	}
      else if (e->epathhi != e_register || e->evalue.i)
	{
	  EXPRESSION *ne = blank_reg();
	  code_moveri(ne, e, "glt - ndf", 1); 
	  copy_etype_info(ne, e);
	  ne->it = e->it;
	  killval(e);
	  return gloadto(ne);
	}
      
      else return e;
    }
}

/*
 * Routine to dereference exactly once
 */
EXPRESSION *reduce_indsof(EXPRESSION *e)
{
  if (e->einds <= 0) return e; 
  else switch(e->epathhi)
    {
    default:
      pexp(e);
      error("internal: load_addressof called on !B", e);
      return e;
     

    case e_register: 
    case e_value:
      {
	EXPRESSION *r = blank_reg();
	code_moveri(r, e, "deref", 0);
	r->einds = e->einds - 1;  
	copy_etype_info(r, e);
	killval(e);
	return r;
      }
    }
}


/* 
 * remove compile time index by adding now.
 *  
 */
EXPRESSION *remove_index(EXPRESSION *e)
{
  if (e->epathhi == e_register && e->einds == 0 && e->evalue.i != 0)
    {
      EXPRESSION *nex = nexp(e);
      int v = nex->evalue.i;
      nex->evalue.i = 0;
      nex = makedalt(nex);
      if (v < 0)
	assembly("\t sub !r,!r,#!i ; RMI\n", nex->epathlo, nex->epathlo, -v);
      else assembly("\t add !r,!r,#!i ; RMI\n", nex->epathlo, nex->epathlo, v);
      
      killval(e);
      return nex;
    }
  else return e;
}

/* predicate indicates whether expression is manifest power of 2 */
int pim124(EXPRESSION *e)
{
  int j;
  if (pimrhs(e)==0) return 0;
  j = e->evalue.i;
  while(j)
   {
   if (j == 1) return 1;
   if (j &  1) return 0;
   j = j >> 1;
   }
  return 0;
}

/* predicate indicates whether expression is manifestly zero
 */
int pimzero(e) EXPRESSION *e;
{ 
  if (pimrhs(e) && e->epathlo == el_numeric && e->evalue.i == 0) return 1;
  else return 0;
}

/*
 *  Main multiply routine.
 */
EXPRESSION *rmult(EXPRESSION *prv, EXPRESSION *rv)
{
	
  if (pim124(prv))                 /* check identities of times one */
  {
    int i = prv->evalue.i;         /* or simple shifts left of one or two */
    killval(prv);
    return mul124(rv, i);
  }
  if (pim124(rv))
  {
     int i = rv->evalue.i;
     killval(rv);
     return mul124(prv, i);
  }
   
  return longmult(prv, rv);
}

/* multiply by manifest powers of two
 */
EXPRESSION *mul124(EXPRESSION *ex, int val)
{
  if (val == 1) return ex;
  if (val == 0) return manifestint(0);
  if (pimrhs(ex))              /* both args of * manifest */
  {
    ex->evalue.i = ex->evalue.i * val;  /* multiply at compile time */
    return ex;
  }
  ex = makedalt(loadasint(ex));
  while (val >= 16)
  {
    assembly("\t mov !B,!B,ASL #8\n", ex, ex);
    val = val >> 8;
  }
  if (val > 1)
  {
      int k = 0;
      while(val>1) { k++; val = val >> 1; }
      assembly("\t mov !B,!B,ASL #!i\n", ex, ex, k);
  }
  return ex;
}




int writeable(reg)
{
  if (reg == target_preg_name) return 0;
  return 1;
}

/*
 * Copy a register to a new one if currently write protected 
 */
int writereg(int reg)
{
  int nreg;
  if (writeable(reg)) return reg;
  nreg = newdreg();
  assembly("\t mov !r,!r\n", nreg, reg);
  return nreg;
}

   

/*
 * Not used ?
 */
EXPRESSION *monadic_negate(EXPRESSION *ex)
{
  if (pimrhs(ex))
    {
      ex->evalue.i = 0 - ex->evalue.i;
      return ex;
    }
  ex = makedalt(gloadto(ex));
  if (pathsize(ex) == 1)
    assembly("\t rsbb !B,!B,#0\n", ex, ex);
  else assembly("\t rsb !B,!B,#0\n", ex, ex);

  return ex;
}

/* end of arith.c */

