/* CBGC closure c compiler 4th January 1992 
 * pugen.c
 *  PU17 version - code generator  DEC 98.
 *
 * (C) 1995 Tenison Technology
 * DJ Greaves
 * Tenison Technology
 * 10 Tenison Road
 * Cambridge CB1 2DW
 */

#define slavetrace 0

#include <stdio.h>
#include <malloc.h>
#include "ccchdr.h"
#include <string.h>

#define text_output assembly

#define MAXOBJ 10000

typedef struct ocode_s
{
  int key;
  int rr[2], size, value;
  char *msg, *author;
  int colouring[MAXDREG+1]; 
} OCODE;

OCODE obj [MAXOBJ];

int objcount= 0;

int gsize; /* used to correct(?) endianness variations */
int tracing = 0;
extern FILE * sysout;
extern int nobssf;

extern char * malloc();
EXPRESSION *loadtoh(EXPRESSION *ex);
struct expression *mul124(), *longmult();
extern int mode_arx_000;

/* prototypes */
EXPRESSION *remove_ind(EXPRESSION *oldex);
extern int tracing;

static int op_segment = O_TEXT;
#define SKIP(X) 

/* prototypes */
int writereg(int reg);
int pointedsize(EXPRESSION *e);
EXPRESSION *gloadto(EXPRESSION *e);
EXPRESSION * make_valid_mode(EXPRESSION *e);
void seg_select(int x);
void aslabel();
void asreg();
void asexpr(EXPRESSION *e);
void ascondition();
void pval(int type, int arg);


/*
 * PU16/17 can deal with 8 and 16 bit values normally
 */
char assize(int i)
{
  gsize = i;
  if (i==1) return 'b';
  if (i==2) return ' ';
  error("internal: bad size %i", i);
  return 'X';
}

static int nextreg = 100;

int newdreg()
{
  return nextreg++;
}


void objchar(char c)
{
  if (c=='\t') c = 9;
  putc(c, sysout);
}

void escape_objchar(char c)
{
  if ((c == (char) 0x22) || c == (char) '\\' || (c == (char) 0x27))
    {
      putc('\\', sysout);
    }
  if (c=='\t') c = 9;
  putc(c, sysout);
}

/*
 * Return 1 if instruction has index restriction on reg colouring
 */
int indexing_key(int k)
{
  switch(k)
    {
    case o_storesf:
    case o_loadsf:
    case o_addsf:
    case o_subsf:
      return 1;

    default: return 0;
    }
}



void spite (char *author1, OCODE *o)
{
  switch(o->key)
    {
    default:
      printf("spite: %s: Key %i not implemented", o->author, o->key);
      exit(1);


    case o_lodi:
      assembly("\t lod !r,#!i", o->rr[0], o->value);
      break;

    case o_lodisymb:
      assembly("\t lod !r,#_!s", o->rr[0], o->value);
      break;

    case o_loadsymb:
      assembly("\t lod!S !r,_!s", o->size, o->rr[0], o->value);
      break;


    case o_storesymb:
      assembly("\t str!S !r,_!s", o->size, o->rr[0], o->value);
      break;

    case o_storeabs:
      assembly("\t str!S !r,!i", o->size, o->rr[0], o->value);
      break;


    case o_lodilab:
      assembly("\t lod !r,#!L", o->rr[0], o->value);
      break;


    case o_mov:
      if (o->rr[0] == o->rr[1])
	assembly("\t ; mov !r,!r redundant ", o->rr[0], o->rr[1]);
	  else assembly("\t mov !r,!r", o->rr[0], o->rr[1]);
      break;

    case o_bxl: /* branch indirect with link */
      assembly("\t bxl !r", o->rr[0]);
      break;

    case o_bx: /* branch indirect  */
      assembly("\t bx !r", o->rr[0]);
      break;

    case o_add:
      assembly("\t add !r,!r", o->rr[0], o->rr[1]);
      break;

    case o_sub:
      assembly("\t sub !r,!r", o->rr[0], o->rr[1]);
      break;

    case o_and:
      assembly("\t and !r,!r", o->rr[0], o->rr[1]);
      break;


    case o_asl1:
      assembly("\t asl !r,#1", o->rr[0]);
      break;

    case o_asr1:
      assembly("\t asr !r,#1", o->rr[0]);
      break;

    case o_lsr1:
      assembly("\t lsr !r,#1", o->rr[0]);
      break;

    case o_lsl1:
      assembly("\t lsl !r,#1", o->rr[0]);
      break;

    case o_or:
      assembly("\t or !r,!r", o->rr[0], o->rr[1]);
      break;

    case o_eor:
      assembly("\t xor !r,!r", o->rr[0], o->rr[1]);
      break;

    case o_cmp:
      assembly("\t cmp !r,!r", o->rr[0], o->rr[1]);
      break;



    case o_eori:
      assembly("\t xor !r,#!i", o->rr[0], o->value);
      break;

    case o_ori:
      assembly("\t or !r,#!i", o->rr[0], o->value);
      break;

    case o_addi:
      assembly("\t add !r,#!i", o->rr[0], o->value);
      break;

    case o_tsti:
      assembly("\t tst !r,#!i", o->rr[0], o->value);
      break;

    case o_cmpi:
      assembly("\t cmp !r,#!i", o->rr[0], o->value);
      break;


    case o_subi:
      assembly("\t sub !r,#!i", o->rr[0], o->value);
      break;


    case o_label:
      assembly("!L:", o->value);
      break;

    case o_ujump:
      assembly("\t bra !L", o->value);
      break;

    case o_bne:
      assembly("\t bne !L", o->value);
      break;

    case o_beq:
      assembly("\t beq !L", o->value);
      break;


    case o_storesf:
      if (o->value) assembly("\t str!S !r,[!r,#!i]", o->size, o->rr[0], o->rr[1], o->value);
      else assembly("\t str!S !r,[!r]", o->size, o->rr[0], o->rr[1]);
      break;

    case o_loadsf:
      if (o->value)
	assembly("\t lod!S !r,[!r,#!i]", o->size, o->rr[0], o->rr[1], o->value);
      else assembly("\t lod!S !r,[!r]", o->size, o->rr[0], o->rr[1]);
      break;

    case o_addsf:
      if (o->value)
	assembly("\t add!S !r,[!r,#!i]", o->size, o->rr[0], o->rr[1], o->value);
      else assembly("\t add!S !r,[!r]", o->size, o->rr[0], o->rr[1]);
      break;

    case o_subsf:
      if (o->value)
	assembly("\t sub!S !r,[!r,#!i]", o->size, o->rr[0], o->rr[1], o->value);
      else assembly("\t sub!S !r,[!r]", o->size, o->rr[0], o->rr[1]);
      break;

    case o_msg:
    case o_msg1:
    case o_msg2: 
      assembly(o->msg, o->size, o->value);
      break;

    case o_code:
    case o_code1:
    case o_code2: /* These are all typefoxed - should be unions */
      assembly(" \t ");
      assembly(o->msg, o->size, o->value);
      break;

    case o_code2reg: 
      assembly(" \t ");
      assembly(o->msg, o->rr[0], o->size, o->value);
      break;


    case o_code2reg2: 
      assembly(" \t ");
      assembly(o->msg, o->rr[0], o->rr[1], o->size, o->value);
      break;

    case o_code0reg: 
      assembly(" \t ");
      assembly(o->msg, o->rr[0]);
      break;

    case o_code0reg2: 
      assembly(" \t ");
      assembly(o->msg, o->rr[0], o->rr[1]);
      break;

    case o_labl1: /* These are all typefoxed - should be unions */
      assembly(o->msg, o->size);
      break;

    case o_andi:
      assembly("\t and !r,#!i", o->rr[0], o->value);
      break;

    case o_hard:
      assembly("\t ; force VR!i to !i", o->rr[0], o->value); 
      break;
    }


  fprintf(sysout, " \t ; %s\n", o->author);
}

/*
 * Assembly output code.
 */
void ocode(va_alist) va_dcl
{ 
  va_list ap;
  int key;
  int size;
  int r1, r2;
  char *a1, *a2, *msg;
  int value;
  char *author;
  va_start(ap);
  author = va_arg(ap, char *);
  key = va_arg(ap, int);

  if (objcount >= MAXOBJ)
    {
      printf("Too much ocode created\n");
      exit(1);
    }

  switch(key)
    {


    case o_storesymb:
      size = va_arg(ap, int);
      r1 = va_arg(ap, int);
      value = va_arg(ap, int);
      obj[objcount].key = key;
      obj[objcount].rr[1] = -1;
      obj[objcount].rr[0] = r1;
      obj[objcount].value = value;
      obj[objcount].size = size;
      break;

    case o_storesf:
    case o_loadsf:
    case o_addsf:
    case o_subsf:

      size = va_arg(ap, int);
      r1 = va_arg(ap, int);
      r2 = va_arg(ap, int);
      value = va_arg(ap, int);      
      obj[objcount].key = key;
      obj[objcount].rr[1] = r2;
      obj[objcount].rr[0] = r1;
      obj[objcount].value = value;
      obj[objcount].size = size;
      break;

    case o_ori:
    case o_eori:
    case o_rsbi:
    case o_andi:
    case o_addi:
    case o_tsti:
    case o_cmpi:
    case o_subi:
    case o_lodi:
    case o_lodisymb:
    case o_loadsymb:
    case o_lodilab:
    case o_storeabs:
      size = va_arg(ap, int);
      r1 = va_arg(ap, int);
      value = va_arg(ap, int);
      obj[objcount].key = key;
      obj[objcount].rr[1] = -1;
      obj[objcount].rr[0] = r1;
      obj[objcount].value = value;
      obj[objcount].size = size;
            break;

    case o_cmp:
    case o_add:
    case o_sub:
    case o_eor: 
    case o_and:
    case o_mov:
    case o_or:
      size = va_arg(ap, int);
      r1 = va_arg(ap, int);
      r2 = va_arg(ap, int);
      obj[objcount].key = key;
      obj[objcount].rr[1] = r2;
      obj[objcount].rr[0] = r1;
      obj[objcount].size = size;
            break;

    case o_asl1:
    case o_asr1:
    case o_lsr1:
    case o_lsl1:
      size = va_arg(ap, int); /* not used */
      r1 = va_arg(ap, int);
      obj[objcount].key = key;
      obj[objcount].rr[1] = -1;
      obj[objcount].rr[0] = r1;
      break;


    case o_hard: /* one val, one reg */
      value = va_arg(ap, int);
      r1 = va_arg(ap, int);
      obj[objcount].key = key;
      obj[objcount].rr[1] = -1;
      obj[objcount].rr[0] = r1;
      obj[objcount].value = value;
      break;

    case o_bxl: /* one reg */
    case o_bx: /* one reg */
      r1 = va_arg(ap, int);
      obj[objcount].key = key;
      obj[objcount].rr[1] = -1;
      obj[objcount].rr[0] = r1;
      break;

    case o_label:
    case o_ujump:
    case o_bne:
    case o_beq:

      value = va_arg(ap, int);
      obj[objcount].key = key;
      obj[objcount].rr[1] = -1;
      obj[objcount].rr[0] = -1;
      obj[objcount].value = value;
      break;

    case o_msg:
    case o_msg1:
    case o_msg2: 
    case o_code:
    case o_code1:
    case o_code2:
    case o_labl1:
      msg = va_arg(ap, char *);
      a1 = va_arg(ap, char *);
      a2 = va_arg(ap, char *);
      obj[objcount].key = key;
      obj[objcount].rr[1] = -1;
      obj[objcount].rr[0] = -1;
      obj[objcount].msg =  msg;
      obj[objcount].size = (int) a1;
      obj[objcount].value = (int) a2;
            break;

    case o_code0reg2:
      msg = va_arg(ap, char *);
      obj[objcount].rr[0] = va_arg(ap, int);
      obj[objcount].rr[1] = va_arg(ap, int);
      obj[objcount].key = key;
      obj[objcount].msg =  msg;
      break;

    case o_code0reg:
      msg = va_arg(ap, char *);
      obj[objcount].rr[0] = va_arg(ap, int);
      obj[objcount].rr[1] = -1;
      obj[objcount].key = key;
      obj[objcount].msg =  msg;
      break;
    
    case o_code2reg:
      msg = va_arg(ap, char *);
      obj[objcount].rr[0] = va_arg(ap, int);
      a1 = va_arg(ap, char *);
      a2 = va_arg(ap, char *);
 
      obj[objcount].key = key;
      obj[objcount].rr[1] = -1;
      obj[objcount].msg =  msg;
      obj[objcount].size = (int) a1;
      obj[objcount].value = (int) a2;
      break;

    case o_code2reg2:
      msg = va_arg(ap, char *);
      obj[objcount].rr[0] = va_arg(ap, int);
      obj[objcount].rr[1] = va_arg(ap, int);
      a1 = va_arg(ap, char *);
      a2 = va_arg(ap, char *);

      obj[objcount].key = key;
      obj[objcount].msg =  msg;
      obj[objcount].size = (int) a1;
      obj[objcount].value = (int) a2;
      break;

    default:
      printf("ocode: %s: Key %i not implemented\n", author, key);
      exit(1);
    }


  obj[objcount].author = author;

  /* debug */
  if (aflag) 
    {
      fprintf(sysout, "; VR \t %i: ", objcount); spite("", &(obj[objcount]));
    }

  objcount++;
}


/*
 * Find a register to use over the region required, starting from 0 upwards. 
 */
int findreg(int base, int last)
{
  int i;


  for (i=0;i<=MAXDREG;i++) 
    {
      int p;
      for (p=base; p<=last; p++)
	if (obj[p].colouring[i] != -1) break; /* already in use */
      if (p == last+1) return i;
    }

  return -1; /* none found */
}


/*
 * Apply the colour allocated to the instructions.
 */
void colour1(int vd, int finalf)
{
  int base;
  int i;
  /* Convert vr to real regs */
  for (base=0;base<objcount;base++) 
    {
      int rr;
      for (rr=0;rr<2; rr++)
	{
	  int vr = obj[base].rr[rr];
	  if (vr > MAXREG)
	    {
	      for (i=0; i<=MAXDREG; i++) 
		{
		  if (obj[base].colouring[i] == vr) break;
		}
	      if (i == MAXDREG+1)
		{
		  if (finalf)
		    {
		      printf("%i: Reg %i\n", base, vr); 
		      fatal("Reg was not coloured");
		      
		    }
		}
	      else
		{
		  obj[base].rr[rr] = i;
		  if (vd) printf("%i: Coloured VR%i with R%i\n", base, vr, i);
		}
	    }
	}
    }
}


/*
 * Make a register colouring - naive algorithm.  Return 0 if ok.
 */
int colour()
{
  int base, i;
  int vd = aflag;

  /* clear all colours in the array */
  for (base=0;base<objcount;base++) for (i=0; i <=MAXDREG; i++) obj[base].colouring[i] = -1;


  /* allocate named registers */
  for (base=0;base<objcount;base++)
    {
      int rr;
      for (rr=0; rr<2; rr++)
	{
	  int vr = obj[base].rr[rr];
	  if (vr >= 0 && vr <= MAXDREG)
	    {
	      /* Needs be coloured with itself */
	      if (obj[base].colouring[vr] != -1) 
		{
		  printf("%i: Register %i requested but in use", base, vr);
		  exit(1);
		}
	      obj[base].colouring[vr] = vr;
	    }
	}
    }

  /* allocate forced registers */
  for (base=0;base<objcount;base++)
    {
      if (obj[base].key == o_hard)
	{
	  int vr = obj[base].rr[0];
	  int value = obj[base].value;
	  
	  int first = -1, last, p;
	  for (p=0;p<objcount; p++)
	    {
	      if (obj[p].rr[0] == vr || obj[p].rr[1] == vr) 
		{
		  if (first == -1) first = p;
		  last = p;
		}
	    }
	  if (vd) printf("%i: Force %i to %i: used between %i and %i inclusive\n", base, vr, value, first, last);
	  

	  /* see if the force is possible */
	  for (p=first;p<=last;p++)
	    {
	      if (obj[p].colouring[value] != -1 && obj[p].colouring[value] != vr)
		{
		  /* if it is a move to another vr mapped to the same pr then thats ok */
		  if (obj[p].key != o_mov)
		    {
		      break;
		    }
		}
	    }
  


	  if (p != last +1)  /* Force failed, put in a move */
	    {
	      if (vd) printf("%i: Forced register VR%i to R%i requested but was in use as (V)R%i at %i\n", base, vr, value, obj[p].colouring[value], p);
	      obj[base].key = o_mov;
	      obj[base].rr[0] = value;
	      obj[base].rr[1] = vr;
	      obj[base].author = "forceresolve";

	      obj[base].colouring[value] = value;
	    }
	  
	  else for (p=first;p<=last;p++)
	    {
	      if (obj[p].colouring[value] != -1 && obj[p].colouring[value] != vr)
		{
		  /* if it is a move to another vr mapped to the same pr then thats ok */
		  if (obj[p].key != o_mov)
		    {
		      printf("%i: Forced register VR%i to R%i requested but already in use as (V)R%i\n", p, vr, value, obj[p].colouring[value]);
		      exit(1);
		    }
		}
	      else obj[p].colouring[value] = vr;
	    }


	}
    }



  
  /* now colour those that are used as index regs */
  for (base=0;base<objcount;base++)
    {
      int rr = 1;
      int vr = obj[base].rr[rr];
        
      if (vr > MAXREG && indexing_key(obj[base].key))
	{
	  /* See if already coloured */
	  for (i=0; i<=MAXDREG;i++) if (obj[base].colouring[i] == vr) break;
	  
	  if (i == MAXDREG+1)   /* not already coloured */
	    {
	      int first = -1;
	      int last = -1;
	      int p = 0; /* Find first and last place used */
	      while (p < objcount)
		{
		  if (obj[p].rr[0] == vr) last = p;
		  if (obj[p].rr[1] == vr) last = p;
		  if (last >= 0 && first < 0) first = last;
		  p++;
		}
	      if (vd) printf("%i, %i: Index reg VR%i used between %i and %i inclusive\n", obj[base].key, rr, vr, first, last);
	      
	      i = findreg(first, last);
	      
	      if (i == -1 || i >= 3)
		{
		  if (vd) printf("%s: too many regs needed for index - local copy not done yet\n", current_routine);
		  return -1;
		}
	      
	      if (vd) printf("Allocate index register %i for VR%i\n", i, vr);
		  
	      for (p=first;p<=last;p++) obj[p].colouring[i] = vr;
	      
	    }
	}
      
    }

  colour1(vd, 0);

  /* now colour the remainder */
  for (base=0;base<objcount;base++)
    {
      int rr;
      for (rr=0; rr<2; rr++)
	{
	  int vr = obj[base].rr[rr];
	  
	  if (vr > MAXREG)
	    {
	      /* See if already coloured */
	      for (i=0; i<=MAXDREG;i++) if (obj[base].colouring[i] == vr) break;
	      
	      if (i == MAXDREG+1)   /* not already coloured */
		{
		  int last = base;
		  int p = base+1; /* Find last place used */
		  while (p < objcount)
		    {
		      if (obj[p].rr[0] == vr) last = p;
		      if (obj[p].rr[1] == vr) last = p;
		      p++;
		    }
		  if (vd) printf("%i, %i: VR%i used between %i and %i inclusive\n", obj[base].key, rr, vr, base, last);

		  i = findreg(base, last);

		  if (i == -1)
		    {
		      if (vd) printf("too many regs needed - spill to stack not done yet");
		      return 0;
		    }

		  if (vd) printf("Allocate register %i for vr %i\n", i, vr);
		  
		  for (p=base;p<=last;p++) obj[p].colouring[i] = vr;

		}
	    }


	}
    
    }
  colour1(vd, 1);
  return 0;

}


void dump_code()
{
  int i;
  assembly("; ------------------------------------------------- \n");
  for (i=0;i<objcount;i++) spite("", &(obj[i]));
}

void clear_code()
{
  objcount = 0;
}


EXPRESSION *getflagsv(EXPRESSION *ex)
{
  if (flagsvalid == 0)
    {
      ex = gloadto(ex);
      ocode("gfv", o_cmpi, 0, ex->epathlo, 0);
      flagsvalid = 1;
    }
  return ex;

}

void escape_print_string(FILE *f, char *s)
{
  while (*s)
    {
      escape_objchar(*s++);
    }
}

/*
 * Assembly output code.
 */
void assembly(va_alist) va_dcl
{ 
  va_list ap;
  char *poi;
  va_start(ap);
  poi = va_arg(ap, char *);

  if (!strncmp(poi, "BSS", 3))
    {
      poi += 3;
      seg_select(O_BSS);
    }

  if (!strncmp(poi, "TEX", 3))
    {
      poi += 3;
      seg_select(O_TEXT);
    }

  SKIP(printf("sysout is %x and f = %s\n", sysout, format));
  while(*poi)
   { 
     if (*poi != '!' && *poi !='%')
       {
	 objchar(*(poi++));
	 continue;
       }
     poi++;
     switch(*poi++)
       { 
       default: putc('!', sysout); 
	 error("bad ! modifier %c", *(poi-1));
	 continue;
       
       case 'S': 
	 fprintf(sysout, "%c", assize(va_arg(ap, char))); continue;
       
       case 'B': 
	 asexpr(va_arg(ap, EXPRESSION *)); continue;
       
       case 'L': 
	 aslabel(va_arg(ap, int)); continue;
       
       case 's': 
	 fprintf(sysout, "%s", va_arg(ap, char *)); continue;
       
       case 'x': 
	 fprintf(sysout, "0x%x", va_arg(ap, int)); continue;
       
       case '2': 
	 fprintf(sysout, "%i", (va_arg(ap, int)) & 0xFF); continue;
       
       case 'r':
	 asreg(va_arg(ap, int)); continue;
       
       case 'c': 
	 ascondition(va_arg(ap, char), 0); continue;
       
       case 'u': 
	 ascondition(va_arg(ap, char), 1); continue;
       
       case 'i': 
	 fprintf(sysout, "%i", va_arg(ap, int)); continue;
       
       case 'V': 
	 {
	   int t  = va_arg(ap, int); 
	   pval(t, va_arg(ap, int)); continue;
	 }
       }
   }
}





void pval(int type, int arg)
{
  switch(type)
    { 
    case el_numeric:
      fprintf(sysout, "%i", arg);
      break;
    case el_label:
      aslabel(arg);
      break;
    case el_symbolic:
      fprintf(sysout, "_%s", (char *) arg);
      break;
    
    case el_litpool:
      fprintf(sysout, "litpool %i", ((struct lititem *) arg)->lindex);
      break;
    }
}

void quick_add_sub(char op, int size, EXPRESSION *e, int delta)
{
  EXPRESSION *ne = gloadto(e);
  ocode("qas", (op=='+') ? o_addi: o_subi, 0, ne->epathlo, delta);
  code_moveri(e, ne, "qasmi", -1);
}


void ascondition(int c, int uf)
{
  int j = c * 3;
  char * sconds = "gt ge ne eq lt le ";
  char * uconds = "hi cs ne eq cc ls ";
  char *conds = (uf) ? uconds: sconds;
  if (c<0 || c>5)  fprintf(sysout, " bad %i ", c);
  else 
    {
      fprintf(sysout, "%c%c", conds[j], conds[j+1]);
      if (conds[j+2] != ' ') putc(conds[j+2], sysout);
    }
}

/*
 *  Print an operand as in a valid ocode language addressing mode
 */
void asexpr(EXPRESSION *e)
{ 
  if (e->epathhi == e_flags) fprintf(sysout, "<flags>");
  else if (e->epathhi == e_flags_unsigned) fprintf(sysout, "<flags_u>");
  else
    { 
      switch(e->epathhi)
	{
	case e_register:
	  if (e->einds == 0)
	    {
	      asreg(e->epathlo);
	      if (e->evalue.i) fprintf(sysout, "<value %i error>", e->evalue.i);
	      return;
	    }
	  else if (e->einds >= 1)
	    {
	      if (abs(e->evalue.i) >= target_max_pidx) fprintf(sysout, "<Too big>");
	      if (e->evalue.i) fprintf(sysout, "[R%i,#%i]", e->epathlo, e->evalue.i);
	      else fprintf(sysout, "[R%i]", e->epathlo);
	      return;
	    }
	  else break;
	
	case e_value:
	  if (e->einds == 0) objchar(immediate_mode_char);
	  pval(e->epathlo, e->evalue.i);
	  return;
	  
	default:
	  fprintf(sysout, "BROKEN AS"); 
	  pexp(e, "BROKAS");
	}
      fprintf(sysout, "BROKEN ASE"); 
      pexp(e, "ASE");
      breakpoint();
    }
}


/*
 * Print a GP register name - low byte 
 */
void asreg(r)
{
  fprintf(sysout, "R%i", r);
}


int uidseed = 10; /* Values below 10 reserved as flag values */

int uid(x)
 { if (x == 0) return uidseed++;
   if (x == -1) error("undefined break/continue");
   return x;
 }


char label_prefix[] = "pu_";  /* This gets changed */

void aslabel(int i)
{
  fprintf(sysout, "%s%i", label_prefix, i);
}

int label(x)
{
  flagsvalid = 0;
  x = uid(x);
  ocode("anon", o_label, x);
  flowing = 1;
  return x;
}

int ujump(x)
{
  if (x == 0) x = uid(x);
  ocode("anon", o_ujump, x);
  flowing = 0;
  return x;
}

/*
 * If not a leaf, push actuals onto stack
 */
void code_entry(int fpleaf, int formals)
{ 
  assembly("\t str r7,[r2]\n");
  assembly("\t mov r7,r2\n");
  /*  printf("Entry %i %i\n", fpleaf, formals);
   */

  if (fpleaf ==0)
    {
      assembly(" str R6,[R7,#-2]\n");
    }

  if (fpleaf ==0 && formals > 0)
    {
      assembly(" str R0,[R7,#2]\n");
    }

  if (fpleaf ==0 && formals > 1)
    {
      assembly(" str R1,[R7,#4]\n");
    }

  flowing = 1;
}

void code_return(int fpleaf)
{ 
  if (fpleaf ==0)
    {
      ocode("cr", o_code, "lod R6,[R7,#-2]");
    }
  ocode("cr", o_code, "lod r7,[r7]");
  ocode("cr", o_code, "ret");
  flowing = 0;
}


void force(EXPRESSION *ex, int reg, char *name)
{
  ocode(name, o_hard,  reg, ex->epathlo);
}

void force_loadtod0(EXPRESSION *ex)
{
  int reg = 0;
  ex = gloadto(ex);
  force(ex, reg, "loadtod0");
}


/*
 *
 */
EXPRESSION *code_callv(EXPRESSION *dest, int sp)
{
  dest = make_ldst_mode(dest);
#ifdef CTRACE
  printf("; making a call to "); pexp(dest, "call");
#endif  
  ocode("call", o_code, "mov r2,r7");
  ocode("call", o_code1, "sub r2,#!i",  -sp);
  
 
  if (dest->epathhi == e_value &&  dest->epathlo == el_symbolic && dest->einds == 0) 
   {
     ocode("call", o_code1, "jsr _!s", dest->evalue.s);   
   }
  else
    {
      dest = gloadto(dest);

      if (dest->epathhi == e_register &&  dest->einds == 0) 
	{
	  ocode("call", o_bxl, dest->epathlo);   
	}
      else 
	{
	  pexp(dest, "calla");
	  fatal("subroutine call to this mode not implemented");
	}
    }

 return dest;
}



int fjump(int labin, EXPRESSION *ex)
{
  labin = uid(labin);
  if (ex->epathhi == e_flags_unsigned)
  { 
    ocode("anon", o_code2, "b!u,!L; fjump U", 5 - ex->epathlo, labin);
    
    return labin;
   }
  else if (ex->epathhi == e_flags)
  { 
    ocode("anon", o_code2, "b!c,!L; fjump F", 5 - ex->epathlo, labin);
    
    return labin;
   }
  ex = make_valid_mode(ex);

  if (pimrhs(ex)==0 || ex->evalue.i == 0) /* constant condition of non zero ? */
    {
      ex = getflagsv(ex);
      ocode("anon", o_beq, labin);
    }
  
  else /* unconditional false jump is a nop */
    {
    
    }
  
  return labin;
}


int tjump(int labin, EXPRESSION *ex)
{ 
  labin = uid(labin);

  if (ex->epathhi == e_flags_unsigned)
    {
      ocode("tj", o_code2, "b!u !L ; Uns", ex->epathlo, labin);
      
      return labin;
    }

  else if (ex->epathhi == e_flags)
    { ocode("tj", o_code2, "b!c !L", ex->epathlo, labin);
    
      return labin;
    }
  ex = make_valid_mode(ex);
  if ((pimrhs(ex)==0) || (ex->evalue.i)) /* constant condition of zero */
   {
     ex = getflagsv(ex);
     ocode("tj", o_bne, labin);
     
   }
  else error("tjump unflagged internal error");

  return labin;
}

void bss_ds_bytes(int noff)
{
  assembly("BSS\t .defs !i\n", noff);
}


void code_goto(e) EXPRESSION *e;
{
  e = make_valid_mode(e);


  if (e->einds == 0 && e->epathhi == e_value && e->epathlo == el_symbolic)
    {
      ocode("goto", o_code1, "jmp _%s", e->evalue);
    }
  else 
    {
      e = gloadto(e);
      pexp(e, "GOTO");
      ocode("goto", o_bx, e->epathlo);
    }

  /*  else error("bad goto addressing mode");
   */
}



int sopcodei(uchar symb, int uf)
{
  if (symb == e_lshift) return o_asl1;
  else if (uf) return o_lsr1;
  else return o_asr1;
}

EXPRESSION * varshift(uchar symb, EXPRESSION *obj, EXPRESSION *amount)
{
  int lab, top;
  int uf = obj->it->flagvec & m_unsigned;
  int nem = sopcodei(symb, uf);
  obj = loadasint(obj);
  amount = loadasint(amount);
  top = label(0);
  lab = tjump(0, amount);
  ocode("vshift", nem, 0, obj->epathlo);
  ocode("vshift", o_subi, 0, amount->epathlo, 1);
  ujump(top);
  label(lab);
  return obj;
}

EXPRESSION * fixedshift(uchar symb, EXPRESSION *obj, EXPRESSION *amount)
{
  int a = amount->evalue.i;
  int uf = obj->it->flagvec & m_unsigned;

  obj = loadasint(obj);
  while (a > 0)
    {
      ocode("fshif", sopcodei(symb, uf), 0, obj->epathlo);
      a--;
    }
  return obj;
}


/*
 * Duplicate an ee
 */
EXPRESSION *nexp(EXPRESSION *p)
 {
   EXPRESSION *q =  NEWZ(EXPRESSION);
   q->unmodifiablef = p->unmodifiablef;
   q->evalue = p->evalue;
   q->einds = p->einds;
   q->it  = p->it;
   q->epathlo = p->epathlo;
   q->epathhi = p->epathhi;
   return q;
 }



void save_or_restore_mcstate(int savef)
{


}

/*
 * predicate: is the value an immediate r-val constant known at compile time ?
 */
int pimrhs(EXPRESSION *e)
{ 
  if ((e->epathhi == e_value) && (e->epathlo == el_numeric) && (e->einds == 0)) return 1;
  return 0;
}

/*
 * predicate: is the value an immediate r-val constant ?
 */
int pimlhs(EXPRESSION *e)
{ 
  if ((e->epathhi == e_value) && (e->einds == 1)) return 1;
  return 0;
}

/*
 * Yield string straight away as an array initialisation
 */
void staticstring(char *s)
{
  text_output("\t data ");
  while(*s)
  {
    text_output("!2,", *(s++));
  }
  text_output("0\n");
}


void fprint_it(FILE *f, INSTANCE *it)
{
  fprintf(f, "instance %s stars1=%i stars2=%i dimensions=%i flagvec=%i ct.st=%x st.ctsize=%i ct.startstars=%i\n", it->wnode, it->stars1, it->stars2, it->dimensions, it->flagvec, (int) (it->ct->st), it->ct->ctsize, it->ct->startstars); 
}
/*
 * chain an item into the lit pool
 * The item itself may be a chain of strings.
 */
struct lititem *litpoollist = NULL;
struct lititem *litpooladd(CONS *c, int labelindex) 
{
  struct lititem *p = NEWZ(struct lititem);
  p-> lindex = uid(labelindex);
  p-> slist = c;
  p-> lnext = litpoollist;
  litpoollist = p;
  return p;
}

/*
 * Dump strings to form a lit pool 
 */
void litpooldump()                        
{
  struct lititem *p = litpoollist;
  /*  
   */
  while (p)
    {
    CONS *q = p->slist;
    aslabel(p-> lindex);
    while(q)
      {
	int first = 0;
	char *r = (char *) q->car;
	q = q->cdr;
	text_output("\t .data ");
	if (*r >= ' ' && *r <= 0x7E)
	  {
	    objchar('\"');
	    while (*r >= ' ' && *r <= 0x7E && *r != '\'') escape_objchar(*r++);
	    objchar('\"');
	    first = 1;
	  }
	while(*r)
	  {
	    if (first) objchar(',');
	    first = 1;
	    text_output("!2", *(r++));
	  }
	if (q == NULL)                 /* Null terminate last string */
	  {
	    if (first) objchar(',');
	    first = 1;
	    objchar('0');
	  }
	text_output("\n");
      }
    p = p ->lnext;
    }
  litpoollist = NULL;
}

void seg_select(int x)
{
  if (x == op_segment) return;
  if (x == O_BSS && nobssf) return;
  op_segment = x;
  
  if (x == O_TEXT) fprintf(sysout, "\t .text\n");
  else if (x == O_BSS) fprintf(sysout, "\t .bss\n");
  else fprintf(stderr, " badseg\n");
  
}


int compile_fjump(ENODE *e, int labin, int sp)
{
  EXPRESSION *ex = compile_expr(e, sp);

  if (pimrhs(ex)) /* if condition known at compile time */
    {
      if (ex->evalue.i == 0) return ujump(labin); /* unconditional */
      return uid(labin);
    }


  labin = uid(labin);
  if (ex->epathhi == e_flags_unsigned)
  { 
    ocode("cfj", o_code2, " b!u !L; fjump U", 5 - ex->epathlo, labin);
    return labin;
   }
  else if (ex->epathhi == e_flags)
  { 
    ocode("cfj", o_code2, "b!c !L ; fjump F", 5 - ex->epathlo, labin);
    return labin;
   }
  ex = make_ldst_mode(ex);

  if (pimrhs(ex)==0 || ex->evalue.i == 0) /* constant condition of non zero ? */
    {
      ex = getflagsv(ex);
      ocode("cfj", o_code2, "beq !L ; fjmp1", labin);
    }
  
  else /* unconditional false jump is a nop */
    {
      
    }
  
  return labin;
}

int compile_tjump(ENODE *e, int labin, int sp)
{ 
  EXPRESSION *ex = compile_expr(e, sp);
  if (pimrhs(ex)) /* if condition known at compile time */
    {
      if (ex->evalue.i) return ujump(labin); /* unconditional */
      return uid(labin);
    }


  labin = uid(labin);

  if (ex->epathhi == e_flags_unsigned)
    {
      ocode("ctj", o_code2, "b!u !L ; Uns", ex->epathlo, labin);
            return labin;
    }

  else if (ex->epathhi == e_flags)
    { 
      ocode("ctj", o_code2, " b!c !L", ex->epathlo, labin);
   
      return labin;
    }
  ex = make_ldst_mode(ex);
  if ((pimrhs(ex)==0) || (ex->evalue.i)) /* constant condition of zero */
   {
     ex = getflagsv(ex);
     ocode(o_bne, labin);
     
   }
  else error("tjump unflagged internal error");

  return labin;
}

/*
 *
 */
EXPRESSION *quick_add_sub_post(char op, int size, EXPRESSION *e, int delta)
{
  if (0) pexp(e, "; POST");
  if (0) ocode("anon", o_msg1, "; post of !B\n", e);
  if (e->epathhi == e_register && e->einds == 0 && e->evalue.i == 0) 
    {
      int s = newdreg();
      EXPRESSION *ne = nexp(e);
      ne->unmodifiablef = 0;
      ocode("qasp", o_mov, 0, s, e->epathlo);
      ocode("qasp", (op=='+') ? o_addi: o_subi, 0, e->epathlo, delta);
      ne->epathlo = s;
      return ne;
    }
    
  else
    {
      EXPRESSION *na = make_ldst_mode(e);
      EXPRESSION *val = gloadto(na);
      EXPRESSION *new = blank_reg(e->it);
      
      /* Get copy of it to reg new */
      ocode("qasp1", o_mov, 0, new->epathlo, val->epathlo);
      ocode("qasp", (op=='+') ? o_addi: o_subi, 0, new->epathlo, delta);
      code_moveri(e, new, "qasp", -1);
      val -> it = na -> it;
      return val;
    }
}

EXPRESSION *quick_add_sub_pre(char op, int size, EXPRESSION *e, int delta)
{
  int r;
  EXPRESSION *ne = gloadto(e);
  if (0) ocode("anon", o_msg2, "; pre of !B !x\n", ne, op);
  r = ne->epathlo;
  ocode("qap", (op=='+') ? o_addi: o_subi, 0, r, delta);
  code_moveri(e, ne, "qasp", -1);  
  return ne;
}





/*
 * logical negate
 */
EXPRESSION *logical_negate(EXPRESSION *ex)
{
  int lab = 0;
  EXPRESSION *new = blank_reg(ex->it);
  ocode ("neg", o_lodi, 0, new->epathlo, 0);
  ex = getflagsv(ex);
  lab = tjump(lab, ex);
  ocode ("neg", o_addi, 0, new->epathlo, 1);
  label(lab);
  return new;
}


EXPRESSION *arith_abs(EXPRESSION *ex)
{
  int lab = uid(0);
  ex = getflagsv(ex);
  ocode("aabs", o_code1, "bge !L", lab);
  ocode("anon", o_rsbi, 0, ex->epathlo, 0);
  label(lab);
  return ex;
}

EXPRESSION *arith_complement(int size, EXPRESSION *ex)
{
  EXPRESSION *new = blank_reg(ex->it);
  ex = gloadto(ex);
  ocode("aC", o_lodi, 0, new->epathlo, 0);
  ocode("aC", o_sub, 0, new->epathlo, ex->epathlo);
  if (size == 1) ocode("aC", o_andi, 0, new->epathlo, 255);
  return new;
}

/* 
 * This routine scales a pointer-offset when necessary 
 * It also makes sure that the index type is integer   
 */
EXPRESSION *indexscale(uchar op, EXPRESSION *base, EXPRESSION *index)
{
  int size = pointedsize(base);
  /*ocode("anon", "; pointedsize !i", size); pexp(base);  */

  if (op != e_add && op != e_subtract)
    error("only + and - supported for pointer arithemetic");
  if (pathsize(index) != target_int_size) index = loadasint(index);
  index = rmult(index, manifestint(size));  /* Return new index */
  return index;
}


EXPRESSION *fpexp(FILE *jcos, EXPRESSION *ex)
{
   fprintf(jcos, "; hi=%i lo=%i val=%04X inds=%i  umf=%i flagvec=%i ",
       ex->epathhi, ex->epathlo, ex->evalue.i, ex->einds, ex->unmodifiablef, ex->it->flagvec);
   
   fprint_it(jcos, ex->it);
   if (ex->it->ct == NULL) fprintf(jcos, "bad null ct");
   else if (ex->it->ct->st) fprintf(jcos, "'%s'", ex->it->ct->st->sname);
   
   fprintf(jcos, "\n");
   return ex;
}

EXPRESSION *pexp(EXPRESSION *ex, char *name)
{
  extern FILE *sysout;
  fprintf(sysout, name);
  return fpexp(sysout, ex);
}


/*
 * Modify an expression rhs as required when to be assigned to 
 * a given destination. 
 */
EXPRESSION *assigncoerce(EXPRESSION *rhs, CT *ct, int lstars)
{ 
  int rs;
  int vd = 0;
  int ls = (lstars > 0) ? target_ptr_size : ct->ctsize;
  rhs = make_ldst_mode(rhs);

  if (vd) pexp(rhs, "; aCC");
  rs = pathsize(rhs);

  /* Coerce the C `NULL' to correct for any number of stars */
  if(pimzero(rhs)) 
    {
      rhs->it = copyit(rhs->it);
      rhs->it->stars1 = lstars;
      rhs->it->dimensions = 0;
    }

  if (lstars >= 0 && lstars != rhs->it->stars1+rhs->it->dimensions)
    {
      printct(ct);
      if (lstars) error("warning: assign non-pointer to pointer variable %i %i %i", lstars, rhs->it->stars1, rhs->it->dimensions);
      else if (lstars >= 0) error("warning: assign pointer to non-pointer variable %i %i %i", lstars, rhs->it->stars1, rhs->it->dimensions);
    }
  if (ls > target_ptr_size || rs > target_ptr_size)
    {
      /* structure assignment */
      if (ls != rs) 
	{
	  printct(ct);
	  error("%i %i size mismatch in structure assignment", ls, rs);
	}
      return rhs;
    }

  if (pimzero(rhs))      /* a clear instruction ? */
    {
      return rhs;
    }
  else
    {
      if (rs == 1 && ls > 1)   /* coerce char to int */
	{
	  rhs = gloadto(rhs);
	  ocode("ccti", o_andi, 0, rhs->epathlo, 255);
	  rhs->it->ct = ct_int;
	  return rhs;
	}

      else if (rs == 2 && ls == 1)   /* coerce int to char */
	{
	  /* little endian machine - this is always simple */
	  rhs ->it-> ct = ct_char;
	  
	  return rhs;
	}
      
      else return rhs;
    }
}


/*
 * >>assign  P.Ex := Ex
 */
EXPRESSION *assign(EXPRESSION *lhs, EXPRESSION *rhs) 
{
  int lstars;
  if (rhs == NULL)
    {
      error("internal: rhs null");
      return lhs;
    }

  lstars = (lhs->it->ct == ct_generic) ? -1: lhs->it->stars1+lhs->it->dimensions;
  
  if (lhs->it->stars2) lstars = -1;



  rhs = assigncoerce(rhs, lhs->it->ct, lstars);


  if (lhs->einds == 0 && lhs->it->ct->ctsize > target_ptr_size)
    {
      error("Struct assign not supported\n");
    }

  rhs = gloadto(rhs);
  lhs = make_ldst_mode(lhs);
  code_moveri(lhs, rhs, "assign", -1);
  return rhs;
}

/*
 * Move,  f means ?
 */
void code_moveri(EXPRESSION *lhs, EXPRESSION *rhs, char *name, int f)
{

  /* First: cases where lhs inds are zero */
  if (lhs->epathhi == e_register && lhs->einds == 0 && rhs->epathhi == e_register)
    {
      ocode(name, o_mov, 0, lhs->epathlo, rhs->epathlo); 
    }
  else if (lhs->epathhi == e_register && lhs->einds == 0)
    {
      ocode(name, o_load, pathsize(lhs), lhs->epathlo, rhs); 
    }

  /* Then lhs inds are one */

  else if (lhs->epathhi == e_value && lhs->einds == 1)
    {      
      if (lhs->epathlo == el_symbolic)
	ocode(name, o_storesymb, pathsize(lhs), rhs->epathlo, lhs->evalue.s); 
      else if (lhs->epathlo == el_numeric)
	ocode(name, o_storeabs, pathsize(lhs), rhs->epathlo, lhs->evalue.i); 
    }
  else if (lhs->epathhi == e_register && rhs->einds == 0 && lhs->einds == 1)
    {      
      ocode(name, o_storesf, pathsize(lhs), rhs->epathlo, lhs->epathlo, lhs->evalue.i); 
    }

  else
    {
      pexp(lhs, "; lhs");
      pexp(rhs, "; rhs");
      printf("<%s> ", name);
      fatal("moveri not implemented mode");
    }

}


/*
 * This routine does not need to set ex->it since it will be reset by a parent.
 */

EXPRESSION *gen_alu(uchar op, EXPRESSION *lhs, EXPRESSION *rhs, char adr)
{
  int nem = 0;
  int nem_i;
  int vd = 0;
  if (vd)
    {
      pexp(lhs, "; ALU-L");
      pexp(rhs, "; ALU-R");
    }

  if (op == e_comparisonip) nem = o_cmp;
  else if (op == e_subtract) nem = o_sub;
  else if (op == e_add) nem = o_add;
  else if (op == e_bitand) nem = o_and;
  else if (op == e_bitor) nem = o_or;
  else if (op == e_eor) nem = o_eor;
  
  if (op == e_comparisonip) nem_i = o_cmpi;
  else if (op == e_subtract) nem_i = o_subi;
  else if (op == e_add) nem_i = o_addi;
  else if (op == e_bitand) nem_i = o_andi;
  else if (op == e_bitor) nem_i = o_ori;
  else if (op == e_eor) nem_i = o_eori;
  
  if (nem == 0)
    {
      printf("Bad op in rpolish %i\n", op);
      exit(1);
    }


  /*Decide which arg to load first, if none loaded.
   *We load the arg which is least suitable as a direct addressing mode.
   */
  lhs = gloadto(lhs);
  rhs = make_valid_mode(rhs);


  /* Compares do not have to be alterable, but all other lhs do */
  if (op != e_comparisonip) lhs = makedalt(lhs);
  
#if 0
  /*
   * Sort out coercion of different size objects
   */
  if (pathsize(lhs) != pathsize(rhs) && lhs->it->stars1+lhs->it->dimensions == 0)
    {
      lhs = loadasint(lhs);
      rhs = loadasint(rhs);
      returnptr = target_int_size;
    }
#endif

  if (pimrhs(rhs) && rhs->evalue.i >= 0 && rhs->evalue.i < 256)
    {
      ocode("alu_i", nem_i, 0, lhs->epathlo, rhs->evalue.i);
    }
    
  else
    {
      rhs = gloadto(rhs);   
      ocode("alu-l", nem, 0, lhs->epathlo, rhs->epathlo);
    }
  flagsvalid = 1;
  




  /* Return flags if a comparison */
  if (op == e_comparisonip)
    {
      int r = e_flags;
      EXPRESSION *ex = NEWZ(EXPRESSION);
      
      if ((rhs->it->flagvec | lhs->it->flagvec) & m_unsigned)
	{
	  r = e_flags_unsigned;
	}
      ex->epathhi = r;
      return ex;
    }
  else
    {
      EXPRESSION *ex = nexp(lhs);
      if (vd) pexp(ex, "; ALU");
      return ex;
    }
}

/*
 * This routine does not need to set ex->it since it will be reset by a parent.
 */
EXPRESSION *gen_arith(uchar op, EXPRESSION *lhs, EXPRESSION *rhs, char adr)
{
  if (op == e_divide || op == e_remainder) return rdiv(lhs, rhs, op);

  else if (op == e_multiply) return rmult(lhs, rhs);

  else return gen_alu(op, lhs, rhs, adr);
}


int pathsize(EXPRESSION *e)
{
  if (e->it->stars1+e->it->dimensions > 0) return target_ptr_size;
  if (e->it == NULL || e->it->ct == NULL)
    {
      pexp(e, "ps");
      printf("internal error: Null pathsize\n");
      return 0;
    }
  return e->it->ct->ctsize;
}


/* Return size of item pointed at */
int pointedsize(EXPRESSION *e)
{
  if (e->it->stars1+e->it->dimensions > 1) return target_ptr_size;
  if (e->it->ct == NULL)
    {
      ocode("anon", o_msg, "; bad CT\n");
      return target_ptr_size;
    }
  return e->it->ct->ctsize;
}

/*load e to a register and make word size
 * >loadasint 
 */
EXPRESSION * loadasint(EXPRESSION *e)
{
  EXPRESSION * newe;
  int startsize = pathsize(e);
  e = gloadto(e);
  if (e->it->stars1 + e->it->dimensions >= 1) return e;
  newe = nexp(e);

  if (startsize == 1) 
    {
      newe->it = copyit(newe->it);
      newe->it->ct = ct_int;
      ocode("Xd", o_andi, 0, newe->epathlo, 255);
    }
  return newe;
}

// predicate indicates whether expression is manifest power of 2
int pim124(e) EXPRESSION *e;
{
  int j;
  if (pimrhs(e)==0) return 0;
  j = e->evalue.i;
  while(j)
   {
   if (j == 1) return 1;
   if (j &  1) return 0;
   j = j >> 1;
   }
  return 0;
}

/* predicate indicates whether expression is manifestly zero
 */
int pimzero(e) EXPRESSION *e;
{ 
  if (pimrhs(e) && e->epathlo == el_numeric && e->evalue.i == 0) return 1;
  else return 0;
}

/*
 *  Main multiply routine.
 */
EXPRESSION *rmult(EXPRESSION *prv, EXPRESSION *rv)
{
  if (pimrhs(prv) && pimrhs(rv))
    {
      EXPRESSION *r = manifestint(prv->evalue.i * rv->evalue.i);
      return r;
    }
	
  if (pim124(prv))                 /* check identities of times one */
  {
    int i = prv->evalue.i;         /* or simple shifts left of one or two */
    return mul124(rv, i);
  }
  if (pim124(rv))
  {
     int i = rv->evalue.i;
     return mul124(prv, i);
  }
  
  
  return longmult(prv, rv);
}

/* multiply by manifest powers of two
 */
EXPRESSION *mul124(EXPRESSION *ex, int val)
{
  if (val == 1) return ex;
  if (val == 0) return manifestint(0);
  if (pimrhs(ex))              /* both args of * manifest */
  {
    ex->evalue.i = ex->evalue.i * val;  /* multiply at compile time */
    return ex;
  }
  ex = makedalt(loadasint(ex));
  while (val > 1)
  {
    ocode("anon", o_asl1, 0, ex->epathlo);
    val = val >> 1;
  }
  return ex;
}


/*
 *  unsigned long mult.  must add signed ?  should add optimisations for non power of 2 constants.
 */
EXPRESSION *longmult(EXPRESSION *prv, EXPRESSION *pv)
{
  EXPRESSION * ex = blank_reg(prv->it); /* todo: coerce */
  int toplab, botlab, skipjmp;
  pv = makedalt(gloadto(pv));
  prv = makedalt(gloadto(prv));
  ocode("LM", o_lodi, 0, ex->epathlo, 0);
  toplab = label(0);
  flagsvalid = 0;
  botlab = fjump(0, pv);

  ocode("anon", o_tsti, 0, pv->epathlo, 1);
  flagsvalid = 1;
  skipjmp = fjump(0, pv);
  ocode("anon", o_add, 0, ex->epathlo, prv->epathlo);
  label(skipjmp);
  ocode("anon", o_lsr1, 0, pv->epathlo, 0);
  ocode("anon", o_lsl1, 0, prv->epathlo, 0);
  ujump(toplab);

  label(botlab);
  return ex;
}

EXPRESSION *rdiv(EXPRESSION *num , EXPRESSION *den, int op)
/*
 * binary long division.  Note we can drop qreg but not freg when doing
 *  a remainder since freg is required for loop exit condition.
 */
{
  EXPRESSION * ex = NEWZ(EXPRESSION);
  int unsignedf = (num->it->flagvec | den->it->flagvec) & m_unsigned; /* correct C semantic ?*/
  int dd = pim124(den);
  num = loadasint(num);

  
  if (dd && op == e_divide) /* constant power of 2 and dividing */
    {
      int i = 1;
      while (i < num -> evalue.i)
	{
	  i <<= 1;
	  ocode("div", (unsignedf) ? o_lsr1:o_asr1, 0, num->epathlo, 0);
	}
      return num;
    }
  else
    {
      int qreg = newdreg();
      int freg = newdreg();
      int l1, l2, l3, l4;
      int dreg;
      /* quotient not needed for mod */
      if (op == e_divide) ocode("anon", o_lodi, 0, qreg, 0);
      l2 = uid(0);
      
      if (pimrhs(den))
	{                                /* If constant, do denorm now */
	  int f = 1;
	  int d = den->evalue.i;            /* Get constant value */
	  dreg = newdreg();
	  if (d == 0) 
	    {
	      error("Divide by zero");
	      return num;
	    }
	  else while((d & max_denom) == 0)
	    {
	      d = d<<1;
	      f = f<<1;
	    }
	  ocode("anon", o_lodi, 0, freg, f);
	  ocode("anon", o_lodi, 0, dreg, d);
	}
      else
	{                                 /* Test and norm denom at runtime */
	  den = loadasint(den);
	  dreg = den->epathlo;
	  ocode("anon", o_lodi, 0, freg, 1);
	  ocode("anon", o_cmpi, 0, dreg, 0);
	  ocode("anon", o_code, "beq divzero");
	  l1 = label(0);
	  ocode("anon", o_code, "bmi !L", l2);
	  ocode("anon", o_asl1, 0, freg);
	  ocode("anon", o_asl1, 0, dreg);
	  ocode("anon", o_code, "bra !L\n",  l1);
	}
      label(l2);
      l3 = uid(0);
      l4 = uid(0);
      ocode("anon", o_sub, 0, dreg, num->epathlo);
      ocode("anon", o_code, "bcs !L", l3);
      /* Get non-optimal branches with mod here */
      if (op == e_divide) ocode("div", o_add, 0, qreg, freg);
      ocode("anon", o_ujump, l4);
      label(l3);
      ocode("anon", o_add, 0, dreg, num->epathlo);
      label(l4);
      ocode("anon", o_lsr1, 0, dreg, 0);
      ocode("anon", o_lsr1, 0, freg, 0);
      ocode("anon", o_bne, l2);
      
      if (op == e_divide)
	{
	  ex->epathlo = qreg;
	}
      else
	{
	  ex->epathlo = num->epathlo;
	}

      ex->it = NEWZ(INSTANCE);
      ex->it->ct = ct_int;
      ex->epathhi = e_register;
      ex->einds = 0;
      ex->evalue.i = 0;
      return ex;
    }
}


int writeable(reg)
{
  if (reg == target_preg_name) return 0;
  return 1;
}

/* Copy a register to a new one if currently write protected */
int writereg(int reg)
{
  int nreg;
  if (writeable(reg)) return reg;
  nreg = newdreg();
  ocode("writereg", o_mov, 0, nreg, reg);
  return nreg;
}

EXPRESSION *blank_reg(INSTANCE *it)
{
  int dreg = newdreg();
  EXPRESSION *ce = NEWZ(EXPRESSION);
  ce->it = copyit(it);
  ce -> epathhi = e_register;
  ce -> epathlo = dreg;
  return ce;
}




/*
 * make a valid lhs mode for storing 
 */
EXPRESSION *make_ldst_mode(EXPRESSION *ex)
{
  while (ex->einds >= 2) ex = remove_ind(ex);
  return ex;
}

/*
 * A valid mode is any that a !B can refer to
 */
EXPRESSION *make_valid_mode(EXPRESSION *ex)
{
  return ex;
}

/*
 * Remove one indirection from a pointer or memory reference
 */
EXPRESSION *remove_ind(EXPRESSION *oldex)
{
  if (oldex->einds)
    {
      EXPRESSION *ex = make_valid_mode(oldex);
      EXPRESSION *nex = blank_reg(ex->it);

      int nreg = nex->epathlo;
      int jsize = (ex->einds >= 2) ? target_ptr_size: pathsize(ex);

      /* printf("jsize is %i\n", jsize); */

      nex -> einds = ex->einds-1;

      if (ex->epathhi == e_value && ex->epathlo == el_symbolic)
	{
	  ocode("ris", o_loadsymb, jsize, nreg, ex->evalue.s);
	}
      else if (ex->epathhi == e_register)
	{
	  ocode("risf", o_loadsf, jsize, nreg, ex->epathlo, ex->evalue.s);
	}

      else
	{
	  pexp(ex, "ri");
	  fatal("Ri not implemented");
	}
      return nex;
    }
  else return oldex;
}


EXPRESSION *loadto_given_dreg(EXPRESSION *ex, int r0)
{

  while(ex->einds > 1) 
    {
      ex = remove_ind(ex);
    }

  
  /* may need to remove value additive offset field if zero inds */
  if (ex->evalue.i && ex->einds == 0 && ex->epathhi == e_register)
    {
      int s = o_addi;
      ex = nexp(ex);
      if (ex->evalue.i < 0) 
	{
	  s = o_subi;
	  ex->evalue.i = -ex->evalue.i;
	}
      
      if (ex->unmodifiablef)  /* If unmodifiable, then copy to a fresh reg */
	{
	  int nreg = newdreg();
	  ocode("lt-u", o_mov, 0, nreg, ex->epathlo);
	  ex->epathlo = nreg;
	  ex->unmodifiablef = 0;
	}
      
      ocode("ltgr", s, 0,  ex->epathlo, ex->evalue.i);
      ex->evalue.i = 0;
      
    }

  if (ex->epathhi == e_value && ex->epathlo == el_numeric && ex->einds == 0)
    {
      ocode("lti", o_lodi, 0, r0, ex->evalue.i);
    }
  else if (ex->epathhi == e_value && ex->epathlo == el_symbolic && ex->einds == 0)
    {
      ocode("ltgd2", o_lodisymb, 0, r0, ex->evalue.s);
    }

  else if (ex->epathhi == e_value && ex->epathlo == el_symbolic && ex->einds == 1)
    {
      ocode("ltgs2", o_loadsymb, pathsize(ex), r0, ex->evalue.s);
    }

  else if (ex->epathhi == e_value && ex->epathlo == el_label && ex->einds == 0)
    {
      ocode("ltgd3", o_lodilab, 0, r0, ex->evalue.i);
    }

  else if (ex->epathhi == e_register && ex->evalue.i == 0 && ex->einds == 0) 
    {
      ocode("ltmv", o_mov, 0, r0, ex->epathlo);
    }
  else if (ex->epathhi == e_register && ex->einds == 1) 
    {
      ocode("ltgd", o_loadsf, pathsize(ex), r0, ex->epathlo, ex->evalue.i);
    }

  else 
    {
      pexp(ex, "gd");
      fatal("loadto_gd not implemented mode");
    }

  /*  ocode("ltgd", o_hard, r0, ex->epathlo);
   */
  ex = blank_reg(ex->it);
  ex->epathlo = r0;
  return ex;
}


/*
 *  After a loadto, an R value is in a register
 */
EXPRESSION *gloadto(EXPRESSION *ex)
{
  EXPRESSION *nex;
  if (ex->epathhi == e_register && ex->evalue.i == 0 && ex->einds == 0) return ex;


  if (ex->einds > 0) 
    {
      while(ex->einds > 0) 
	{
	  ex = remove_ind(ex);
	}
      return ex;
    }
  nex = blank_reg(ex->it);
  return loadto_given_dreg(ex, nex->epathlo);
}

/*
 * Move a value from a write protected site to a writeable register.
 * Needs fix
 */
EXPRESSION *makedalt(EXPRESSION * ex)
{
  while(ex->einds > 0) 
    {
      ex = remove_ind(ex);
    }

  if (tracing) ocode("anon", o_msg2, "; MX-DALT !B umf=!i\n", ex, ex->unmodifiablef);
 
  /*
    if (ex->unmodifiablef && ex->einds == 0)
    {
      EXPRESSION *nex = nexp(ex);
      int nreg = newdreg();
      if (tracing) ocode("anon", o_msg1, "; MX-DALT got !i as new reg\n", nreg);
      ocode("anon", o_error, "\t mov !r,!B ; makedalt c\n", nreg, ex);
      nex->epathhi = e_register;
      nex->epathlo = nreg;
      nex->evalue.i = 0;
      nex->unmodifiablef = 0;
      flagsvalid = 1;
      return nex;
    }
    */
  return ex;
}


/*
 * This scanner needed for case statement jump tables
 *
 * Size is tag size (1 or 2)
 */
void code_generate_scanner(int defaultvec, int cases, int tagpoolvec, int vecpoolvec, int exprreg, int size)
{
  int scanloopvec;
  int fnd = uid(0);
  int r1 = newdreg(); /* case counter */
  int r2 = newdreg(); /* base register  for tag pool */
  int r3 = newdreg(); /* scratch */

  ocode("scan", o_lodi, 0, r1, cases);
  ocode("scan", o_lodilab, 0, r2, tagpoolvec);
  scanloopvec = label(0);
  ocode("scan", o_loadsf, size, r3, r2, 0);
  ocode("scan", o_cmp, 0, r3, exprreg);
  ocode("scan", o_beq, fnd);
  ocode("scan", o_addi, 0, r2, size);
  ocode("scan", o_subi, 0, r1, 1);
  ocode("scan", o_bne, scanloopvec);
  ocode("scan", o_ujump, defaultvec);

  label(fnd);
  if (size == target_ptr_size)
    {
      ocode("scan", o_code2reg, "add !r,#(!L-!L)", r2, vecpoolvec, tagpoolvec);
      ocode("scan", o_code0reg2, "lod !r,[!r]", r1, r2);
    }
  else
    {
      ocode("scan", o_add, 0, r1, r1); /* double it */
      ocode("scan", o_code2reg, "lod !r, #(!L-2)", r2, vecpoolvec, 0);
      ocode("scan", o_add, 0, r2, r1);
      ocode("scan", o_code0reg2, "lod !r,[!r]", r1, r2);
    }
 
 ocode("scan", o_code0reg, "bx !r", r1);
}


void killval(EXPRESSION *ex)
{
  /* not used now */
}
/* end of pugen.c */


