 

/*
 * proto-solos prlibc.c
 *
 * Software Excellence from Tenison Technology.
 *
 * (C) 1995 Tenison Technology.
 * (C) 1992 DJ Greaves.
 *
 */

/*
 * This file generates libc.o and libc-debug.o when LDEBUG is on.
 */



#define TRC(X)
#undef LDEBUG
#define STALLONE

#define INCLUDE_STDIO

#ifdef INCLUDE_STDIO

#include  "mymachdep.h"
#include  "prstdio.h"


#define s_stdioflush fflush
#define SKIP(X)

/* Prototypes */
struct stdio *fopen();
struct stdio *stdin;
struct stdio *stdout;
struct stdio *stderr;
void prstring(char *s, int prefield, int field);
void printu(int x);
void shi(unsigned int *p, int d);
void printx(unsigned int x, int field);

int errno;  /* provided as part of stdio library */
int deb;
uchar *kmalloc_poi;

static char *spf;
static char _spfbuf[1024];

#define pfputc(X) { *spf++ = ((char)(X)); }

int _crt0()
{
  kmalloc_poi = (char *) HEAP_START;
  errno = 0;
  stdin = NULL; /* fopen(0, "r"); */
  stdout = NULL; /* fopen(1, "w"); */
  stderr = NULL; /* fopen(2, "w"); */
  return main(0, 0);
}


/* Read a line, returning line or NULL on eof */
char *fgets(char *buf, int maxn, struct stdio *f)
{
  char *p = buf;
  if (f->flags & 1)
  {
    *p = (char) 0;
    return (char *) NULL;  /* EOF */
  }

  maxn--; /* Make room for NULL to go on the end*/
  while(maxn>0)
  {
    int sn = f->bytes;
    char c = 0;
    int n, d;
    if (sn > maxn) sn = maxn;  /* Determine smaller constraint */
    n = sn;
    while(n > 0)  /* Copy n bytes here */
    {
      c = *(f->poi)++;
      *p++ = c;
      n--;
      if (c == '\n') break;
    }
    d = sn - n; /* Number of bytes moved */    
    f->bytes -= d;
    maxn -= d;
    if (c == '\n') break;
    if (f->bytes == 0 && f->flags == 0)
    {
      int b;
      b = read(f->sysfd, f->data, STDIOLEN);    
      if (b == 0)
       {
        f->flags = 1;
      }
      f->bytes = b;
      f->poi = f->data;
    }
    if (f->flags & 1) break;  /* eof found - return whatever read */
  }
  *p = (char) 0;
  return buf;
}


#if 0
/* fmk_index generates an index for a file suitable for random access
 * using fseek.
 */

#define INDEXSIZE 5000  /* Max number of STIOLEN blocks in a file */

int fmk_index(FILE *f)
{
  int b = 0;
  int running = 1;
  ioctl(fileno(f), CTL_REWIND, 0);
  if (f->index) return 0;
  f->index = (fpos_t *) malloc(INDEXSIZE * sizeof(fpos_t));
  while(running)
  {
    ioctl(fileno(f), CTL_GETPOS, &( f->index[b] ));
    b++;
    if (b > INDEXSIZE)
    {
      printf("Random access file too big\n");
      exit(1);
    }
    if (ioctl(fileno(f), CTL_CHAIN, 0)) running = 0;
  }
}


int fseek(FILE *f, int pos)
{
  int o = pos & 0x3FF;
  int b = pos >> 10;
  if (f->index == NULL) fmk_index(f);
  ioctl(fileno(f), CTL_SETPOS, &( f->index[b] ));
  read(fileno(f), f->data, STDIOLEN);
  f->bytes = STDIOLEN - o;
  f->poi = f->data + o;
}

int frewind(FILE *f)
{
  return ioctl(fileno(f), CTL_REWIND, 0);
}


/* 
 * fopen doubles as fdopen by assuming all strings are less than SYSFDS
 * in store.
*/
struct stdio *fopen(char *fname, char *mode)
{
  struct stdio *r;
  int fd = -1;

  if ((int)fname <= SYSFDS) fd = (int) fname;
  else
  {
    if (mode[0] == 'r') fd = open(fname, O_RDONLY);
    else if (mode[0] == 'w') fd = open(fname, O_WRONLY);
    if (fd == 0) fd = -1;
  }
  if (fd == -1) return (struct stdio *) NULL;
  r = (struct stdio *) malloc(sizeof(struct stdio));
  r->mode = mode[0];
  r->bytes = 0;
  r->sysfd = fd;
  r->flags = 0;
  r->poi = r->data;  /* Needed for putc */
  r->error = 0;
  r->index = NULL;
  return r;
}
#endif



char getc(struct stdio *f)
{
  if (f->bytes == 0)
  {
    int b;
    if (f->flags) return EOF;
    b = read(f->sysfd, f->data, STDIOLEN);    
    if (b == 0)
    {
      f->flags = 1;
      return EOF;
    }
    f->bytes = b;
    f->poi = f->data;
  }
  f->bytes --;
  return *(f->poi)++;
} 

void putc(char c, struct stdio *f)
{
  while (f->bytes == STDIOLEN) s_stdioflush(f);
  *(f->poi)++ = c;
  f->bytes ++;
  if (c == '\n') s_stdioflush(f);
}

#ifndef putchar
void putchar(char c)
{
  _sa_wrch(c);
#ifdef UDP_CONSOLE
  udp_telnet_flush();
#endif
}
#endif

/*
 *
 */
fflush(struct stdio *f)
{
  if (f && f->mode == 'w')
  {
    write(f->sysfd, f->data, f->bytes);
    f->bytes = 0;
    f->poi = f->data;
  }
}

void exit(c)
{
  s_stdioflush(stderr);
  s_stdioflush(stdout);
#ifdef LDEBUG
  _debugger(c);
#endif
  while (1) continue;
}


int fclose(struct stdio * f)
{
  s_stdioflush(f);
#if 0
  return close(f->sysfd);
#endif
}

int fwrite(char *buf, int size, int nitems, struct stdio *stream)
{
  s_stdioflush(stream);
  return write(stream->sysfd, buf, size * nitems);
}

int fread(char *buf, int size, int nitems, struct stdio *stream)
{
  return read(stream->sysfd, buf, size * nitems);
}


#endif INCLUDE_STDIO

int strlen(char *s)
{
  int r = 0;
  while(*s++) r++;
  return r;
}


char *strstr(char *targ, char *pat)
{
  while(*targ)
  {
    char *p = pat;
    char *q = targ;
    while (*p && *p == *q) { p++; q++; };
    if (*p == (char) 0) return targ;
    targ++;
  }
  return NULL;
}

/*
 *
 */
char *strcpy(char *dest, const char *src)
{
  while (*src)
  { 
    *(dest++) = *(src++);
  }
  *dest = (char) 0;
  return dest;
}

/*
 *
 */
char *strncpy(char *dest, char *src, int n)
{
  while (n-- > 0)
    {
      *(dest++) = *(src++);
    }
  return dest;
}



void *memcpy(void *dest, void *src, int length)
{
  char *b1 = (char *) src;
  char *b2 = (char *) dest;
  void *d = dest;
  while(--length >= 0) *(b2++) = *(b1++);
  return d;
}

void bcopy(char *src, char *dest, int length)
{
  while(--length >= 0) *(dest++) = *(src++);
}


int bcmp(char *b1, char *b2, int length) 
{
  while(--length >= 0) if ( *(b1++) != *(b2++)) return 1;
  return 0;
}

void bzero(char *b1, int length) 
{
  while(--length >= 0) *(b1++) = (char) 0;
}

char *strcat(char *dest, char *src)
{
  while (*dest) dest++;
  while (*src) { *(dest++) = *(src++); }
  *dest = (char) 0;
  return dest;
}


void printf(char *s, int a, ...) 
{
  spf = _spfbuf;
  dof(s, &a);
#ifdef FSL
  s_stdioflush(stdout);
  write(stdout->sysfd, _spfbuf, spf-_spfbuf);
#else
  sa_write(_spfbuf, spf-_spfbuf);
#endif
}

#if 0
void testprintf(char *s,  int a, ...)
{
  spf = _spfbuf;
  dof(s, &a);
  sa_write(_spfbuf, spf-_spfbuf);
}
#endif

void sprintf(char *string, char *s,  int a, ...)
{
  spf = string;
  dof(s, &a);
  *spf = (char) 0;
}

void fprintf(struct stdio *fd, char *s,  int a, ...)
{ 
  SKIP(printf("fprintf with f of %x\n", fd));
  s_stdioflush(fd);
  spf = _spfbuf;
  dof(s, &a);
  write(fd->sysfd, _spfbuf, spf-_spfbuf);
}

/*
 * This is for the GNU ARM calling convention.
 */
/* #define UPDATEPOI(X) { argsused += 1; if (argsused <3) poi-=1; else if \
 *   (argsused==3) poi = poi+8; else poi += 1; }
 */

/*
 * This is for the CBG ARX calling convention.
 */
#define UPDATEPOI(X) { poi ++; }


dof(char *s, int *poi)
{
  int i = 0;
  int zeropad = 0;
  char c = s[0];
  /* int argsused = 0; */
  int prefield;
  int field;

  while (c)
   { 
     if (c !='%')
     {
       pfputc(c);
       c = s[++i];
       continue;
     }
     field = 0;
     prefield = -1;
 sol:
     {
       uchar t1, t; 
       int tc;
       t = s[++i];


       if (t >= 'a') t = t - 32;
       if (t == 'L') goto sol;



       if (t == '%')
	 {
	   pfputc('%');
	 }
       else
	 {
	   switch(t)
	    { 
	    case 'C': tc = *poi; pfputc(tc);
	      break;

	    case 'S': 
	      prstring((char *) *poi, prefield, field);
	      break;
	    
	    case 'X': 
	      printx(*poi, field);
	      break;
	      
	    case '*': field = *poi; UPDATEPOI(poi); goto sol;
	      
	    case 'I':
	    case 'D':
	      printi(*poi);
	      break;
	    case 'U':
	      printu(*poi);
	      break;
	      
	    case '0':
	      if (field==0) zeropad = 1;
	    case '1': case '2': case '3': case '4':
	    case '5': case '6': case '7': case '8': case '9':
	      field = field*10 + t - '0';
	      goto sol;
	      
	    case '.': prefield = field; field = 0; goto sol;
	      
	    default: printf("Bad printf selector '%c' \n", t);
	      
	    }
	  c = s[++i];
	  UPDATEPOI(poi);
	}
     }
   }
}

void prstring(char *s, int prefield, int field) 
{
  if (s == NULL)
    {
      pfputc('<');      pfputc('>');
    }
  else
    {
      if (prefield >= 0)  /* prefield positive implies field is MAX length */
	{
	  while(*s && field>0) 
	    { 
	      pfputc(*s++);
	      field--; 
	      prefield--; 
	    }
	  while(prefield>0)
	    {
	      pfputc(' '); prefield--; 
	    }
	}
      else
	{
	  while(*s)
	    {
	      pfputc(*s++); field--;
	    }
	  while(field>0) 
	    {
	      pfputc(' '); field--;
	    }
	}
    }
}

static char _zeroflag;

printi(int x) 
{
  if (x < 0)
  {
     pfputc('-');
#ifndef IS16BIT
     if (x == 0x80000000) 
     { 
       prstring("2147483648", 0, 100);
       return;
     }
#else
     if (x == 0x8000) 
     { 
       prstring("32768", 0, 100);
       return;
     }
#endif
     x = -x;
  }
  printu(x);
}
  
void printu(int x)
{
  if (x == 0)
    { 
      pfputc('0');
      return;
    }
  _zeroflag = 0;
  
  shi(&x, 1000000000);
  shi(&x, 100000000);
  shi(&x, 10000000);
  shi(&x, 1000000);
  shi(&x, 100000);
  shi(&x, 10000);
  shi(&x, 1000);
  shi(&x, 100);
  shi(&x, 10);
  shi(&x, 1);
}


void shi(unsigned int *p, int d)
{ 
  char r = 0;
  while (*p >= d)
    { r ++;
      *p = *p - d;
    }
   if (r) _zeroflag = 1;
   if (_zeroflag) pfputc(r + '0');
}


void hex1(int x)
{
  x = x & 15;
  pfputc( x>9 ? x+('A'-10): x+'0');
}

void hex2(int x)
{
  x = x & 255;
  hex1(x >> 4);
  hex1(x);
}



void debhex8(int x)
{
#ifndef IS16BIT
  hex2(x >> 24);
  hex2(x >> 16);
#endif
  hex2(x >> 8);
  hex2(x >> 0);
  pfputc(' ');
}

int isupper (char c)
{
  if ((c >='A') && (c <= 'Z')) return 1;
  return 0;
}

int isdigit (char c)
{
  if ((c >='0') && (c <= '9')) return 1;
  return 0;
}

int isprint (char c)
{
  if ((c >=' ') && (c <= 126)) return 1;
  return 0;
}


void printx(unsigned int x, int field)
{
  int i;
  unsigned int r = x >> 8;
#if 0
  if (field > 10)
    {
      debhex8(field);
      pfputc('^');
      field = 8;
    }
#endif
  if (r) printx(r, field-2);
  else for (i=2; i<field; i++) pfputc('0');
  hex2(x);
}


int strcmp(const char *a, const char *b)
{ 
  while(*a == *b)
  {
    if (*a == 0) return 0;
    a++; b++;
  }
  return *a - *b;
}



int strncmp(char *a, char *b, int n) 
{ 
  while(*a == *b && n > 0)
  {
    if (*a == 0) return 0;
    a++; b++; n--;
  }
  if (n==0) return 0;
  return *a - *b;
}



char tolower(char c)
{
  if ((c >='A') && (c <= 'Z')) return c+32;
  return c;
}

char toupper(char c)
{
  if ((c >='a') && (c <= 'z')) return c-32;
  return c;
}


int islower(char c)
{
  if ((c >= 'a') && (c <= 'z')) return 1;
  return 0;
 }

int isalnum(char c)
{
  if (c >= 'a' && c <= 'z') return 1;
  if (c >= 'A' && c <= 'Z') return 1;
  if (c >= '0' && c <= '9') return 1; 
  return 0;
}

int isalpha(char c)
{
  if (c >= 'a' && c <= 'z') return 1;
  if (c >= 'A' && c <= 'Z') return 1;
  return 0;
}

int atoi(char *s)
{
  int r = 0;
  int base = 10;
  if (s == NULL) return 0;
  while (*s == ' ' || *s == 0) s++;  /* Skip leading whities */
  while (1)
   { char c = *(s++);
     if (c >= '0' && c <= '9')
       { r = r*base + c - '0';
       continue;
       }
     if (c >= 'a') c = c - 32;
     if (c =='X')
       { base = 16;
       continue;
       }
     if (base >= 10 && c >= 'A' && c <= 'F')
       {
	 r = r*base + c - 55;
	 continue;
       }
     break;
   }
  return r;
}



/* 
 * malloc routine 
 */

#ifdef VM_USER_MODE
#define BIGAMOUNT (50000)
char *m_malpoi = NULL;
int m_malbytes = 0;
extern char *sc_malloc();

char *malloc(int size)
{
  char *r;
  if (size > BIGAMOUNT) return sc_malloc(size);
  size = ((size + 15) & 0xFFFFFFF0);
  while (m_malbytes < size)
    {
      m_malpoi = sc_malloc(BIGAMOUNT);
      m_malbytes = BIGAMOUNT;
    }
  r = m_malpoi;
  m_malbytes -= size;
  m_malpoi += size;
  return r;
}
#else

extern uchar *kmalloc_poi;
char *malloc(int size)
{
  uchar *r = kmalloc_poi;

#ifndef IS16BIT
  size = (size + 15) & 0xFFFFfff0;
#else
  size = (size + 1) & 0xfffE;
#endif
  kmalloc_poi += size;
  return r;
}
#endif


int write(int fd, char *buf, int len)
{
  TRC(_sa_wrch(*buf));
  while (len >0)
    {
      _sa_wrch(*buf++);
      len -= 1;
    }
  return 0;
}
/*#define GDB*/

int sa_write(char *buf, int len)
{
  unsigned char checksum='O';
  TRC(_sa_wrch(*buf));
#ifdef GDB
  _sa_wrch('$');
  _sa_wrch('O');
#endif
  while (len >0)
    {
      char c=*buf++;
      if (c == '\n')
	{
#ifdef GDB
	  checksum+='0'+'d';
	  _sa_wrch('0');
	  _sa_wrch('d');
#else
	  _sa_wrch(13);
#endif
	}
#ifdef GDB
      checksum+="0123456789abcdef"[c >> 4];      
      _sa_wrch("0123456789abcdef"[c >> 4]);
      checksum+="0123456789abcdef"[c & 0xf];      
      _sa_wrch("0123456789abcdef"[c & 0xf]);
#else
      _sa_wrch(c);
#endif
      len -= 1;
    }
#ifdef UDP_CONSOLE
  udp_telnet_flush();
#endif
#ifdef GDB
  _sa_wrch('#');
  _sa_wrch("0123456789abcdef"[checksum >> 4]);
  _sa_wrch("0123456789abcdef"[checksum & 0xf]);
#endif
  return 0;
}



int read(int f, char *buf, int len)
{
  char c = polled_sa_rdch();
  *buf = c;
  return 1;
}

char getchar()
{
  return polled_sa_rdch();
}


int ioctl()
{
  return -1;
}


/* end of cbg prlibc.c */


