
/* cbg closure c compiler. compile.c */

/*
 * (C) 1995 Tenison Technology
 * DJ Greaves
 * Tenison Technology
 * 10 Tenison Road
 * Cambridge CB1 2DW
 */


#include <stdio.h>
#include <malloc.h>
#include "ccchdr.h"
#include <ctype.h>
/* #define TRACING */

extern FILE *sysout;


extern struct christ *genv;
ROUTINE *routines;
extern EXPRESSION *gloadto(EXPRESSION *);
int breakvec = -1;
int contvec = -1;
static CONS *findlist;
static int static_decl_count; 
static int forces; /* index to forcearray array */
char *error_src_string;

#define FORCEMAX 100

struct force_s
{
  EXPRESSION *e;
  int v;
  char *reason;
} forcearray[FORCEMAX];

/* Prototypes */
extern EXPRESSION *compile_general_call(ENODE *, int sp);
int stack_needed(ROUTINE *r);
EXPRESSION *local_christ_to_expr(CHRIST *c);
void compile_command(PT *p, int sp, int leaff);
int stoflag(uchar s);
EXPRESSION *doashift(int s, EXPRESSION *lhs, EXPRESSION *rhs);
EXPRESSION *giveaddsub(char key, EXPRESSION *ee, int);
EXPRESSION *manifestint(int);
EXPRESSION *compile_comparison(uchar s, EXPRESSION *lhs, EXPRESSION *rhs);
EXPRESSION *fixedshift();
EXPRESSION *varshift(uchar s, EXPRESSION *obj, EXPRESSION *amount);


static int max(int x, int y) 
{
  return (x>y) ? x:y;
}


INSTANCE *current_ptr;
	   

int flag_undefineds = 1;


ROUTINE *routine_lookup(char *name)
{
  ROUTINE *r = routines;
  while (r)
    {
      if (!strcmp(r->name, name)) return r;
      r = r->next;
    }
  return NULL;
}


void dump_routine_names()
{
  ROUTINE *r = routines;
  while (r)
    {
      printf("Routine %s\n", r->name);
      r = r->next;
    }
}



EXPRESSION * manifestint(int val)
{
  EXPRESSION * e = NEWZ(EXPRESSION);
  e->evalue.i = val;
  e->epathhi= e_value;
  e->epathlo = el_numeric;
  e->it = NEWZ(INSTANCE);
  e->it->ct = ct_int;
  e->einds  = 0;
  return e;
}

/*
 *
 */
EXPRESSION *local_christ_to_expr(CHRIST *c)
{
  EXPRESSION *ex = NEWZ(EXPRESSION);
  int idx = c->idx;

  if (c->cpath == sim_local_stack)
    {
      ex->epathlo = target_preg_name;
      ex->epathhi = e_register;
      ex->einds = 1;
      ex->evalue.i = idx;
      ex->unmodifiablef = 1;
    }
  else  if (c->cpath == sim_local_reg)
    {
      ex->epathlo = idx;
      ex->epathhi = e_register;
      ex->unmodifiablef = 1;
      ex->einds = 0;
    }
  else fatal("bad cpath sim_local type");

  ex->it = c->it;

  /* pexp(ex, "; CHLO"); */

  return ex;
}


/* Matrix for commuted application of comparison ops. */
int commute [] = { 4, 5, 2, 3, 0, 1 };

EXPRESSION *compile_comparison(uchar s, EXPRESSION *lhs, EXPRESSION *rhs)
{
  EXPRESSION * ex = NEWZ(EXPRESSION);
  int r = e_flags;
  
  if ((rhs->it->flagvec | lhs->it->flagvec) & m_unsigned)
    {
      r = e_flags_unsigned;
    }
  
  if (pimzero(lhs))
  {
    rhs = gloadto(rhs);
    rhs = getflagsv(rhs);
    
    
    ex  -> epathhi = r;
    ex  -> epathlo = commute[stoflag(s)];
  }
  
  else if (pimzero(rhs))
  {
    lhs = gloadto(lhs);
    lhs = getflagsv(lhs);
    
    
    ex  -> epathhi = r;
    ex  -> epathlo = stoflag(s);
  }
  else
  {
    new_rpolish(e_comparisonip, lhs, rhs, 0);
    ex  -> epathhi = r;
    ex  -> epathlo = stoflag(s);
    /* assembly("; returning flags\n"); */
  }
  return ex;
}

int stoflag(uchar s)
{ 
  return (s == s_eqeq) ?  3:
         (s == s_plingeq) ? 2:
         (s == s_lessereq) ? 5:
         (s == s_greatereq) ? 1:
         (s == s_lesser) ? 4: 0;
}



/*
 * new_rpolish is the general entry point to generate code 
 * for all diadic operators.  This routine itself is target 
 * neutral and handles compile time evaluations.
 *
 *
 * Options are : 
 *       1.  num <op> num      gives a num of the larger size
 *       2.  ptr +/- num       gives ptr where num is scaled
 *       3.  num +/- ptr       as case 2 
 *       4.  ptr - ptr         must be same type of pointer, post divide needed.
 *
 *   Any arithemtic on structures (where inds is zero) is illegal.
 *
 */
EXPRESSION *new_rpolish(int op, EXPRESSION *lhs, EXPRESSION *rhs, char adr)
{
  int vd = 0;
  int postscale = 1;  /* Amount to divide by afterwards */

  int returnstars = lhs->it->stars1 + rhs->it->stars1 + lhs->it->dimensions + rhs->it->dimensions; 

  /* of course it is illegal for lhs and rhs to both be non zero in the star or dimension dept */
  INSTANCE *returnit;



  if (vd)
    {
      assembly("; new_rpolish %i\n", op);
      pexp(lhs, "LHS");
      pexp(rhs, "RHS");
    }

  if (lhs->it->stars1+lhs->it->dimensions == 0  && rhs->it->stars1+rhs->it->dimensions == 0 /* && op != e_comparisonip */) /* case 1 num +/- num */
    {
      int size = max(lhs->it->ct->ctsize, rhs->it->ct->ctsize);


      if (vd) assembly("; RP Case 1\n");

      if (lhs->it->ct->st || rhs->it->ct->st)
	{
	  error("Arithmetic on structures not allowed");
	}

      returnit = NEWZ(INSTANCE);
      returnit->wnode = "$ALU";
      returnit ->ct = NEWZ(CT);
      returnit ->flagvec = lhs->it->flagvec | rhs->it->flagvec; /* Todo: sort out flag clashes */
      returnit -> stars1 = returnstars;
      returnit -> ct->ctsize = size;
    }

  else if (lhs->it->stars1+lhs->it->dimensions > 0  && rhs->it->stars1+rhs->it->dimensions == 0 /* && op != e_comparisonip */) /* case 2  ptr +/- num */
    {

      /* assert op is plus or minus  */
      if (vd) assembly("; RP Case 2\n");
      returnit = lhs->it;
      rhs = indexscale(op, lhs, rhs);
    }
      
  else       if (lhs->it->stars1+lhs->it->dimensions == 0  && rhs->it->stars1+rhs->it->dimensions > 0 /* && op != e_comparisonip */) /* case 3  num +/- ptr */
    {
      if (vd) assembly("; RP Case 3\n");
      returnit = rhs->it;
      lhs = indexscale(op,  rhs, lhs);
    }
    

  else if (lhs->it->stars1+lhs->it->dimensions > 0 && rhs->it->stars1+rhs->it->dimensions > 0)
    {

      /* Case 4*/
      if (vd) assembly("; RP Case 4\n");
      if (op != e_subtract && op != e_comparisonip)
	
	{
	  error("Both arguments pointers in address arithmetic (non subtract or compare)");
	}
      else                 /* pointer subtraction */
	{
	  if (lhs->it->ct->ctsize != rhs->it->ct->ctsize) error("subtraction of different types");
	  returnit = NEWZ(INSTANCE);
	  returnit->wnode = "$POINTERSUB";
	  returnit->ct= ct_int;
	  postscale = pointedsize(lhs);  /* Lhs is(should be) same as rhs for this */
	}
    }

  else 
    {
      pexp(lhs, "ALUL");
      pexp(rhs, "ALUR");
      error("illegal combination in address arithemetic");
    }

  /*--------------------------------- another routine ------------------*/
  flagsvalid = 0;
  
  if (pimrhs(lhs) && pimrhs(rhs)    /* If both operands known now ? */
      && (lhs->epathlo == el_numeric) /* and real numeric vals */
      && (rhs->epathlo == el_numeric)) /* then we have a manifest constant */
    {
      int a = lhs->evalue.i;
      int b = rhs->evalue.i;
      int y;
      

      if (op == e_add) y = a + b;
      else if (op == e_subtract) y = a - b;
      else if (op == e_bitand) y = a & b;
      else if (op == e_bitor) y = a | b;
      else if (op == e_multiply) y = a * b;
      else if (op == e_remainder) 
	{

	  if (b == 0) error("divide by zero");
	  else y = a % b;
	}
      else if (op == e_divide) 
	{
	  if (b == 0) error("divide by zero");
	  else y = a / b;
	}

      else if (op == e_eor) y = a ^ b;
      else if (op == e_rshift) y = a >> b; /* @@@@ add unsigned */
      else if (op == e_lshift) y = a << b;

      rhs->evalue = y;
	
      if (postscale > 1)
	{
	  rhs->evalue.i = rhs->evalue.i / postscale;
	}
      flagsvalid = 0;
      return rhs;
    }
  else
    { /* not both manifest */

      /* We optimise by not generating immediate adds of zero */
      if (op == e_add)
	{
	  if (pimzero(rhs))
	    {
	      flagsvalid = 0;
	      return lhs;
	    }
	  if (pimzero(lhs))
	    {
	      
	      flagsvalid = 0;
	      return rhs;
	    }
	}


      /* We optimise by not generating immediate takes of zero */
      if (op == e_subtract && pimzero(rhs))
	{
	  flagsvalid = 0;
	  return lhs;
	}
	

  /*
   * If op is add, and one operand is in a register and the other is a manifest
   * int less than target_max_index, then we can return a value of index+offset addressing mode.
   */
      if (op==e_add && pimrhs(lhs) && rhs->epathlo == el_numeric &&
	  rhs->einds==0 && rhs->epathhi==e_register && abs(rhs->evalue.i + lhs->evalue.i) <= target_max_index)
	{
	  rhs->evalue.i = rhs->evalue.i + lhs->evalue.i;
	  
	  rhs->it  = returnit;
	  ocode("a", o_msg, "; L IND OPT\n");
	  flagsvalid = 0;
	  return rhs;
	}
      
            
      /* Can do additions of constants to registers here by adding on to evalue */
      if (op==e_add && pimrhs(rhs) && lhs->einds==0 && lhs->epathhi==e_register
	  && abs(rhs->evalue.i + lhs->evalue.i) <= target_max_index)
	{
	  lhs->evalue.i = lhs->evalue.i + rhs->evalue.i;
	  
	  lhs->it = returnit;
	  return lhs;
	}
      
      
      lhs = gen_arith(op, lhs, rhs, adr);
      
      if (postscale > 1)
	{
	  if (postscale & 1) error("pointer division not implemented");
	  while (postscale > 1) 
	    { 
	      ocode("ps", o_lsr1, rhs->epathlo);
	      postscale = postscale / 2; 
	    }
	  flagsvalid = 0;
	}

      lhs->it = returnit;
      return lhs;
    }
}





int evalmanifeste(ENODE *e)      /* eval with check that answer is */
{                                    /* known at compile time. */
  int r = 1;
  EXPRESSION *ex = compile_expr(e, 0);
  if (ex->epathhi != e_value  || ex->epathlo != el_numeric)
                       error("manifest constant expression needed");
  else r = ex->evalue.i;
  
  return r;
}

EXPRESSION *compile_evalconst(ENODE *e)      /* Return a constant (relocatable) expr */
{
  EXPRESSION *ex = compile_expr(e, 0);
  if (ex->epathhi != e_value  || ex->einds != 0)
    error("constant expression needed");
  return ex;
}

/* 
 * eval which will not flag undefined vars 
 */
EXPRESSION *compile_expr_for_gotos(ENODE *e, int sp)  
{
  EXPRESSION * r;
  flag_undefineds = 0;
  r = compile_expr(e, sp);
  flag_undefineds = 1;
  return r;
}



EXPRESSION *doashift(int s, EXPRESSION *lhs, EXPRESSION *rhs)
{
  lhs = makedalt(lhs);
  if (pimrhs(rhs))
  {
    if (pimrhs(lhs) && lhs->epathlo == el_numeric && rhs->epathlo == el_numeric)
    {
      if (s == e_lshift) lhs->evalue.i = lhs->evalue.i << rhs->evalue.i;
      else lhs->evalue = lhs->evalue.i >> rhs->evalue.i;
      return lhs;
    }
    if (pimrhs(rhs)) return fixedshift(s, lhs, rhs);
  }
 return varshift(s, lhs, rhs);
}


/* private entry routine for other evals */
EXPRESSION * compile_expr0(ENODE *e, int sp)          
{
  EXPRESSION *lhs, *rhs, *ex; int p, q, r0;  

  if (e == NULL) return NULL;
  else switch(e->key)
    {

    case e_cmd:
      {
	flagsvalid = 0;
	
	while(e->exp)
	  {
	    ex = compile_expr(e->exp, sp);
	    if (e->exp1)
	      {
		
	      }
	    e = e->exp1;
	  }
	return ex;
      }
    
    case e_query:
      p = compile_fjump(e->exp, 0, sp);
      lhs = gloadto(compile_expr(e->exp1, sp));
      r0 = lhs->epathlo;
      q = ujump(0);
      label(p);

      rhs = loadto_given_dreg(compile_expr(e->exp2, sp), r0);
     
      label(q);
      if (rhs->epathlo != r0) error("register assignment mismatch");
      return rhs;

    case e_number:
      return manifestint(e->i);
    
    case e_id:
      { 
	struct christ *c = clookup(e->wordnode, genv);
	EXPRESSION * ex;
	if (c)
	  { 
	    switch(c->cpath)
	      { 
	      case sim_lval: 
		
		ex = NEWZ(EXPRESSION);
		ex->epathlo = el_symbolic;
		ex->epathhi = e_value;
		ex->einds = 1;
		ex->evalue.s = e->wordnode;
		break;

	      case sim_enum:   
	      case num_rval:
		ex = manifestint(c->idx);
		break;


	      case sim_rval:   
		ex = NEWZ(EXPRESSION);
		ex->epathlo = el_symbolic;
		ex->epathhi = e_value;
		ex->einds = 0;
		ex->evalue.s = e->wordnode;
		break;


	      case sim_local_reg:  
	      case sim_local_stack:
		ex = local_christ_to_expr(c);
		break;

	      default: fatal("bad sim_xx value");
	      }
	    ex->it = c->it;
	  }
	else
	  { 
	    ex = NEWZ(EXPRESSION);
	    ex->epathhi = e_value;
	    ex->epathlo = el_symbolic;
	    ex->einds = 0; /* default to an extern const or entry point */
	    ex->it = NEWZ(INSTANCE);
	    ex->it->ct = ct_int;
	    ex->evalue.s = e->wordnode;

	    error("%s not defined", e->wordnode);
	    if (target_autoextern) assembly("_!s\t extern\n", e->wordnode);
	    /* C makes us do this awful hack to implicitly define functions */
	    if (0 && flag_undefineds)
	      error("%s not defined", e->wordnode);
	  }
	/* assembly("; term of type "); pexp(ex); */
	return ex;
      }
    
    case e_string:
      {
	EXPRESSION * ex = NEWZ(EXPRESSION);
	CONS *start, *end;
	start = cons(e->wordnode, NULL);
	end = start;
	while(symb == s_string) /* cat adjacent strings */
	  { 
	    CONS *p = cons(wordnode, NULL);
	    end->cdr = p;
	    end = p;
	    nextsymb();
	  }
	ex->epathhi = e_value;
	ex->epathlo = el_label;
	ex->einds = 0;       /* insert values for (char *) */
       	ex->it = NEWZ(INSTANCE);
	ex->it->ct = ct_char;
	ex->it->stars1 = 1;
	ex->evalue.i = litpooladd(start, 0)->lindex;
	/* printf("Gave lab %i for string %s\n", ex->evalue.i, wordnode); */
	return ex;
      }

    default:
      error("Compile bad expression e_key %i", e->key);
      return manifestint(0);


    case e_cast:
      ex = compile_expr(e->exp, sp);
      ex = nexp(ex);
      ex->it = e->it;
      return ex;
      
    case e_stars:                /* monadic star operator */
      
      ex = compile_expr(e->exp, sp); 
      ex = nexp(ex);
      ex -> einds ++;
      flagsvalid = 0;
      ex->it = copyit(ex->it);
      if (ex->it->dimensions) ex->it->dimensions -= 1;
      else if (ex ->it->stars1) ex ->it->stars1 -= 1;
      else error("star or subscript applied to non-pointer");

      return ex;

    case e_pling:             /* monadic negation */
      ex = compile_expr(e->exp, sp);
      if (pimrhs(ex))
	{
	  ex = nexp(ex);
	  ex->evalue.i = (ex->evalue.i) ? 0: 1;
	  return ex;
	}
      else return logical_negate(ex);
      
    case e_abs:             /* absolute value function */
      ex = compile_expr(e->exp, sp);
      if (pimrhs(ex))
	{
	  ex = nexp(ex);
	  ex->evalue.i = abs(ex->evalue.i);
	  return ex;
	}
      else return arith_abs(ex);
      
      
      
    case e_tilda:             /* monadic ones complement */
      ex = compile_expr(e->exp, sp);
      if (pimrhs(ex))
	{
	  ex = nexp(ex);
	  ex->evalue.i = 0xFFFFffff - ex->evalue.i;
	  flagsvalid = 0;
	  return ex;
	}
      else return arith_complement(pathsize(ex), ex);
      
    case e_pre_plusplus:              /* prefix ++ and -- operators */
    case e_pre_minusminus:
      ex = compile_expr(e->exp, sp);
      ex = giveaddsub((e->key==e_pre_plusplus) ? '+':'-', ex, -1);
      return ex;
      

    case e_addressof:
      ex = compile_expr(e->exp, sp);
      ex = nexp(ex);
      if (ex->einds == 0) error("warning: non-lvalue argument to ampersand");
      else ex->einds --;
      ex->it = copyit(ex->it);
      ex->it->stars1 ++;
      flagsvalid = 0;
      return ex;
      

    case e_assign:      /* assignment operators  */
      
      rhs = compile_expr(e->exp1, sp);
      lhs = compile_expr(e->exp, sp);


    
      switch(e->uch)
      {

      case s_equals:
	ex = rhs;
	break;
      case s_pluseq:
	ex = new_rpolish(e_add,  lhs, rhs, 0);
	break;
      case s_minuseq:
	ex = new_rpolish(e_subtract,  lhs, rhs, 0);
	break;

      case s_eoreq:
	ex = new_rpolish(e_eor, lhs, rhs, 0);
	break;

      case s_andeq:
	ex = new_rpolish(e_bitand, lhs, rhs, 0);
	break;
      case s_oreq:
	ex = new_rpolish(e_bitor, lhs, rhs, 0);
	break;
      case s_lshifteq:
	ex = doashift(e_lshift, lhs, rhs);
	break;
      case s_rshifteq:
	ex = doashift(e_rshift, lhs, rhs);
	break;
      case s_stareq:
	ex = new_rpolish(e_multiply, lhs, rhs, 0);
	break;
      case s_slasheq:
	ex = new_rpolish(e_divide, lhs, rhs, 0);
	break;
      }
      return assign(lhs, ex); 
      
    case e_bitor:
    case e_eor:
    case e_bitand:
    case e_multiply:
    case e_divide:
    case e_remainder:
    case e_add:
    case e_subtract:
	lhs = compile_expr(e->exp, sp);
	rhs = compile_expr(e->exp1, sp);
	return new_rpolish(e->key, lhs, rhs, 0);
 

    case e_comparisonip:
      lhs = compile_expr(e->exp, sp);
      rhs = compile_expr(e->exp1, sp);
      return compile_comparison(e->uch, lhs, rhs);
      

    case e_lshift:
    case e_rshift:
	lhs = compile_expr(e->exp, sp);
	rhs = compile_expr(e->exp1, sp);
	return doashift(e->key, lhs, rhs);


      
	/*Function call in expression, answer in d0. */
    case e_call:
      save_or_restore_mcstate(1);
      ex = compile_general_call(e, sp);
      save_or_restore_mcstate(0);
      flagsvalid = 0;
      return ex;
      
      /* postfix ++ or -- */
    case e_post_plusplus:
    case e_post_minusminus:
      ex = compile_expr(e->exp, sp);
      ex = giveaddsub((e->key==e_post_plusplus) ? '+':'-', ex, 1);
      flagsvalid = 0;
      return ex;

      
    case e_arrow:                  /* C Pling operator -> */
      ex = compile_expr(e->exp, sp);
      ex->einds = ex->einds+1;
      ex->it = copyit(ex->it);
      if (ex->it->dimensions) ex->it->dimensions -= 1;
      else if (ex->it->stars1) ex->it->stars1 -= 1;
      else 
	{

	  error("non-pointer type on lhs of ->");
	
	}
      goto dotcont;
    
    case e_dot:                    /* Dot structure access */
      ex = compile_expr(e->exp, sp);
    dotcont:
      if (ex->einds <= 0) error("non pointer on lhs of . or ->");
      if (ex->it->ct->st == NULL) error("non structure on lhs of . or ->");
      else
	{ 
	  EXPRESSION *rex = NEWZ(EXPRESSION);
	  struct stag *dt = findtag(ex->it->ct->st, e->wordnode);
	  if (dt == NULL)
	    { 
	      error("%s not a member of struct/union", e->wordnode);
	      return ex;
	    }
	  rhs = manifestint(dt->tagindex);
	  rex->epathhi = ex->epathhi;
	  rex->epathlo = ex->epathlo;
	  rex->evalue = ex->evalue;
	  
	  rex-> it = NEWZ(INSTANCE);
	  rex->it->ct = ct_char;
	  rex->it->stars1 = 1; /* pretend it is pointer to char */
	  rex = new_rpolish(e_add, rex, rhs, 1);
	  rex->it = dt->it;
	  if (dt->tpartial) rex->einds = ex->einds-1;
	  else rex->einds = ex->einds;
	  flagsvalid = 0;
	  if (0) pexp(rex, "; DOTCONT");
	  return rex;
	}
    }
  return NULL;
}



EXPRESSION *compile_expr(ENODE *e, int sp)            /* generic eval routine */
{
  EXPRESSION *ex;
  flagsvalid = 0;
  
  ex = compile_expr0(e, sp);  
#ifdef TRACING
  assembly(";Eval returns !B\n", ex);
#endif
  return ex;
}




/* perform ++ or -- on operand ee. */
EXPRESSION * giveaddsub(char key, EXPRESSION *ee, int v)
{
  int delta, size;
  int stars = ee->it->stars1+ee->it->dimensions;

  ee = make_ldst_mode(ee);
  
  if (stars == 0)
    {
      delta = 1;       /* add or take one for a scalar */
      size  = ee->it->ct->ctsize;
    }
  else if (stars == 1)
    {
      delta = ee->it->ct->ctsize;
      size  = target_ptr_size;
    }
  else /* more than one star */
    {
      delta = target_ptr_size;
      size  = target_ptr_size;
    }

  if (v < 0) return   quick_add_sub_pre(key, size, ee, delta);
  else if (v > 0) return   quick_add_sub_post(key, size, ee, delta);
  quick_add_sub(key, size, ee, delta);
  return ee;
}


/*==
 * / general_call PROCEDURE CALL
 */
EXPRESSION *compile_general_call(ENODE *e, int sp)
{
  ENODE *args = e->exp1;
  ENODE *first = NULL;
  EXPRESSION *ex;
  ROUTINE *r;
  EXPRESSION * vregs[32];
  int newsp, argcount = 0;
  int vd = 0;
  int arg = 0;


  if (e->exp->key == e_id) r = routine_lookup(e->exp->wordnode);
  else return NULL;

  if (r == NULL) 
    {
      /* fatal("lost routine %s\n", e->exp->wordnode); */
    }


  while (args) /* count them */
    {
      first = args;
      args = args->exp1;
      argcount += 1;
    }


  /* This step is needed to allow space to save regs which may not be in use
   *  but could be in the vararg situation
   */
  if (argcount < target_tot) 
      newsp = sp-target_tot*target_int_size;
  else  newsp = sp-argcount*target_int_size;

  /* sp points to free entry. Last arg is at [sp].
   *  printf("There are %i args to initialise. sp is %i\n", argcount, sp);
   */
  args = e->exp1;

  if (args) 
    {
      first = args;
      args = args->exp1;
    }


  /* eval args passed on stack */
  if (argcount > target_tot)
    {
      int newidx = 2; /* 0 and 1 in regs */
      args = e->exp1->exp1->exp1;
      while(args)
	{
	  EXPRESSION *ee = compile_expr(args->exp, newsp);  /* Eval the args */
	  EXPRESSION *lhs = NEWZ(EXPRESSION);
	  /* Initialise formal pram, passing on stack. */
	  
	  lhs->epathhi = e_register;   
	  lhs->it = NEWZ(INSTANCE);
	  lhs->it->ct = ct_generic;  
	  lhs->epathlo = target_preg_name;
	  
	  lhs->evalue.i = sp + (1 - argcount + newidx) * target_int_size;
	  lhs->einds = 1;
	  
	  assign(lhs, ee); 
	  if (vd) printf("Saved arg %i with an arg\n", newidx);
	  newidx += 1;
	
	  args = args->exp1; /* chain along */
	}
    }


  /* Now do the ones in registers */
  args = e->exp1;
  arg = 0;
  while (arg < argcount && arg < target_tot)
    {
      EXPRESSION *ee = compile_expr(args->exp, newsp);  
      /* Initialise formal pram - passing in registers */
      ee = gloadto(ee);
      vregs[arg] = ee;
      if (vd) printf("Loaded reg %i with an arg\n", arg);
      arg++;
      args = args->exp1; /* chain along */
   }

  /* Compile the call address */
  ex = compile_expr(e->exp, newsp); 

  arg = 0;
  while (arg < argcount && arg < target_tot)
  {
    force(vregs[arg], arg, "call");
    arg ++;
  }


  /* This step is needed to allow space to save regs which may not be in use
but could be in the vararg situation
*/
  if (argcount < target_tot) argcount = target_tot;
    
  ex = code_callv(ex, newsp);   /* value in reg (oldrunsp), type from function def*/
  
  ex->epathhi = e_register;
  ex->unmodifiablef = 0;

  ex->epathlo = newdreg();
  ex->einds = 0;
  ex->evalue = 0;

  /* Result will actually be in D0 */
  force(ex, 0, "res");
  return ex;
}

/*
 * Evaluate an expression and it is false branch to the offered dbranch
 * location, otherwise continue.
 */
int compile_fcondition(ENODE *e, int dbranch, int sp)
{
  if (e->key == e_logand)
    {
      dbranch = compile_fcondition(e->exp, dbranch, sp);
      dbranch = compile_fcondition(e->exp1, dbranch, sp);
      return dbranch;
    }
  else if (e->key == e_logor)
    {
      int cfall = compile_tjump(e->exp, 0, sp);
      dbranch = compile_fcondition(e->exp1, dbranch, sp);
      label(cfall);
      return dbranch;
    }
  else return compile_fjump(e, dbranch, sp);
}


int arraysize(INSTANCE *ins)
{
  int r = 1;
  int i;
  for(i=0;i<ins->dimensions;i++) r *= ins->dim_idx[i];
  return r;
}


void log_force(EXPRESSION *e, int v, char *reason)
{
  forcearray[forces].e = e;
  forcearray[forces].v = v;
  forcearray[forces].reason = reason;
  forces += 1;
}


void dump_forces()
{
  int i;
  for (i=0;i<forces;i++) force(forcearray[i].e, forcearray[i].v, forcearray[i].reason);
}


/*
 * Christen a local, allocate store for formals and locals.
 * Return stack use in bytes.
 *
 * Locals work down from P whereas formals work up.
 * In a leaf routine, args (R0 and R1) are not pushed to stack.
 */
int def_loca(int sp, int key,  INSTANCE * ins, ENODE *exp, int leaff)
{
  int vd = 0;
  if (ins->wnode)
    {
      int size;
      int mode;
      CHRIST *c;
      EXPRESSION *lhs;

      if (vd) printf("Defining local %s\n", ins->wnode);

      if (leaff && sp > 0)
	{
	  if (sp <= target_int_size*target_tot)
	    {
	      EXPRESSION *p;
	      int reg = newdreg();
	      mode =  sim_local_reg;
	      c = christen(ins->wnode, mode, ins, reg, 1);
	      p = local_christ_to_expr(c);
	      

	      log_force(p, sp/target_int_size-1, "pram");
	    }
	  else
	    {
	      mode = sim_local_stack;
	      c = christen(ins->wnode, mode, ins, sp, 1);
	    }
	}
      else
	{
	  mode = sim_local_stack;
	  c = christen(ins->wnode, mode, ins, sp, 1);
	}


      lhs = local_christ_to_expr(c);
      ocode("s", o_msg2, "; local !s  !B\n", ins->wnode, lhs); 

      if (exp && ins->dimensions) error("initialised local arrays not supported\n");
      
      if (exp)  /* initialized local var ? */
	{
	  EXPRESSION *i = compile_expr(exp, sp); 
	  if (vd) pexp(i, "; INITLV");
	  assign(lhs, i);
       	}

      size = arraysize(ins) * pathsize(lhs);
      return (size + target_int_size-1) & target_int_mask;  /* Round to word align */
    }
  else error("missing ins");
  return target_int_size;
}



/*
 * Introduce and define formal prams and local vars.  
 */
int define_local_vars(PT *p, int leafformal, int formalsf, int sp) 
{
  int fsp = 2; /* First formal at P(2) */
  while (p)
    {
      if (p->key == p_formal)
	{
	  /* work up for formals */
	  fsp += def_loca(fsp, p->key, p->instance, NULL, leafformal);
	  p = p->c1;
	}
      else break;
    }

 
  while(p)
    {
      if (p->key == p_decl)
	{
	  PT *pp = p->c1;
	  while (pp)
	    {
	      /* work down for locals */
	      sp -= def_loca(sp, p->key, pp->instance, pp->e1, leafformal);
	      pp = pp->c1;
	    }
	}
      else if (p->key == p_3dots)
	{

	  /* */
	}

      /*      else printf("ignored thing in formal chain %i\n", p->key);
       */
      p = p->c1;
    }
  return sp;
}


/* 
 * mutable list reverse on c2 pointer
 */
PT *ptreverse(PT *l, PT *prev)
{
  if (l)
    {
      PT *next = l->c2;
      l->c2 = prev;
      return ptreverse(next, l);
    }
  else return prev;
}
  

void compile_switch(ENODE *e, PT *items, int sp, int leaff)
{
  int oldbreak = breakvec;

  int defaultvec;
  int explicitdef = 0;
  int cases = 0;
  EXPRESSION *ex;
  PT *p;

  int vecpoolvec = uid(0);
  int tagpoolvec = uid(0);
  breakvec = uid(0);
  defaultvec = breakvec; /* default `default' is break */

  p = items;
  /* First scan bodies to assign labels to each tag.
   * Use key field to store the labels.
   */
  while (p)
  {
    if (p->wordnode) /* default item */
    { 
      defaultvec = uid(0);
      explicitdef = 1;
    }
    
    else if (p->c1)
      {
	/* */
      }

    else if (p->e1)
      { 
	cases ++;
	p -> key = uid(0);
      }

    p = p -> c2;
   }


  /* Then compile head expression */
  ex = gloadto(compile_expr(e, sp));

  code_generate_scanner(defaultvec, cases, tagpoolvec, vecpoolvec, ex->epathlo, pathsize(ex));
 


  p = items;
  /*
   * First create tag table
   */
  label(tagpoolvec);
  while (p)
  {
    if (p->wordnode) /* default item */
    { 
      /* */
    }
    
    else if (p->c1)
      {
	/* */
      }

    else if (p->e1)
      { 
	if (pathsize(ex) == 1)
	  ocode("ci", o_code1, ".byte !i", evalmanifeste(p->e1));
	else ocode("ci", o_code1, ".word !i", evalmanifeste(p->e1));
      }
    
    p = p -> c2;
  }
  
  if (pathsize(ex) != target_ptr_size) 
    {
      ocode("ci", o_code1, ".align !i", target_ptr_size);
      items = ptreverse(items, NULL);
    }
  
  p = items;
  
  /* Second generate vector pool. In reverse order for bytes.
   */
  label(vecpoolvec);
  while (p)
    {
      if (p->wordnode) /* default item */
	{ 
	  explicitdef = 1;
	  /* */
	}
      
      else if (p->c1)
	{
	  /* */
	}
      
      else if (p->e1)
	{ 
	  ocode("vp", o_code1, ".word !L", p -> key);
	}
      p = p -> c2;
    }
  
  if (pathsize(ex) != target_ptr_size) 
    {
      /* swap back again so fall through works from case to case */
      items = ptreverse(items, NULL);
    }
  
  p = items;

  /* Now compile bodies of the switch (order is reverse still, but matters not)*/
  while (p)
  {
    if (p->wordnode) /* default item */
    { 
      label(defaultvec);
    }
    
    else if (p->c1)
      {
	compile_command(p->c1, sp, leaff);
      }
    
    else if (p->e1)
      { 
	label(p->key);
      }
    p = p -> c2;
  }

  /* Final exit code for break and non-instantiated default */
  label(breakvec);

  breakvec = oldbreak;
}





void compile_block(PT *p, int sp, int leaff)
{
  int count = 0;
  struct christ * oldgenv = genv;
  while(p)
    {
      if (p->key == p_decl)  
	{
	  sp = define_local_vars(p, leaff, 0, sp);
	  dump_forces();
	}
      else
      compile_command(p->c1, sp, leaff);
      if (litpoollist) count ++;
      if (count == 12)
	{
	  int v = ujump(0);
	  assembly("; forced litpool here\n");
	  label(v);
	  count = 0;
	}
      p = p->c2;
    }
  
  genv = oldgenv;
}


int compile_tcondition(ENODE *e, int dbranch, int sp)
{
  if (e->key == e_logand)
    {
      int cfall = compile_fjump(e->exp, 0, sp);
      dbranch = compile_tcondition(e->exp1, dbranch, sp);
      label(cfall);
      return dbranch;
    }
  else if (e->key == e_logor)
    {
      dbranch = compile_tcondition(e->exp, dbranch, sp);
      dbranch = compile_tcondition(e->exp1, dbranch, sp);
      return dbranch;
    }
  else return compile_tjump(e, dbranch, sp);
}


void compile_command(PT *p, int sp, int leaff)
{
  if (p == NULL) return;
  switch(p->key)
    { 
    default:
      error("[V] bad parse item in tree %i", p->key);
      return;
      
    case p_srctext:
      {
	CONS *m = (CONS *) (p->wordnode);
	while (m)
	  {
	    error_src_string = m->car;
	    ocode("", o_msg1, "; !s\n", m->car);
	    m = m -> cdr;
	  }
      }
      compile_command(p->c1, sp, leaff);
      return;

    case p_label:
      {
	INSTANCE *it = NEWZ(INSTANCE);
	it->wnode = p->wordnode;
	it->ct = ct_label;
	/* a code label */
	ocode("labl", o_labl1, "_!s:", p->wordnode);
	christen(p->wordnode, sim_rval, it, 0, 0);
	return;
      }
      
    case p_eval:
      {
	EXPRESSION *db;
	if (p->e1)
	{
	  /* Optimise some of these here */
	  if (p->e1->key == e_post_plusplus ||p->e1->key == e_post_minusminus)
	    { 
	      EXPRESSION *ex = compile_expr(p->e1->exp, sp);
	      ex = giveaddsub((p->e1->key==e_post_plusplus) ? '+':'-', ex, 0);
	     
	      return;
	    }
	}
	db = compile_expr(p->e1, sp);

	return;
      }

    case p_decl:
    case p_block:
      compile_block(p, sp, leaff);
      return;


      case p_return:
        if (p->e1)
	  {
	    EXPRESSION *ex = compile_expr(p->e1, sp);
	    ex = assigncoerce(ex, current_ptr->ct, ex->it->stars1+ex->it->dimensions);
	    force_loadtod0(ex);
	  }
        code_return(leaff);
        return;

     case p_do:
        { 
	  int loopvec = label(0);
          int oldbreak = breakvec;
          int oldcont = contvec;
          breakvec = 0;
          contvec = 0;
          compile_command(p->c1, sp, leaff);
          if (contvec) contvec = label(contvec);
          loopvec = compile_tcondition(p->e1, loopvec, sp);
          if (breakvec) label(breakvec);
          breakvec = oldbreak;
          contvec = oldcont;
          return;
        }

      case p_break:
        if (breakvec == -1) error("break out of place");
        breakvec = ujump(breakvec);
        return;

      case p_continue:
        if (contvec == -1) error("continue out of place");
	contvec = ujump(contvec);
        return;

     case p_while:
        { 
	  int oldbreak = breakvec;
          int oldcont = contvec;
          contvec = label(0);
          breakvec = compile_fcondition(p->e1, 0, sp);
          compile_command(p->c1, sp, leaff);
          ujump(contvec);
          label(breakvec);
          breakvec = oldbreak;
          contvec = oldcont;
          return;
        }

     case p_if:
        { 
	  int ff = compile_fcondition(p->e1, 0, sp);
          compile_command(p->c1, sp, leaff);
	  if (p->c2)
           { 
	     int elseskip = ujump(0);
             label(ff);
             compile_command(p->c2, sp, leaff);
             label(elseskip);
           }
         else
          { 
	    label(ff);
          }
         return;
       }

     case p_goto:
       code_goto(compile_expr_for_gotos(p->e1, sp));
       return;

     case p_for:
       { 
	 int oldcont = contvec;
         int oldbreak = breakvec;
	 int testvec;
	 contvec = 0;

         if (p->c1) compile_command(p->c1, sp, leaff); /* e1 - initial action */
         testvec = label(0);

         if (p->e1) breakvec = compile_fjump(p->e1, 0, sp);
         else breakvec = 0;

         if (p->c3) compile_command(p->c3, sp, leaff); /* put body before e3 update */
         
	 if (contvec) label(contvec);
	 if (p->c2) compile_command(p->c2, sp, leaff); 

         ujump(testvec);

         label(breakvec);
         contvec = oldcont;
         breakvec = oldbreak;
         return;
       }



     case p_switch:
      { 
	compile_switch(p->e1, p->c1, sp, leaff);
        return;
      }
    }
}


/*
 * map a function over all the expressions in 
 * the parse statement part of parse tree.  This will include
 * assignments and proc calls.
 */
int compile_map(int (*f)(), int dontstopf, PT *p)
{
  if (p == NULL) return 0;
  switch(p->key)
    { 
    default:
      error("[X] bad parse item in tree %i", p->key);
      return 0;
      
    case p_srctext:
      return compile_map(f, dontstopf, p->c1);

    case p_label:
      return 0;
      
      
    case p_eval:
      return f(p->e1);
     

    case p_decl:  
      {
	PT *pp = p -> c1;
	while(pp)
	  {
	    static_decl_count += 1; /* bigger for an array */
	    if (pp->e1)  /* if initialised */
	      {
		int v = f(pp->e1);
		if (dontstopf == 0 && v) return v;
	      }
	    pp = pp->c1;
	  }
	return compile_map(f, dontstopf, p->c2);
      }
    
    case p_block:
      while (p)
	{
	  int v = compile_map(f, dontstopf, p->c1);
	  if (dontstopf == 0 && v) return v;
	  p = p->c2;
	}
      return 0;



    case p_return:
      if (p->e1) return f(p->e1); else return 0;
      
    case p_do:
    case p_while:
        { 
	  int v = f(p->e1);
	  if (dontstopf == 0 && v) return v;
	  return compile_map(f, dontstopf, p->c1);
	}

    case p_goto:
    case p_break:
    case p_continue:
        return 0;

    case p_if:
        { 
	  int v = f(p->e1);
	  if (dontstopf == 0 && v) return v;
	  v = compile_map(f, dontstopf, p->c1);
	  if (dontstopf == 0 && v) return v;
	  if (p->c2) v =compile_map(f, dontstopf, p->c2);
	  return v;
	}


    case p_for:
       {
	 int v = f(p->e1);
	 if (dontstopf == 0 && v) return v;
	 v = compile_map(f, dontstopf, p->c1);
	 if (dontstopf == 0 && v) return v;
	 if (p->c2) v = compile_map(f, dontstopf, p->c2);
	 if (dontstopf == 0 && v) return v;
	 if (p->c3) v = compile_map(f, dontstopf, p->c3);
	 return v;
       }



     case p_switch:
      { 
	PT *pp = p->c1;
	while (pp)
	  {
	    if (pp->c1)
	      {
		int v = compile_map(f, dontstopf, pp->c1);
		if (dontstopf == 0 && v) return v;
	    }
	    pp = pp->c2;
	}
      return 0;
      }
    }
}


int formal_count(ROUTINE *r)
{
  int l = 0;
  PT *p = r->formals;
  {
    while (p)
      {
	if (p->key == p_3dots) l += 15; /* hack value for ... */ 
	else l += 1;
	p = p->c1;
      }
    
  }
  return l;
}


/*
 * Attempt to compile a routine.  Return 0 if ok.
 */
int compile_rtn_1(ROUTINE *r, int leaff)
{
  int formals = formal_count(r);
  int sp = -target_sof_overhead;  /* start a new stack frame */
  /* old stuff   ocode("crt", o_msg2, "; %i stack needed. leaf=!i\n", v, leaff); */

  forces = 0;
  clear_code();
  /* locals go up from P */
  define_local_vars(r->formals, leaff, 1, 0);    
  dump_forces();

  flowing = 1;

  current_ptr = r->it;
  compile_block(r->body, sp, leaff);
  dump_forces();  

  if (flowing) code_return(leaff);

  if (colour()) return -1;  /* failed to colour */

  assembly("\t .align 2 \n");
  text_mkglobext2(r->it->flagvec, r->name);  
  code_entry(leaff, formals);
  dump_code();

  flowing = 0;
  return 0;
}


void compile_routine(ROUTINE *r, int thetop)
{
  CHRIST *oldgenv = genv;

  /* int v = stack_needed(r); */

  int leaff = (r->callees) ? 0: 1;
  int rc;

  debugleader(r->name);
  
  current_routine = r->name;  /* put in global for error messages */

  rc = compile_rtn_1(r, leaff);
  if (rc == 0) return;
  
  /* now try without leaf flag optimisation */
  if (leaff) rc = compile_rtn_1(r,  0);
  if (rc) fatal("cant compile routine %s\n (too complex ?)", r->name);
  genv = oldgenv;
}

void log_callee(ENODE *ecall)
{
  ENODE *e = ecall->exp;
  ENODE *args = ecall->exp1;
  int a = 0;
  while (args)
    {
      a++;
      args = args->exp1; /* chain along to count args in call */
    }

  if (e->key == e_id)
    {
      CONS *f = findlist;
      while (f)
	{
	  if (e->wordnode == f->car) 
	    {
	      if (strcmp(e->wordnode, "printf") && f->n != a) error("warning: routine %s called with wrong number of args", e->wordnode);
	      return; /* found already */
	    }
	  f = f->cdr;
	}
      findlist = cons_with_n(e->wordnode, findlist, a);
    }
  else error("call graph involves computed jumps");
}

void find_callees(ROUTINE *r)
{
  extern int find_callees1();
  findlist = NULL;
  compile_map(find_callees1, 1, r->body); 
  r->callees = findlist;
}

/*
 * The work is actually done by compile_map for us, but could
 * be improved to reuse locations in different sub blocks.
 */
int count_decls()
{
  return 0;
}

/*
 * Count up the non-formal local dynamic declarations to get initial frame size. 
 */
int stack_needed(ROUTINE *r)
{
  int l = 0;  /* dont call formal_count(r); */
  static_decl_count = 0; 
  compile_map(count_decls, 1, r->body); 
  
  /* 
   *printf("Routine %s, %i formals, %i locals\n", r->name, l, static_decl_count);
   */
  return l+static_decl_count; 
}
  

/*
 *
 */
#if 0
int not_used_build_call_graph(ROUTINE *r)
{
  int v;
  CONS *c;
  int currenttop = 0;
  if (r == NULL) return 0;
  if (r->checkedf) return 0;
  v = stack_needed(r);
  r->checkedf = 1;

  c = r->callees;

  while (c)
    {
      ROUTINE *x = routine_lookup(c->car);
      int top;
      if (x == NULL)
	{
	  printf("Routine %s called from %s not defined\n", c->car, r->name);
	  printf("  ...assuming extern with %i args starting from R0\n", c->n);
	  x = NEWZ(ROUTINE);
	  x->externflag = 1;
	  x->name = c->car;
	  x->argbase = 0;
	  x->argcount = c->n;
	  x->next = routines;
	  x->checkedf = 1;
	  routines = x;
	}
      else
	{
	  build_call_graph(x);
	}
      top = x->argbase + x->argcount; 
      if (top > currenttop) currenttop = top;

      c = c->cdr;
    }
  r->argcount = v;
  r->argbase = currenttop;
  /* need to need R13..15 for sp,lr and pc, and R11,12 to work in */
  if (currenttop > 10) error("Too many local vars and formal prams. Reduce depth\n");
  printf("Routine %s allocated registers R%i to R%i\n", r->name, r->argbase, r->argbase+r->argcount-1);
  return currenttop;
}
#endif

/*
 * Total 1 for one file.
 */
void compile1(char *fname)
{
  ROUTINE *r;
  int thetop;
  int i, s;
  extern char *scanpoi;
  extern char label_prefix[];

  lexinit("lexinit");
  litpoollist = NULL;
  genv = NULL;
  parser_clear();

  label_prefix[0] = 'Y';
  label_prefix[1] = 'Y';
  label_prefix[2] = 0;
  
  if (isalpha(fname[1])) label_prefix[1] = fname[1];
  s = 0;
  for (i=0;i<strlen(fname);i++) s+= fname[i];
  label_prefix[0] = (s % 26) + 'a';

  routines = NULL;

  ocode("", o_msg1, "; cbg c compiler '!s'\n", fname);
  /*
    assembly("divzerotrap .extern\ndivzero b divzerotrap\n\n");
    */
  while (*scanpoi)
  {
    errorflag = 0;
    startlev1();
  }


  r = routines;

  if (verbosef) printf("Source files parsed\n");
  linenumber = -1;

  while(r)  /* find callees */
    {
      find_callees(r);
      r = r->next;
    }


  /* thetop = build_call_graph(routine_lookup("main")); */

  r = routines;
  while(r)  /* now code generate */
    {
      if (0) ocode("compile", o_msg1, "; Start compile routine %s\n", r->name);
      
      if (r->body) 
	{
	  compile_routine(r, thetop);
	}
      litpooldump();
      r = r->next;
    }
}


/* end of compile.c */
