/*
 * 
 * CBG Xilinx ROM generator from intel hex.  Also generates verilog model 
 * (C) 1999 Tenison Technology. DJG.
 *
 * Input formats   Intel Hex
 * Output formats  XNF, Verilog, EDIF to be added.

 */

#include <stdio.h>

#define uchar unsigned char


const sizer = 1234567;
FILE *fd;

int iread(len)
{
  int r = 0;
  int i;
  for (i=0; i < len; i++)
  {
    unsigned char c = getc(fd);
    c = (c <= '9') ? c-'0': c-('0'+7);
    r = (r<<4) + c;
  }
  return r;
}


static char *pp, *base, *limit;
FILE * fdout;

int yield(uchar c)
{
  if (c == 0xED) 
    {
      printf("ED in code\n");
      exit(1);
    }
  putc(c, fdout);
}


void dump(char *buffer)
{
  int b = 0;
  int addr = 0xF800;
  while (addr <= 0xFFFF)
    {
      printf("%c\n", 13);
      {
	uchar sum;
	int i;
	int objbytes = 16;
	printf(":%02X%04X00", objbytes, addr);
	sum = objbytes + (addr & 255) + ((addr >> 8) & 255);
	for (i=0; i<objbytes; i++) 
	  {
	    uchar d = buffer[b++];
	    addr ++;
	    printf("%02X", d);
	    sum = d + sum;
	  }
	printf("%02X%c\n", (256 - sum) & 255, 13);
      }
    }
}


int main (argc, argv) char ** argv;
{
  char * buffer = (char *) malloc(sizer);
  int * array;
  int width, length;

  char *vfn = NULL;
  char *xfn = NULL;
  while (argc > 3)
    {
      if (!strcmp(argv[1], "-x"))
	{
	  xfn = argv[2];
	  argc -=2; argv += 2;
	  continue;
	}
      if (!strcmp(argv[1], "-v"))
	{
	  vfn = argv[2];
	  argc -=2; argv += 2;
	  continue;
	}
      break;
    }


  pp = buffer;
  base = buffer;
  limit = buffer + sizer;

  fdout = fopen("downout", "w");
  run(argv[1], yield);

  /*  putc(0xED, fdout);
   */
fclose(fdout);
  return 0;

}

int run(fn, f) char *fn;
void (*f)();
{
  int line = 1;
  int addr = -1;
  int bytes = 0;  
  fd = fopen(fn, "r");
  if (fd == 0) 
    {
      printf("%s ", fn);
      perror("cant open input file");
      exit(1);
    }
  while (feof(fd)==0)
  {
    uchar c = getc(fd);
    int llen, laddr, ltype;
    uchar lsum;
    int wq;

    if (c == '\n') line++;
    if (c != ':') continue;
    llen = iread(2);
    laddr = iread(4);
    ltype = iread(2);
/*
    printf("Type %x  addr %x len %x \n", ltype, laddr, llen);
*/
    if (ltype != 0) 
    { 
      printf("Type %i encountered in line %i\n", ltype, line);
      continue;
    }
    if (addr == -1) addr = laddr;
    else if (laddr != addr)
    {
      printf("Disjoint addresses %x and %x in line %i\n",
                   laddr, addr, line);
      addr = laddr;
    }
    lsum = llen + laddr + ltype + (laddr >> 8);
    for (wq=0; wq<llen; wq++)
    {
      uchar data = iread(2);
      lsum = lsum + data;
      f(data);
      bytes += 1;
    }
    lsum = lsum + iread(2);

    if (lsum != 0) 
          fprintf(stderr, "Checksum error in line %i, residue %i\n", line, lsum);    

    addr = addr + llen;
  }
  return 0;
}


/* eof */

