/**
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *	Copyright 2011 Andrew Rice (acr31@cam.ac.uk)
 */
package uk.ac.cam.acr31.geomessagingserver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Servlet implementation class QueryMessagesServlet
 */
public class QueryMessagesServlet extends DatabaseServlet {
	private static final long serialVersionUID = 1L;

	/**
	 * @see HttpServlet#HttpServlet()
	 */
	public QueryMessagesServlet() {
		super();
		// TODO Auto-generated constructor stub
	}

	
	
	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		doGet(req,resp);
	}



	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		Float latitude = Util.parseFloat(request
				.getParameter(DatabaseServlet.REQ_LATITUDE));
		Float longitude = Util.parseFloat(request
				.getParameter(DatabaseServlet.REQ_LONGITUDE));
		float distance = Util.parseFloat(request
				.getParameter(DatabaseServlet.REQ_DISTANCE), 0.1f);
		response.setContentType("text/xml");
		try {
			Connection db = mDataSource.getConnection();
			try {
				final XMLWriter w = new XMLWriter(response.getWriter());
				w.open("messages");
				MessageCollector c = new MessageCollector(latitude, longitude,
						distance) {
					@Override
					protected void handleRow(String message, float latitude,
							float longitude, String pictureName,Date uploadTime) {
						w.empty("message", "message",message,"latitude",latitude,"longitude",longitude,"picture",pictureName);
					}
				};
				c.doQuery(db);
				w.close("messages");
				w.flush();
				
			} finally {
				db.close();
			}
		} catch (SQLException e) {
			response.getWriter().println(e);
		}
	}
}
