/**
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *	Copyright 2011 Andrew Rice (acr31@cam.ac.uk)
 */
package uk.ac.cam.acr31.geomessagingserver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Servlet implementation class ListMessagesServlet
 */
public class ListMessagesServlet extends DatabaseServlet {
	private static final long serialVersionUID = 1L;
	
	/**
	 * @see HttpServlet#HttpServlet()
	 */
	public ListMessagesServlet() {
		super();
		// TODO Auto-generated constructor stub
	}

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {

		Float latitude = Util.parseFloat(request
				.getParameter(DatabaseServlet.REQ_LATITUDE));
		Float longitude = Util.parseFloat(request
				.getParameter(DatabaseServlet.REQ_LONGITUDE));
		float distance = Util.parseFloat(
				request.getParameter(DatabaseServlet.REQ_DISTANCE), 0.1f);

		response.setContentType("text/html");
		try {
			Connection db = mDataSource.getConnection();
			try {
				final StringBuffer latLng = new StringBuffer(
						"var myLatLng = new Array();\n");
				final StringBuffer messages = new StringBuffer();

				MessageCollector c = new MessageCollector(latitude, longitude,
						distance) {
					@Override
					protected void handleRow(String message, float latitude,
							float longitude, String pictureName, Date uploadTime) {
						latLng.append(String
								.format("myLatLng.push({loc: new google.maps.LatLng(%f,%f), message: \"%s\",picture: \"%s\"});\n",
										latitude, longitude,
										message.replaceAll("\"", "\\\""),
										pictureName));
						messages.append(String
								.format("<div style=\"float:left;margin:1em;width:100px\">"
										+ "%s<br /><img width=\"50\" src=\"img/%s\" /><br />%s</div>",
										uploadTime.toString(), pictureName,
										message));
					}
				};
				c.doQuery(db);

				InputStream is = getClass().getResourceAsStream(
						"template-ListMessagesServlet.html");
				ByteArrayOutputStream bos = new ByteArrayOutputStream();
				byte[] buf = new byte[512];
				int read;
				while ((read = is.read(buf)) != -1) {
					bos.write(buf, 0, read);
				}
				String result = new String(bos.toByteArray());
				result = result.replace("@LatLngArray@", latLng.toString());
				result = result.replace("@Messages@", messages.toString());
				result = result.replace("@Prefix@",mUrlPrefix);
				response.getWriter().print(result.toString());
			} finally {
				db.close();
			}
		} catch (SQLException e) {
			response.getWriter().println(e);
		}
	}
}
