/**
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *	Copyright 2009 Andrew Rice (acr31@cam.ac.uk) and Vytautas Vaitukaitis (vv236@cam.ac.uk)
 */

package uk.ac.cam.acr31.android.geomessaging.servertools;

/**
 * A geotagged message returned from the server. This class wraps the two
 * aspects of a message: the message text itself and the URL from which to
 * request the associated image.
 * 
 * @author acr31
 * 
 */
public class Message {
	
	/**
	 * The URL of the image for this message
	 */
	private String pictureUri;
	
	/**
	 * The message text itself
	 */
	private String message;

	/**
	 * Returns the absolute URL for the image associated with this message
	 */
	public String getPictureUri() {
		return pictureUri;
	}

	/**
	 * Store the absolute image URL for this message 
	 */
	public void setPictureUri(String pictureUri) {
		this.pictureUri = pictureUri;
	}

	/**
	 * Return the message text
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * Store the text of this message
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * Two messages have the same hashcode if their picture URL and message text are the same
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((message == null) ? 0 : message.hashCode());
		result = prime * result
				+ ((pictureUri == null) ? 0 : pictureUri.hashCode());
		return result;
	}

	/**
	 * Two messages are equal if their picture URL and message text are equal
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Message other = (Message) obj;
		if (message == null) {
			if (other.message != null)
				return false;
		} else if (!message.equals(other.message))
			return false;
		if (pictureUri == null) {
			if (other.pictureUri != null)
				return false;
		} else if (!pictureUri.equals(other.pictureUri))
			return false;
		return true;
	}

}
