/**
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *	Copyright 2009 Andrew Rice (acr31@cam.ac.uk) and Vytautas Vaitukaitis (vv236@cam.ac.uk)
 */

package uk.ac.cam.acr31.android.geomessaging;

import java.net.URL;

import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import android.widget.ImageView;
import android.widget.TextView;

public class ShowMessageActivity extends android.app.Activity
{
	protected final static String INTENT_MESSAGE = "message";
	protected final static String INTENT_PICTURE_URI = "picture_uri";
	
	
	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		setContentView(R.layout.showmessagewindow);
		
		// get the intent that the Activity was called by
		Intent intent = getIntent();
		
		String message = intent.getStringExtra(INTENT_MESSAGE);
		String pictureUri = intent.getStringExtra(INTENT_PICTURE_URI);
		
		// change the picture if picture Uri is set
		if (pictureUri != null)
		{
			ImageView imageView = (ImageView) findViewById(R.id.pictureView);
			
			try
			{
				URL pictureURL = new URL(pictureUri);			
				imageView.setImageDrawable(Drawable.createFromStream(pictureURL.openStream(), null));
			}
			catch (Exception e)
			{
				Log.e("ShowMessageActivity", "Unable to show the image...");
			}
		}
		
		TextView messageText = (TextView) findViewById(R.id.messageText);
		messageText.setText(message);		
		
		super.onCreate(savedInstanceState);
	}
	
	
}
