/**
 * Copyright 2010 Andrew Rice
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package uk.ac.cam.acr31.oggdecoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;

final class StreamRecognisingPacketReceiver implements
		OggPacketReceiver {
	private final OggLogicalStream newStream;
	private ByteArrayOutputStream packetData = new ByteArrayOutputStream();
	private long granulePosition;
	private List<OggPacketReceiverFactory> factories;

	StreamRecognisingPacketReceiver(OggLogicalStream newStream, List<OggPacketReceiverFactory> factories) {
		this.newStream = newStream;
		this.factories = factories;
	}

	@Override
	public void packetData(long granulePosition, OggStream stream, int length,boolean isStart, boolean isEnd)
			throws EndOfStreamException, InvalidStreamException {
		if (isStart) 
			this.granulePosition = granulePosition;
		byte[] b = new byte[length];
		stream.read(b, 0, length);
		try {
			packetData.write(b);
		} catch (IOException e) {
			throw new ImpossibleExceptionError(e);
		}
		if (isEnd) {
			processPacket();
		}
	}

	@Override
	public boolean needsData() {
		return true;
	}

	private void processPacket() {
		byte[] data = packetData.toByteArray();
		for (OggPacketReceiverFactory fact : factories) {
			if (fact.testFirstPacket(data)) {
				OggPacketReceiver p = fact.getInstance();
				try {
					p.packetData(granulePosition,new ByteArrayOggStream(data),
							data.length,true,true);
				} catch (EndOfStreamException e) {
					throw new ImpossibleExceptionError(e);
				} catch (InvalidStreamException e) {
					throw new ImpossibleExceptionError(e);
				}
				newStream.setPacketReceiver(p);
				return;
			}
		}
		newStream.setPacketReceiver(new DiscardingPacketReceiver());
	}

	@Override
	public void close() {
	}
}