/**
 * Copyright 2010 Andrew Rice
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package uk.ac.cam.acr31.oggdecoder;

public abstract class OggStream {

	public abstract void read(byte[] buf, int off, int len)
			throws EndOfStreamException, InvalidStreamException;

//	public abstract void setPosition(long newPosition)
//			throws InvalidStreamException, EndOfStreamException;
//
//	public abstract long getPosition() throws InvalidStreamException;

	private byte[] buf = new byte[8];

	public int read8() throws EndOfStreamException, InvalidStreamException {
		read(buf, 0, 1);
		return buf[0] & 0xFF;
	}

	public int read16() throws EndOfStreamException, InvalidStreamException {
		read(buf, 0, 2);
		return (buf[0] & 0xFF) | ((buf[1] & 0xFF) << 8);
	}

	public int read32() throws EndOfStreamException, InvalidStreamException {
		read(buf, 0, 4);
		return (buf[0] & 0xFF) | ((buf[1] & 0xFF) << 8)
				| ((buf[2] & 0xFF) << 16) | ((buf[3] & 0xFF) << 24);
	}

	public long read64() throws EndOfStreamException, InvalidStreamException {
		read(buf, 0, 8);
		return (buf[0] & 0xFF) | ((buf[1] & 0xFF) << 8)
				| ((buf[2] & 0xFF) << 16) | ((buf[3] & 0xFF) << 24)
				| ((buf[4] & 0xFF) << 32) | ((buf[5] & 0xFF) << 40)
				| ((buf[6] & 0xFF) << 48) | ((buf[7] & 0xFF) << 56);
	}

	/**
	 * advance the stream by length bytes discarding the information
	 * @param length
	 */
	public void advance(int length) throws EndOfStreamException, InvalidStreamException {
		byte[] data = new byte[length];
		read(data,0,length);
	}

	public abstract void close();

}