/*
 * Chartparser.java
 *
 * Created on November 8, 2004, 2:14 PM
 */

package Parser;

import java.util.*;
import Common.*;

/**
 *
 * @author  pjb48
 */
public class Chartparser {
    
    String input;
    Lexicon lexicon;
    Chart chart;
    Grammar grammar;
    
    LinkedList paths = new LinkedList();
    
    /** Creates a new instance of Chartparser */
    public Chartparser(Chart myChart, String inputSentence, Lexicon myLexicon,
                        Grammar myGrammar) {

        chart = myChart;
        grammar = myGrammar;
        lexicon = myLexicon;
        input = inputSentence;
    }
            
    public String initChart(){
        
        /* Look up words in sentence and add to the chart */ 
        
         
        StringTokenizer sentence = new StringTokenizer(input); 
        while (sentence.hasMoreTokens()) {
            String validEntry = lexicon.lookup(chart, sentence.nextToken());
            if(!(validEntry.equals("0"))){
               return validEntry;
           }
        }
        return("0"); 
    }
        
    public void buildChart(){
        
        boolean haveAddedEdge = false;
        
        for(int i = 0; i<chart.edgeLimit && i<chart.size(); i++){
            Edge currentEdge = (Edge) chart.elementAt(i);
            Iterator step = grammar.iterator();
            while(step.hasNext()){
                Rule currentRule = (Rule) step.next();
                LinkedList accumulator = new LinkedList();
                haveAddedEdge = haveAddedEdge | validateRule(currentEdge, currentRule.mother, currentRule.daughterList, accumulator);
            }
        }
      /**  if(haveAddedEdge && !chart.spanningEdge()){ **/
        if(haveAddedEdge){
            this.buildChart();
        }
    }
    
    
   private boolean validateRule(Edge myEdge, String mother, Vector daughters,
                                     LinkedList accumulator){  
    
     boolean haveAddedEdge = false;
                                         
     Vector copyDaughters = (Vector) daughters.clone();
     LinkedList copyAccumulator = (LinkedList) accumulator.clone();
     if(copyDaughters.size() >= 1){                                    
        String currentCat = (String) copyDaughters.firstElement();
        if(validate(myEdge, currentCat)){
            copyAccumulator.add(myEdge);
            copyDaughters.remove(0);
            if(copyDaughters.size()!=0){
                String nextCat = (String) copyDaughters.firstElement();
                LinkedList edges = chart.findEdges(myEdge.to, nextCat);
                Iterator step = edges.iterator();
                while(step.hasNext()){
                    Edge nextEdge = (Edge) step.next();
                    haveAddedEdge = haveAddedEdge | validateRule(nextEdge, mother, copyDaughters, copyAccumulator);
                }
           }
        }
    }
    if(copyDaughters.size()==0){
        Edge firstEdge = (Edge) copyAccumulator.getFirst();
        Edge lastEdge = (Edge) copyAccumulator.getLast();
        LinkedList newList = new LinkedList();
        newList.add(copyAccumulator);
        Edge newEdge = new Edge(chart.size(),firstEdge.from, 
                                        lastEdge.to, mother, newList);
        if(chart.packing){
            haveAddedEdge = chart.packingAdd(newEdge);
        }
        else{
            haveAddedEdge = chart.normalAdd(newEdge);
        }
    }
     
     return haveAddedEdge;
   }
    
    private boolean validate(Edge myEdge, String category){
        return(myEdge.motherCat.equals(category));
    }
}
        
        
        

    
