/*
 * FileDialogue.java
 *
 * Created on November 15, 2004, 11:17 AM
 */

package Gui;

import Common.*;

/**
 *
 * @author  pjb48
 */
public class FileDialogue extends javax.swing.JDialog {
    
    Lexicon lexicon;
    Grammar grammar;
    boolean rw; /** true for read, false for write **/
    
    /** Creates new form FileDialogue for reading/writing lexicons */
    public FileDialogue(java.awt.Frame parent, boolean modal, Lexicon lex, boolean readWrite) {
        super(parent, modal);
        initComponents();
        lexicon = lex;
        rw = readWrite;
    }
    
    /** Creates new form FileDialogue for reading/writing grammars */
    public FileDialogue(java.awt.Frame parent, boolean modal, Grammar gram, boolean readWrite) {
        super(parent, modal);
        initComponents();
        grammar = gram;
        rw = readWrite;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jFileChooser1 = new javax.swing.JFileChooser();

        getContentPane().setLayout(new java.awt.FlowLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setLocationRelativeTo(null);
        jFileChooser1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jFileChooser1ActionPerformed(evt);
            }
        });

        getContentPane().add(jFileChooser1);

        pack();
    }//GEN-END:initComponents

    private void jFileChooser1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jFileChooser1ActionPerformed
        String file = jFileChooser1.getSelectedFile().toString();
        if(lexicon!=null){
            if(rw){
                lexicon.readFile(file);
            }
            else{
                lexicon.writeFile(file);
            }
        }
        else if(grammar!=null){
            if(rw){
                grammar.readFile(file);
            }
            else{
                grammar.writeFile(file);
            }
        }
        else{
            System.out.println("No Lexicon or Grammar");
        }
        this.dispose();
    }//GEN-LAST:event_jFileChooser1ActionPerformed
    
    /**
     * @param args the command line arguments
     */
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JFileChooser jFileChooser1;
    // End of variables declaration//GEN-END:variables
    
}
