/*
 * Rule.java
 *
 * Created on November 8, 2004, 10:48 AM
 */

package Common;

import java.util.*;

/**
 * Stores and edits a grammar rule
 *
 * @author  pjb48
 */
public class Rule implements Comparable{
    
    public String mother;
    public Vector daughterList;
    
    /** Creates a new instance of Rule */
    public Rule(String moth, Vector daughter) {
        mother = moth;
        daughterList = daughter;
    }
   
    public void printRule(){
        System.out.print(mother);
        System.out.print(" " + daughterList.toString() + "\n");
    }           
    
    public String toString(){
        StringBuffer output = new StringBuffer(mother);
        output.append(" ->");
        Iterator step = daughterList.iterator();
        while(step.hasNext()){
            String s = (String) step.next();
            output.append(" "+s);
        }
        return output.toString();
    }
            
    public int compareTo(Object obj) {
        
        Rule anotherRule = (Rule) obj;
        int value = this.mother.compareTo(anotherRule.mother);
        if(value!=0){
            return(value);
        }
        else{
           return(compareLists(this.daughterList,anotherRule.daughterList)); 
        }
    }
    
    public int compareLists(Vector a, Vector b){
        for(int i=0; i<a.size() && i<b.size(); i++){
            String aString = (String) a.elementAt(i);
            String bString = (String) b.elementAt(i);
            int value = aString.compareTo(bString);
            if(value!=0){
                return(value);
            }
        }
        if(a.size()>b.size()){
            return -1;
        }
        else{
            return 1;
        }
    }
    
}
