/*
 * Edge.java
 *
 * Created on November 8, 2004, 2:18 PM
 */

package Common;

import java.util.*;

/**
 *
 * @author  pjb48
 */
public class Edge implements Comparable{
    
    public int id;
    public int from;
    public int to;
    public String motherCat;
    
    /** daughters list contains lists of daughters - 
     *  implemented as a list of lists to facilitate packing.
     *  When packing not being used daughters list will 
     *  contain a single pair only
     **/
     
    public LinkedList daughtersList;
    
    /** Creates a new instance of Edge */
    public Edge(int edgeId, int edgeFrom, int edgeTo, 
                String edgeMotherCat, LinkedList edgeDaughters){
        id = edgeId;
        from = edgeFrom;
        to = edgeTo;
        motherCat = edgeMotherCat;
        daughtersList = edgeDaughters;
    }
    
    
    public void printEdge(){
        System.out.print("Edge id = " + this.id +
                         ": " + this.from + "-" + this.to +
                         " Mother Category " + motherCat +
                         " Daughters: ");
        if(daughtersList != null){
        
            System.out.print(daughtersList.toString() + "\n");
        }
        else{
           System.out.print(" - " + "\n");
        }
    }
    
    public String toString(){
        String returnString = "id " + this.id;
        return(returnString);
    }
    
    public String fullToString(){
        StringBuffer output = new StringBuffer();
        output.append("Edge id = " + this.id +
                         ": " + this.from + "-" + this.to +
                         " Mother Category " + motherCat +
                         " Daughters: ");
        if(daughtersList != null){
        
            output.append(daughtersList.toString() + "\n");
        }
        else{
            output.append(" - " + "\n");
        }
        return output.toString();
    }
    
    public int compareTo(Object obj) {
        Edge anotherEdge = (Edge) obj; 
        if(this.id >= anotherEdge.id){
            return 1;
        }
        else{
            if (this.id == anotherEdge.id){
                return 0;
            }
            else{
                return -1;
            }
        }
    }
    
    public boolean equals(Edge edge){
        if(this.from==edge.from &&
            this.to==edge.to &&
            this.motherCat.equals(edge.motherCat)){
                /** there will only ever be one list in the daughtersList when
                 *we aren't using packing **/
                LinkedList lista = (LinkedList) this.daughtersList.getFirst();
                LinkedList listb = (LinkedList) edge.daughtersList.getFirst();
                if(!(lista.size()==listb.size())){
                        return false;
                }
                else if(lista.size()>0){
                    Iterator step1 = lista.iterator();
                    Iterator step2 = listb.iterator();
                    while(step1.hasNext()){
                        Edge edge1 = (Edge) step1.next();
                        Edge edge2 = (Edge) step2.next();
                        if(((Edge)edge1).id != ((Edge)edge2).id){
                            return false;
                        }
                    }
                    /** all daughters are the same **/
                    return true;
                }
        }
        return false;
    }
    
}
