% Ex 7: Photoreceptor TMO
% This is a part of the tone-mapping workshop 
% (c) 2012 Rafal Mantiuk

%img = hdrread( 'slate_mines.hdr' );
img = hdrread( 'memorial.hdr' );

%%

L = img/100;

m = 0.60105;

sigma = geomean( L(:) ).^m;

V = L ./ (L+sigma);

clf
subplot( 1, 3, [1:2] );
imshow( cat( 2, lin2srgb( L ), V ) );

subplot( 1, 3, 3 );

l = logspace( -4, 0 );
sigma = mean( l( [1 end] ) )^m;
V = l ./ (l+sigma);

plot( log10( l ), log10(gog_fw_display_model(V)) );
xlabel( 'log Input luminance' );
ylabel( 'log Displayed luminance' );
ylim( [-0.2 2] );





