(*        x86-TSO Semantics: HOL sources                                *)
(*                                                                      *)
(* Scott Owens, Susmit Sarkar, Peter Sewell                             *)
(*                                                                      *)
(*  Computer Laboratory, University of Cambridge                        *)
(*                                                                      *)
(*  Copyright 2007-2009                                                 *)
(*                                                                      *)
(* Redistribution and use in source and binary forms, with or without   *)
(* modification, are permitted provided that the following conditions   *)
(* are met:                                                             *)
(*                                                                      *)
(* 1. Redistributions of source code must retain the above copyright    *)
(*    notice, this list of conditions and the following disclaimer.     *)
(* 2. Redistributions in binary form must reproduce the above copyright *)
(*    notice, this list of conditions and the following disclaimer in   *)
(*    the documentation and/or other materials provided with the        *)
(*    distribution.                                                     *)
(* 3. The names of the authors may not be used to endorse or promote    *)
(*    products derived from this software without specific prior        *)
(*    written permission.                                               *)
(*                                                                      *)
(* THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS   *)
(* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED    *)
(* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE   *)
(* ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY      *)
(* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL   *)
(* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE    *)
(* GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS        *)
(* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,         *)
(* WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING            *)
(* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS   *)
(* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.         *)

(* 
app load ["utilLib", "linear_valid_executionTheory", "lts_memory_modelTheory", 
          "pathTheory"];
use "lts_traceScript.sml";
*)

open HolKernel boolLib Parse bossLib wordsTheory pred_setTheory pathTheory;
open optionTheory arithmeticTheory listTheory prim_recTheory llistTheory;
open combinTheory;
open utilLib utilTheory set_relationTheory;
open axiomatic_memory_modelTheory lts_memory_modelTheory 
open basic_lemmasTheory linear_valid_executionTheory;

open HolDoc;
val _ = new_theory "lts_trace";

val COND_EXPAND_EQ_GSYM = Q.prove (
`!x y t1 t2. (if x = y then t1 else t2) <=> (y <> x \/ t1) /\ ((y = x) \/ t2)`,
METIS_TAC [COND_EXPAND]);

val nth_label_lem01 = Q.prove (
`!i p1 l p2. nth_label i (pconcat (take i p1) l p2) = l`,
Induct THEN
RWTAC [pconcat_thm]);

val nth_label_lem03 = Q.prove (
`!j i p1 l p2. 
  i < j 
  ==> 
  (nth_label i (pconcat (take j p1) l p2) = nth_label i (take j p1))`,
Induct THEN
RWTAC [pconcat_thm] THEN
Cases_on `i` THEN 
FSTAC []);

val nth_label_lem04 = Q.prove (
`!i p1 l p2. 
  SUC i IN PL p1
  ==> 
  (nth_label i (pconcat p1 l p2) = nth_label i p1)`,
Induct THEN
RWTAC [] THEN
STRIP_ASSUME_TAC (Q.SPEC `p1` path_cases) THEN
RWTAC [pconcat_thm] THEN
FSTAC [PL_thm]);

val nth_label_lem05 = Q.prove (
`!i c l j p l' p'.
  i <= j 
  ==>
  (nth_label i (pcons c l (pconcat (take j p) l' p')) =
   nth_label i (pcons c l (take j p)))`,
RWTAC [] THEN
Cases_on `i` THEN 
FSTAC [] THEN
`n < j` by DECIDE_TAC THEN
METIS_TAC [nth_label_lem03]);

val nth_label_lem06 = Q.prove (
`!i j path.
  i < j ==> (nth_label i (take j path) = nth_label i path)`,
Induct_on `j` THEN
RWTAC [] THEN
Cases_on `i` THEN
FSTAC []);


val el_lem01 = Q.prove (
`!i p1 l p2. el i (tail (pconcat (take i p1) l p2)) = first p2`,
Induct THEN
RWTAC [pconcat_thm]);

val el_lem02 = Q.prove (
`!i p. el i (take i p) = el i p`,
Induct THEN
RWTAC []);

val el_lem03 = Q.prove (
`!i path j l s. i <= j ==> (el i (pconcat (take j path) l s) = el i (take j path))`,
Induct_on `j` THEN
RWTAC [pconcat_thm] THEN
Cases_on `i` THEN
FSTAC []);

val el_lem04 = Q.prove (
`!i j path. i <= j ==> (el i (take j path) = el i path)`,
Induct_on `j` THEN
RWTAC [] THEN
Cases_on `i` THEN
FSTAC []);

val first_pconcat = Q.prove (
`!p1 l p2. first (pconcat p1 l p2) = first p1`,
RWTAC [] THEN
STRIP_ASSUME_TAC (Q.SPEC `p1` path_cases) THEN
FSTAC [pconcat_thm]);

val PL_lem01 = Q.prove (
`!i path.
  (SUC i IN PL path ==> i IN PL (tail path)) /\
  (!s l. i IN PL path ==> SUC i IN PL (pcons s l path)) /\
  (!j. j < i /\ i IN PL path ==> j IN PL (take j path)) /\
  (i IN PL path ==> i IN PL (take i path))`,
RWTAC [] THENL
[STRIP_ASSUME_TAC (Q.SPEC `path` path_cases) THEN
     FSTAC [],
 `j IN PL path` by METIS_TAC [PL_downward_closed] THEN
     RWTAC []]);

val PL_pconcat = Q.prove (
`!i path l path2. i IN PL path ==> SUC i IN PL (pconcat path l path2)`,
Induct THEN
RWTAC [] THEN
STRIP_ASSUME_TAC (Q.SPEC `path` path_cases) THEN
RWTAC [pconcat_thm] THEN
FSTAC [PL_thm]);

val LNTH_PL_thm = Q.prove (
`!i path. SUC i IN PL path = (?l. LNTH i (labels path) = SOME l)`,
Induct THEN
RWTAC [] THEN
STRIP_ASSUME_TAC (Q.SPEC `path` path_cases) THEN
RWTAC []);

val LNTH_nth_label_thm = Q.prove (
`!i path l. i + 1 IN PL path /\ (nth_label i path = l) = (LNTH i (labels path) = SOME l)`, 
Induct THEN 
RWTAC [] THEN
STRIP_ASSUME_TAC (Q.SPEC `path` path_cases) THEN
RWTAC [] THEN
EQ_TAC THEN
RWTAC [] THENL
[`x = SUC i` by DECIDE_TAC THEN
     FSTAC [] THEN
     METIS_TAC [ADD1],
 Q.EXISTS_TAC `SUC i` THEN
     RWTAC [] THEN1
     DECIDE_TAC THEN
     METIS_TAC [LNTH_PL_thm],
 METIS_TAC []]);

val take_lem01 = Q.prove (
`!n p. SUC n IN PL p ==> (take (SUC n) p = pconcat (take n p) (nth_label n p) (stopped_at (el (SUC n) p)))`,
Induct THEN
RWTAC [pconcat_thm] THEN
FSTAC [] THEN
METIS_TAC [PL_lem01]);

val no_dup_writes_def = Define `
  no_dup_writes path =
    !i j ew. 
      SUC i IN PL path /\ 
      SUC j IN PL path /\ 
      (nth_label i path = WEvt ew) /\ 
      (nth_label j path = WEvt ew)
      ==>
      (i = j)`;

val no_dup_writes_lem01 = Q.prove (
`!p1 l p2.
  no_dup_writes (pconcat p1 l p2) ==> no_dup_writes p1`,
RWTAC [no_dup_writes_def] THEN
Q.PAT_ASSUM `!i j ew. P i j ew ==> (i = j)` MATCH_MP_TAC THEN
Q.EXISTS_TAC `ew` THEN
RWTAC [] THENL
[METIS_TAC [PL_pconcat, PL_downward_closed, LESS_SUC_REFL],
 METIS_TAC [PL_pconcat, PL_downward_closed, LESS_SUC_REFL],
 METIS_TAC [nth_label_lem04],
 METIS_TAC [nth_label_lem04]]);

val no_dup_writes_lem02 = Q.prove (
`!i j p1 p2 ew.
  j IN PL p1 /\
  (nth_label i p1 = WEvt ew) /\
  i < j
  ==>
  ~no_dup_writes (pconcat (take j p1) (WEvt ew) e2)`,
RWTAC [no_dup_writes_def] THEN
MAP_EVERY Q.EXISTS_TAC [`i`, `j`, `ew`] THEN
RWTAC [nth_label_lem01, nth_label_lem03, nth_label_lem06] THENL
[METIS_TAC [PL_pconcat, PL_downward_closed, PL_lem01],
 METIS_TAC [PL_pconcat, PL_lem01],
 DECIDE_TAC]);

val no_dup_writes_lem03 = Q.prove (
`!p j. j IN PL p /\ no_dup_writes p ==> no_dup_writes (take j p)`,
RWTAC [no_dup_writes_def] THEN
Q.PAT_ASSUM `!i j ew. P i j ew ==> (i = j)` MATCH_MP_TAC THEN
Q.EXISTS_TAC `ew` THEN
METIS_TAC [PL_downward_closed, LESS_OR_EQ, nth_label_lem06, OR_LESS]);

val ind_lem01 = Q.prove (
`!i path.
  i IN PL path ==>
  (pcons (first path) (first_label path) (take i (tail path)) =
   pconcat (take i path) (first_label (drop i path)) (stopped_at (first (tail (drop i path)))))`,
Induct THEN
RWTAC [pconcat_thm] THEN
`i IN PL (tail path)` 
        by (STRIP_ASSUME_TAC (Q.SPEC `path` path_cases) THEN
            FSTAC [PL_stopped_at]) THEN
RES_TAC THEN
RWTAC []);

val ind_lem02 = Q.prove (
`!i path. SUC i IN PL path ==> i IN PL (tail path)`,
RWTAC [] THEN
STRIP_ASSUME_TAC (Q.SPEC `path` path_cases) THEN
FSTAC []);

val okpath_ind1 = Q.prove (
`(!start. 
   evt_is_init start ==> P 0 (stopped_at start)) /\
 (!path l s i.
   okpath evt_machine_trans path /\ 
   evt_is_init (first path) /\
   evt_machine_trans (el i path) l s /\ 
   P i (take i path) /\ 
   i IN PL path
   ==>
   P (SUC i) (pconcat (take i path) l (stopped_at s)))
 ==>
 (!path i. evt_is_init (first path) /\ okpath evt_machine_trans path /\ 
           i IN PL path ==> P i (take i path))`,
NTAC 2 STRIP_TAC THEN
Induct_on `i` THEN
FSTAC [] THEN
RWTAC [] THEN
`i IN PL path` 
          by METIS_TAC [PL_downward_closed, LESS_SUC_REFL] THEN 
FSTAC [ind_lem01] THEN
`okpath evt_machine_trans (drop i path)` by METIS_TAC [okpath_drop] THEN
POP_ASSUM (STRIP_ASSUME_TAC o SIMP_RULE (std_ss) [Once okpath_cases]) THENL
[`PL (drop i path) = {n - i | n IN PL path}` 
               by (IMP_RES_TAC PL_drop THEN
                   FSTAC [IMAGE_DEF]) THEN
          `SUC 0 IN {n - i | n IN PL path}` 
                    by (RWTAC [] THEN
                        Q.EXISTS_TAC `SUC i` THEN
                        RWTAC [] THEN
                        DECIDE_TAC) THEN
          `SUC 0 IN {0}` by METIS_TAC [PL_stopped_at] THEN
          FSTAC [],
 `P (SUC i) (pconcat (take i path) (nth_label i path) (stopped_at (first p)))`
              by METIS_TAC [first_drop, first_thm, ADD, nth_label_drop, 
                            nth_label_def, first_label_def] THEN
     RWTAC []]);

val okpath_ind2 = Q.prove (
`(!start l s. 
   evt_machine_trans start l s /\ evt_is_init start ==> P 0 (pcons start l (stopped_at s))) /\
 (!path l s i.
   okpath evt_machine_trans path /\ 
   evt_is_init (first path) /\
   evt_machine_trans (el (SUC i) path) l s /\ 
   P i (take (SUC i) path) /\ 
   SUC i IN PL path
   ==>
   P (SUC i) (pconcat (take (SUC i) path) l (stopped_at s)))
 ==>
 (!path i. evt_is_init (first path) /\ okpath evt_machine_trans path /\ 
           (SUC i) IN PL path ==> P i (take (SUC i) path))`,
NTAC 2 STRIP_TAC THEN
Induct_on `i` THEN
FSTAC [] THEN
RWTAC [] THENL
[RWTAC [] THEN
     FSTAC [Once okpath_cases] THEN
     RWTAC [] THEN
     FSTAC [PL_stopped_at],
 `SUC i IN PL path /\ i IN PL path /\ i IN PL (tail path)` 
          by METIS_TAC [PL_downward_closed, LESS_SUC_REFL, ind_lem02] THEN 
     `okpath evt_machine_trans (drop (SUC i) path)` by METIS_TAC [okpath_drop] THEN
     POP_ASSUM (STRIP_ASSUME_TAC o SIMP_RULE (std_ss) [Once okpath_cases]) THENL
     [`PL (drop (SUC i) path) = {n - (SUC i) | n IN PL path}` 
               by (IMP_RES_TAC PL_drop THEN
                   FSTAC [IMAGE_DEF]) THEN
          `SUC 0 IN {n - (SUC i) | n IN PL path}` 
                    by (RWTAC [] THEN
                        Q.EXISTS_TAC `SUC (SUC i)` THEN
                        RWTAC [] THEN
                        DECIDE_TAC) THEN
          `SUC 0 IN {0}` by METIS_TAC [PL_stopped_at] THEN
          FSTAC [],
      FSTAC [] THEN
          `P (SUC i) (pconcat (pcons (first path) (first_label path) (take i (tail path))) 
                              r
                              (stopped_at (first p)))`
                             by METIS_TAC [first_drop, first_thm] THEN
          FSTAC [pconcat_thm] THEN
          METIS_TAC [ind_lem01, first_label_def, first_def, tail_def]]]);

val okpath_trans = Q.prove (
`!path i.
  okpath evt_machine_trans path /\
  SUC i IN PL path
  ==>
  evt_machine_trans (el i path) (nth_label i path) (el (SUC i) path)`,
Induct_on `i` THEN
RWTAC [] THENL
[FSTAC [Once okpath_cases] THEN
     RWTAC [] THEN
     FSTAC [],
 Q.PAT_ASSUM `okpath evt_machine_trans path`
             (STRIP_ASSUME_TAC o ONCE_REWRITE_RULE [okpath_cases]) THEN
     FSTAC []]);

val machine_state_invariant = 
SIMP_RULE (srw_ss ()) [el_lem02] (Q.prove (
`!path i.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  i IN PL path
  ==>
  (!p r v ew. 
    ((el i (take i path)).eR p r = SOME (v, SOME ew))
    ==>
    (proc ew = p) /\
    (ew.action = Access W (Location_reg p r) v)) /\
  (!a v ew.
    ((el i (take i path)).eM a = SOME (v, SOME ew))
    ==>
    (ew.action = Access W (Location_mem a) v)) /\
  (!p ew. 
    MEM ew ((el i (take i path)).eB p)
    ==>
    (proc ew = p) /\
    (?a v. ew.action = Access W (Location_mem a) v))`,
HO_MATCH_MP_TAC okpath_ind1 THEN
RWTAC [] THEN
FSTAC [Once evt_machine_trans_cases, evt_is_init_def, evt_machine_init_state_def] THEN
RWTAC [] THEN
FSTAC [el_lem01, el_lem02, APPLY_UPDATE_THM, COND_RAND, COND_EXPAND, COND_RATOR] THEN
FSTAC [] THEN
RWTAC [] THEN
METIS_TAC [action_11, location_11, MEM_APPEND]));

val machine_label_invariant = Q.prove (
`!path i.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  SUC i IN PL path ==>
  (!e. (nth_label i path = TauEvt e) ==> 
    is_mem_access e /\ ?l v. e.action = Access W l v) /\
  (!e. 
     (nth_label i path = REvt e NONE) ==> ?l v. (e.action = Access R l v)) /\
  (!e1 e2. 
     (nth_label i path = REvt e1 (SOME e2)) 
     ==> 
     ?l v. (e1.action = Access R l v) /\ (e2.action = Access W l v)) /\
  (!e. (nth_label i path = WEvt e) ==> ?l v. e.action = Access W l v) /\
  (!e. (nth_label i path = BEvt e) ==> ?f. e.action = Barrier f)`,
RWTAC [] THEN
IMP_RES_TAC okpath_trans THEN
RWTAC [is_mem_access_def] THEN
FSTAC [Once evt_machine_trans_cases] THEN
FSTAC [] THEN
RWTAC [] THEN
IMP_RES_TAC machine_state_invariant THEN
FSTAC []);

val lem01' = Q.prove (
`!path j. 
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path ==>
  !e p k.
  MEM e ((el j (take j path)).eB p) /\
  ~MEM e ((el k (take j path)).eB p) /\
  k < j
  ==>
  ?i. k <= i /\ i < j /\ (nth_label i (take j path) = WEvt e)`,
HO_MATCH_MP_TAC okpath_ind1 THEN
RWTAC [] THEN
FSTAC [Once evt_machine_trans_cases, evt_is_init_def, evt_machine_init_state_def] THEN
RWTAC [] THEN
`k <= j` by DECIDE_TAC THEN
FSTAC [el_lem01, el_lem02, el_lem03, COND_RAND, COND_EXPAND, COND_RATOR,
       APPLY_UPDATE_THM, LESS_THM] THEN
RWTAC [] THEN
METIS_TAC [nth_label_lem03, LESS_SUC, LESS_SUC_REFL, nth_label_lem01, MEM_APPEND, 
           el_lem02]);

val lem01 = Q.prove (
`!path j e p k. 
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path /\
  MEM e ((el j path).eB p) /\
  ~MEM e ((el k path).eB p) /\
  k < j
  ==>
  ?i. k <= i /\ i < j /\ (nth_label i path = WEvt e)`,
METIS_TAC [lem01', el_lem04, LESS_OR_EQ, nth_label_lem06]);

val lem16 = Q.prove (
`!path j e p. 
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path /\
  MEM e ((el j path).eB p)
  ==>
  ?i. i < j /\ (nth_label i path = WEvt e)`,
RWTAC [] THEN
`~MEM e ((el 0 path).eB p)`
         by (FSTAC [evt_is_init_def, evt_machine_init_state_def] THEN
             POP_ASSUM MP_TAC THEN
             RWTAC []) THEN
Cases_on `j` THEN
FSTAC [] THEN
METIS_TAC [LESS_0, lem01, el_def]);

val lem02 = Q.prove (
`!path j e.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  SUC j IN PL path /\
  (nth_label j path = TauEvt e)
  ==>
  ?i. i < j /\ (nth_label i path = WEvt e)`,
RWTAC [] THEN
IMP_RES_TAC okpath_trans THEN
FSTAC [Once evt_machine_trans_cases] THEN
RWTAC [] THEN
FSTAC [] THEN
`MEM e ((el j path).eB (proc e))` by RWTAC [] THEN
`j IN PL path` by METIS_TAC [PL_downward_closed, LESS_SUC_REFL] THEN
IMP_RES_TAC lem16 THEN
METIS_TAC []);

val lem03' = Q.prove (
`!path k.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  SUC k IN PL path ==>
  !i e.
  is_mem_access e /\
  i < SUC k /\
  (nth_label i (take (SUC k) path) = WEvt e)
  ==>
  (?j. i < j /\ j <= k /\ (nth_label j (take (SUC k) path) = TauEvt e)) \/
  MEM e ((el (SUC k) (take (SUC k) path)).eB (proc e))`,
HO_MATCH_MP_TAC okpath_ind2 THEN
RWTAC [DECIDE ``!x:num. x < 1 = (x = 0)``] THEN
FSTAC [Once evt_machine_trans_cases] THEN
RWTAC [] THEN1
RWTAC [APPLY_UPDATE_THM] THEN1
(FSTAC [is_mem_access_def] THEN
     FSTAC []) THEN
(`i < SUC k \/ (i = SUC k)` by DECIDE_TAC THENL
     [`i <= k` by DECIDE_TAC THEN
          FSTAC [pconcat_thm, nth_label_lem05, APPLY_UPDATE_THM, el_lem02, el_lem01] THEN
          Q.PAT_ASSUM `!i' e'. P i' e' ==> Q i' e'` (MP_TAC o Q.SPECL [`i`, `e`]) THEN
          RWTAC [] THEN
          METIS_TAC [DECIDE ``j <= k ==> j <= SUC k``, nth_label_lem05, LESS_EQ_REFL,
                     LESS_EQ_IMP_LESS_SUC, nth_label_lem01, take_def,
                     pconcat_thm, MEM_APPEND, MEM],
      FSTAC [pconcat_thm, nth_label_lem01, el_lem02, APPLY_UPDATE_THM, el_lem01] THEN
          RWTAC [] THEN
          FSTAC [nth_label_lem01, is_mem_access_def] THEN
          RWTAC [] THEN
          FSTAC []]));

val lem03 = Q.prove (
`!path k i e.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  SUC k IN PL path /\
  is_mem_access e /\
  i < SUC k /\
  (nth_label i path = WEvt e)
  ==>
  (?j. i < j /\ j <= k /\ (nth_label j path = TauEvt e)) \/
  MEM e ((el (SUC k) path).eB (proc e))`,
METIS_TAC [lem03', el_lem04, LESS_OR_EQ, nth_label_lem06, LESS_THM]);

val lem04 = Q.prove (
`!path k i ef ew p es es'.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  SUC k IN PL path /\
  i < k /\
  (((nth_label k path = BEvt ef) /\ (proc ef = proc ew) /\ (ef.action = Barrier Mfence)) \/ 
   (nth_label k path = UnlockE (proc ew) es) \/
   (nth_label k path = LockE (proc ew) es')) /\
  (nth_label i path = WEvt ew) /\
  is_mem_access ew
  ==>
  ?j. i < j /\ j < k /\ (nth_label j path = TauEvt ew)`,
RWTAC [] THEN
IMP_RES_TAC okpath_trans THEN
FSTAC [Once evt_machine_trans_cases] THEN
RWTAC [] THEN
FSTAC [] THEN
RWTAC [] THEN
FSTAC [] THEN
(`(?j. i < j /\ j <= k /\ (nth_label j path = TauEvt ew)) \/
  MEM ew ((el (SUC k) path).eB (proc ew))`
           by METIS_TAC [lem03, LESS_SUC] THEN1
METIS_TAC [LESS_OR_EQ, evt_machine_label_distinct] THEN
FSTAC [] THEN
POP_ASSUM MP_TAC THEN
RWTAC [] THEN
METIS_TAC [MEM]));

val lem05' = Q.prove (
`!path j.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path ==>
  !p r v1 i e v2. 
  ((el j (take j path)).eR p r = SOME (v1, NONE)) /\
  (nth_label i (take j path) = WEvt e) /\
  i < j 
  ==>
  e.action <> Access W (Location_reg p r) v2`,
HO_MATCH_MP_TAC okpath_ind1 THEN
RWTAC [] THEN
FSTAC [Once evt_machine_trans_cases] THEN
RWTAC [] THEN
FSTAC [el_lem02, el_lem01, LESS_THM] THEN
RWTAC [] THEN
FSTAC [nth_label_lem01, nth_label_lem03, APPLY_UPDATE_THM,
       COND_EXPAND, COND_RAND, COND_RATOR] THEN
METIS_TAC []);

val lem05 = Q.prove (
`!path j p r v1 i e v2.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path /\
  ((el j path).eR p r = SOME (v1, NONE)) /\
  (nth_label i path = WEvt e) /\
  i < j 
  ==>
  e.action <> Access W (Location_reg p r) v2`,
METIS_TAC [lem05', el_lem04, LESS_OR_EQ, nth_label_lem06, LESS_THM]);

val lem06' = Q.prove (
`!path j.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path ==>
  !a v1 i e v2. 
  ((el j (take j path)).eM a = SOME (v1, NONE)) /\
  (nth_label i (take j path) = TauEvt e) /\
  i < j 
  ==>
  e.action <> Access W (Location_mem a) v2`,
HO_MATCH_MP_TAC okpath_ind1 THEN
RWTAC [] THEN
FSTAC [Once evt_machine_trans_cases] THEN
RWTAC [] THEN
FSTAC [el_lem02, el_lem01, LESS_THM] THEN
RWTAC [] THEN
FSTAC [nth_label_lem01, nth_label_lem03, APPLY_UPDATE_THM,
       COND_EXPAND, COND_RAND, COND_RATOR] THEN
METIS_TAC []);

val lem06 = Q.prove (
`!path j a v1 i e v2.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path /\
  ((el j path).eM a = SOME (v1, NONE)) /\
  (nth_label i path = TauEvt e) /\
  i < j 
  ==>
  e.action <> Access W (Location_mem a) v2`,
METIS_TAC [lem06', el_lem04, LESS_OR_EQ, nth_label_lem06, LESS_THM]);

val lem07' = Q.prove (
`!path j.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path ==>
  !p r v. 
  ((el j (take j path)).eR p r = SOME (v, NONE))
  ==>
  (SOME v = evt_machine_state_to_state_constraint (first (take j path))
                    (Location_reg p r))`, 
HO_MATCH_MP_TAC okpath_ind1 THEN
RWTAC [] THEN
FSTAC [Once evt_machine_trans_cases] THEN
RWTAC [] THEN
FSTAC [el_lem02, el_lem01, LESS_THM] THEN
RWTAC [] THEN
FSTAC [nth_label_lem01, nth_label_lem03, evt_is_init_def, evt_machine_state_to_state_constraint_def,
       COND_EXPAND, COND_RAND, COND_RATOR, first_pconcat, APPLY_UPDATE_THM] THEN
RWTAC [] THEN
METIS_TAC []);

val lem07 = Q.prove (
`!path j p r v.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path /\
  ((el j path).eR p r = SOME (v, NONE))
  ==>
  (SOME v = evt_machine_state_to_state_constraint (first path) (Location_reg p r))`, 
METIS_TAC [first_take, el_lem02, lem07']);

val lem08' = Q.prove (
`!path j.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path ==>
  !a v. 
  ((el j (take j path)).eM a = SOME (v, NONE))
  ==>
  (SOME v = evt_machine_state_to_state_constraint (first (take j path))
                    (Location_mem a))`, 
HO_MATCH_MP_TAC okpath_ind1 THEN
RWTAC [] THEN
FSTAC [Once evt_machine_trans_cases] THEN
RWTAC [] THEN
FSTAC [el_lem02, el_lem01, LESS_THM] THEN
RWTAC [] THEN
FSTAC [nth_label_lem01, nth_label_lem03, evt_is_init_def, evt_machine_state_to_state_constraint_def,
       COND_EXPAND, COND_RAND, COND_RATOR, first_pconcat, APPLY_UPDATE_THM] THEN
RWTAC [] THEN
METIS_TAC []);

val lem08 = Q.prove (
`!path j a v.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path /\
  ((el j path).eM a = SOME (v, NONE))
  ==>
  (SOME v = evt_machine_state_to_state_constraint (first path) (Location_mem a))`,
METIS_TAC [first_take, el_lem02, lem08']);

local
val TAC1 = 
RES_TAC THEN
Q.EXISTS_TAC `i` THEN
RWTAC [nth_label_lem03, LESS_SUC] THEN
FSTAC [LESS_THM] THEN
RWTAC [] THEN
FSTAC [nth_label_lem01] THEN
METIS_TAC [nth_label_lem03];

val TAC2 = 
RES_TAC THEN
Q.EXISTS_TAC `i` THEN
RWTAC [nth_label_lem03, LESS_SUC] THEN
FSTAC [LESS_THM] THEN
RWTAC [] THEN
FSTAC [nth_label_lem01] THENL
[IMP_RES_TAC machine_state_invariant THEN
     RWTAC [loc_def] THEN
     FSTAC [],
 METIS_TAC [nth_label_lem03]];

val TAC3 = 
Q.EXISTS_TAC `j` THEN
RWTAC [nth_label_lem01] THEN
FULL_SIMP_TAC arith_ss [];
in
val lem09' = Q.prove (
`!path j.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path ==>
  !p r v ew. 
  ((el j (take j path)).eR p r = SOME (v, SOME ew)) 
  ==>
  ?i. 
    i < j /\ (nth_label i (take j path) = WEvt ew) /\
    (!k ew'. 
      i < k /\ k < j /\ (nth_label k (take j path) = WEvt ew') 
      ==>
      loc ew <> loc ew')`,
HO_MATCH_MP_TAC okpath_ind1 THEN
RWTAC [] THEN
FSTAC [Once evt_machine_trans_cases] THEN
RWTAC [] THEN
FSTAC [el_lem02, el_lem01] THEN
RWTAC [] THENL
[FSTAC [evt_is_init_def, evt_machine_init_state_def],
 TAC1,
 TAC1,
 TAC1,
 TAC2,
 TAC1,
 FSTAC [APPLY_UPDATE_THM, COND_RAND, COND_RATOR, COND_EXPAND] THEN
     RWTAC [] THENL
     [TAC2,
      TAC2,
      TAC2,
      TAC3,
      TAC3,
      TAC3,
      TAC3],
 TAC1,
 TAC1,
 TAC1,
 TAC1,
 TAC1]);

val lem09 = Q.prove (
`!path j p r v ew.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path /\
  ((el j path).eR p r = SOME (v, SOME ew)) 
  ==>
  ?i. 
    i < j /\ (nth_label i path = WEvt ew) /\
    (!k ew'. 
      i < k /\ k < j /\ (nth_label k path = WEvt ew') 
      ==>
      loc ew <> loc ew')`,
Cases_on `j` THEN
RWTAC [] THENL
[CCONTR_TAC THEN
     FSTAC [evt_is_init_def, evt_machine_init_state_def] THEN
     RWTAC [] THEN
     POP_ASSUM MP_TAC THEN
     RWTAC [],
 METIS_TAC [lem09', el_lem04, LESS_OR_EQ, nth_label_lem06, LESS_THM, el_def]]);

val lem10' = Q.prove (
`!path j.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path ==>
  !a v ew. 
  ((el j (take j path)).eM a = SOME (v, SOME ew)) 
  ==>
  ?i. 
    i < j /\ (nth_label i (take j path) = TauEvt ew) /\
    (!k ew'. 
      i < k /\ k < j /\ (nth_label k (take j path) = TauEvt ew') 
      ==>
      loc ew <> loc ew')`,
HO_MATCH_MP_TAC okpath_ind1 THEN
RWTAC [] THEN
FSTAC [Once evt_machine_trans_cases] THEN
RWTAC [] THEN
FSTAC [el_lem02, el_lem01] THEN
RWTAC [] THENL
[FSTAC [evt_is_init_def, evt_machine_init_state_def],
 TAC1,
 TAC1,
 TAC1,
 TAC1,
 FSTAC [APPLY_UPDATE_THM, COND_RAND, COND_RATOR, COND_EXPAND] THEN
     RWTAC [] THENL
     [TAC2,
      TAC3,
      TAC3],
 TAC1,
 TAC1,
 TAC1,
 TAC1,
 TAC1,
 TAC1]);

val lem10 = Q.prove (
`!path j a v ew.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path /\
  ((el j path).eM a = SOME (v, SOME ew)) 
  ==>
  ?i. 
    i < j /\ (nth_label i path = TauEvt ew) /\
    (!k ew'. 
      i < k /\ k < j /\ (nth_label k path = TauEvt ew') 
      ==>
      loc ew <> loc ew')`,
Cases_on `j` THEN
RWTAC [] THENL
[CCONTR_TAC THEN
     FSTAC [evt_is_init_def, evt_machine_init_state_def] THEN
     RWTAC [] THEN
     POP_ASSUM MP_TAC THEN
     RWTAC [],
 METIS_TAC [lem10', el_lem04, LESS_OR_EQ, nth_label_lem06, LESS_THM, el_def]]);
end;
 
val lem11 = Q.prove (
`!path j er.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  SUC j IN PL path /\
  (nth_label j path = REvt er NONE)
  ==>
  (value_of er = evt_machine_state_to_state_constraint (first path) (THE (loc er))) /\
  !i ew.
    i < j /\ 
   ((nth_label i path = TauEvt ew) \/ 
    ((nth_label i path = WEvt ew) /\ (proc er = proc ew)))
   ==>
   loc ew <> loc er`,
RWTAC [] THEN
IMP_RES_TAC okpath_trans THEN
FSTAC [Once evt_machine_trans_cases] THEN
RWTAC [] THEN
FSTAC [] THEN
RWTAC [] THENL
[FSTAC [value_of_def, loc_def] THEN
     METIS_TAC [lem08, PL_downward_closed, LESS_SUC_REFL],
 FSTAC [value_of_def, loc_def] THEN
     METIS_TAC [lem07, PL_downward_closed, LESS_SUC_REFL],
 `!v. ew.action <> Access W (Location_mem a) v` 
                  by METIS_TAC [lem06, el_def, PL_downward_closed, LESS_SUC_REFL] THEN
     Cases_on `ew.action` THEN
     RWTAC [loc_def] THEN
     `SUC i IN PL path` by METIS_TAC [PL_downward_closed, LESS_MONO] THEN
     `?l v. ew.action = Access W l v`
                by METIS_TAC [machine_label_invariant] THEN
     FSTAC [],
 `SUC i IN PL path` by METIS_TAC [PL_downward_closed, LESS_MONO] THEN
     `is_mem_access ew` by METIS_TAC [machine_label_invariant] THEN
     FSTAC [is_mem_access_def] THEN
     RWTAC [loc_def],
 CCONTR_TAC THEN 
     FSTAC [] THEN
     `is_mem_access ew`
                 by (FSTAC [loc_def, is_mem_access_def] THEN
                     Cases_on `ew` THEN
                     FSTAC [] THEN
                     Cases_on `er` THEN
                     FSTAC [] THEN
                     RWTAC [] THEN
                     Cases_on `a'` THEN
                     FSTAC []) THEN
     `(?k. i < k /\ k <= j /\ (nth_label k path = TauEvt ew)) \/
           MEM ew ((el (SUC j) path).eB (proc ew))`
                    by METIS_TAC [lem03, LESS_SUC] THENL
     [FSTAC [LESS_OR_EQ] THEN
          RWTAC [] THEN
          FSTAC [] THEN
          `!v. ew.action <> Access W (Location_mem a) v` 
                  by METIS_TAC [lem06, PL_downward_closed, LESS_SUC_REFL] THEN
          FSTAC [loc_def, is_mem_access_def] THEN
          Cases_on `ew.action` THEN
          FSTAC [] THEN
          Cases_on `er.action` THEN
          FSTAC [] THEN
          RWTAC [] THEN
          `SUC i IN PL path` by METIS_TAC [PL_downward_closed, LESS_MONO] THEN
          `?l v. ew.action = Access W l v` 
                by METIS_TAC [machine_label_invariant] THEN
          FSTAC [],
      FSTAC [] THEN
          `loc ew <> SOME (Location_mem a)` by METIS_TAC [evt_no_pending_def] THEN
          FSTAC [loc_def] THEN
          Cases_on `ew.action` THEN
          FSTAC [is_mem_access_def] THEN
          Cases_on `er.action` THEN
          FSTAC [] THEN
          RWTAC []],
 RWTAC [loc_def] THEN
     `!v. ew.action <> Access W (Location_reg (proc ew) r) v` 
                  by METIS_TAC [lem05, el_def, PL_downward_closed, LESS_SUC_REFL] THEN
     Cases_on `ew.action` THEN
     RWTAC [] THEN
     `SUC i IN PL path` by METIS_TAC [PL_downward_closed, LESS_MONO] THEN
     `?l v. ew.action = Access W l v`
                by METIS_TAC [machine_label_invariant] THEN
     FSTAC []]);

val lem12 = Q.prove (
`!path j p e e'.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  SUC j IN PL path /\
  is_mem_access e /\
  ((el j path).eL = SOME p) /\
  ((nth_label j path = REvt e e') \/ 
   (nth_label j path = TauEvt e))
  ==>
  (proc e = p)`,
RWTAC [] THEN
IMP_RES_TAC okpath_trans THEN
FSTAC [Once evt_machine_trans_cases, evt_not_blocked_def, is_mem_access_def] THEN
RWTAC [] THEN
FSTAC [] THEN
RWTAC [] THEN
FSTAC []);

local
val TAC =
FSTAC [LESS_OR_EQ] THENL
[Q.PAT_ASSUM `!i' p'. P i' p' ==> ((el j path).eL = SOME p')` MATCH_MP_TAC THEN
     Q.EXISTS_TAC `i` THEN
     RWTAC [] THEN
     FSTAC [] THEN
     METIS_TAC [nth_label_lem03, LESS_SUC],
 FSTAC [el_lem02]];
in
val lem13' = Q.prove (
`!path j.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path
  ==>
  !i p.
  i < j /\
  ((el i (take j path)).eL = SOME p) /\
  (!k es. i <= k /\ k < j ==> nth_label k (take j path) <> UnlockE p es)
  ==>
  ((el j (take j path)).eL = SOME p)`,
HO_MATCH_MP_TAC okpath_ind1 THEN
RWTAC [] THEN
FSTAC [Once evt_machine_trans_cases] THEN
RWTAC [] THEN
FSTAC [el_lem01, el_lem02] THEN
RWTAC [] THEN
`i <= j` by DECIDE_TAC THEN
FSTAC [nth_label_lem05, el_lem03] THENL
[TAC,
 TAC,
 TAC,
 TAC,
 TAC,
 TAC,
 TAC,
 TAC,
 TAC,
 FSTAC [LESS_THM] THENL
     [RWTAC [] THEN
          FSTAC [el_lem02],
      METIS_TAC [nth_label_lem03, NOT_SOME_NONE]],
 `UnlockE p es <> UnlockE p' es` by METIS_TAC [nth_label_lem01, LESS_SUC_REFL] THEN
     FSTAC [LESS_THM] THENL
     [RWTAC [] THEN
          FSTAC [el_lem02],
      METIS_TAC [nth_label_lem03, SOME_11]]]);

val lem13 = Q.prove (
`!path j i p es.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path /\
  i < j /\
  ((el i path).eL = SOME p) /\
  (!k es. i <= k /\ k < j ==> nth_label k path <> UnlockE p es)
  ==>
  ((el j path).eL = SOME p)`,
METIS_TAC [lem13', el_lem04, LESS_OR_EQ, nth_label_lem06, LESS_THM]);
end;

local
val TAC = 
RES_TAC THEN
MAP_EVERY Q.EXISTS_TAC [`k`, `l`] THEN
`k < j` by DECIDE_TAC THEN
RWTAC [nth_label_lem03, LESS_SUC];
in
val lem14' = Q.prove (
`!path j.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path ==>
  !ew1 ew2 b b'.
  ((el j (take j path)).eB (proc ew2) = b ++ b') /\
  MEM ew1 b' /\
  MEM ew2 b
  ==>
  ?k l. k < j /\ l < j /\ k < l /\ 
        (nth_label k (take j path) = WEvt ew1) /\ 
        (nth_label l (take j path) = WEvt ew2)`,
HO_MATCH_MP_TAC okpath_ind1 THEN
RWTAC [] THEN
FSTAC [Once evt_machine_trans_cases] THEN
RWTAC [] THEN
FSTAC [el_lem01, el_lem02] THENL
[FSTAC [evt_is_init_def, evt_machine_init_state_def] THEN
     METIS_TAC [MEM],
 TAC,
 TAC,
 TAC,
 FSTAC [COND_EXPAND, COND_RAND, COND_RATOR, APPLY_UPDATE_THM] THEN
     FSTAC [] THENL
     [TAC,
      Cases_on `b` THEN
          FSTAC [] THEN
          RWTAC [] THENL
          [`~MEM ew1 ((el 0 path).eB (proc ew)) /\
            MEM ew1 ((el j path).eB (proc ew))` 
                       by FSTAC [evt_is_init_def, evt_machine_init_state_def] THEN
               `0 < j` 
                     by (Cases_on `j` THEN 
                         FSTAC [evt_is_init_def, evt_machine_init_state_def]) THEN
               `?k. k < j /\ (nth_label k path = WEvt ew1)` 
                     by METIS_TAC [lem01, ZERO_LESS_EQ] THEN
               MAP_EVERY Q.EXISTS_TAC [`k`, `j`] THEN
               RWTAC [LESS_SUC, nth_label_lem03, nth_label_lem01] THEN
               Cases_on `j` THEN
               FSTAC [] THEN
               METIS_TAC [nth_label_lem06, take_def, LESS_THM],
           Q.PAT_ASSUM `!ew1' ew2' b''' b''''. P ew1' ew2' b''' b''''`
                       (MP_TAC o Q.SPECL [`ew1`, `ew2`, `t`, `b'`]) THEN
               RWTAC [] THEN
               MAP_EVERY Q.EXISTS_TAC [`k`, `l`] THEN
               `k < j` by DECIDE_TAC THEN
               RWTAC [nth_label_lem03, LESS_SUC]]],
 FSTAC [COND_EXPAND, COND_RAND, COND_RATOR, APPLY_UPDATE_THM] THEN
     FSTAC [] THENL
     [TAC,
      Q.PAT_ASSUM `!ew1' ew2' b''' b''''. P ew1' ew2' b''' b''''`
                  (MP_TAC o Q.SPECL [`ew1`, `ew2`, `b`, `b' ++ [ew]`]) THEN
          RWTAC [] THEN
          MAP_EVERY Q.EXISTS_TAC [`k`, `l`] THEN
          `k < j` by DECIDE_TAC THEN
          RWTAC [nth_label_lem03, LESS_SUC],
      TAC],
 TAC,
 TAC,
 TAC,
 TAC,
 TAC,
 TAC]);
end;

local
val TAC1 = 
`?k l. k < i /\ l < j /\ k < l /\
       (nth_label k (take j path) = WEvt ew1) /\
       (nth_label l (take j path) = WEvt ew2)` 
             by METIS_TAC [MEM_APPEND] THEN
MAP_EVERY Q.EXISTS_TAC [`k`, `l`] THEN
RWTAC [] THEN
METIS_TAC [LESS_TRANS, nth_label_lem03];

val TAC = 
FSTAC [LESS_THM] THEN
RWTAC [] THEN
FSTAC [nth_label_lem03, nth_label_lem01] THEN
TAC1;
in
val lem15' = Q.prove (
`!path j.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path ==>
  !i ew1 ew2.
  (proc ew1 = proc ew2) /\
  (nth_label i (take j path) = TauEvt ew1) /\
  MEM ew2 ((el j (take j path)).eB (proc ew2)) /\
  i < j
  ==>
  ?k l. k < i /\ l < j /\ k < l /\ 
        (nth_label k (take j path) = WEvt ew1) /\ 
        (nth_label l (take j path) = WEvt ew2)`,
HO_MATCH_MP_TAC okpath_ind1 THEN
RWTAC [] THEN
FSTAC [Once evt_machine_trans_cases] THEN
RWTAC [] THEN
FSTAC [el_lem01, el_lem02] THENL
[TAC,
 TAC,
 TAC,
 FSTAC [LESS_THM] THEN
     RWTAC [] THEN
     FSTAC [nth_label_lem01, nth_label_lem03, COND_RAND, COND_RATOR,
            COND_EXPAND_EQ_GSYM, APPLY_UPDATE_THM] THEN
     FSTAC [] THENL
     [TAC1,
      RWTAC [] THEN
          `SUC i IN PL path` by METIS_TAC [PL_downward_closed, LESS_OR, LESS_OR_EQ] THEN
          Cases_on `j` THEN
          FSTAC [] THEN
          `?i'. i' < i /\ (nth_label i' path = WEvt ew1)`
                      by METIS_TAC [lem02, nth_label_lem06, take_def,
                                    LESS_THM] THEN
          MAP_EVERY Q.EXISTS_TAC [`i'`, `SUC n`] THEN
          RWTAC [pconcat_thm] THEN1
          DECIDE_TAC THEN
          `i' <= n` by DECIDE_TAC THEN
          RWTAC [nth_label_lem05, nth_label_lem01] THEN
          METIS_TAC [nth_label_lem06, take_def, LESS_THM, LESS_OR_EQ],
      TAC1,
      TAC1,
      TAC1],
 FSTAC [LESS_THM] THEN
     RWTAC [] THEN
     FSTAC [nth_label_lem01, nth_label_lem03, COND_RAND, COND_RATOR,
            COND_EXPAND, APPLY_UPDATE_THM] THEN
     RWTAC [] THEN
     FSTAC [] THENL
     [`?k l.
            k < i /\ l < i /\ k < l /\
            (nth_label k (take i path) = WEvt ew) /\
            (nth_label l (take i path) = WEvt ew2)`
                 by METIS_TAC [lem14', el_lem02, MEM] THEN
          MAP_EVERY Q.EXISTS_TAC [`k`, `l`] THEN
          RWTAC [] THEN
          METIS_TAC [LESS_TRANS, nth_label_lem03],
      `?k l.
            k < i /\ l < i /\ k < l /\
            (nth_label k (take i path) = WEvt ew) /\
            (nth_label l (take i path) = WEvt ew2)`
                 by METIS_TAC [lem14', el_lem02, MEM] THEN
          MAP_EVERY Q.EXISTS_TAC [`k`, `l`] THEN
          RWTAC [] THEN
          METIS_TAC [LESS_TRANS, nth_label_lem03],
      TAC1,
      TAC1,
      TAC1],
 TAC,
 TAC,
 TAC,
 TAC,
 TAC,
 TAC]);
end;

val lem15 = Q.prove (
`!path j i ew1 ew2.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path /\
  (proc ew1 = proc ew2) /\
  (nth_label i path = TauEvt ew1) /\
  MEM ew2 ((el j path).eB (proc ew2)) /\
  i < j
  ==>
  ?k l. k < i /\ l < j /\ k < l /\ 
        (nth_label k path = WEvt ew1) /\ 
        (nth_label l path = WEvt ew2)`,
RWTAC [] THEN
`?k l. k < i /\ l < j /\ k < l /\
       (nth_label k (take j path) = WEvt ew1) /\
       (nth_label l (take j path) = WEvt ew2)`
           by METIS_TAC [lem15', nth_label_lem06, LESS_OR_EQ, el_lem04] THEN
METIS_TAC [lem15', nth_label_lem06, LESS_TRANS]);

val lem17' = Q.prove (
`!path j.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path
  ==>
  !ew1 ew2 b1 b2.
  no_dup_writes (take j path) /\
  ((el j (take j path)).eB (proc ew1) = b1 ++ b2) /\
  MEM ew1 b1 /\
  MEM ew2 b2
  ==>
  ew1 <> ew2`,
HO_MATCH_MP_TAC okpath_ind1 THEN
RWTAC [] THEN
FSTAC [Once evt_machine_trans_cases] THEN
RWTAC [] THEN
FSTAC [el_lem01, el_lem02, APPLY_UPDATE_THM, COND_RAND, COND_RATOR, COND_EXPAND] THEN
CCONTR_TAC THEN
FSTAC [] THENL
[FSTAC [evt_is_init_def, evt_machine_init_state_def] THEN
     RWTAC [] THEN
     FSTAC [] THEN
     RWTAC [] THEN
     FSTAC [],
 METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01],
 Cases_on `b1` THEN
     FSTAC [] THENL
     [RWTAC [] THEN
          METIS_TAC [MEM_APPEND, lem16, no_dup_writes_lem02],
      METIS_TAC [no_dup_writes_lem01]],
 METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01, MEM, MEM_APPEND, APPEND_ASSOC],
 METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01]]);

val lem17 = Q.prove (
`!path j ew1 ew2 b1 b2.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  j IN PL path /\
  no_dup_writes (take j path) /\
  ((el j path).eB (proc ew1) = b1 ++ b2) /\
  MEM ew1 b1 /\
  MEM ew2 b2
  ==>
  ew1 <> ew2`,
METIS_TAC [el_lem02, lem17']);

val lem18' = Q.prove (
`!path k.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  k IN PL path
  ==>
  !i ew.
  no_dup_writes (take k path) /\
  (nth_label i (take k path) = WEvt ew) /\
  MEM ew ((el k (take k path)).eB (proc ew)) /\
  i < k
  ==>
  (!j. i < j /\ j < k ==> nth_label j (take k path) <> TauEvt ew)`,
HO_MATCH_MP_TAC okpath_ind1 THEN
RWTAC [] THEN
FSTAC [Once evt_machine_trans_cases] THEN
RWTAC [] THEN
FSTAC [LESS_THM] THEN
RWTAC [] THEN
FSTAC [nth_label_lem01, nth_label_lem03, el_lem01, nth_label_lem06, el_lem04] THEN
FULL_SIMP_TAC (srw_ss() ++ ARITH_ss) [] THEN
TRY (`i < k` by DECIDE_TAC) THENL
[METIS_TAC [nth_label_lem01, nth_label_lem03, nth_label_lem06, no_dup_writes_lem01],
 METIS_TAC [nth_label_lem01, nth_label_lem03, nth_label_lem06, no_dup_writes_lem01],
 METIS_TAC [nth_label_lem01, nth_label_lem03, nth_label_lem06, no_dup_writes_lem01],
 FSTAC [APPLY_UPDATE_THM, COND_RAND, COND_RATOR, COND_EXPAND_EQ_GSYM] THEN
     FSTAC [] THENL
     [METIS_TAC [nth_label_lem01, nth_label_lem03, nth_label_lem06, no_dup_writes_lem01],
      METIS_TAC [no_dup_writes_lem02, PL_lem01],
      METIS_TAC [nth_label_lem01, nth_label_lem03, nth_label_lem06, no_dup_writes_lem01],
      METIS_TAC [nth_label_lem01, nth_label_lem03, nth_label_lem06, no_dup_writes_lem01],
      METIS_TAC [nth_label_lem01, nth_label_lem03, nth_label_lem06, no_dup_writes_lem01]],
 FSTAC [APPLY_UPDATE_THM, COND_RAND, COND_RATOR, COND_EXPAND_EQ_GSYM] THEN
     FSTAC [] THEN
     METIS_TAC [lem17, no_dup_writes_lem01, MEM],
 FSTAC [APPLY_UPDATE_THM, COND_RAND, COND_RATOR, COND_EXPAND_EQ_GSYM] THEN
     FSTAC [] THEN
     METIS_TAC [nth_label_lem01, nth_label_lem03, nth_label_lem06, no_dup_writes_lem01, MEM, MEM_APPEND],
 METIS_TAC [nth_label_lem01, nth_label_lem03, nth_label_lem06, no_dup_writes_lem01],
 METIS_TAC [nth_label_lem01, nth_label_lem03, nth_label_lem06, no_dup_writes_lem01],
 METIS_TAC [nth_label_lem01, nth_label_lem03, nth_label_lem06, no_dup_writes_lem01],
 METIS_TAC [nth_label_lem01, nth_label_lem03, nth_label_lem06, no_dup_writes_lem01],
 METIS_TAC [nth_label_lem01, nth_label_lem03, nth_label_lem06, no_dup_writes_lem01],
 METIS_TAC [nth_label_lem01, nth_label_lem03, nth_label_lem06, no_dup_writes_lem01]]);

val lem18 = Q.prove (
`!path k i ew.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  k IN PL path /\
  no_dup_writes path /\
  (nth_label i path = WEvt ew) /\
  MEM ew ((el k path).eB (proc ew)) /\
  i < k
  ==>
  (!j. i < j /\ j < k ==> nth_label j path <> TauEvt ew)`,
METIS_TAC [lem18', el_lem04, LESS_OR_EQ, nth_label_lem06, LESS_THM, no_dup_writes_lem03]);

val lem19' = Q.prove (
`!path k.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  k IN PL path ==>
  !ew1 ew2 i j b1 b2.
  no_dup_writes (take k path) /\
  (proc ew1 = proc ew2) /\
  (nth_label i (take k path) = WEvt ew1) /\
  (nth_label j (take k path) = WEvt ew2) /\
  is_mem_access ew2 /\
  i < j /\
  j < k /\ 
  ((el k (take k path)).eB (proc ew1) = b1 ++ [ew1] ++ b2)
  ==>
  MEM ew2 b1`,
HO_MATCH_MP_TAC okpath_ind1 THEN
RWTAC [] THEN
FSTAC [Once evt_machine_trans_cases] THEN
RWTAC [] THEN
FSTAC [LESS_THM] THEN
RWTAC [] THEN
FSTAC [el_lem01, nth_label_lem01, el_lem02] THEN
IMP_RES_TAC LESS_TRANS THEN
FSTAC [nth_label_lem03] THENL
[METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01],
 FSTAC [COND_RAND, COND_RATOR, COND_EXPAND, APPLY_UPDATE_THM] THEN
     FSTAC [] THEN
     Cases_on `b1` THEN
     FSTAC [] THEN
     METIS_TAC [no_dup_writes_lem02, nth_label_lem06],
 FSTAC [COND_RAND, COND_RATOR, COND_EXPAND, APPLY_UPDATE_THM] THEN
     FSTAC [] THENL
     [METIS_TAC [no_dup_writes_lem01],
      Cases_on `b1` THEN1
          METIS_TAC [no_dup_writes_lem02, nth_label_lem06, APPEND, APPEND_ASSOC, CONS_11] THEN
          FSTAC [] THEN
          METIS_TAC [no_dup_writes_lem01]],
 FSTAC [COND_RAND, COND_RATOR, COND_EXPAND, APPLY_UPDATE_THM] THEN
     FSTAC [] THEN
     METIS_TAC [no_dup_writes_lem01, APPEND_ASSOC],
 FSTAC [is_mem_access_def] THEN
     FSTAC [],
 METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01],
 METIS_TAC [no_dup_writes_lem01]]);

val lem19 = Q.prove (
`!path k ew1 ew2 i j b1 b2.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  k IN PL path /\
  no_dup_writes path /\
  (proc ew1 = proc ew2) /\
  (nth_label i path = WEvt ew1) /\
  (nth_label j path = WEvt ew2) /\
  is_mem_access ew2 /\
  i < j /\
  j < k /\ 
  ((el k path).eB (proc ew1) = b1 ++ [ew1] ++ b2)
  ==>
  MEM ew2 b1`,
RWTAC [] THEN
`i < k` by DECIDE_TAC THEN
METIS_TAC [lem19', el_lem04, LESS_OR_EQ, nth_label_lem06, LESS_THM, no_dup_writes_lem03]);

val lem20 = Q.prove (
`!path j er ew.
  evt_is_init (first path) /\
  okpath evt_machine_trans path /\
  SUC j IN PL path /\
  (nth_label j path = REvt er (SOME ew)) /\
  no_dup_writes path
  ==>
  (loc er = loc ew) /\
  (value_of er = value_of ew) /\
  (((proc er = proc ew) /\ 
    ?i. 
      i < j /\ 
      (nth_label i path = WEvt ew) /\
      (!k. i < k /\ k < j ==> nth_label k path <> TauEvt ew) /\
      (!k ew'. 
        i < k /\ k < j /\ (nth_label k path = WEvt ew') /\ (proc er = proc ew') 
        ==> 
        loc ew <> loc ew')) \/
   (?i. 
      i < j /\ 
      (nth_label i path = TauEvt ew) /\ 
      (!k ew'. 
        k < j /\ (nth_label k path = WEvt ew') /\ (proc er = proc ew') /\ 
        (loc ew' = loc er) 
        ==> 
        ?l. k < l /\ l < j /\ (nth_label l path = TauEvt ew')) /\
      (!k ew'. 
        i < k /\ k < j /\ (nth_label k path = TauEvt ew') 
        ==> 
        loc ew <> loc ew')))`,
RWTAC [] THEN
IMP_RES_TAC okpath_trans THEN
FSTAC [Once evt_machine_trans_cases] THEN
RWTAC [] THEN
FSTAC [] THEN
RWTAC [] THENL
[`ew.action = Access W (Location_mem a) v` 
            by METIS_TAC [machine_state_invariant, el_def] THEN
     RWTAC [loc_def],
 RWTAC [loc_def],
 `ew.action = Access W (Location_reg (proc er) r) v` 
            by METIS_TAC [machine_state_invariant, el_def] THEN
     RWTAC [loc_def],
 `ew.action = Access W (Location_mem a) v` 
            by METIS_TAC [machine_state_invariant, el_def] THEN
     RWTAC [value_of_def],
 RWTAC [value_of_def],
 `ew.action = Access W (Location_reg (proc er) r) v` 
            by METIS_TAC [machine_state_invariant, el_def] THEN
     RWTAC [value_of_def],
 DISJ2_TAC THEN
     `?i. i < SUC j /\ (nth_label i path = TauEvt ew) /\
          (!k ew'. i < k /\ k < SUC j /\ (nth_label k path = TauEvt ew') ==>
                   loc ew <> loc ew')`
               by METIS_TAC [lem10, el_def] THEN
     Q.EXISTS_TAC `i` THEN
     RWTAC [] THEN
     FSTAC [LESS_THM] THEN
     RWTAC [] THEN
     FSTAC [] THENL
     [`is_mem_access ew'` 
                by (FSTAC [is_mem_access_def, loc_def] THEN
                    Cases_on `ew'.action` THEN
                    Cases_on `er.action` THEN
                    FSTAC []) THEN
          `(?i. k < i /\ i <= j /\ (nth_label i path = TauEvt ew')) \/
           MEM ew' ((el (SUC j) path).eB (proc ew'))`
                    by METIS_TAC [lem03, LESS_SUC] THENL
          [FSTAC [LESS_OR_EQ] THEN
               RWTAC [] THEN
               FSTAC [] THEN
               METIS_TAC [],
          `loc ew' <> SOME (Location_mem a)` by METIS_TAC [evt_no_pending_def, el_def] THEN
              FSTAC [loc_def] THEN
              Cases_on `ew'.action` THEN
              FSTAC [is_mem_access_def] THEN
              Cases_on `er.action` THEN
              FSTAC [] THEN
              RWTAC []],
      METIS_TAC []],
 `?i. i < SUC j /\ (nth_label i path = WEvt ew)` 
           by METIS_TAC [lem16, MEM_APPEND, MEM, el_def] THEN
     DISJ1_TAC THEN
     `proc er = proc ew` by METIS_TAC [machine_state_invariant, el_def, MEM, MEM_APPEND] THEN 
     RWTAC [] THEN
     Q.EXISTS_TAC `i` THEN
     FSTAC [LESS_THM] THEN
     RWTAC [] THEN
     FSTAC [] THENL
     [`j IN PL path` by METIS_TAC [PL_downward_closed, LESS_SUC_REFL] THEN
          METIS_TAC [MEM, MEM_APPEND, lem18],
      CCONTR_TAC THEN 
          FSTAC [] THEN
          `j IN PL path` by METIS_TAC [LESS_SUC_REFL, PL_downward_closed] THEN
          `is_mem_access ew'` 
                   by (FSTAC [loc_def, is_mem_access_def] THEN
                       Cases_on `ew.action` THEN
                       Cases_on `ew'.action` THEN
                       FSTAC []) THEN
          `MEM ew' b1` by METIS_TAC [lem19] THEN
          Q.PAT_ASSUM `evt_no_pending b1 a` MP_TAC THEN
          RWTAC [evt_no_pending_def] THEN
          Q.EXISTS_TAC `ew'` THEN
          RWTAC [] THEN
          FSTAC [evt_no_pending_def, loc_def] THEN
          Cases_on `ew.action` THEN
          Cases_on `ew'.action` THEN
          FSTAC [] ],
 DISJ1_TAC THEN
     `proc er = proc ew` by METIS_TAC [machine_state_invariant, el_def] THEN 
     RWTAC [] THEN
     `?i. i < SUC j /\ (nth_label i path = WEvt ew) /\
          (!k ew'. i < k /\ k < SUC j /\ (nth_label k path = WEvt ew') ==>
                   loc ew <> loc ew')`
               by METIS_TAC [el_def, lem09] THEN
     Q.EXISTS_TAC `i` THEN
     RWTAC [] THEN
     FSTAC [LESS_THM] THEN
     RWTAC [] THEN
     FSTAC [] THENL
     [CCONTR_TAC THEN
          FSTAC [] THEN
          `SUC k IN PL path` by METIS_TAC [PL_downward_closed, LESS_THM, LESS_MONO] THEN
          `is_mem_access ew` by METIS_TAC [machine_label_invariant] THEN
          `ew.action = Access W (Location_reg (proc er) r) v` 
                 by METIS_TAC [machine_state_invariant, el_def] THEN
          FSTAC [is_mem_access_def],
      METIS_TAC []]]);

(* All TauEvt transitions arise from a previous WEvt transition *)
val tau_source = Q.store_thm ("tau_source",
`!path j e. 
  okMpath path /\
  j + 1 IN PL path /\
  (nth_label j path = TauEvt e)
  ==>
  ?i. i < j /\ (nth_label i path = WEvt e) /\ is_mem_access e`,
METIS_TAC [machine_label_invariant, lem02, ADD1, okMpath_def]);

(* Given two TauEvt transitions on the same processor, they both arise from previous WEvt transitions in the same order *)
val tau_ordered_source = Q.store_thm ("tau_ordered_source",
`!path i j ew1 ew2.
  okMpath path /\
  j + 1 IN PL path /\
  i < j /\
  (proc ew1 = proc ew2) /\
  (nth_label i path = TauEvt ew1) /\
  (nth_label j path = TauEvt ew2)
  ==>
  ?k l. k < i /\ l < j /\ k < l /\ 
        (nth_label k path = WEvt ew1) /\ (nth_label l path = WEvt ew2)`,
RWTAC [GSYM ADD1, okMpath_def] THEN
IMP_RES_TAC okpath_trans THEN
FSTAC [Once evt_machine_trans_cases] THEN
FSTAC [] THEN
RWTAC [] THEN
MATCH_MP_TAC lem15 THEN
RWTAC [] THEN
METIS_TAC [LESS_SUC_REFL, PL_downward_closed]);

(* REvt transitions have reads on them *)
val revt_read = Q.store_thm ("revt_read",
`!path i e1 e2.
  okMpath path /\
  i + 1 IN PL path /\
  (nth_label i path = REvt e1 e2)
  ==>
  ?l v. e1.action = Access R l v`,
Cases_on `e2` THEN
METIS_TAC [machine_label_invariant, okMpath_def, ADD1]);

(* WEvt transitions have writes on them *)
val wevt_write = Q.store_thm ("wevt_write",
`!path i e.
  okMpath path /\
  i + 1 IN PL path /\
  (nth_label i path = WEvt e)
  ==>
  ?l v. e.action = Access W l v`,
METIS_TAC [machine_label_invariant, okMpath_def, ADD1]);

(* BEvt transitions have barriers on them *)
val bevt_barrier = Q.store_thm ("bevt_barrier",
`!path i e.
  okMpath path /\
  i + 1 IN PL path /\
  (nth_label i path = BEvt e)
  ==>
  ?f. e.action = Barrier f`,
METIS_TAC [machine_label_invariant, okMpath_def, ADD1]);

val tau_fairness = Q.store_thm ("tau_fairness",
`!path i e.
  okMpath path /\
  i + 1 IN PL path /\
  (nth_label i path = WEvt e) /\
  is_mem_access e
  ==>
  ?j. j + 1 IN PL path /\ i < j /\ (nth_label j path = TauEvt e)`,
RWTAC [okMpath_def] THEN
METIS_TAC []);

(* Given two WEvt memory transitions on the same processor, there are two later TauEvt transitions in the same order *)
val tau_ordered_fairness = Q.store_thm ("tau_ordered_fairness",
`!path i j ew1 ew2.
  okMpath path /\
  j + 1 IN PL path /\
  i < j /\
  (proc ew1 = proc ew2) /\
  (nth_label i path = WEvt ew1) /\
  (nth_label j path = WEvt ew2) /\
  is_mem_access ew1 /\
  is_mem_access ew2 /\
  no_dup_writes path
  ==>
  ?k l. l + 1 IN PL path /\ k < l /\ (nth_label k path = TauEvt ew1) /\ (nth_label l path = TauEvt ew2)`,
RWTAC [] THEN
`i + 1 IN PL path` by (`i + 1 < j + 1` by DECIDE_TAC THEN
                       METIS_TAC [PL_downward_closed]) THEN
`?k. k + 1 IN PL path /\ i < k /\ (nth_label k path = TauEvt ew1)` 
                     by METIS_TAC [tau_fairness] THEN
`?l. l + 1 IN PL path /\ j < l /\ (nth_label l path = TauEvt ew2)` 
                     by METIS_TAC [tau_fairness] THEN
`(k = l) \/ k < l \/ l < k` by DECIDE_TAC THENL
[FSTAC [no_dup_writes_def, GSYM ADD1] THEN
     METIS_TAC [LESS_NOT_EQ],
 MAP_EVERY Q.EXISTS_TAC [`k`, `l`] THEN
     RWTAC [],
 `?i' j'. i' < k /\ j' < l /\ j' < i'/\ 
          (nth_label i' path = WEvt ew1) /\ (nth_label j' path = WEvt ew2)`
              by METIS_TAC [tau_ordered_source] THEN
     FSTAC [no_dup_writes_def, GSYM ADD1] THEN
     `SUC i' IN PL path /\ SUC j' IN PL path` 
                   by METIS_TAC [PL_downward_closed, LESS_MONO] THEN
     METIS_TAC [LESS_ANTISYM]]);

(* Every memory WEvt on a processor must have a corresponding TauEvt event before a BEvt *)
val wevt_tau_bevt = Q.store_thm ("wevt_tau_bevt",
`!path i j ef ew p es.
  okMpath path /\
  j + 1 IN PL path /\
  i < j /\
  (((nth_label j path = BEvt ef) /\ (proc ef = proc ew) /\ (ef.action = Barrier Mfence)) \/ 
   (nth_label j path = UnlockE (proc ew) es) \/
   (nth_label j path = LockE (proc ew) es)) /\
  (nth_label i path = WEvt ew) /\
  is_mem_access ew
  ==>
  ?k. k < j /\ (nth_label k path = TauEvt ew)`,
METIS_TAC [lem04, okMpath_def, ADD1]);

val read_from_write = Q.store_thm ("read_from_write",
`!path j er ew.
  okMpath path /\
  j + 1 IN PL path /\
  no_dup_writes path /\
  (nth_label j path = REvt er (SOME ew))
  ==>
  (loc er = loc ew) /\
  (value_of er = value_of ew) /\
  (((proc er = proc ew) /\ 
    ?i. 
      i < j /\ 
      (nth_label i path = WEvt ew) /\
      (!k. i < k /\ k < j ==> nth_label k path <> TauEvt ew) /\
      (!k ew'. i < k /\ k < j /\ (nth_label k path = WEvt ew') /\ (proc er = proc ew') ==> 
               loc ew <> loc ew')) \/
   (?i. 
      i < j /\ 
      (nth_label i path = TauEvt ew) /\ 
      (!k ew'. k < j /\ (nth_label k path = WEvt ew') /\ (proc er = proc ew') /\
               (loc ew' = loc er) ==> 
               ?l. k < l /\ l < j /\ (nth_label l path = TauEvt ew')) /\
      (!k ew'. i < k /\ k < j /\ (nth_label k path = TauEvt ew') ==> loc ew <> loc ew')))`,
NTAC 5 STRIP_TAC THEN
MATCH_MP_TAC lem20 THEN
FSTAC [okMpath_def, ADD1]);

val read_from_init = Q.store_thm ("read_from_init",
`!path i er.
  okMpath path /\
  i + 1 IN PL path /\
  (nth_label i path = REvt er NONE)
  ==>
  (value_of er = evt_machine_state_to_state_constraint (first path) (THE (loc er))) /\
  !j ew.
    j < i /\ 
   ((nth_label j path = TauEvt ew) \/ ((nth_label j path = WEvt ew) /\ (proc er = proc ew)))
   ==>
   loc ew <> loc er`,
METIS_TAC [lem11, ADD1, okMpath_def]);

val lock_proc = Q.store_thm ("lock_proc",
`!path i j k p e e'.
  okMpath path /\
  locked_segment path i k p /\
  i < j /\
  j < k /\ 
  is_mem_access e /\
  ((nth_label j path = REvt e e') \/ 
   (nth_label j path = TauEvt e))
  ==>
  (proc e = p)`,
RWTAC [locked_segment_def, okMpath_def] THEN
`SUC i < k + 1 /\ SUC j < k + 1 /\ j < k + 1` by DECIDE_TAC THEN
`SUC j IN PL path /\ j IN PL path` by METIS_TAC [PL_downward_closed, LESS_TRANS] THEN
`SUC i IN PL path` by METIS_TAC [PL_downward_closed] THEN
`(el (SUC i) path).eL = SOME p`
        by (IMP_RES_TAC okpath_trans THEN
            FSTAC [Once evt_machine_trans_cases] THEN
            FSTAC []) THEN
MATCH_MP_TAC lem12 THEN
MAP_EVERY Q.EXISTS_TAC [`path`, `j`] THEN
RWTAC [] THEN
`SUC i < j \/ (SUC i = j)` by DECIDE_TAC THEN
RWTAC [] THEN
MATCH_MP_TAC lem13 THEN
RWTAC [] THEN
Q.EXISTS_TAC `SUC i` THEN
RWTAC [] THEN
`i < k' /\ k' < k` by DECIDE_TAC THEN
METIS_TAC []);

val lock_wevt_tau = Q.store_thm ("lock_wevt_tau",
`!path i j ew.
  okMpath path /\
  locked_segment path i j (proc ew) /\
  is_mem_access ew
  ==>
  ((?k. i < k /\ k < j /\ (nth_label k path = WEvt ew)) =
   (?k. i < k /\ k < j /\ (nth_label k path = TauEvt ew)))`,
RWTAC [locked_segment_def, okMpath_def] THEN
EQ_TAC THEN
RWTAC [] THENL
[`?k'. k < k' /\ k' < j /\ (nth_label k' path = TauEvt ew)`
           by METIS_TAC [lem04, ADD1] THEN
     METIS_TAC [LESS_TRANS],
 FSTAC [] THEN
     `SUC i IN PL path /\ SUC k IN PL path` 
              by METIS_TAC [PL_downward_closed, LESS_MONO, ADD1] THEN
     IMP_RES_TAC okpath_trans THEN
     FSTAC [Once evt_machine_trans_cases] THEN
     FSTAC [] THEN
     RWTAC [] THEN
     `MEM ew ((el k path).eB (proc ew)) /\
      ~MEM ew ((el i path).eB (proc ew))`
                 by FSTAC [] THEN
     `k IN PL path` by METIS_TAC [PL_downward_closed, LESS_SUC_REFL] THEN
     `?k'. i <= k' /\ k' < k /\ (nth_label k' path = WEvt ew)` by METIS_TAC [lem01] THEN
     FSTAC [LESS_OR_EQ] THEN
     FSTAC [] THEN
     METIS_TAC [LESS_TRANS]]);

val _ = export_theory ();
