(*        x86-TSO Semantics: HOL sources                                *)
(*                                                                      *)
(* Scott Owens, Susmit Sarkar, Peter Sewell                             *)
(*                                                                      *)
(*  Computer Laboratory, University of Cambridge                        *)
(*                                                                      *)
(*  Copyright 2007-2009                                                 *)
(*                                                                      *)
(* Redistribution and use in source and binary forms, with or without   *)
(* modification, are permitted provided that the following conditions   *)
(* are met:                                                             *)
(*                                                                      *)
(* 1. Redistributions of source code must retain the above copyright    *)
(*    notice, this list of conditions and the following disclaimer.     *)
(* 2. Redistributions in binary form must reproduce the above copyright *)
(*    notice, this list of conditions and the following disclaimer in   *)
(*    the documentation and/or other materials provided with the        *)
(*    distribution.                                                     *)
(* 3. The names of the authors may not be used to endorse or promote    *)
(*    products derived from this software without specific prior        *)
(*    written permission.                                               *)
(*                                                                      *)
(* THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS   *)
(* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED    *)
(* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE   *)
(* ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY      *)
(* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL   *)
(* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE    *)
(* GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS        *)
(* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,         *)
(* WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING            *)
(* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS   *)
(* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.         *)

(*
app load ["lts_memory_modelTheory", "utilLib"];
use "lts_erasureScript.sml";
*)


open HolKernel boolLib Parse bossLib wordsTheory;
open pred_setTheory listTheory combinTheory rich_listTheory;
open utilLib;
open lts_memory_modelTheory axiomatic_memory_modelTheory;
open HolDoc;
val _ = new_theory "lts_erasure";  

val list_eq_el = Q.prove (
`!l1 l2. (l1 = l2) = 
         (LENGTH l1 = LENGTH l2) /\ !n. n < LENGTH l1 ==> (EL n l1 = EL n l2)`,
Induct THEN
Cases_on `l2` THEN
RWTAC [] THEN
EQ_TAC THEN
RWTAC [] THENL
[Cases_on `n` THEN
     RWTAC [] THEN
     METIS_TAC [],
 METIS_TAC [EL, prim_recTheory.LESS_0, HD],
 METIS_TAC [EL, prim_recTheory.LESS_MONO, TL]]);

val map_split = Q.prove (
`!l1 l2 l3 f. (l1++l2 = MAP f l3) = ?l4 l5. (l3 = l4++l5) /\ (l1 = MAP f l4) /\ (l2 = MAP f l5)`,
Induct THEN RW_TAC list_ss [] THEN Cases_on `l3` THEN RW_TAC list_ss [] THEN EQ_TAC THEN
RW_TAC list_ss [] THENL
[MAP_EVERY Q.EXISTS_TAC [`h'::l4`, `l5`] THEN RW_TAC list_ss [],
 Cases_on `l4` THEN FULL_SIMP_TAC list_ss [],
 Cases_on `l4` THEN FULL_SIMP_TAC list_ss [] THEN METIS_TAC []]);

val el_last = Q.prove (
`!l l2 x. EL (LENGTH l) (l ++ [x] ++ l2) = x`,
Induct THEN
SRW_TAC [ARITH_ss] [EL_APPEND2]);

val el_last2 = Q.prove (
`!l x. EL (LENGTH l) (l ++ [x]) = x`,
Induct THEN
SRW_TAC [ARITH_ss] [EL_APPEND2]);

val lem01 = Q.prove (
`!f g x. OPTION_MAP f (OPTION_MAP g x) = OPTION_MAP (\x. f (g x)) x`,
Cases_on `x` THEN
RWTAC []);

val lem02 = Q.prove (
`!x. OPTION_MAP (\x. x) x = x`,
Cases_on `x` THEN
RWTAC []);

val erasure_init = Q.store_thm ("erasure_init",
`!sc. erase_state (evt_machine_init_state sc) (machine_init_state sc)`,
RWTAC [erase_state_def, evt_machine_init_state_def, machine_init_state_def,
       FUN_EQ_THM, EXTENSION] THEN
FSTAC [lem01, lem02]);

val erasure_states = Q.store_thm ("erasure_states",
`!s s'.
  erase_state s s'
  ==>
  (evt_machine_state_to_state_constraint s = 
   machine_state_to_state_constraint s')`,
RWTAC [erase_state_def,
       evt_machine_state_to_state_constraint_def, FUN_EQ_THM,
       machine_state_to_state_constraint_def, EXTENSION]);

val erase_not_blocked = Q.prove (
`!s1 s1' p. erase_state s1 s1' ==> (evt_not_blocked s1 p = not_blocked s1' p)`,
RWTAC [not_blocked_def, evt_not_blocked_def, erase_state_def]);

val erase_no_pending = Q.prove (
`!s1 s1' p a. 
  erase_state s1 s1' 
  ==> 
  (evt_no_pending (s1.eB p) a = no_pending (s1'.B p) a)`,
RWTAC [erase_state_def, evt_no_pending_def, no_pending_def] THEN
EQ_TAC THEN 
RWTAC [] THEN
Q.PAT_ASSUM `!p. P p /\ Q p` (STRIP_ASSUME_TAC o Q.SPEC `p`) THEN
FSTAC [MEM_EL, loc_def] THEN
RWTAC [] THEN
CCONTR_TAC THEN
FSTAC [] THEN
RWTAC [] THEN
RES_TAC THEN
FSTAC [] THEN
RWTAC [] THENL
[Q.PAT_ASSUM `!e. (!n. ~(n < LENGTH (s1.eB p)) \/ e <> EL n (s1.eB p)) \/ P p`
             (MP_TAC o Q.SPEC `EL n (s1.eB p)`) THEN
     RWTAC [] THEN
     METIS_TAC [],
 METIS_TAC []]);

val erase_buffer_empty = Q.prove (
`!s s' p.
  erase_state s s'
  ==>
  ((s.eB p = []) = (s'.B p = []))`,
RWTAC [erase_state_def] THEN
METIS_TAC [LENGTH_NIL]);

val erase_buffer = Q.prove (
`!s s' p.
  erase_state s s'
  ==>
  (s'.B p = MAP (\ew. case ew.action of Access d (Location_mem a) v -> (a, v)) (s.eB p))`,
RWTAC [erase_state_def, list_eq_el, EL_MAP] THEN
RES_TAC THEN
RWTAC []);

val erase_label_annotation = Q.store_thm ("erase_label_annotation",
`!l l' ew er_opt. 
  l IN annotated_labels l' ew er_opt
  ==>
  (l' = erase_label l)`,
Cases_on `l'` THEN
RWTAC [annotated_labels_def] THEN
RWTAC [erase_label_def] THEN
Cases_on `a` THEN
FSTAC [annotated_labels_def, erase_label_def] THEN
Cases_on `d` THEN
FSTAC [annotated_labels_def, erase_label_def]);

val erasure_thm1 = Q.store_thm ("erasure_thm1",
`!s1 l s2 s1'.
  evt_machine_trans s1 l s2 /\
  erase_state s1 s1'
  ==>
  ?s2'.
    erase_state s2 s2' /\
    machine_trans s1' (erase_label l) s2'`,
RWTAC [evt_machine_trans_cases, machine_trans_cases] THEN
RWTAC [erase_label_def, clause_name_def] THENL
[Q.EXISTS_TAC `s1'` THEN
     IMP_RES_TAC erase_no_pending THEN
     IMP_RES_TAC erase_not_blocked THEN
     RWTAC [] THEN
     FSTAC [erase_state_def],
 Q.EXISTS_TAC `s1'` THEN
     IMP_RES_TAC erase_not_blocked THEN
     IMP_RES_TAC erase_buffer THEN
     RWTAC [] THEN
     DISJ2_TAC THEN
     MAP_EVERY Q.EXISTS_TAC 
        [`MAP (\ew. case ew.action of Access d (Location_mem a) v -> (a, v)) b1`,
         `MAP (\ew. case ew.action of Access d (Location_mem a) v -> (a, v)) b2`] THEN
     RWTAC [] THEN
     FSTAC [no_pending_def, evt_no_pending_def, MEM_MAP] THEN
     RWTAC [] THEN
     CCONTR_TAC THEN
     FSTAC [] THEN
     `loc ew' <> SOME (Location_mem a)` by METIS_TAC [] THEN
     FSTAC [MEM_EL, erase_state_def] THEN
     RWTAC [] THEN
     `n < LENGTH (s1.eB (proc er))` by SRW_TAC [ARITH_ss] [] THEN
     RES_TAC THEN
     `(EL n b1).action = Access W (Location_mem a') v''` 
               by METIS_TAC [EL_APPEND1, APPEND_ASSOC] THEN
     FSTAC [loc_def],
 FSTAC [erase_state_def],
 IMP_RES_TAC erase_buffer THEN
     RWTAC [] THEN
     FSTAC [erase_state_def] THEN
     RWTAC [APPLY_UPDATE_THM] THEN
     Cases_on `n` THEN
     FSTAC [],
 RWTAC [GSYM RIGHT_EXISTS_AND_THM] THEN
     MAP_EVERY Q.EXISTS_TAC [`a`, `v`, `proc ew`] THEN
     IMP_RES_TAC erase_not_blocked THEN
     IMP_RES_TAC erase_buffer THEN
     RWTAC [] THEN
     FSTAC [erase_state_def] THEN
     RWTAC [APPLY_UPDATE_THM, EL_MAP] THENL
     [`n < LENGTH (s1.eB (proc ew))`
                by (SRW_TAC [ARITH_ss] []) THEN
          RES_TAC THEN
          RWTAC [] THEN
          POP_ASSUM MP_TAC THEN
          RWTAC [EL_MAP] THEN
          POP_ASSUM MP_TAC THEN
          RWTAC [EL_APPEND1] THEN
          METIS_TAC [EL_APPEND1],
      `LENGTH b < LENGTH (s1.eB (proc ew))`
                by (SRW_TAC [ARITH_ss] []) THEN
          RES_TAC THEN
          RWTAC []],
 FSTAC [erase_state_def, APPLY_UPDATE_THM] THEN
     RWTAC [APPLY_UPDATE_THM] THEN
     RWTAC [],
 IMP_RES_TAC erase_buffer_empty THEN
     FSTAC [erase_state_def],
 FSTAC [erase_state_def],
 FSTAC [erase_state_def],
 IMP_RES_TAC erase_buffer_empty THEN
     FSTAC [erase_state_def],
 FSTAC [erase_state_def],
 FSTAC [erase_state_def],
 IMP_RES_TAC erase_buffer_empty THEN
     FSTAC [erase_state_def]]);

val erasure_thm2 = Q.store_thm ("erasure_thm2",
`!s1' l' s2' s1.
  machine_trans s1' l' s2' /\
  erase_state s1 s1'
  ==>
  ?ew ew_opt. 
    !l. l IN annotated_labels l' ew ew_opt ==>
      ?s2. erase_state s2 s2' /\ evt_machine_trans s1 l s2`,
RWTAC [evt_machine_trans_cases, machine_trans_cases, clause_name_def] THEN
FSTAC [annotated_labels_def] THENL
[Q.EXISTS_TAC `SND (THE (s1.eM a))` THEN
     RWTAC [] THEN
     IMP_RES_TAC erase_no_pending THEN
     IMP_RES_TAC erase_not_blocked THEN
     RWTAC [] THEN
     FSTAC [erase_state_def] THEN
     METIS_TAC [],
 Q.EXISTS_TAC `SOME (EL (LENGTH b1) (s1.eB p))` THEN
     RWTAC [] THEN
     Q.EXISTS_TAC `s1` THEN
     IMP_RES_TAC erase_not_blocked THEN
     IMP_RES_TAC erase_buffer THEN
     RWTAC [] THEN
     FSTAC [map_split] THEN
     Cases_on `l5'` THEN
     FSTAC [el_last] THEN
     DISJ2_TAC THEN
     RWTAC [] THEN
     FSTAC [erase_state_def] THENL
     [`LENGTH l4' < LENGTH (s1.eB (proc e))` by SRW_TAC [ARITH_ss] [] THEN 
          RES_TAC THEN
          `EL (LENGTH l4') (s1.eB (proc e)) = h` by RWTAC [el_last] THEN
          FSTAC [],
      MAP_EVERY Q.EXISTS_TAC [`l4'`, `l5`] THEN
          RWTAC [] THEN
          FSTAC [no_pending_def, evt_no_pending_def, MEM_MAP] THEN
          RWTAC [] THEN
          CCONTR_TAC THEN
          FSTAC [MEM_EL, erase_state_def] THEN
          RWTAC [] THEN
          `n < LENGTH (s1.eB (proc e))` by SRW_TAC [ARITH_ss] [] THEN
          RES_TAC THEN
          `(EL n l4').action = Access W (Location_mem a') v'` 
                    by METIS_TAC [EL_APPEND1, APPEND_ASSOC] THEN
          FSTAC [loc_def] THEN
          Q.PAT_ASSUM `!(v':bool[32]) (ew:'a event). P v' ew` 
                      (MP_TAC o Q.SPECL [`v'`, `EL n l4'`]) THEN
          RWTAC [] THEN
          METIS_TAC []],
 Q.EXISTS_TAC `SND (THE (s1.eR p r))` THEN
     RWTAC [] THEN
     FSTAC [erase_state_def],
 RWTAC [] THEN
     IMP_RES_TAC erase_buffer THEN
     RWTAC [] THEN
     FSTAC [erase_state_def] THEN
     RWTAC [APPLY_UPDATE_THM] THEN
     Cases_on `n` THEN
     FSTAC [],
 RWTAC [GSYM RIGHT_EXISTS_AND_THM] THEN
     IMP_RES_TAC erase_not_blocked THEN
     IMP_RES_TAC erase_buffer THEN
     RWTAC [] THEN
     FSTAC [map_split] THEN
     Cases_on `l5` THEN
     FSTAC [erase_state_def] THEN
     MAP_EVERY Q.EXISTS_TAC [`h`, `a`, `v`, `l4`] THEN
     RWTAC [] THEN
     RWTAC [APPLY_UPDATE_THM, EL_MAP] THEN
     FSTAC [APPLY_UPDATE_THM] THEN
     TRY (`LENGTH l4 < LENGTH (s1.eB p)` 
                  by (SRW_TAC [ARITH_ss] [] THEN 
                      NO_TAC) THEN
          `EL (LENGTH l4) (s1.eB p) = h` 
                  by (RWTAC [el_last2] THEN
                      NO_TAC)) THENL
     [METIS_TAC [],
      METIS_TAC [],
      `n < LENGTH (s1.eB (proc h))`
                by (SRW_TAC [ARITH_ss] []) THEN
          RES_TAC THEN
          RWTAC [] THEN
          POP_ASSUM MP_TAC THEN
          RWTAC [EL_MAP] THEN
          POP_ASSUM MP_TAC THEN
          RWTAC [EL_APPEND1] THEN
          METIS_TAC [EL_APPEND1],
      METIS_TAC [],
      METIS_TAC [],
      METIS_TAC [],
      RES_TAC THEN
          RWTAC [] THEN
          FSTAC [],
      METIS_TAC []],
 RWTAC [] THEN
     FSTAC [erase_state_def, APPLY_UPDATE_THM] THEN 
     RWTAC [] THEN
     FSTAC [APPLY_UPDATE_THM] THEN
     RWTAC [],
 RWTAC [] THEN
     IMP_RES_TAC erase_buffer_empty THEN
     FSTAC [erase_state_def],
 RWTAC [] THEN
     Cases_on `b` THEN
     FSTAC [erase_state_def],
 RWTAC [] THEN
     IMP_RES_TAC erase_buffer_empty THEN
     FSTAC [erase_state_def],
 RWTAC [] THEN
     IMP_RES_TAC erase_buffer_empty THEN
     FSTAC [erase_state_def]]);

val _ = export_theory();
