(*        x86-TSO Semantics: HOL sources                                *)
(*                                                                      *)
(* Scott Owens, Susmit Sarkar, Peter Sewell                             *)
(*                                                                      *)
(*  Computer Laboratory, University of Cambridge                        *)
(*                                                                      *)
(*  Copyright 2007-2009                                                 *)
(*                                                                      *)
(* Redistribution and use in source and binary forms, with or without   *)
(* modification, are permitted provided that the following conditions   *)
(* are met:                                                             *)
(*                                                                      *)
(* 1. Redistributions of source code must retain the above copyright    *)
(*    notice, this list of conditions and the following disclaimer.     *)
(* 2. Redistributions in binary form must reproduce the above copyright *)
(*    notice, this list of conditions and the following disclaimer in   *)
(*    the documentation and/or other materials provided with the        *)
(*    distribution.                                                     *)
(* 3. The names of the authors may not be used to endorse or promote    *)
(*    products derived from this software without specific prior        *)
(*    written permission.                                               *)
(*                                                                      *)
(* THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS   *)
(* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED    *)
(* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE   *)
(* ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY      *)
(* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL   *)
(* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE    *)
(* GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS        *)
(* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,         *)
(* WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING            *)
(* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS   *)
(* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.         *)

(*
app load ["lts_memory_modelTheory", "axiomatic_memory_modelTheory",
          "typesettingTheory", "utilLib", "HolDoc",
          "moretypesettingTheory"];
use "correct_typesettingScript.sml";
*)


open HolKernel boolLib Parse bossLib;
open lts_memory_modelTheory axiomatic_memory_modelTheory;
open typesettingTheory moretypesettingTheory utilLib;

open HolDoc;
val _ = new_theory "correct_typesetting";

val previous_writes_typesetting_thm = Q.store_thm ("previous_writes_typesetting_thm",
`typesetting$previous_writes = 
 axiomatic_memory_model$previous_writes`,
RWTAC [typesettingTheory.previous_writes_def,
       axiomatic_memory_modelTheory.previous_writes_def,
       myIN_def, FUN_EQ_THM]);

val check_rfmap_written_typesetting_thm = Q.store_thm ("check_rfmap_written_typesetting_thm",
`typesetting$check_rfmap_written = 
 axiomatic_memory_model$check_rfmap_written`,
RWTAC [typesettingTheory.check_rfmap_written_def,
       axiomatic_memory_modelTheory.check_rfmap_written_def,
       myORDER_def, FUN_EQ_THM, previous_writes_typesetting_thm]);

val check_rfmap_initial_typesetting_thm = Q.store_thm ("check_rfmap_initial_typesetting_thm",
`typesetting$check_rfmap_initial = 
 axiomatic_memory_model$check_rfmap_initial`,
RWTAC [typesettingTheory.check_rfmap_initial_def,
       axiomatic_memory_modelTheory.check_rfmap_initial_def,
       myORDER_def, FUN_EQ_THM, previous_writes_typesetting_thm]);

val valid_ex_typesetting_thm = Q.store_thm ("valid_ex_typesetting_thm",
`valid_execution E X =
    ve1 E X /\
    ve2 E X /\
    ve3 E X /\
    ve4 E X /\
    ve5 E X /\
    ve6 E X /\
    ve7 E X /\
    ve8 E X /\
    ve9 E X /\
    ve10 E X /\
    check_rfmap_written E X /\
    check_rfmap_initial E X`,
RWTAC [valid_execution_def, ve1_def, ve2_def, ve3_def, ve4_def, ve5_def,
       ve6_def, ve7_def, ve8_def, ve9_def, ve10_def, myIN_def,
       myORDER_def, myNOTIN_def, previous_writes_typesetting_thm,
       check_rfmap_written_typesetting_thm, 
       check_rfmap_initial_typesetting_thm, IN_DEF]);

val lts_typesetting_thm = Q.store_thm ("lts_typesetting_thm",
`!s l s' x y z. machine_trans s l s' = x /* x,z */ s -- l --> s'`,
RWTAC [machine_trans_cases, host_redn0_cases, clause_name_def,
       UPD_def, machine_state_component_equality] THEN
EQ_TAC THEN
RWTAC [] THEN
METIS_TAC []);

val _ = export_theory ();
