Require Import Ensembles.
Definition set := Ensemble.
Set Implicit Arguments.

Axiom excluded_middle :
  forall (A:Set) (s:set A),
  ~(exists e, In _ s e) \/ (exists e, In _ s e).

Lemma empty_set_is_empty (A:Set) (s:set A):
  ~(exists e, In _ s e) <-> Same_set _ (Empty_set _) s.
Proof.
intros A s.
split.
(*->*)
intros Hnon; unfold Same_set.
unfold not in Hnon; unfold In in Hnon;
unfold Included.
split; intros x Hin_empty.
elim Hnon; exists x; inversion Hin_empty.
destruct Hnon; exists x; apply Hin_empty.
(*<-*)
intros Hsame; unfold not; unfold In.
intros Hexists.
unfold Same_set in Hsame.
unfold Included in Hsame.
destruct Hsame as [Hemp_s Hs_emp].
destruct Hexists as [e Hse].
assert (In _ (Empty_set _) e).
apply (Hs_emp e Hse).
inversion H.
Qed.

Lemma empty_set_is_empty_dir (A:Set) (s:set A):
  ~(exists e, In _ s e) -> Same_set _ s (Empty_set _).
Proof.
Admitted.

Lemma empty_set_is_empty_back (A:Set) (s:set A):
  Same_set _ s (Empty_set _) ->  ~(exists e, In _ s e).
Proof.
Admitted.

Lemma non_empty_set_is_non_empty_dir (A:Set) (s:set A):
  (exists e, In _ s e) -> ~(Same_set _ s (Empty_set _)).
Proof.
Admitted.

Lemma incl_union (A:Set) (s1 s2 s:set A) :
  Included _ s1 s -> Included _ s2 s -> Included _ (Union _ s1 s2) s.
Proof.
unfold Included; intros.
inversion H1.
(*s1 x*)
apply H.
apply H2.
(*s2 x*)
apply H0.
apply H2.
Qed.

Lemma incl_union_in (A:Set) (s1 s2 s:set A) :
  Included _ s1 s -> Included _ s2 s -> 
  (forall x, In _ (Union _ s1 s2) x -> In _ s x).
Proof.
apply incl_union.
Qed.

Lemma incl_union_left_in (A:Set) (s1 s2 : set A) :
  forall x, In _ s1 x -> In _ (Union _ s1 s2) x.
Proof.
unfold In; intros.
apply Union_introl.
exact H.
Qed.

Lemma incl_union_right_in (A:Set) (s1 s2 : set A) :
  forall x, In _ s2 x -> In _ (Union _ s1 s2) x.
Proof.
unfold In; intros.
apply Union_intror.
exact H.
Qed.

Lemma incl_union_back (A:Set) (s1 s2 s: set A) : 
  Included _ (Union _ s1 s2) s -> Included _ s1 s /\ Included _ s2 s.
Proof.
unfold Included; intros.
split.
intros.
apply (H x).
apply incl_union_left_in; exact H0.
intros.
apply (H x).
apply incl_union_right_in; exact H0.
Qed.

Lemma incl_union_back_in (A:Set) (s1 s2 s: set A) : 
  Included _ (Union _ s1 s2) s -> 
  (forall x, In _ (Union _ s1 s2) x -> In _ s x).
Proof.
unfold Included; intros.
apply H.
exact H0.
Qed.

Lemma incl_trans (A:Set) (s1 s2 s3:set A) :
  Included _ s1 s2 -> Included _ s2 s3 -> Included _ s1 s3.
Proof.
unfold Included; unfold In; intros.
apply (H0 x (H x H1)).
Qed.

(** Domain and range *)
Definition domain (A B:Set) (e:set (A*B)) : set B :=
  fun y => exists x, In _ e (x,y).

Definition range (A B:Set) (e:set (A*B)) : set A :=
  fun x => exists y, In _ e (x,y).

Lemma range_is_range (A B:Set) (e:set (A*B)) (x:A) :
  (exists y, In _ e (x,y)) -> In _ (range e) x.
Proof.
unfold range; unfold In; trivial.
Qed.

Lemma domain_is_domain (A B:Set) (e:set (A*B)) (y:B) :
  (exists x, In _ e (x,y)) -> In _ (domain e) y.
Proof.
unfold domain; unfold In; trivial.
Qed.

(** Linear and linear strict orders *)
Definition linear_strict_order (A:Set) (r:set (A*A)) (xs:set A) : Prop :=
  Included _ (Union _ (domain r) (range r)) xs /\
  (*transitivity*)
  (forall x1 x2 x3, (In _ r (x1,x2)) /\ (In _ r (x2,x3)) -> (In _ r (x1,x3))) /\
  (*irreflexivity*)
  (forall x, ~(In _ r (x,x))) /\
  (*linear on xs*)
  (forall x1 x2, (x1 <> x2) -> (In _ xs x1) -> (In _ xs x2) -> ((In _ r (x1,x2)) \/ (In _ r (x2,x1)))).

Definition linear_order (A:Set) (r:set (A*A)) (xs:set A) : Prop :=
  Included _ (Union _ (domain r) (range r)) xs /\
  (*transitivity*)
  (forall x1 x2 x3, (In _ r (x1,x2)) /\ (In _ r (x2,x3)) -> (In _ r (x1,x3))) /\
  (*antisymetry*)
  (forall x1 x2, (In _ r (x1,x2)) /\ (In _ r (x2,x1)) -> x1=x2) /\
  (*linear on xs*)
  (forall x1 x2, (In _ xs x1) -> (In _ xs x2) -> ((In _ r (x1,x2)) \/ (In _ r (x2,x1)))).

Definition linearisations_strict (A:Set) (xs:set A) : set (set (A*A)) :=
  fun r => linear_strict_order r xs.

Definition linearisations (A:Set) (xs:set A) : set (set (A*A)) :=
  fun r => linear_order r xs.

Lemma linear_prop_cart (A:Set) (so:set (A*A)) (s:set A) (x:A) :
  (linear_order so s) -> In _ s x -> In _ s x -> In _ so (x,x).
Proof.
unfold linear_order; unfold linear_strict_order; unfold In; intros. 
destruct H as [Hincl H].
destruct H as [Htrans H].
destruct H as [Hrefl Hlin].
assert (so (x,x) \/ so (x,x)).
apply (Hlin x x H0 H1).
inversion H.
exact H2.
exact H2.
Qed.

Lemma linear_order_trans (A:Set) (so:set (A*A)) (x1 x2 x3:A) :
  (exists s, (linear_order so s)) ->
  In _ so (x1,x2) -> In _ so (x2,x3) -> In _ so (x1,x3).
Proof.
intros A so x1 x2 x3 Hexists H12 H23.
unfold linear_order in Hexists.
destruct Hexists as [s He].
destruct He as [Hincl He].
destruct He as [Htrans He].
eapply Htrans.
split; [apply H12 | apply H23].
Qed.

Lemma linear_strict_order_trans (A:Set) (so:set (A*A)) (x1 x2 x3:A) :
  (exists s, (linear_strict_order so s)) ->
  In _ so (x1,x2) -> In _ so (x2,x3) -> In _ so (x1,x3).
Proof.
unfold linear_strict_order; unfold In; intros. 
repeat (destruct H); destruct H2.
apply (H2 x1 x2 x3).
split. 
exact H0.
exact H1.
Qed.

Lemma incl_lin_strict_order_range (A:Set) (so: set (A*A)) (s:set A) (x1 x2:A) :
  linear_strict_order so s -> In _ so (x1,x2) -> In _ s x1.
Proof.
unfold linear_strict_order; unfold In; intros.
assert (In _ (range so) x1).
apply range_is_range.
exists x2; apply H0.
assert (In _ (Union A (domain so) (range so)) x1).
apply incl_union_right_in; exact H1.
repeat (destruct H).
unfold Included in H; apply H; exact H2.
Qed.

Lemma incl_lin_strict_order_domain (A:Set) (so: set (A*A)) (s:set A) (x1 x2:A) :
  linear_strict_order so s -> In _ so (x1,x2) -> In _ s x2.
Proof.
unfold linear_strict_order; unfold In; intros.
assert (In _ (domain so) x2).
apply domain_is_domain.
exists x1; apply H0.
assert (In _ (Union A (domain so) (range so)) x2).
apply incl_union_left_in; exact H1.
repeat (destruct H).
unfold Included in H; apply H; exact H2.
Qed.

Lemma incl_lin_order_range (A:Set) (so: set (A*A)) (s:set A) (x1 x2:A) :
  linear_order so s -> In _ so (x1,x2) -> In _ s x1.
Proof.
unfold linear_order; unfold linear_strict_order; unfold In; intros.
assert (In _ (range so) x1).
apply range_is_range.
exists x2; apply H0.
assert (In _ (Union A (domain so) (range so)) x1).
apply incl_union_right_in; exact H1.
repeat (destruct H).
unfold Included in H; apply H; exact H2.
Qed.

Lemma incl_lin_order_domain (A:Set) (so: set (A*A)) (s:set A) (x1 x2:A) :
  linear_order so s -> In _ so (x1,x2) -> In _ s x2.
Proof.
unfold linear_order; unfold linear_strict_order; unfold In; intros.
assert (In _ (domain so) x2).
apply domain_is_domain.
exists x1; apply H0.
assert (In _ (Union A (domain so) (range so)) x2).
apply incl_union_left_in; exact H1.
repeat (destruct H).
unfold Included in H; apply H; exact H2.
Qed.

Axiom todo: forall P,P. 

Lemma refined_lin_strict_still_strict (A:Set) (so sor:set (A*A)) (s:set A) :
  linear_strict_order so s ->
  Included _ sor so ->
  linear_strict_order sor s.
Proof.
unfold linear_strict_order; unfold Included.
intros A so sor s Hlin_strict_so_s Hincl_sor_so.
split.
(*incl*)
intros x Hin.
destruct Hlin_strict_so_s as [Hincl Hrest].
apply Hincl.
inversion Hin.
apply incl_union_left_in.
apply todo.
apply incl_union_right_in.
apply todo.
split.
(*trans*)
intros x1 x2 x3 H123.
Admitted.
 
(** Transitive closure *)
Inductive transitive_closure (A:Type) (e:set (A*A)) : set (A*A) :=
    | t_step : forall x y, In _ e (x,y) -> In _ (transitive_closure e) (x,y)
    | t_trans : forall x y z, In _ (transitive_closure e) (x,y) -> 
                     In _ (transitive_closure e) (y,z) -> 
                     In _ (transitive_closure e) (x,z).

(** Strict transitive closure *)
(*Check me*)
Inductive sTC (A:Set) (r:set (A*A)) : set (A*A) := 
  | stc_step : forall x y, In _ r (x,y) -> In _ (sTC r) (x,y)
  | stc_ind : (forall x y,
      (exists z, In _ (sTC r) (x, z) /\ In _ (sTC r) (z, y)) -> In _ (sTC r) (x, y)).

(** Acyclicity *)
Definition acyclic (A:Set) (r: set (A*A)) : Prop :=
  forall x, ~(In _ (sTC r) (x,x)).

Lemma union_preserves_acyclicity (A:Set) (r s : set (A*A)) :
  acyclic (Union _ r s) -> acyclic (Union _ (Union _ r s) s).
Proof.
unfold acyclic; unfold not;
intros A r s Hacu x Hacuu;
apply (Hacu x).
Admitted.

Lemma incl_preserves_acyclicity (A:Set) (s1 s2 s : set (A*A)) :
  Included _ s1 s2 ->
  acyclic (Union _ s s2) ->
  acyclic (Union _ s s1).
Proof.
Admitted.

Lemma incl_implies_acyclicity (A:Set) (s1 s2:set (A*A)):
  Included _ s2 s1 ->
  acyclic (Union _ s1 s2).
Proof.
Admitted.

(** Cartesian product of two sets *)
Definition cartesian (A B:Set) (sa:set A) (sb:set B) : set (A*B) :=
  fun c => match c with (a,b) =>
  In _ sa a /\ In _ sb b end.

(** Restriction *)
Definition rrestrict (A:Set) (r:set (A*A)) (s:set A) : set (A*A) := 
  fun c => match c with (x, y) => 
    In _ r (x, y) /\ In _ s x /\ In _ s y end.

Lemma rrestrict_preserves_linear_strict_order (A:Set) (so:set (A*A)) (r:set A) (s:set A):
  linear_strict_order so s -> linear_strict_order (rrestrict so r) s.
Proof.
unfold linear_strict_order; unfold rrestrict.
intros.
Admitted.

Lemma rrestrict_preserves_linear_order (A:Set) (so:set (A*A)) (r:set A) (s:set A):
  linear_order so s -> linear_order (rrestrict so r) s.
Proof.
(* fix me:
unfold linear_order;unfold linear_strict_order; unfold rrestrict.
intros.
repeat split; repeat (destruct H).
(*9*)
unfold Included; intros.
unfold Included in H.
apply H.
inversion H2.
(*domain*)
unfold In in H3.
unfold In.
inversion H3.
unfold In in H5.
destruct H5.
assert (In _ (domain so) x).
apply domain_is_domain.
exists x1.
exact H5.
apply incl_union_left_in; exact H7.
(*range*)
unfold In in H3.
unfold In.
inversion H3.
unfold In in H5.
destruct H5.
assert (In _ (range so) x).
apply range_is_range.
exists x1.
exact H5.
apply incl_union_right_in; exact H7.
(*8*)
*)
Admitted.

Lemma rrestrict_prop (A:Set) (ps:set (A*A)) (s:set A) :
  Included _ (rrestrict ps s) ps.
Proof.
unfold Included; unfold rrestrict; unfold In; intros.
case_eq x; intros.
rewrite H0 in H. 
destruct H; exact H.
Qed.

Lemma rrestrict_prop_in (A:Set) (ps:set (A*A)) (s:set A) :
  forall c, In _ (rrestrict ps s) c -> In _ ps c.
Proof.
unfold rrestrict; unfold In; intros.
case_eq c; intros; rewrite H0 in H.
destruct H; exact H.
Qed.

Lemma rrestrict_cartesian_prop (A:Set) (ps:set (A*A)) (s:set A) :
 Included _ (rrestrict ps s) (cartesian s s).
Proof.
unfold Included; unfold rrestrict; unfold cartesian; unfold In; intros.
case_eq x; intros.
rewrite H0 in H. 
destruct H; exact H1.
Qed.

Lemma rrestrict_domain_prop (A:Set) (ps:set (A*A)) (s:set A) :
  Included _ (domain (rrestrict ps s)) s.
Proof.
unfold Included; unfold rrestrict; unfold domain; unfold In; intros.
repeat (destruct H); destruct H0.
exact H1.
Qed.

Lemma rrestrict_domain_prop_in (A:Set) (ps:set (A*A)) (s:set A) :
  forall x, In _ (domain (rrestrict ps s)) x -> In _ s x.
Proof.
apply rrestrict_domain_prop.
Qed.

Lemma rrestrict_range_prop (A:Set) (ps:set (A*A)) (s:set A) :
  Included _ (range (rrestrict ps s)) s.
Proof.
unfold Included; unfold rrestrict; unfold range; unfold In; intros.
repeat (destruct H); destruct H0.
exact H0.
Qed.

Lemma rrestrict_range_prop_in (A:Set) (ps:set (A*A)) (s:set A) :
  forall x, In _ (range (rrestrict ps s)) x -> In _ s x.
Proof.
apply rrestrict_range_prop.
Qed.

Lemma rrestrict_to_strict_order_makes_you_strict (A:Set) (evts s: set A) (so: set (A*A)) :
  Included _ s evts ->
  linear_strict_order so evts -> 
  linear_strict_order (rrestrict so s) s.
Proof.
Admitted.

Lemma rrestrict_in_both (A:Set) (s1 : set (A*A)) (s2:set A) (x1 x2:A) :
  In _ s1 (x1,x2) ->
  In _ s2 x1 ->
  In _ s2 x2 ->
  In _ (rrestrict s1 s2) (x1,x2).
Proof.
Admitted.

(** Maximal elements *)
Definition maximal_elements (A:Set) (xs:set A) (r:set (A*A)) : set A :=
  fun x => In _ xs x /\ forall x', In _ xs x'/\ In _ r (x, x') -> (x = x').

Lemma maximal_preserves_incl (A:Set) (xs:set A) (r:set (A*A)) (e:A):
  In _ (maximal_elements xs r) e ->
  In _ xs e.
Proof.
unfold maximal_elements; unfold In.
intros A xs r e Hmax.
destruct Hmax as [Hxs].
exact Hxs.
Qed.

(** Strictness *)
Definition strict (A:Set) (r:set (A*A)) := 
  fun c => match c with (x, y) =>
  In _ r (x, y) /\ ~(x = y) end.

Unset Implicit Arguments.
