(*========================================================================*)
(*                                                                        *)
(*             ppcmem model exploration tool                              *)
(*                                                                        *)
(*          Susmit Sarkar, University of Cambridge                        *)
(*          Peter Sewell, University of Cambridge                         *)
(*          Luc Maranget, INRIA Rocquencourt                              *)
(*          Pankaj Pawan, INRIA Rocquencourt                              *)
(*          Francesco Zappa Nardelli, INRIA Rocquencourt                  *)
(*                                                                        *)
(*  This file is copyright 2010,2011 Institut National de Recherche en    *)
(*  Informatique et en Automatique (INRIA), Susmit Sarkar, Peter          *)
(*  Sewell, and Pankaj Pawan                                              *)
(*                                                                        *)
(*  All rights reserved.                                                  *)
(*                                                                        *)
(*                                                                        *)
(*                                                                        *)
(*                                                                        *)
(*                                                                        *)
(*========================================================================*)

(* val black : int *)
(* val red : int *)
(* val green : int *)
(* val yellow : int *)
(* val blue : int *)
(* val magenta : int *)
(* val cyan : int *)
(* val white : int *)
(* val _reset : string *)
(* val _color : int -> int -> string *)
(* val _w : string *)
(* val _r : string *)
(* val _b : string *)
(* val _g : string *)
(* val col_wrap : string -> string -> string *)
val col_red : string -> string
val linebreak_init : unit -> unit
(* val col_black : string -> string *)
(* val col_green : string -> string *)
(* val col_yellow : string -> string *)
(* val col_blue : string -> string *)
(* val col_magenta : string -> string *)
(* val col_cyan : string -> string *)
(* val col_white : string -> string *)
(* val pp_old_raw : 'a -> 'b -> string *)
(* val pp_new_raw : Globals.ppmode -> string -> string *)
(* val pp_error : Globals.ppmode -> string -> string *)
(* val pp_tran_id : Globals.ppmode -> string -> string *)
(* val pp_oldnew_raw : Globals.ppmode -> 'a -> string -> string *)
(* val pp_oldnew : Globals.ppmode -> string -> string -> string *)
(* val pp_oldnew_string_list : *)
(*   Globals.ppmode -> string list -> string list -> string list *)
(* val pp_oldnew_string_list_rev : *)
(*   Globals.ppmode -> string list -> string list -> string list *)
(* val pp_barrier_type : MachineDefTypes.barrier_type -> string *)
(* val pp_cst : MachineDefValue.cst -> string *)
val pp_value : MachineDefValue.value -> string


val initialise_pretty_event_map : MachineDefTypes.w_eiid list -> MachineDefTypes.system_state -> unit

(* val iregs : (MachineDefTypes.ireg * string) list *)
(* val pp_ireg : MachineDefTypes.ireg -> string *)
(* val pp_reg : MachineDefTypes.reg -> string *)
(* val pp_crf : int -> string *)
(* val pp_op : MachineDefValue.op -> string *)
(* val pp_op1 : MachineDefValue.op1 -> string *)
(* val pp_k : int -> string *)
(* val pp_idx : int -> string *)
(* val ppi_index_mode : *)
(*   string -> *)
(*   MachineDefTypes.reg -> MachineDefTypes.reg -> MachineDefTypes.reg -> string *)
(* val ppi_imm_index_mode : *)
(*   string -> MachineDefTypes.reg -> int -> MachineDefTypes.reg -> string *)
(* val ppi_imm_instr : *)
(*   string -> MachineDefTypes.reg -> MachineDefTypes.reg -> int -> string *)
(* val ppi_ri : string -> MachineDefTypes.reg -> int -> string *)
(* val ppi_rr : string -> MachineDefTypes.reg -> MachineDefTypes.reg -> string *)
(* val pp_op3 : *)
(*   string -> *)
(*   MachineDefTypes.setcr0 -> *)
(*   MachineDefTypes.reg -> MachineDefTypes.reg -> MachineDefTypes.reg -> string *)
(* val pp_cond : MachineDefTypes.cond -> string *)
(* val pp_instruction : MachineDefTypes.instruction -> string *)
(* val pretty_write_id_hashtbl : (MachineDefTypes.eiid, string) Hashtbl.t *)
(* val pretty_write_id_next : int ref *)
(* val pretty_init_write_id_next : int ref *)
(* val pp_pretty_write_id : MachineDefTypes.eiid -> string *)
val pp_trans : Globals.ppmode -> MachineDefTypes.trans -> string
(* val option_map : ('a -> 'b MachineDefUtils.option) -> 'a list -> 'b list *)
(* val reflexive_domain : ('a -> 'b -> bool) -> ('a * 'b) list -> 'a list *)
(* val irreflexive_reduction : *)
(*   ('a -> 'b -> bool) -> ('a * 'b) list -> ('a * 'b) list *)
(* val pset_checked_diff : 'a Pset.set -> 'a Pset.set -> 'a Pset.set *)
(* val check_list_prefix : 'a list -> 'a list -> unit *)
(* val checked_list_suffix : 'a list -> 'a list -> 'a list *)
(* val is_ss_transition : Types.trans -> bool *)
(* val is_instruction_instance_transition : *)
(*   MachineDefTypes.thread_id -> *)
(*   MachineDefTypes.instruction_instance -> Types.trans -> bool *)
(* val make_ui_storage_subsystem_state : *)
(*   MachineDefTypes.storage_subsystem_state -> *)
(*   MachineDefTypes.storage_subsystem_state -> *)
(*   Types.ui_trans list -> Types.ui_storage_subsystem_state *)
(* val make_ui_instruction_instance : *)
(*   MachineDefTypes.instruction_instance -> *)
(*   MachineDefTypes.instruction_instance -> *)
(*   Types.ui_instruction_instance_kind -> Types.ui_instruction_instance *)
(* val make_ui_thread_state : *)
(*   MachineDefTypes.thread_id -> *)
(*   MachineDefTypes.thread_state -> *)
(*   MachineDefTypes.thread_state -> *)
(*   Types.ui_trans list -> Types.ui_thread_state *)
(* val make_ui_system_state : *)
(*   MachineDefTypes.system_state -> *)
(*   MachineDefTypes.system_state -> *)
(*   Types.ui_trans list -> Types.ui_system_state *)
val make_ui_system_state_opt :
   MachineDefTypes.system_state option -> 
   MachineDefTypes.system_state -> 
   Types.ui_trans list -> Types.ui_system_state 
(* val colour_old_new : Globals.ppmode -> Types.ppcolour -> string -> string *)
val colour_tran_id : Globals.ppmode -> string -> string
(* val pp_write_uncoloured : 'a -> MachineDefTypes.write -> string *)
(* val pp_write : *)
(*   Globals.ppmode -> Types.ppcolour -> MachineDefTypes.write -> string *)
(* val pp_barrier : *)
(*   Globals.ppmode -> Types.ppcolour -> MachineDefTypes.barrier -> string *)
(* val pp_tracked_event : *)
(*   Globals.ppmode -> Types.ppcolour -> MachineDefTypes.tracked_event -> string *)
(* val pp_coherence_edge : *)
(*   Globals.ppmode -> *)
(*   Types.ppcolour -> MachineDefTypes.write * MachineDefTypes.write -> string *)
(* val pp_list_sep : Globals.ppmode -> Types.ppcolour -> string *)
(* val pp_list : *)
(*   Globals.ppmode -> *)
(*   Types.ppcolour -> *)
(*   (Globals.ppmode -> Types.ppcolour -> 'a -> string) -> 'a list -> string *)
(* val pp_list_core_old_new : *)
(*   Globals.ppmode -> *)
(*   (Globals.ppmode -> Types.ppcolour -> 'a -> string) -> *)
(*   'a list -> 'a list -> string *)
(* val pp_list_old_new : *)
(*   Globals.ppmode -> *)
(*   (Globals.ppmode -> Types.ppcolour -> 'a -> string) -> *)
(*   'a list -> 'a list -> string *)
(* val pp_leftbrace : Globals.ppmode -> string *)
(* val pp_rightbrace : Globals.ppmode -> string *)
(* val pp_set_old_new : *)
(*   Globals.ppmode -> *)
(*   (Globals.ppmode -> Types.ppcolour -> 'a -> string) -> *)
(*   'a list -> 'a list -> string *)
(* val pp_thread_trans_brief : 'a -> Types.trans -> string *)
(* val pp_cand : Globals.ppmode -> int * Types.trans -> string *)
(* val pp_ui_storage_subsystem_state : *)
(*   Globals.ppmode -> *)
(*   MachineDefTypes.model_params -> Types.ui_storage_subsystem_state -> string *)
(* val pp_v_soln : *)
(*   Globals.ppmode -> *)
(*   MachineDefValue.solution -> *)
(*   MachineDefValue.value -> *)
(*   MachineDefValue.solution -> MachineDefValue.value -> string *)
(* val pp_action : *)
(*   Globals.ppmode -> *)
(*   MachineDefValue.solution -> *)
(*   MachineDefTypes.action -> *)
(*   MachineDefValue.solution -> MachineDefTypes.action -> string *)
(* val pp_sem_state : Globals.ppmode -> Types.ui_sem_state -> string *)
(* val pp_reaches : *)
(*   Globals.ppmode -> *)
(*   MachineDefTypes.reaches_by -> *)
(*   MachineDefTypes.reaches_by -> *)
(*   MachineDefValue.solution -> MachineDefValue.solution -> string *)
(* val pp_prev0 : *)
(*   Globals.ppmode -> *)
(*   (int * MachineDefTypes.reaches_by) MachineDefUtils.option -> *)
(*   (int * MachineDefTypes.reaches_by) MachineDefUtils.option -> *)
(*   MachineDefValue.solution -> MachineDefValue.solution -> string *)
(* val pp_ui_instruction_instance : *)
(*   Globals.ppmode -> int -> Types.ui_instruction_instance -> string *)
(* val pp_ui_thread_state : Globals.ppmode -> Types.ui_thread_state -> string *)
val pp_ui_system_state : Globals.ppmode -> Types.ui_system_state -> string
