(** r1fail
 * DOC string to bool unmarshal failure 
 * FAM readme
 * RUNFAIL .*Marshal type mismatch.*
 *)
  let s = Marshal.to_string  17 [] 
  let b = true && (Marshal.from_string s 0) 
(** r1succeed
 * DOC string to bool unmarshal failure 
 * FAM readme
 * RET
 *)
  let s = Marshal.to_string  false  [] 
  let b = true && (Marshal.from_string s 0) 
(** r1fresh
 * DOC fresh expression name generation
 * FAM readme
 * RET
 *)
  let x : int name = fresh
(** r1poly
 * DOC marshalling (and type construction) within a polymorphic function
 * FAM readme
 * RET
 *)
  let pair_and_marshal : 'a -> string 
    = function x -> Marshal.to_string (x,x) [] 
  let s = pair_and_marshal 17
  let n = let (x1,x2)=(Marshal.from_string s 0) in x1+x2
(** r1fieldname
 * DOC building a name from a module myname and field
 * FAM readme
 * RET
 *)
  module M = struct let f : int -> int = function z->z end
  let x : (int -> int) name = fieldname M.f
(** r1ifname
 * DOC ifname
 * FAM readme
 * RET
 *)
  let x : int name = fresh
  let y : bool name = fresh
  let f x' y' = ifname x' = y' then [x';y'] else [x']
  let a = f x y
  let b = f x x
(** r1coerce
 * DOC coerce
 * FAM readme
 * RET
 *)
  type ('a,'b) t = Foo of 'a*'b
  type ('c,'d) t' = Bar of 'c*'d*int
  let x : (int,bool) t name = fresh
  let y : (int,bool) t' name = namecoercion(t,t',x)
(** r1hashname
 * DOC hashname
 * FAM readme
 * RET
 *)
  let x : int name = hashname(int, "foo")
(** r1rep
 * DOC rep
 * FAM readme
 * RET
 *)
  let x : typerep = rep( int * int )
  let s : string = Dyntype.string_of_typerep x
(** r1dyntype
 * DOC dyntype
 * FAM readme
 * RET
 *)
  let x : typerep = dyntype( 3 )
(** r1hashed
 * DOC a hashed module
 * FAM readme
 * RET
 *)
  module M : sig type t end = struct type t=int end
  let x : typerep = rep ( M.t )
(** r1freshed
 * DOC a fresh module
 * FAM readme
 * RET
 *)
  module M : sig type t end = fresh struct type t=int end
  let x : typerep = rep ( M.t )
(** r1cfreshed
 * DOC a cfresh module
 * FAM readme
 * RET
 *)
  module M : sig type t end = cfresh struct type t=int end
  let x : typerep = rep ( M.t )
(** r1filehashed
 * DOC a hashed cu
 * FAM readme
 * RET
 *)
  type t=int 
(** r1filefreshed
 * DOC a fresh cu
 * FAM readme
 * RET
 *)
  typemode fresh
  type t=int
(** r1filecfreshed
 * DOC a cfresh cu
 * FAM readme
 * RET
 *)
  typemode cfresh
  type t=int
(** r1prefix
 * DOC prefix module
 * FAM readme
 * RET
 *)
        module M = struct
            let x = 1
            module N = struct
                let y = x
            end
        end
(** r1prefix2
 * DOC prefix2 module
 * FAM readme
 * RET
 *)
        module M = struct
            let x = 1
            module N = struct
                let y = 2
            end
        end
(** r1functor1
 * DOC functor1 module
 * FAM readme
 * RET
 *)
        module F(P : sig val x : int end) = struct
            module Q = P
            let y = Q.x
        end
        module M = struct let x = 1 end
        module N = F(M)
(** r1functor2
 * DOC functor2 module
 * FAM readme
 * RET
 *)
        module F(P : sig end) = struct end
        module M = struct end
        module N = F(M)
(** r2
 * DOC marshal with free tyvar, list
 * FAM readme
 * RUNFAIL .*free.*
 *)
  let x = [] 
  let s = Marshal.to_string x [] 
(** r2f
 * DOC marshal with free tyvar, function
 * FAM readme
 * RUNFAIL .*free.*
 *)
  let x=function y -> y 
  let s=Marshal.to_string x [Marshal.Closures] 
(** r2fannot
 * DOC marshal with free tyvar, function, type annotated
 * FAM readme
 * RET
 *)
  let x=function y -> y 
  let s=Marshal.to_string (x:int->int) [Marshal.Closures] 
(** r2b
 * DOC marshal with non free tyvar - P thinks this should work
 * FAM readme
 * RET
 *)
  let f x = 
    let s = Marshal.to_string x [] in
    x + 1 in
  f 0 
(** r3
 * DOC if generalisation - works in ocaml
 * FAM readme
 * COMPFAIL .*
 *)
  let r = ref 0 
  let f = if (r:=1;true) then (fun x->x) else (fun x->x) 
  let y = !r
  let z = (f true, f 3)
(** r3m
 * DOC if generalisation with marshal 
 * FAM readme
 * COMPFAIL .*
 *)
  let r = ref 0 
  let s = ref ""
  let f = if (r:=1;true) then 
               (fun x-> s := Marshal.to_string x []; x)
          else (fun x-> x)
  let y = !r
  let z = (f true, f 3)
(** r3-sml
 * DOC if generalisation in SML just to check
 * FAM readme
 * COMPFAIL .*
 *)
  let val r = ref 0 in
  let val f = if (r:=1;true) then (fn x=>x) else (fn x=>x) in
  let val x = (f true, f 3) in
  () end end end
(** r4
 * DOC garrigue
 * FAM readme
 * RUNFAIL .*free.*
 *)
  let r = ref "" in
  let f () = let x = [] in ((r := Marshal.to_string x []); x) in
  (*  val f : unit -> 'a list = <fun> *) 
   ( 3::(f ()) , "foo"::(f ()) )
(** r4-typepassing
 * DOC garrigue
 * FAM readme
 * COMPFAIL .*
 *)
  let r = ref "" in
  let f tyrep_a () = let x = [] in ((r := Marshal.to_string x []); x) in
  (*  val f : typerep -> unit -> 'a list = <fun> *) 
    ( 3::(f rep(unit) ()) , "foo"::(f rep(string) ()) )
(** r4-expansive
 * DOC garrigue
 * FAM readme
 * COMPFAIL .*
 *)
  let s = ref ""
  let id = fun y -> (s := Marshal.to_string y []; y) 
  let r = ref 0 
  let x = (r := 1; id []) 
(** r4-abc
 * DOC garrigue           (* -:  val f : unit -> 'a list = <fun> *)           (* -:  int list * string list = ([3], ["foo"]) *)
 * FAM readme
 * COMPFAIL .*
 *)
  let r = ref 0
  let s = ref ([] : string list)
  let f = (r := 1 + !r; 
           fun () -> let x = [] in 
                     (s:=Marshal.to_string x [] :: !s; x))
  let z = (  3 :: (f ())  ,  "foo" :: (f ())  )
(** p11_even
 * DOC    should compile ok
 * FAM    readme
 * COMPILE
 *)
  module EvenCounter
  : sig
      type t
      val start:t
      val get:t->int
      val up:t->t
    end
  = struct
      type t=int
      let start = 0
      let get = fun (x:int)->x
      let up = fun (x:int)->2+x
    end

(** p11_even_horiz 
 * DOC    should NOT compile ok
 * FAM    readme
 * COMPFAIL   .*
 *)
  module EvenCounter
  : sig             = struct
      type t            type t=int
      val start:t       let start = 0
      val get:t->int    let get = fun (x:int)->x
      val up:t->t       let up = fun (x:int)->2+x
    end               end
(** r5s
 * DOC    static datatype generativity - should not compile ok
 * FAM    readme
 * COMPFAIL .*
 *)
  module M1
  = struct
      type t = C of int
    end
  module M2
  = struct
      type t = C of int
    end
  let f : M1.t -> M2.t = fun x->x
(** r5d
 * DOC    dynamic datatype generativity 
 * FAM    readme
 * RET
 *)
  module M1
  = struct
      type t = C of int
    end
  module M2
  = struct
      type t = C of int
    end
  let s = Marshal.to_string (M1.C 3) [] 
  let x = match (Marshal.from_string s 0) with M2.C(y)->y
(** r5dcycle
 * DOC    dynamic datatype generativity - up to reordering of types and of clauses. P thought this should succeed, but it doesnot
 * FAM    readme
 * RET
 *)
  module M1
  = struct
      type t1 = C1 of int | D1 of t2
      and  t2 = C2 of bool | D2 of t1
    end
  module M2
  = struct
      type t2 = D2 of t1 | C2 of bool 
      and  t1 = D1 of t2 | C1 of int 
    end
  let s = Marshal.to_string (M1.C1 3) [] 
  let x = match (Marshal.from_string s 0) 
          with M2.C1(y) -> y | M2.D1 _ -> 3
(** r5dcycle2a
 * DOC    dynamic datatype generativity - up to reordering of types and of clauses. P thought this should succeed, but it doesnot
 * FAM    readme
 * RET .*
 *)
  module M
  = struct
      type t1 = C1 of int | D1 of t2
      and  t2 = C2 of bool | D2 of t1
    end
  let s = Marshal.to_string (M.C1 3) [] 
  let _ = print_string (String.escaped s)
(** r5dcycle2b
 * DOC    dynamic datatype generativity - up to reordering of types and of clauses. P thought this should succeed, but it doesnot
 * FAM    readme
 * RET
 *)
  module M
  = struct
      type t2 = D2 of t1 | C2 of bool 
      and  t1 = D1 of t2 | C1 of int 
    end
  let s  = "\132\149\166\190\000\000\000%\000\000\000\003\000\000\000\015\000\000\000\011\160\144C\t 1\183;\026j\198\t\250\200\\e\219\236\138\169q\0162\241\180\028H\237\163=\000\025\160\153\164$\023"
  let x = match (Marshal.from_string s 0) with M.C1(y) -> y | M.D1 _ -> 3
(** r5s_record
 * DOC    static record generativity - should not compile ok
 * FAM    readme
 * COMPFAIL .*
 *)
  module M1
  = struct
      type t = {fieldlabel : int}
    end
  module M2
  = struct
      type t = {fieldlabel : int}
    end
  let f : M1.t -> M2.t = fun x->x
(** r5d_record
 * DOC    dynamic record generativity 
 * FAM    readme
 * RET
 *)
  module M1
  = struct
      type t = {fieldlabel : int}
    end
  module M2
  = struct
      type t = {fieldlabel : int}
    end
  let s = Marshal.to_string {M1.fieldlabel = 3} [] 
  let x = match (Marshal.from_string s 0) with {M1.fieldlabel=y} -> y
(** r5d_record_order
 * DOC    record field reordering
 * FAM    readme
 * RET
 *)
  module M1
  = struct
      type t = {fieldlabel1 : int; fieldlabel2 : bool}
    end
  module M2
  = struct
      type t = {fieldlabel2 : bool; fieldlabel1 : int}    
    end
  let s = Marshal.to_string {M1.fieldlabel1 = 3; M1.fieldlabel2 = true} [] 
  let x = match (Marshal.from_string s 0) with {M2.fieldlabel1 = x; M2.fieldlabel2 = b} -> (x,b)
(** r5d_record_poly
 * DOC    record field polymorphism
 * FAM    readme
 * RET
 *)
  type t = { f : 'a . 'a -> 'a * int };;
  let (r : t) = { f = fun z -> (z,3) };;
  let s = Marshal.to_string  r [Marshal.Closures] ;;
  let r' =  (Marshal.from_string s 0) ;;
  let x = r'.f "foo"
(** r6a_static
 * DOC    signature ascription - static - does not compile in OCaml
 * FAM    readme
 * COMPFAIL .*
 *)
  module M
  = struct
      type t = int
      let x = 3
    end
  module M1 : sig type t  val x:t end = M
  let id : M.t -> M1.t = fun z->z
(** r6a_dynamic
 * DOC    signature ascription - dynamic - fail with unmarshal error
 * FAM    readme
 * RUNFAIL .*Marshal type mismatch.*
 *)
  module M
  = struct
      type t = int
      let x = 3
    end
  module M1 : sig type t  val x:t end = M
  let s = Marshal.to_string M.x [] 
  let (z : M1.t) = Marshal.from_string s 0
(** r6b_static
 * DOC    signature ascription - binary, static - doesnot compile in OCaml
 * FAM    readme
 * COMPFAIL .*
 *)
  module M = struct type t = int  let x = 3 end
  module M1 : sig type t val x:t end = M
  module M2 : sig type t val x:t end = M
  let id : M1.t -> M2.t = fun x -> x
(** r6b_dynamic
 * DOC    signature ascription - binary, dynamic - fail or succeed in HashCaml?
 * FAM    readme
 * RET
 *)
  module M = struct type t = int  let x = 3 end
  module M1 : sig type t val x:t end = M
  module M2 : sig type t val x:t end = M
  let s = Marshal.to_string M1.x [] 
  let (z : M2.t) = Marshal.from_string s 0
(** p11_n
 * DOC    should compile ok  
 * FAM    readme-n
 * COMPILE
 *)
  module NCounter
  : sig
      type t
      val start:t
      val get:t->int
      val up:t->t
    end
  = fresh struct
      type t=int
      let start = 0
      let get = fun (x:int)->x
      let up =
        let step = Pervasives.read_int () in
        fun (x:int)->step+x
  end
(** p11_n_highlight
 * DOC    should not compile 
 * FAM    readme-n
 * COMPFAIL
 *)
  module NCounter
  : sig
      type t
      val start:t
      val get:t->int
      val up:t->t
    end
  = \highlight{fresh} struct
      type t=int
      let start = 0
      let get = fun (x:int)->x
      let up =
        let step = Pervasives.read_int () in
        fun (x:int)->step+x
    end
(** p11_n_highlight_horiz
 * DOC    should not compile 
 * FAM    readme-n
 * COMPFAIL
 *)
  module NCounter
  : sig            = \highlight{fresh} struct                
      type t           type t=int                            
      val start:t      let start = 0                         
      val get:t->int   let get = fun (x:int)->x              
      val up:t->t      let up =                              
    end                  let step = \highlight{read_int ()} in
                         fun (x:int)->step+x                 
                     end                                     
 (** r7
 * DOC    abstract type constructors
 * FAM    readme
 * RET
 *)
  module M
  = struct
      type 'a t = int * 'a
      let f x = (3,x)
    end
  module M1 : sig type 'a t  val f:'a -> 'a t end = M
  let s = Marshal.to_string (M1.f true) [] 
  let (z : bool M1.t) = Marshal.from_string s 0
(** exc
 * DOC    broken exception marshalling in OCaml
 * FAM    readme
 * RET .*false.*
 *)
  exception E;;
  let s=Marshal.to_string E [];;
  print_string (match Marshal.from_string s 0 with
      E -> "true"
    | _ -> "false") ;;
  (* output : false *)
(** r8
 * DOC    substructure paths  in OCaml ret (true,true,true) if you make the values the same  (!s1 = !s2, !s2 = !s3, !s3 = !s1)      
 * FAM    readme
 * RET   
 *)
  let s1=ref "" ;;  let s2=ref "" ;;  let s3=ref "" ;;
  module M1
  : sig 
      module M2 
      : sig type t  val x:t end
    end
  = struct
      module M2 : sig type t  val x:t  val f:t->t end 
      = struct
          type t = int
          let  x = 2
          let  f = fun z->z+2
          let  _ = (s3 := Marshal.to_string (3:t) [])
        end
        let _=(s2:=Marshal.to_string(M2.f M2.x:M2.t) [])
    end;;
  let _ = (s1:=Marshal.to_string (M1.M2.x : M1.M2.t) []) 
(** r8highlight
 * DOC    substructure paths  in OCaml ret (true,true,true) if you make the values the same  (!s1 = !s2, !s2 = !s3, !s3 = !s1)      
 * FAM    readme
 * COMPFAIL *
 *)
  let s1=ref "" ;;  let s2=ref "" ;;  let s3=ref "" ;;
  module M1
  : sig 
      module M2 
      \highlight{: sig type t  val x:t end}
    end
  = struct
      module M2 \highlight{: sig type t  val x:t  val f:t->t end} 
      = struct
          type t = int
          let  x = 2
          let  f = fun z->z+2
          let  _ = (s3 := Marshal.to_string (3:t) [])
        end
        let _=(s2:=Marshal.to_string(M2.f M2.x:M2.t) [])
    end;;
  let _ = (s1:=Marshal.to_string (M1.M2.x : M1.M2.t) []) 
(** r8tyrep
 * DOC    substructure paths  
 * FAM    readme
 * RET   .*false.*false.*false.*
 *)
  let s1=ref (rep(unit)) ;;  let s2=ref (rep(unit)) ;;  let s3=ref (rep(unit)) ;;
  module M1
  : sig 
      module M2 
      : sig type t  val x:t end
    end
  = struct
      module M2 : sig type t  val x:t  val f:t->t end 
      = struct
          type t = int
          let  x = 2
          let  f = fun z->z+2
          let  _ = s3 := rep(t)
        end
        let _ = s2:= rep (M2.t)
    end;;
  let _ = s1:= rep(M1.M2.t);;
  let f b = print_string (string_of_bool b) in
  (f (!s1 = !s2), f(!s2 = !s3), f(!s3 = !s1))      
(** r9camlascrip
 * DOC    in OCaml ascription does not build a new struct
 * FAM    readme
 * RET   .*1.*2.*
 *)
  module M = 
    struct 
      let x = let r = ref 0 in 
              fun () -> r := 1 + !r ; print_int !r; print_string " "; !r 
    end
  module M' = (M : sig val x:unit -> int end)
  let _ = M.x () ;;
  let _ = M'.x ()  ;;
(** r9camlapplic
 * DOC    in OCaml functors are applicative
 * FAM    readme
 * RET
 *)
  module F (X:sig end) : sig type t end 
                       = struct type t=int end
  module U = struct end
  module M = F(U)
  module M'= F(U);;

  ((fun x->x) : M.t -> F(U).t);;
  ((fun x->x) : M.t -> M'.t);;
(** p11_n_func
 * DOC    should compile ok  
 * FAM    readme-n
 * RET
 *)
  module NCounterFunc (Z : sig val z:int end)
  : sig
      type t
      val start:t
      val get:t->int
      val up:t->t
    end
  = fresh struct
      type t=int
      let start = Z.z
      let get = fun (x:int)->x
      let up =
        let step = Pervasives.read_int () in
        fun (x:int)->step+x
    end
  module U = struct let z=300 end
  module NCounter = NCounterFunc(U)
  module NCounter'= NCounterFunc(U);;
(** r10a
 * DOC type abbrev in type - should work
 * FAM readme
 * RET
 *)
  type t = int
  let s = Marshal.to_string  (3:t) [] 
  let x : int =  (Marshal.from_string s 0) 
(** r10b
 * DOC type abbrev in module hashing - should be invisible
 * FAM readme
 * RET .*
 *)
  module M : sig type t end
  = struct
      type t2 = int
      let x = function (z:t2)->z
      type t = t2
    end
  let r1 = rep(M.t)
  let _ = print_string (String.escaped (Dyntype.string_of_typerep r1))
(** r10c
 * DOC type abbrev in module hashing - should be invisible - have to compare the output of r10b and r10c by eye
 * FAM readme
 * RET .*
 *)
  module M : sig type t end
  = struct
      type t2 = int
      let x = function (z:int)->z
      type t = int
    end
  let r2 = rep(M.t)
  let _ = print_string (String.escaped (Dyntype.string_of_typerep r2))
(** p11_n_func_highlight
 * DOC    should not compile ok  
 * FAM    readme-n
 * COMPFAIL
 *)
  module NCounterFunc (Z : sig val z:int end)
  : sig
      type t
      val start:t
      val get:t->int
      val up:t->t
    end
  = \highlight{fresh} struct
      type t=int
      let start = Z.z
      let get = fun (x:int)->x
      let up =
        let step = Pervasives.read_int () in
        fun (x:int)->step+x
    end
  module U = struct let z=300 end
  module NCounter = NCounterFunc(U)
  module NCounter'= NCounterFunc(U);;
(** r10prefix
 * DOC    prefix
 * FAM    readme
 * RET
 *)
module M 
= struct
    let iterate = List.iter
    let x = 7
    module N = struct  let y = x  end
    module O = struct  let w = 4  end
  end


