(* TODO clean up this structure (use sensible names, formatting)
 *      check marshalling of values of reference type (slightly special)
 *      fresh, cfresh, ... (do we even have these yet?)
 *      ...
 *)

(** p1
 * DOC Marshalling of a value of a built-in type through a string
 * FAM paper
 * RET 5
 *)

let s = Marshal.to_string 5 []
let i = Marshal.from_string s 0
let _ = print_string (string_of_int i)

(** p2
 * DOC   Marshalling of a value of a built-in type across a persistent store
 * FAM   paper
 * GROUP p2a p2b
 *)

(** p2a
 * DOC  Marshal and send value
 * RET
 * OPTS io.ml
 *)

let s = Marshal.to_string 5 []
let _ = Io.send s

(** p2b
 * DOC  Receive and unmarshal value
 * RET  5
 * OPTS io.ml
 *)

let s = Io.recv ()
let n = Marshal.from_string s 0
let _ = print_string (string_of_int n)

(** p3
 * DOC     Verify (built-in) type mismatch at unmarshal
 * FAM     paper
 * RUNFAIL .*Marshal type mismatch.*
 *)

let s : string = Marshal.to_string "five" []
let i : int = Marshal.from_string s 0
let _ = print_string (string_of_int i)

(** p4
 * DOC Marshalling of monomorphic functional value
 * FAM paper
 * RET 42
 *)

let f = function () -> 42
let s = Marshal.to_string f [Marshal.Closures]
let f' = Marshal.from_string s 0
let _ = print_string (string_of_int (f' ()))

(** even
 * DOC   Marshalling of values of the same abstract types
 * FAM   paper
 * GROUP even1 even2
 *)

(** even1
 * DOC  Store value of an abstract type (EvenCounter [start = 0])
 * RET
 * OPTS io.ml
 *)
 
module EvenCounter :
  sig
    type t
    val start : t
    val get : t -> int
    val up : t -> t
  end =
  struct
    type t = int
    let start = 0
    let get = function x -> x
    let up = function x -> 2 + x
  end

let x = EvenCounter.up EvenCounter.start
let s = Marshal.to_string x []
let _ = Io.send s

(** even2
 * DOC  Retrieve value of the same abstract type (EvenCounter [start = 0])
 * RET  2
 * OPTS io.ml
 *)
 
module EvenCounter :
  sig
    type t
    val start : t
    val get : t -> int
    val up : t -> t
  end =
  struct
    type t = int
    let start = 0
    let get = function x -> x
    let up = function x -> 2 + x
  end

let s = Io.recv ()
let x = Marshal.from_string s 0
let n = EvenCounter.get x
let _ = print_int n

(** even_odd
 * DOC   Verify (abstract) type mismatch at unmarshal
 * FAM   paper
 * GROUP even_odd1 even_odd2
 *)

(** even_odd1
 * DOC Store value of an abstract type (EvenCounter [start = 0])
 * RET
 *)
 
module EvenCounter :
  sig
    type t
    val start : t
    val get : t -> int
    val up : t -> t
  end =
  struct
    type t = int
    let start = 0
    let get = function x -> x
    let up = function x -> 2 + x
  end

let x = EvenCounter.up EvenCounter.start
let s = Marshal.to_string x []
let _ = Io.send s

(** even_odd2
 * DOC     Try to retrieve value of a different abstract type (EvenCounter [start = 1])
 * RUNFAIL .*Marshal type mismatch.*
 *)
 
module EvenCounter :
  sig
    type t
    val start : t
    val get : t -> int
    val up : t -> t
  end =
  struct
    type t = int
    let start = 1 (* <- odd value now! *)
    let get = function x -> x
    let up = function x -> 2 + x
  end

let s = Io.recv ()
let x = Marshal.from_string s 0
let n = EvenCounter.get x
let _ = print_int n

(** even_renamed
 * DOC   Marshalling of values of alpha-equivalent abstract types
 * FAM   paper
 * GROUP even_renamed1 even_renamed2
 *)

(** even_renamed1
 * DOC Store value of an abstract type (EvenCounter [start = 0])
 * RET
 *)
 
module EvenCounter :
  sig
    type t
    val start : t
    val get : t -> int
    val up : t -> t
  end =
  struct
    type t = int
    type 'b s
    let start = 0
    let get = function x -> x
    let up = function x -> 2 + x
  end

let x = EvenCounter.up EvenCounter.start
let s = Marshal.to_string x []
let _ = Io.send s

(** even_renamed2
 * DOC Retrieve value of an alpha-equivalent abstract type (EvenCounter [start = 0])
 * RET 2
 *)
 
module EvenCounter :
  sig
    type t
    val start : t
    val get : t -> int
    val up : t -> t
  end =
  struct
    type t = int
    type 'a s
    let start = 0
    let get = function y -> y
    let up = function x -> 2 + x
  end

let s = Io.recv ()
let x = Marshal.from_string s 0
let n = EvenCounter.get x
let _ = print_int n

(** monopolymarsh
 * DOC Marshalling of monomorphic values via a polymorphic function
 * FAM paper
 * RET 42foo
 *)

let f x = Marshal.to_string x []
let g x = Marshal.from_string x 0

let s1 = f 42
let s2 = f "foo"

let v1 = g s1
let v2 = g s2

let _ = print_int v1
let _ = print_string v2

(** polypolymarsh
 * DOC     Attempt to marshal a polymorphic value
 * FAM     paper
 * RUNFAIL .*Dynamic type contains free type variables.*
 *)

let ident : 'a -> 'a = function x -> x
let _ = Marshal.to_string ident []
