(* -=-- --*- caml -*---------------------------------------- --=- *
 *                                                                *
 * runtest.ml                                                     *
 *                                                                *
 * Version: $Id: runtest.ml,v 1.513 2004/12/22 12:23:32 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

open Runtest_db
open Runtest_library

let rec show_test t_name =
  match (find_test t_name).expect with
  | Group l -> List.iter show_test l
  | _ -> print_string (" "^t_name)

let show_family f_name =
  let show_test_aux s = print_string s; show_test s; print_newline() in
  List.iter show_test_aux (find_family f_name)

let parse_opts () =
  let verb = ref 1 in

  (* XXX *)
  let options = ref [ "-I tmp" ] in
  let libs = ref [ "unix.cma";  "io.cmo" ] in

  let arg_format = [
    "-f",
    Arg.String (fun test_fam -> runfamily !verb !options !libs test_fam),
    "\"fam\"      run test over entire family \"fam\"";
    "-F",
    Arg.String (fun test_fam -> show_family test_fam),
    "\"fam\"      List all test in the family \"fam\"";
    "-t",
    Arg.String (fun test_name -> runtest !verb !options !libs test_name),
    "\"bar\"      run test \"bar\"\n";

    "-c",
    Arg.String (fun new_options ->
      options := !options @ (Str.split (Str.regexp " -") new_options)),
    "\"copts\"    add the compiler options \"copts\" to the subsequent tests";
    "-l",
    Arg.String (fun new_libs ->
      libs := !libs @ (Str.split (Str.regexp " ") new_libs)),
    "\"clibs\"    add the libraries \"clibs\" to the subsequent tests";
    "-k",
    Arg.Unit   (fun () -> Runtest_library.set_lazy false),
    "           sets the lazy evaluation off for grouped tests";
    "-nok",
    Arg.Unit   (fun () -> Runtest_library.set_lazy true),
    "         sets the lazy evaluation on for grouped tests (default)";
    "-kill",
    Arg.Int    (fun delay -> Runtest_library.set_kill_delay delay),
    "n       kill any test after n seconds\n";

    "-GG1",
    Arg.Unit   (fun () -> Runtest_pretty.set_pp_mode true),
    "         Preprocessor mode 1 (#+ lines added, #- removed)";
    "-GG2",
    Arg.Unit   (fun () -> Runtest_pretty.set_pp_mode false),
    "         Preprocessor mode 2 (#+ lines removed, #- added) (default)\n";


    "-d",
    Arg.String (fun dir -> set_runtest_dir dir),
    "\"dir\"      set trace directory (default: out/)\n";
    "-D",
    Arg.String (fun dir_name -> set_src_dump dir_name),
    "\"bar\"        Dump sources in associated directories\n";

    "-g",
    Arg.String (fun test_name ->
      let (c,f) = (get_test_code test_name) in
      Runtest_pretty.print_body test_name c f),
    "\"bar\"      pretty-print the code of test \"bar\" to stdout";

    "-G",
    Arg.String (fun test_name -> print_string (fst (get_test_code test_name))),
    "\"bar\"      print the raw code of test \"bar\" to stdout";
    "-T",
    Arg.String (fun out_type -> Runtest_pretty.set_out_type out_type),
    "           color|unix|overstrike|html  specify output style";
    "-v",   Arg.Unit (fun () -> verb := 1), "           verbose output (default)";
    "-vv",   Arg.Unit (fun () -> verb := 2), "          very verbose output";
    "-q",   Arg.Unit (fun () -> verb := 0), "           quiet output\n"
  ] in

  let usage = "runtest <options>\n\n  options applied sequentialy (\"runtest -vv -t foo\" <>  \"runtest -t foo -vv\")\n" in
  Arg.parse arg_format (fun string -> ()) usage

let () =
  try
    fill_database "./tests_db";
    parse_opts ()
with e -> (print_endline("Error: " ^ Printexc.to_string e))
