(*
 *  hashing/hashpackage.mli
 *
 *  Representation of parameterized hashes.
 *
 *  (c) Copyright 2005, Mark R. Shinwell.
 * 
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *  this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *  notice, this list of conditions and the following disclaimer in the
 *  documentation and/or other materials provided with the distribution.
 *  3. The names of the authors may not be used to endorse or promote products
 *  derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 *  NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *)

type hash_param
type hash_param_set
type 'a package

val empty_hash_param_set : hash_param_set
val add_hash_param :
  Typedtree.expression -> hash_param_set -> (hash_param * hash_param_set)

val make_package : 'a -> hash_param_set -> 'a package
val generate_code : 'a package -> Typedtree.expression

val get_param_set : 'a package -> hash_param_set

val combine_param_sets :
  hash_param_set -> hash_param_set -> hash_param_set
val combine_packages :
  ('a -> 'b -> 'c) -> 'a package -> 'b package -> 'c package

val map_constant_part : ('a -> 'b) -> 'a package -> 'b package
val listify : ('a package) list -> ('a list) package

val add_hash_params_to_package : 'a package -> hash_param_set -> 'a package

val string_of_hash_param : hash_param -> string
