(** func_die
 * DOC Visibility of myname of functor parameter and its alias
 * FAM func
 * RET
 *)

module F(U : sig val x : int val myname : string end) =
  struct
    module L = U
    let x = L.x
  end




(** func_alpha
 * DOC   Alpha-equivalence of functors' formal parameters
 * FAM   func
 * GROUP func_alpha1 func_alpha2 func_alpha3
 *)

(** func_alpha1
 * DOC A functor definition
 * RET
 *)

module F(U1 : sig end) = struct end

(** func_alpha2
 * DOC Same, but with different name of formal parameter
 * RET
 *)

module F(U2 : sig end) = struct end

(** func_alpha3
 * DOC  The two functors have same mynames
 * RET  true
 * OPTS func_alpha1.cmo func_alpha2.cmo
 *)

print_string (string_of_bool (Func_alpha1.myname = Func_alpha2.myname))




(** func_def
 * DOC   Dependence upon internal parts of a functor definition
 * FAM   func
 * GROUP func_def1 func_def2 func_def3
 *)

(** func_def1
 * DOC A functor definition with a value definition
 * RET
 *)

module F(U : sig end) =
  struct
    let x = true 
  end

(** func_def2
 * DOC Same, but with a different value definition
 * RET
 *)

module F(U : sig end) =
  struct
    let x = false
  end

(** func_def3
 * DOC  The two functors have different mynames
 * RET  true
 * OPTS func_def1.cmo func_def2.cmo
 *)

print_string (string_of_bool (Func_def1.myname <> Func_def2.myname))




(** func_def_ext
 * DOC   Independence upon external references in functor definitions
 * FAM   func
 * GROUP func_def_ext1 func_def_ext2 func_def_ext3 func_def_ext4 func_def_ext5
 *)

(** func_def_ext1
 * DOC An external value
 * RET
 *)

let x = true

(** func_def_ext2
 * DOC Another external value
 * RET
 *)

let x = false

(** func_def_ext3
 * DOC  A functor definition referring the first external value
 * RET
 * OPTS func_def_ext1.cmo
 *)

module F(U : sig end) =
  struct
    let x = Func_def_ext1.x
  end

(** func_def_ext4
 * DOC  A functor definition referring the second external value
 * RET
 * OPTS func_def_ext2.cmo
 *)

module F(U : sig end) =
  struct
    let x = Func_def_ext2.x
  end

(** func_def_ext5
 * DOC  The two functors' mynames are the same
 * RET  true
 * OPTS func_def_ext1.cmo func_def_ext2.cmo func_def_ext3.cmo func_def_ext4.cmo
 *)

print_string (string_of_bool (Func_def_ext3.myname = Func_def_ext4.myname))




(** func_app_ext
 * DOC   Dependence upon external references in functor application
 * FAM   func
 * GROUP func_app_ext1 func_app_ext2 func_app_ext3 func_app_ext4 func_app_ext5 func_app_ext6
 *)

(** func_app_ext1
 * DOC An external value
 * RET
 *)

let x = true

(** func_app_ext2
 * DOC Another external value
 * RET
 *)

let x = false

(** func_app_ext3
 * DOC  A functor definition referring the first external value
 * RET
 * OPTS func_app_ext1.cmo
 *)

module F(U : sig end) =
  struct
    let x = Func_app_ext1.x
  end

(** func_app_ext4
 * DOC  A functor definition referring the second external value
 * RET
 * OPTS func_app_ext2.cmo
 *)

module F(U : sig end) =
  struct
    let x = Func_app_ext2.x
  end

(** func_app_ext5
 * DOC A module used as a parameter
 * RET
 *)

;;

(** func_app_ext6
 * DOC  The two functor applications have different mynames
 * RET  true
 * OPTS func_app_ext1.cmo func_app_ext2.cmo func_app_ext3.cmo func_app_ext4.cmo func_app_ext5.cmo
 *)

module N1 = Func_app_ext3.F(Func_app_ext5)
module N2 = Func_app_ext4.F(Func_app_ext5)
let _ = print_string (string_of_bool (N1.myname <> N2.myname))




(** func_app_param
 * DOC   Dependence upon actual parameter in functor application
 * FAM   func
 * GROUP func_app_param1 func_app_param2 func_app_param3 func_app_param4
 *)

(** func_app_param1
 * DOC A module parameter
 * RET
 *)

let x = true

(** func_app_param2
 * DOC Another module parameter
 * RET
 *)

let x = false

(** func_app_param3
 * DOC  A functor definition
 * RET
 * OPTS func_app_param1.cmo
 *)

module F(U : sig val x : bool end) =
  struct
    let x = U.x
  end

(** func_app_param4
 * DOC  The two functor applications (given different parameters) have different mynames
 * RET  true
 * OPTS func_app_param1.cmo func_app_param2.cmo func_app_param3.cmo
 *)

module N1 = Func_app_param3.F(Func_app_param1)
module N2 = Func_app_param3.F(Func_app_param2)
let _ = print_string (string_of_bool (N1.myname <> N2.myname))
