(* -=-- --*- caml -*---------------------------------------- --=- *
 *                                                                *
 * Acute Systematic Tester Database Handler                       *
 *                                                                *
 * Version:  $Id: runtest_db.mli,v 1.506 2004/12/22 12:23:32 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

type test_name = string
type family_name = string
type expecting = string

type test_body = string option

type test_type =
  | Exits  of expecting option list
  | CompFail   of expecting
  | RunFail   of expecting
  | Group  of test_name list
  | Compile
  | Empty

type test_spec = {
  name : string;
  file : string;
  mutable doc : string;
  mutable options : string list;
  mutable libs : string list;
  mutable expect : test_type;
  mutable families : family_name list;
  mutable body : test_body
}

val fill_database : string -> unit
val find_test : test_name -> test_spec
val find_family : family_name -> test_name list
val is_grouped : test_name -> bool
