(*
 *  polymarshal/polymarshal.mli
 *
 *  Type-passing translation of typed syntax trees for the purposes of
 *  polymorphic marshalling.
 *
 *  (c) Copyright 2005, Mark R. Shinwell.
 * 
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *  this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *  notice, this list of conditions and the following disclaimer in the
 *  documentation and/or other materials provided with the distribution.
 *  3. The names of the authors may not be used to endorse or promote products
 *  derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 *  NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *)

val add_typerep_lambdas : (Typedtree.expression * Types.type_expr) ->
  Location.t -> Env.t -> Typedtree.expression

val rewrite_structure : Typedtree.structure -> Types.signature -> Env.t ->
  (Typedtree.structure * Types.signature * Env.t)

val rewrite_let_lambda_code : Typedtree.pattern -> Typedtree.expression ->
  Ident.t Types.tyvar_id_memo -> Lambda.lambda -> Lambda.lambda

val make_coercion_wrapper : (Typedtree.expression -> Lambda.lambda) ->
  Types.value_description -> Types.value_description -> Env.t ->
  Lambda.lambda -> Lambda.lambda

val make_discard_wrapper : Types.type_expr -> Env.t -> Lambda.lambda ->
  Lambda.lambda

