/*
 *  byterun/random256.c
 *
 *  Generation of 256-bit random numbers.
 *
 *  (c) Copyright 2005, 2006, John N. Billings, Mark R. Shinwell, Rok Strnisa.
 * 
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *  this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *  notice, this list of conditions and the following disclaimer in the
 *  documentation and/or other materials provided with the distribution.
 *  3. The names of the authors may not be used to endorse or promote products
 *  derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 *  NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "alloc.h"
#include "sys.h"
#include "memory.h"
#include "mlvalues.h"

// Generate 256bit random value
CAMLprim value random256(value unit) {
   CAMLparam1(unit);
   CAMLlocal1(s);

   // seed random number generator when first invoked
   static int init = 1;
   if (init) {
     srandom(Long_val(caml_sys_random_seed(Val_int(0))));
     init = 0;
   }

   //create space for string (32 bytes)
   s = caml_alloc_string(32);

   //initialise with random 8 ints (each 4 bytes)
   unsigned int *uip = (unsigned int*) String_val(s);
   int i;
   for (i = 0; i < 8; ++i)
      uip[i] = random();

   //return the result
   CAMLreturn(s);
}
