(* -=-- --*- caml -*---------------------------------------- --=- *
 *                                                                *
 * threadpool.ml                                                  *
 *                                                                *
 * Version: $Id: threadpool.ml,v 1.15 2004/12/22 12:23:32 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

open Ast
open Util

(* -- helpful methods -- *)

(* let signal condvar =
  print_endline("About to signal");
  Condition.signal condvar;
  print_endline("Signalled")
*)let really_print s = () (* prerr_endline(s)*)

let wait s condvar mutex =
  really_print (s ^ " About to wait");
  Condition.wait condvar mutex;
  really_print(s ^ " Waiting done")

let m_lock s m =  really_print(s ^ " locking mutex");
  Mutex.lock m;
 really_print(s ^ " locked")

let m_unlock s m = really_print(s ^ " unlocking mutex");
  Mutex.unlock m;
   really_print(s ^ " unlocked")

(* ------------------------ *)

(* the heap of work to do *)
let inqueue
       (* (Ast.abstract_name * (Ast.prim_expr list -> Ast.prim_expr))  AQueue ref *)
    = ref (AQueue.create ())
(* its associated mutex *)
let inqueue_mutex = Mutex.create()
(* a condition variable to wait on *)
let inqueue_condvar = Condition.create ()


(* the heap of results *)
let outqueue (* (Ast.abstract_name * Ast.prim_expr) AQueue ref) *) = ref (AQueue.create ())
(* its associated mutex *)
let outqueue_mutex = Mutex.create()
(* a condition variable to wait on *)
let outqueue_condvar = Condition.create ()


let add f =
  really_print("Adding");
  m_lock "add" inqueue_mutex;
  really_print("Adding[2]");
  inqueue := AQueue.add f !inqueue;
  really_print("signal");
  Condition.signal inqueue_condvar;
  really_print("unlock");
  m_unlock "add" inqueue_mutex



let rec fetch blocking =
 Mutex.lock outqueue_mutex;
  let r =
  try
    while (blocking && AQueue.empty !outqueue) do
      wait "outquerue" outqueue_condvar outqueue_mutex;
    done;
    let (v, q) =
      (AQueue.take !outqueue)
    in
    outqueue := q; Some (v)
  with AQueue.Empty ->
    (assert (not blocking); None)
  in Mutex.unlock outqueue_mutex; r

(* test for work *)
let is_work = function () ->
  (* should we lock it? *)
  really_print("locking");
   (* m_lock "" inqueue_mutex;  *)
  really_print("checking");
  let r =
    not (AQueue.empty !inqueue) in
  (* m_unlock "" inqueue_mutex; really_print("returning");*) r

(* nasty hack *)

let get_URI = ref (fun _-> raise (Never_happen "get_URI not filled in"))

(* function that thread executes *)
let thread_loop = function () ->
  while (true) do
    m_lock "tl" inqueue_mutex;
    while (not(is_work())) do
      wait "wl" inqueue_condvar inqueue_mutex;
    done;
    try
    let (fn_to_do, rest) = AQueue.take !inqueue
    in
    (
    inqueue := rest;
    really_print("added to queue");
    m_unlock "iq" inqueue_mutex;
    let r =
    match fn_to_do with Inl(tid, (f, args)) ->
      Inl(tid, f args)
    | Inr (tid, uri) ->
	Inr(tid, !get_URI uri)
    in
    (* signal to eval *)
    m_lock "add_oqueue" outqueue_mutex;
    outqueue := AQueue.add r !outqueue;
    Condition.signal outqueue_condvar;
    m_unlock "add_oqueue" outqueue_mutex;
    )
    with AQueue.Empty -> m_unlock "tl" inqueue_mutex;
  done

let create_thread_pool () =
   for i = 0 to 10 do
     ignore(Thread.create(thread_loop) ())
   done


