(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * opts.mli                                                       *
 *                                                                *
 * Version: $Id: opts.mli,v 1.526 2004/12/22 12:23:32 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

(* command-line options *)


exception No_args
type dumplevel = int
type evalname = int

type debugclass =
    DBC_default
  | DBC_flattenclos
  | DBC_desugar
  | DBC_tcopt
  | DBC_mkhash
  | DBC_lexer
  | DBC_evalstep
  | DBC_marshal
  | DBC_hashify
  | DBC_tcquant
  | DBC_linkok
  | DBC_namecase
  | DBC_namevalues
  | DBC_reachable

(* otheropts: *)
val final_filename_opt : string option ref
val output_filename_opt : string option ref
val err_filename_opt : string option ref
val tcdepth : int ref
val debugs : debugclass list ref
val dumpfrom : int ref
val dumpstepinterval : int ref


val printstepinterval : int option ref
val emitobjectfile : string option ref
val emitsourcefile : string option ref

type filename = {
    fi_filename : string;
    fi_basename : string;
    fi_compiled : bool;
  };;
val dslib_filename_opt : filename option ref
val input_filenames : filename list ref

val final_output_filename_opt : string option ref
val final_check_filename_opt : string option ref

(* boolflags: *)
    (* overall control *)
val showpasses : bool ref
val showtimes : bool ref
val showprogress : bool ref
    (* pipeline phases *)
val parsetest : bool ref
val desugar : bool ref
val compile : bool ref
val typecheckcompiled : bool ref
val run : bool ref
val showlocs : bool ref
    (* behaviour options *)
val default : bool ref
(* val evaluator : evalname ref
  val bigstep : evalname
  val smallstep : evalname *)
val printerrordeath : bool ref
val printcleandeath : bool ref
val nonunitthread : bool ref

val rttc : bool ref
val mttc : bool ref
val terminate_on_rttc : bool ref
val disable_import_typecheck : bool ref
val disable_eqsok_typecheck : bool ref
val internal_weqs : bool ref
val linkok_sig_typecheck : bool ref
val showtrailer : bool ref
val suffixall : bool ref
val shownames : bool ref
val globalhashmap : bool ref
val show_options : bool ref
val hack_optimise : bool ref
val really_hack_optimise : bool ref
val abstract_existentials : bool ref
val showtcenv : bool ref
val emitobject : bool ref
val lithash : bool ref
val printenv : bool ref
val printenvbodies : bool ref
val printclos : bool ref
val showfocussing : bool ref
    (* dumping state after pipeline phases *)
val dumpparse : dumplevel ref
val dumppreinf : dumplevel ref
val dumppostinf : dumplevel ref
val dumpdesugared : dumplevel ref
val dumpcompiled : dumplevel ref
val dumptrace : dumplevel ref
val dumpfinal : dumplevel ref
val dumptypefail : dumplevel ref

val production : bool ref

val dumpall : bool ref
val dumptex : bool ref
val dumphuman : bool ref
val marshaltex : bool ref

(*val writechecklevel : dumplevel ref*)
    (* debug *)
val debug : bool ref

val parse : unit -> unit
val custom_parse : string array -> unit

val do_show_options : unit -> string
