(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         *)
(*                                                                     *)
(*  Copyright 1996 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  All rights reserved.  This file is distributed    *)
(*  under the terms of the GNU Library General Public License, with    *)
(*  the special exception on linking described in file LICENSE-OCAML.  *)
(*                                                                     *)
(***********************************************************************)

(* $Id: sys.mli,v 1.503 2004/12/22 15:27:08 zappa Exp $
 * derived from Id: sys.mli,v 1.38 2002/07/23 14:35:30 doligez Exp
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)


(** System interface. *)


(* val argv : string array *)
(* this would need to be thunked
val executable_name : string
(** The name of the file containing the executable currently running. *)
*)

val file_exists : string -> bool
(** Test if a file with the given name exists. *)

val remove : string -> unit
(** Remove the given file name from the file system. *)

val rename : string -> string -> unit
(** Rename a file. The first argument is the old name and the
   second is the new name. *)

val getenv : string -> string
(** Return the value associated to a variable in the process
   environment. Raise [Not_found] if the variable is unbound. *)

val command : string -> int
(** Execute the given shell command and return its exit code. *)

(* val time : unit -> float *)
(** Return the processor time, in seconds, used by the program
   since the beginning of execution. *)

val chdir : string -> unit
(** Change the current working directory of the process. *)

val getcwd : unit -> string
(** Return the current working directory of the process. *)

(* val interactive : bool ref *)
(** This reference is initially set to [false] in standalone
   programs and to [true] if the code is being executed under
   the interactive toplevel system [ocaml]. *)

(* these would need to be thunked
val os_type : string
(** Operating system currently executing the Caml program. One of
   ["Unix"] (for all Unix versions, including Linux and Mac OS X),
   ["Win32"] (for MS-Windows, OCaml compiled with MSVC++),
   ["Cygwin"] (for MS-Windows, OCaml compiled with Cygwin),
   ["MacOS"] (for MacOS 9). *)

val word_size : int
(** Size of one word on the machine currently executing the Caml
   program, in bits: 32 or 64. *)

val max_string_length : int
(** Maximum length of a string. *)

val max_array_length : int
(** Maximum length of an array. *)
*)


val catch_break : bool -> unit
(** [catch_break] governs whether interactive interrupt (ctrl-C)
   terminates the program or raises the [Break] exception.
   Call [catch_break true] to enable raising [Break],
   and [catch_break false] to let the system
   terminate the program on user interrupt. *)

(* this would need to be thunked
val ocaml_version : string
(** [ocaml_version] is the version of Objective Caml.
    It is a string of the form ["major.minor[additional-info]"]
    Where major and minor are integers, and [additional-info] is
    a string that is empty or starts with a '+'. *)
*)

