(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * exceptions.ml                                                  *
 *                                                                *
 * Version: $Id: exceptions.ml,v 1.508 2004/12/22 12:23:31 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

(* TODO: insert strings and values into the right places *)

type include_exn =
  | Cycle
  | System_error of string (* Did have file not found, but this is all the system tells us *)

type hashify_exn =
  | Withspec_equation_from_import of string
  | Withspec_wrt_bad_type_field of string
  | Withspec_types_not_equal of string
  | Likespec_missing_type_fields of string
  | Linkok_not of string
  | Bad_sourcedef_valuability of string
  | Nenv_merge_of_compiledunit

type run_exn =
  | Typecheck_of_configuration of Ast.configuration
  | Typecheck_on_marshal
  | Typecheck_on_unmarshal of Ast.marshalled_body
  | Typecheck_on_get_URI of string


type compile_exn =
  | Lex of string (* * Location.t *)
  | Parse of string (* * Location.t *)
  | Runtime_mismatch of string (* ideally want to know if it's include or import,
				  or unmarshal
                                  can we trust the relevant callers to mark *)
  | Type of string (* * Location.t *)
  | Include of include_exn
  | Nonfinal_expression
  | Hashify of hashify_exn
  | Typecheck_of_compiledunit of string

type internal_exn =
  | Never_happen of string
  | Stuck of string
  | Unimplemented of string


type failure_exn =
  | Compile of compile_exn
  | Run of run_exn
  | Internal of internal_exn

type top_exn =
(*  | Value of Ast.configuration
  | Acute_exception of Ast.configuration *)
  | Success of Ast.configuration
  | Deadlock of Ast.configuration
  | Library of Ast.definitions
  | Failure of failure_exn
  | Emitsource of bool

