(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * econst.ml                                                      *
 *                                                                *
 * Version: $Id: econst.ml,v 1.509 2004/12/22 12:23:31 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

let ident_of_string iid = try
  Library.libfunc_string_to_iident iid
with Not_found -> raise
    (Util.Never_happen(iid ^ " not in libfuncs"))
let string_of_ident string = Library.libfunc_iident_to_string string
let arity_of_ident iid = let (_,arity,_,_,_) = Library.find_libfunc (Library.libfunc_iident_to_string iid) in arity
let type_of_ident iid = let (t,_,_,_,_) = Library.find_libfunc (Library.libfunc_iident_to_string iid) in t
let slow_of_ident iid = let (_,_,slow,_,_) = Library.find_libfunc (Library.libfunc_iident_to_string iid) in slow
let econst_env_list = Library.econst_env_list
let apply iid tid args =
  let (ty,_,slow,_,f) = Library.find_libfunc (Library.libfunc_iident_to_string iid) in
  if (not slow) then
    f (args)
  else
    (Threadpool.add (Util.Inl(tid, (f, args)));
    (* return SlOWRET *)
     Ast.SLOWRET ty)
       (* M: Now we add a transition for SLOWRET to move queues,
	  is there a nicer way?
	  Is this going to work, even? Think we need the slowret on the blocked queue before the thread starts---or do we?
	  fetch () fetches anything that hasn't yet been recovered. Doesn't matter. *)



let in_econst iid = try ignore (Library.libfunc_iident_to_string iid); true with Not_found -> false
(* was: Ast.iident_mem_typeenv iid econst_env *)
(* let register_eval = Library.register_eval *)

(* fill in recursive dependency *)
let _ = Ast.arity_of_econst_ref := arity_of_ident

