(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * atcp.mli                                                       *
 *                                                                *
 * Version: $Id: atcp.mli,v 1.3 2004/12/22 12:23:35 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

type file_descr2 = int  (* provably equal to file_descr *)
type inet_addr2 = string

val inet_addr_of_string2 : string -> inet_addr2
val string_of_inet_addr2 : inet_addr2 -> string
val inet_addr_any2 : unit -> inet_addr2

type socket_domain2 = int
type socket_type2 = int
type sockaddr2 = inet_addr2 * int (* no ADDR_UNIX *)
val socket2 : socket_domain2 -> socket_type2 -> int -> file_descr2
val socketpair2 : socket_domain2 -> socket_type2 -> int -> file_descr2 * file_descr2
val accept2 : file_descr2 -> file_descr2 * sockaddr2
val bind2 : file_descr2 -> sockaddr2 -> unit
val connect2 : file_descr2 -> sockaddr2 -> unit
val listen2 : file_descr2 -> int -> unit
val getsockname2 : file_descr2 -> sockaddr2
val getpeername2 : file_descr2 -> sockaddr2

type shutdown_command2 = int
val shutdown2 : file_descr2 -> shutdown_command2 -> unit

type msg_flag2 = int

val recv2 : file_descr2 -> string -> int -> int -> msg_flag2 list -> int
val recvfrom2 : file_descr2 -> string -> int -> int -> msg_flag2 list -> int * sockaddr2
val send2 : file_descr2 -> string -> int -> int -> msg_flag2 list -> int
val sendto2 : file_descr2 -> string -> int -> int -> msg_flag2 list -> sockaddr2 -> int






