(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * util.mli                                                       *
 *                                                                *
 * Version: $Id: util.mli,v 1.514 2004/12/22 12:23:33 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

exception Unimplemented of string  (* something is unimplemented *)
exception Never_happen of string   (* can't happen *)

val id : 'a -> 'a

val if_ : bool -> ('a -> 'a) -> 'a -> 'a

val partial_map : ('a -> 'b option) -> 'a list -> 'b list
val concat_map : ('a -> 'b list) -> 'a list -> 'b list
val findfirst : ('a -> 'b option) -> 'a list -> 'b option
val findfirst_ext : ('a -> 'b option) -> 'a list -> ('b * 'a list) option
val is_Some : 'a option -> bool
val is_None : 'a option -> bool
val the : 'a option -> 'a
val the' : string -> 'a option -> 'a
val option_lift : ('a -> 'b) -> 'a option -> 'b option
val stringmap : (char -> 'a) -> string -> 'a list

val ( <.> ) : ('a -> 'b) -> ('c -> 'a) -> 'c -> 'b
val ( <$> ) : ('a -> 'b) -> 'a -> 'b
type ('a, 'b) sum = Inl of 'a | Inr of 'b
val summap : ('a -> 'b) * ('c -> 'b) -> ('a, 'c) sum -> 'b
val splitAt : int -> 'a list -> 'a list * 'a list
val take : int -> 'a list -> 'a list
val drop : int -> 'a list -> 'a list
val mem_by : ('a -> 'a -> bool) -> 'a -> 'a list -> bool
val assoc_by : ('a -> 'a -> bool) -> 'a -> ('a * 'b) list -> 'b

val firstdup : ('a -> 'a -> bool) -> 'a list -> 'a option
val uniq : ('a -> 'a -> bool) -> 'a list -> 'a list

val (|=|) : int -> int -> int
val (|==|) : int -> (unit -> int) -> int
val compare_list : int list -> int

val maybe : ('a -> 'b) -> 'a -> 'b option

val remove_duplicates : ('a -> 'a -> int) -> ('a list) -> ('a list)

module AQueue:
sig
  type 'a t
  exception Empty
  val create : unit -> 'a t
  val add : 'a -> 'a t -> 'a t
  val take : 'a t -> 'a * 'a t
  val untake : 'a * 'a t -> 'a t
  val peek : 'a t -> 'a
  val length : 'a t -> int
  val iter : ('a -> unit) -> 'a t -> unit
  val fold_front : ('a -> 'b -> 'a) -> 'a -> 'b t -> 'a
  val fold_rear : ('b -> 'a -> 'a) -> 'b t -> 'a -> 'a
  val toList : 'a t -> 'a list
  val fromList : 'a list -> 'a t
  val removeFirst : ('a -> bool) -> 'a t -> 'a t (* removes first x such that f x *)
  val empty : 'a t -> bool
end

val qmap : ('a -> 'b) -> 'a AQueue.t -> 'b AQueue.t
